/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.util.Vector;
import org.eclipse.aperi.snmp.SnmpMetaPDU;

public class SnmpPDU
extends SnmpMetaPDU {
    public static final int NOERROR = 0;
    public static final int TOOBIG = 1;
    public static final int NOSUCHNAME = 2;
    public static final int BADVALUE = 3;
    public static final int READONLY = 4;
    public static final int GENERR = 5;
    public static final int NO_ACCESS = 6;
    public static final int WRONG_TYPE = 7;
    public static final int WRONG_LENGTH = 8;
    public static final int WRONG_ENCODING = 9;
    public static final int WRONG_VALUE = 10;
    public static final int NO_CREATION = 11;
    public static final int INCONSIST_VAL = 12;
    public static final int RESOURCE_UNAVAIL = 13;
    public static final int COMMIT_FAIL = 14;
    public static final int UNDO_FAIL = 15;
    public static final int AUTH_ERR = 16;
    public static final int NOT_WRITEABLE = 17;
    public static final int INCONSIS_NAME = 18;
    public static final int TIMEOUT = 100;
    public static final int SENDERROR = 101;
    public static final int SESSIONWHACKED = 102;
    public static final int DECODEERROR = 103;
    public static final String[] errorStatusString = new String[]{"Success", "Response PDU too big", "Variable does not exist", "Cannot modify variable, bad value", "Cannot modify object, read only", "Cannot perform operation, general error", "Cannot access variable, no access", "Cannot create/set variable, wrong type", "Cannot create/set variable, wrong length", "Cannot create/set variable, wrong encoding", "Cannot create/set variable, wrong value", "Cannot create variable, creation not allowed", "Cannot create/set variable, inconsistent value", "Cannot create/set variable, resource unavailable", "Cannot create/set variable, commit failed", "Cannot create/set variable, undo failed", "Cannot perform operation, authentication error", "Cannot create/set variable, not writeable", "Cannot create variable, inconsistent name"};
    public static final int GET = 0;
    public static final int GETNEXT = 1;
    public static final int GETRESPONSE = 2;
    public static final int RESPONSE = 2;
    public static final int SET = 3;
    public static final int GETBULK = 4;
    public static final int INFORM = 5;
    public static final int V2_TRAP = 6;
    public static final int REPORT = 7;
    public static final String[] operationString = new String[]{"GET", "GETNEXT", "RESPONSE", "SET", "GETBULK", "INFORM", "V2 TRAP", "REPORT"};
    public int requestId;
    public int errorStatus;
    public int errorIndex;
    public int operation;
    public int correlator;
    public int requestIdPos;

    public int getCorrelatorValue() {
        return this.requestId;
    }

    public SnmpPDU() {
        this.requestId = 0;
        this.errorStatus = 0;
        this.errorIndex = 0;
        this.operation = 0;
    }

    public Object clone() {
        return new SnmpPDU(this);
    }

    public SnmpPDU(SnmpPDU pdu) {
        super(pdu);
        this.requestId = pdu.requestId;
        this.errorStatus = pdu.errorStatus;
        this.errorIndex = pdu.errorIndex;
        this.operation = pdu.operation;
    }

    public SnmpPDU(int reqId, int ver, String comStr, int op, Vector vars) {
        super(ver, comStr, vars);
        this.requestId = reqId;
        this.errorStatus = 0;
        this.errorIndex = 0;
        this.operation = op;
    }

    public int get_error_status() {
        return this.errorStatus;
    }

    public void set_error_status(int errorStatus) {
        this.errorStatus = errorStatus;
    }

    public int get_error_index() {
        return this.errorIndex;
    }

    public void set_error_index(int errorIndex) {
        this.errorIndex = errorIndex;
    }

    public void clear_error_status() {
        this.errorStatus = 0;
    }

    public void clear_error_index() {
        this.errorIndex = 0;
    }

    public int get_request_id() {
        return this.requestId;
    }

    public void set_request_id(int requestId) {
        this.requestId = requestId;
    }

    public int get_type() {
        return this.operation;
    }

    public void set_type(int operationValue) {
        this.operation = operationValue;
    }

    public boolean valid() {
        if (this.operation < 0) {
            return false;
        }
        if (this.operation > 7) {
            return false;
        }
        if (this.errorStatus < 0) {
            return false;
        }
        return this.errorStatus <= 18 || this.errorStatus >= 100 && this.errorStatus <= 103;
    }

    public void fix() {
        if (this.errorStatus == 0) {
            return;
        }
        if (this.errorIndex == 0) {
            this.errorStatus = 0;
            return;
        }
        if (this.errorIndex - 1 <= this.varBindList.size()) {
            this.varBindList.removeElementAt(this.errorIndex - 1);
        }
        this.errorStatus = 0;
        this.errorIndex = 0;
    }

    public boolean equals(SnmpPDU p) {
        if (!super.equals(p)) {
            return false;
        }
        if (this.errorIndex != p.errorIndex) {
            return false;
        }
        if (this.operation != p.operation) {
            return false;
        }
        return this.requestId == p.requestId;
    }

    public static String getErrorStatusString(int err) {
        switch (err) {
            case 100: {
                return "Timeout";
            }
            case 101: {
                return "Send Error";
            }
            case 102: {
                return "Session Terminated";
            }
            case 103: {
                return "Decode Error";
            }
        }
        return errorStatusString[err];
    }

    public String getErrorStatusString() {
        return SnmpPDU.getErrorStatusString(this.errorStatus);
    }

    public String getOperationString() {
        return operationString[this.operation];
    }

    public String toString() {
        try {
            StringBuffer buffer = new StringBuffer("Message :");
            buffer.append(" version=" + this.version);
            if (this.communityString != null) {
                buffer.append(" communityString=" + this.communityString.toDisplayString());
            } else {
                buffer.append(" communityString=<value for session>");
            }
            if (this.errorStatus >= 0 && this.errorStatus < errorStatusString.length) {
                buffer.append("\n          errorStatus=" + errorStatusString[this.errorStatus]);
            } else if (this.errorStatus == 100) {
                buffer.append("\n          errorStatus=Timeout");
            } else if (this.errorStatus == 101) {
                buffer.append("\n          errorStatus=SendError");
            } else if (this.errorStatus == 102) {
                buffer.append("\n          errorStatus=Session Terminated");
            } else if (this.errorStatus == 103) {
                buffer.append("\n          errorStatus=Decode Error");
            } else {
                buffer.append("\n          errorStatus=" + this.errorStatus);
            }
            buffer.append(" errorIndex=" + this.errorIndex);
            if (this.operation >= 0 && this.operation <= 7) {
                buffer.append(" operation=" + operationString[this.operation]);
            } else {
                buffer.append(" operation=" + this.operation);
            }
            buffer.append(" requestId=" + this.requestId + " correlator=" + this.correlator + "\n          ");
            buffer.append(this.varBindListToString());
            return buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Message cannot be formatted";
        }
    }
}

