/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.eclipse.aperi.snmp.AbstractSnmpPoller;
import org.eclipse.aperi.snmp.BackupAlgorithm;
import org.eclipse.aperi.snmp.PollingDriver;
import org.eclipse.aperi.snmp.SessionInfo;
import org.eclipse.aperi.snmp.SessionInfoCommString;
import org.eclipse.aperi.snmp.SessionObservable;
import org.eclipse.aperi.snmp.SnmpAsn1;
import org.eclipse.aperi.snmp.SnmpMetaPDU;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSocket;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpStatistics;
import org.eclipse.aperi.snmp.SnmpTarget;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpV2PDU;
import org.eclipse.aperi.snmp.Snmp_callback;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.utils.AddressChangeEvent;
import org.eclipse.aperi.snmp.utils.AddressChangeListener;
import org.eclipse.aperi.snmp.utils.Queue;
import org.eclipse.aperi.snmp.utils.Timer;
import org.eclipse.aperi.snmp.utils.TimerService;
import org.eclipse.aperi.snmp.utils.Wakeable;

public class SnmpSession
extends SnmpTarget
implements Wakeable,
Observer {
    private static byte[] timeoutData = new byte[1];
    private static Hashtable agents = new Hashtable();
    protected static Vector sessions = new Vector();
    protected String currentHostname;
    protected InetAddress currentAddress = null;
    protected String primaryAddress;
    protected SessionInfo securityInfo;
    protected int retries;
    protected int timeout;
    protected int remotePort;
    protected SnmpSocket socket;
    protected SnmpStatistics stats;
    protected boolean closed;
    protected Hashtable pollDrivers;
    protected int redshift;
    public static final String DEFAULT_COMM_NAME = "public";
    public static final String DEFAULT_SET_COMM = "public";
    public static final int DEFAULT_RETRIES = 3;
    public static final int DEFAULT_TIMEOUT = 1000;
    public static final int DEFAULT_REMOTEPORT = 161;
    private static DatagramSocket timeoutSock = null;
    private static InetAddress localAddr = null;
    private SessionObservable watchMe = null;
    private int max_consecutive_timeouts = 1;
    protected static final int SEND = 0;
    protected static final int TIMEOUT = 1;
    protected int transmit_state = 0;
    private int createTimeoutPeriod = 4000;
    private Timer createTimeoutPeriodTimer = null;
    private int timeoutCount = 0;
    private Vector backupAddresses = null;
    private Object backupAddressLock = new Object();
    private int nextBackup = 0;
    private BackupAlgorithm customBackupAlgorithm = null;
    protected boolean switchedDestination = false;
    protected Vector addressChangeListeners = null;
    protected Object addressChangeLock = new Object();
    private boolean switching = false;
    private boolean useActiveSwitcher = true;
    protected boolean isBroadcast = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SnmpSession(SnmpSession other) {
        this.canReplayMessages = other.canReplayMessages;
        this.securityInfo = (SessionInfo)other.securityInfo.clone();
        this.currentHostname = other.currentHostname;
        this.currentAddress = other.currentAddress;
        this.primaryAddress = other.primaryAddress;
        this.retries = other.retries;
        this.timeout = other.timeout;
        this.remotePort = other.remotePort;
        this.socket = other.socket;
        this.stats = new SnmpStatistics();
        this.pollDrivers = null;
        this.closed = false;
        this.redshift = other.redshift;
        this.isBroadcast = other.isBroadcast;
        Vector vector = sessions;
        synchronized (vector) {
            sessions.addElement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SnmpSession(String hostNameOrIpAddress, String communityName, String setCommunityName, int defaultRetries, int defaultTimeoutMsec, int defaultRemotePort, SnmpSocket snmpSocket) {
        this.canReplayMessages = true;
        this.securityInfo = new SessionInfoCommString(communityName, setCommunityName);
        this.currentHostname = this.nameToAddr(hostNameOrIpAddress);
        this.currentAddress = this.getInetAddress();
        this.primaryAddress = hostNameOrIpAddress;
        this.retries = defaultRetries;
        this.timeout = defaultTimeoutMsec;
        this.remotePort = defaultRemotePort;
        this.socket = snmpSocket;
        this.stats = new SnmpStatistics();
        this.pollDrivers = null;
        this.closed = false;
        this.redshift = (int)(Math.random() * 599.0 + 1.0) * 100;
        if (this.currentAddress.isMulticastAddress()) {
            this.isBroadcast = true;
            this.timeout <<= this.retries - this.timeout;
        }
        Vector vector = sessions;
        synchronized (vector) {
            sessions.addElement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SnmpSession(String hostNameOrIpAddress, OctetString communityName, OctetString setCommunityName, int defaultRetries, int defaultTimeoutMsec, int defaultRemotePort, SnmpSocket snmpSocket) {
        this.canReplayMessages = true;
        this.securityInfo = new SessionInfoCommString(communityName, setCommunityName);
        this.currentHostname = this.nameToAddr(hostNameOrIpAddress);
        this.currentAddress = this.getInetAddress();
        this.primaryAddress = hostNameOrIpAddress;
        this.retries = defaultRetries;
        this.timeout = defaultTimeoutMsec;
        this.remotePort = defaultRemotePort;
        this.socket = snmpSocket;
        this.stats = new SnmpStatistics();
        this.pollDrivers = null;
        this.closed = false;
        this.redshift = (int)(Math.random() * 599.0 + 1.0) * 100;
        if (this.currentAddress.isMulticastAddress()) {
            this.isBroadcast = true;
            this.timeout <<= this.retries;
        }
        Vector vector = sessions;
        synchronized (vector) {
            sessions.addElement(this);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("IP:");
        s.append(this.primaryAddress);
        s.append(this.securityInfo.toString());
        s.append(" retries:");
        s.append(this.retries);
        s.append(" timeout:");
        s.append(this.timeout);
        s.append(" port:");
        s.append(this.port);
        s.append(" is broadcast:");
        s.append(this.isBroadcast);
        return s.toString();
    }

    public void update(Observable obj, Object arg) {
        SnmpSession sess = (SnmpSession)arg;
        this.retries = sess.retries;
        this.timeout = sess.timeout;
        this.remotePort = sess.remotePort;
        this.redshift = sess.redshift;
        this.changeCommName(sess.getCommName());
        this.changeSetCommName(sess.getSetCommName());
    }

    public synchronized void cancelRedShift() throws Exception {
        if (this.pollDrivers == null || this.pollDrivers.size() == 0) {
            this.redshift = 0;
            if (this.watchMe != null) {
                this.watchMe.parmsChanged(this);
            }
        } else {
            throw new Exception("red shift cannot be cancelled once pollers have been added");
        }
    }

    public static SnmpSession open(String hostNameOrIpAddress) throws SnmpUnknownHostException, SnmpSocketException {
        return SnmpSession.open(hostNameOrIpAddress, "public", "public", 3, 1000, 161);
    }

    public static SnmpSession open(String hostNameOrIpAddress, String communityName) throws SnmpUnknownHostException, SnmpSocketException {
        return SnmpSession.open(hostNameOrIpAddress, communityName, "public", 3, 1000, 161);
    }

    public static SnmpSession open(String hostNameOrIpAddress, String communityName, String setCommunityName) throws SnmpUnknownHostException, SnmpSocketException {
        return SnmpSession.open(hostNameOrIpAddress, communityName, setCommunityName, 3, 1000, 161);
    }

    public static SnmpSession open(String hostNameOrIpAddress, String communityName, String setCommunityName, int defaultRetries, int defaultTimeoutMsec, int defaultRemotePort) throws SnmpUnknownHostException, SnmpSocketException {
        if (SnmpSession.validateInfo(hostNameOrIpAddress)) {
            String address = null;
            try {
                address = InetAddress.getByName(hostNameOrIpAddress).getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new SnmpUnknownHostException(hostNameOrIpAddress);
            }
            SnmpSocket snmpSock = SnmpSocket.getSocket(address);
            return new SnmpSession(hostNameOrIpAddress, communityName, setCommunityName, defaultRetries, defaultTimeoutMsec, defaultRemotePort, snmpSock);
        }
        return null;
    }

    public static SnmpSession open(String hostNameOrIpAddress, OctetString communityName, OctetString setCommunityName, int defaultRetries, int defaultTimeoutMsec, int defaultRemotePort) throws SnmpUnknownHostException, SnmpSocketException {
        if (SnmpSession.validateInfo(hostNameOrIpAddress)) {
            String address = null;
            try {
                address = InetAddress.getByName(hostNameOrIpAddress).getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new SnmpUnknownHostException(hostNameOrIpAddress);
            }
            SnmpSocket snmpSock = SnmpSocket.getSocket(address);
            return new SnmpSession(hostNameOrIpAddress, communityName, setCommunityName, defaultRetries, defaultTimeoutMsec, defaultRemotePort, snmpSock);
        }
        return null;
    }

    protected static boolean validateInfo(String hostNameOrIpAddress) throws SnmpSocketException, SnmpUnknownHostException {
        if (!SnmpV1API.initialized) {
            throw new SnmpSocketException("SnmpV1API is not available");
        }
        if (localAddr == null) {
            SnmpSession.initCommonStuff();
        }
        return true;
    }

    private static synchronized void initCommonStuff() throws SnmpUnknownHostException, SnmpSocketException {
        block4: {
            try {
                localAddr = InetAddress.getLocalHost();
                timeoutSock = (DatagramSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new DatagramSocket();
                    }
                });
            }
            catch (UnknownHostException ue) {
                System.out.println("SnmpSession: unknown host exception consumed: fix me!!!!!");
                localAddr = null;
                timeoutSock = null;
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof UnknownHostException) {
                    System.out.println("SnmpSession: unknown host exception consumed: fix me!!!!!");
                    localAddr = null;
                    timeoutSock = null;
                }
                if (!(e instanceof SocketException)) break block4;
                localAddr = null;
                timeoutSock = null;
                throw new SnmpSocketException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("SnmpSession closed to " + this.primaryAddress);
        }
        this.closed = true;
        this.socket.closedSession(this);
        Vector vector = sessions;
        synchronized (vector) {
            sessions.removeElement(this);
            if (sessions.isEmpty()) {
                SnmpSocket.closeSocket();
            }
        }
    }

    public void send(SnmpPDU pdu, Queue rspQ) {
        this.socket.send(this, pdu, rspQ, null, null, false);
    }

    public void send(SnmpPDU pdu, Object callback, Object user_data) {
        this.socket.send(this, pdu, null, callback, user_data, false);
    }

    public void send(SnmpPDU[] pdu, Queue rspQ) {
        int limit = pdu.length;
        for (int i = 0; i < limit; ++i) {
            if (pdu[i] == null) continue;
            this.socket.send(this, pdu[i], rspQ, null, null, false);
        }
    }

    public void send(SnmpPDU pdu, DatagramPacket ber, Queue rspQ) {
        this.socket.send(this, pdu, ber, rspQ, (Object)null, null);
    }

    public void send(SnmpPDU[] pdu, DatagramPacket[] ber, Queue rspQ) {
        int limit = pdu.length;
        for (int i = 0; i < limit; ++i) {
            if (pdu[i] == null) continue;
            this.socket.send(this, pdu[i], ber[i], rspQ, (Object)null, null);
        }
    }

    public void send(SnmpPDU pdu, DatagramPacket ber, Object callback, Object user_data) {
        this.socket.send(this, pdu, ber, null, callback, user_data);
    }

    public void send(SnmpPDU[] pdu, DatagramPacket[] ber, Object callback, Object user_data) {
        int limit = pdu.length;
        for (int i = 0; i < limit; ++i) {
            if (pdu[i] == null) continue;
            this.socket.send(this, pdu[i], ber[i], null, callback, user_data);
        }
    }

    public SnmpPDU send(SnmpPDU pdu) {
        SnmpPDU rsp = null;
        Queue q = new Queue(true);
        this.send(pdu, q);
        rsp = (SnmpPDU)q.dequeue();
        return rsp;
    }

    public SnmpV2PDU send(SnmpV2PDU pdu) {
        SnmpV2PDU rsp = null;
        Queue q = new Queue(true);
        this.send((SnmpPDU)pdu, q);
        rsp = (SnmpV2PDU)q.dequeue();
        return rsp;
    }

    protected SnmpPDU send(SnmpPDU pdu, boolean isUserPacket) {
        SnmpPDU rsp = null;
        Queue q = new Queue(true);
        this.socket.send(this, pdu, isUserPacket, q, null, null, false);
        rsp = (SnmpPDU)q.dequeue();
        return rsp;
    }

    public final SnmpStatistics getSnmpStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AbstractSnmpPoller snmpPoller, Object userData) {
        PollingDriver pd;
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            if (this.pollDrivers == null) {
                this.pollDrivers = new Hashtable();
            }
        }
        Integer key = new Integer(snmpPoller.interval.interval);
        Hashtable hashtable = this.pollDrivers;
        synchronized (hashtable) {
            pd = (PollingDriver)this.pollDrivers.get(key);
            if (pd == null) {
                pd = new PollingDriver(this, snmpPoller.interval.interval);
                this.pollDrivers.put(key, pd);
            }
        }
        pd.add(snmpPoller, userData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AbstractSnmpPoller[] snmpPollers, Object userData) throws Exception {
        PollingDriver pd;
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            if (this.pollDrivers == null) {
                this.pollDrivers = new Hashtable();
            }
        }
        boolean allSameInterval = true;
        int intvl = snmpPollers[0].interval.interval;
        for (int i = 1; allSameInterval && i < snmpPollers.length; ++i) {
            allSameInterval = intvl == snmpPollers[i].interval.interval;
        }
        if (!allSameInterval) {
            throw new Exception("all pollers in the array must have the same polling interval");
        }
        Integer key = new Integer(snmpPollers[0].interval.interval);
        Object object = this.pollDrivers;
        synchronized (object) {
            pd = (PollingDriver)this.pollDrivers.get(key);
            if (pd == null) {
                pd = new PollingDriver(this, intvl);
                this.pollDrivers.put(key, pd);
            }
        }
        object = pd;
        synchronized (object) {
            for (int i = 0; i < snmpPollers.length; ++i) {
                pd.add(snmpPollers[i], userData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AbstractSnmpPoller snmpPoller) {
        Integer key = new Integer(snmpPoller.interval.interval);
        if (this.pollDrivers != null) {
            Hashtable hashtable = this.pollDrivers;
            synchronized (hashtable) {
                PollingDriver pd = (PollingDriver)this.pollDrivers.get(key);
                if (pd != null) {
                    pd.remove(snmpPoller);
                    if (pd.count() == 0) {
                        this.pollDrivers.remove(key);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AbstractSnmpPoller[] snmpPollers) throws Exception {
        Integer key = new Integer(snmpPollers[0].interval.interval);
        boolean allSameInterval = true;
        int intvl = snmpPollers[0].interval.interval;
        for (int i = 1; allSameInterval && i < snmpPollers.length; ++i) {
            allSameInterval = intvl == snmpPollers[i].interval.interval;
        }
        if (!allSameInterval) {
            throw new Exception("all pollers in the array must have the same polling interval");
        }
        if (this.pollDrivers != null) {
            Hashtable hashtable = this.pollDrivers;
            synchronized (hashtable) {
                PollingDriver pd = (PollingDriver)this.pollDrivers.get(key);
                if (pd != null) {
                    PollingDriver pollingDriver = pd;
                    synchronized (pollingDriver) {
                        for (int i = 0; i < snmpPollers.length; ++i) {
                            pd.remove(snmpPollers[i]);
                        }
                    }
                    if (pd.count() == 0) {
                        this.pollDrivers.remove(key);
                    }
                }
            }
        }
    }

    public SnmpPDU makePDU() {
        if (this.securityInfo != null) {
            if (this.securityInfo.version == 2) {
                return new SnmpV2PDU();
            }
            return new SnmpPDU();
        }
        return new SnmpPDU();
    }

    public SnmpPDU makePDU(SnmpPDU other) {
        if (this.securityInfo != null) {
            if (this.securityInfo.version == 2) {
                return new SnmpV2PDU((SnmpV2PDU)other);
            }
            return new SnmpPDU(other);
        }
        return new SnmpPDU(other);
    }

    public SnmpPDU decodeMessage(byte[] buffer, int messageLength) {
        if (this.securityInfo == null) {
            return null;
        }
        if (this.securityInfo.version == 2) {
            return SnmpAsn1.decodeV2PDU(buffer, messageLength);
        }
        return SnmpAsn1.decodePDU(buffer, messageLength);
    }

    private String nameToAddr(String name) {
        try {
            return InetAddress.getByName(name).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return name;
        }
    }

    public String getIpAddress() {
        return this.currentHostname;
    }

    public String getPrimaryIpAddress() {
        return this.primaryAddress;
    }

    public InetAddress getInetAddress() {
        if (this.currentAddress == null) {
            try {
                this.currentAddress = InetAddress.getByName(this.currentHostname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.currentAddress;
    }

    public String getCommName() {
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return "";
        }
        return ((SessionInfoCommString)this.securityInfo).get_getCommunityName();
    }

    public String getSetCommName() {
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return "";
        }
        return ((SessionInfoCommString)this.securityInfo).get_setCommunityName();
    }

    public OctetString getCommNameOctet() {
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return null;
        }
        return ((SessionInfoCommString)this.securityInfo).get_getCommunityNameOctet();
    }

    public OctetString getSetCommNameOctet() {
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return null;
        }
        return ((SessionInfoCommString)this.securityInfo).get_setCommunityNameOctet();
    }

    public void changeCommName(String newCommName) {
        boolean changed;
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return;
        }
        boolean bl = changed = !newCommName.equals(((SessionInfoCommString)this.securityInfo).getCommunityName);
        if (!changed) {
            return;
        }
        ((SessionInfoCommString)this.securityInfo).set_getCommunityName(newCommName);
        this.completeChange();
    }

    public void changeCommName(OctetString newCommName) {
        boolean changed;
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return;
        }
        boolean bl = changed = !newCommName.equals(((SessionInfoCommString)this.securityInfo).get_getCommunityNameOctet());
        if (!changed) {
            return;
        }
        ((SessionInfoCommString)this.securityInfo).set_getCommunityName(newCommName);
        this.completeChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeChange() {
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
        this.transmit_state = 0;
        if (this.pollDrivers == null) {
            return;
        }
        Hashtable hashtable = this.pollDrivers;
        synchronized (hashtable) {
            Enumeration e = this.pollDrivers.elements();
            while (e.hasMoreElements()) {
                PollingDriver d = (PollingDriver)e.nextElement();
                d.anyChanges = true;
            }
        }
    }

    public void changeSetCommName(String newSetCommName) {
        boolean changed;
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return;
        }
        boolean bl = changed = !newSetCommName.equals(((SessionInfoCommString)this.securityInfo).setCommunityName);
        if (!changed) {
            return;
        }
        ((SessionInfoCommString)this.securityInfo).set_setCommunityName(newSetCommName);
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
        this.transmit_state = 0;
    }

    public void changeSetCommName(OctetString newSetCommName) {
        boolean changed;
        if (!(this.securityInfo instanceof SessionInfoCommString)) {
            return;
        }
        boolean bl = changed = !newSetCommName.equals(((SessionInfoCommString)this.securityInfo).get_setCommunityNameOctet());
        if (!changed) {
            return;
        }
        ((SessionInfoCommString)this.securityInfo).set_setCommunityName(newSetCommName);
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
        this.transmit_state = 0;
    }

    public int getVersion() {
        return this.securityInfo.version;
    }

    public void setVersion(int version) {
        this.securityInfo.version = version;
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
    }

    public int getRetries() {
        return this.retries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void changeRetries(int newRetries) {
        this.retries = newRetries;
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
    }

    public void changeTimeout(int newTimeout) {
        this.timeout = newTimeout;
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
    }

    public void changeMaxconsecutiveTimeouts(int maxTimeouts) {
        this.max_consecutive_timeouts = maxTimeouts;
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
    }

    public void changeRemotePort(int newRemotePort) {
        this.remotePort = newRemotePort;
        if (this.watchMe != null) {
            this.watchMe.parmsChanged(this);
        }
    }

    public final synchronized SessionObservable getObservable() {
        if (this.watchMe == null) {
            this.watchMe = new SessionObservable();
        }
        return this.watchMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(String address) {
        try {
            this.switchedDestination = true;
            this.socket = SnmpSocket.getSocket(address);
            if (this.pollDrivers != null) {
                Hashtable hashtable = this.pollDrivers;
                synchronized (hashtable) {
                    Enumeration e = this.pollDrivers.elements();
                    while (e.hasMoreElements()) {
                        PollingDriver d = (PollingDriver)e.nextElement();
                        d.anyChanges = true;
                    }
                }
            }
            this.currentHostname = this.nameToAddr(address);
            this.currentAddress = null;
            if (this.watchMe != null) {
                this.watchMe.parmsChanged(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackupAddress(String address) {
        Object object = this.backupAddressLock;
        synchronized (object) {
            if (this.backupAddresses == null) {
                this.backupAddresses = new Vector();
                this.backupAddresses.addElement(address);
                this.nextBackup = 0;
            } else if (this.backupAddresses.indexOf(address) < 0) {
                this.backupAddresses.addElement(address);
            }
        }
    }

    public void addBackupAddresses(String addresses) {
        System.out.println("NOT ADDING ADDRESSES!!!!!!!!!!!!!! SnmpSession.java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackupAddresses(Vector addresses) {
        int limit = 0;
        if (addresses == null) {
            return;
        }
        limit = addresses.size();
        Object object = this.backupAddressLock;
        synchronized (object) {
            for (int i = 0; i < limit; ++i) {
                this.addBackupAddress((String)addresses.elementAt(i));
            }
        }
    }

    public Vector getBackupAddresses() {
        return this.backupAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBackupAddresses() {
        Object object = this.backupAddressLock;
        synchronized (object) {
            if (this.backupAddresses != null) {
                this.backupAddresses.removeAllElements();
                this.nextBackup = 0;
            }
        }
    }

    public String getCurrentAddress() {
        return this.currentHostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAddressChangeListener(AddressChangeListener listener) {
        Object object = this.addressChangeLock;
        synchronized (object) {
            if (this.addressChangeListeners == null) {
                this.addressChangeListeners = new Vector();
            }
            if (!this.addressChangeListeners.contains(listener)) {
                this.addressChangeListeners.addElement(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAddressChangeListener(AddressChangeListener listener) {
        Object object = this.addressChangeLock;
        synchronized (object) {
            if (this.addressChangeListeners != null && this.addressChangeListeners.contains(listener)) {
                this.addressChangeListeners.removeElement(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBackupAddress(String address) {
        Object object = this.backupAddressLock;
        synchronized (object) {
            if (this.backupAddresses == null) {
                return false;
            }
            return this.backupAddresses.indexOf(address) >= 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBackupAddress(String address) {
        Object object = this.backupAddressLock;
        synchronized (object) {
            if (this.backupAddresses != null) {
                int index = this.backupAddresses.indexOf(address);
                if (index < 0) {
                    return;
                }
                if (index < this.nextBackup) {
                    --this.nextBackup;
                }
                this.backupAddresses.removeElementAt(index);
            }
        }
    }

    public void setBackupAlgorithm(BackupAlgorithm b) {
        this.customBackupAlgorithm = b;
    }

    public void clearBackupAlgorithm() {
        this.customBackupAlgorithm = null;
    }

    public void invalidateCurrentDestination() {
        this.switchDest();
    }

    protected void timeoutReceived() {
        ++this.timeoutCount;
        if (this.timeoutCount > this.max_consecutive_timeouts) {
            this.switchDest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchDest() {
        if (this.backupAddresses != null || this.customBackupAlgorithm != null) {
            Object e;
            Object e22;
            String address = null;
            this.timeoutCount = 0;
            if (this.customBackupAlgorithm != null) {
                try {
                    address = this.customBackupAlgorithm.getBackupAddress();
                    this.socket.closedSession(this);
                    this.socket = SnmpSocket.getSocket(address);
                    this.switchedDestination = true;
                }
                catch (Exception e3) {
                    System.out.println("SnmpSession:Switch to backup failed");
                    e3.printStackTrace();
                }
            } else {
                if (this.useActiveSwitcher) {
                    if (!this.switching) {
                        this.switching = true;
                        ActiveSwitcher a = new ActiveSwitcher(this);
                        a.start();
                    }
                    return;
                }
                try {
                    Object a = this.backupAddressLock;
                    synchronized (a) {
                        if (this.nextBackup >= this.backupAddresses.size()) {
                            address = this.primaryAddress;
                            this.nextBackup = 0;
                        } else {
                            address = (String)this.backupAddresses.elementAt(this.nextBackup++);
                        }
                    }
                    this.socket.closedSession(this);
                    this.socket = SnmpSocket.getSocket(address);
                    this.switchedDestination = true;
                }
                catch (Exception e22) {
                    System.out.println("SnmpSession:Switch to backup failed");
                    e22.printStackTrace();
                }
            }
            if (this.pollDrivers != null) {
                e22 = this.pollDrivers;
                synchronized (e22) {
                    e = this.pollDrivers.elements();
                    while (e.hasMoreElements()) {
                        PollingDriver d = (PollingDriver)e.nextElement();
                        d.anyChanges = true;
                    }
                }
            }
            System.out.println("+++++++++++ SnmpSession: Switching to backup: new addr=" + address);
            if (this.watchMe != null) {
                this.watchMe.parmsChanged(this);
            }
            e22 = null;
            e = this.addressChangeLock;
            synchronized (e) {
                if (this.addressChangeListeners != null) {
                    e22 = this.addressChangeListeners.elements();
                }
            }
            if (e22 != null) {
                AddressChangeEvent addressChangeEvent = new AddressChangeEvent(this, this.currentHostname, address);
                while (e22.hasMoreElements()) {
                    try {
                        AddressChangeListener listener = (AddressChangeListener)e22.nextElement();
                        listener.ipAddressChanged(addressChangeEvent);
                    }
                    catch (Exception except) {
                        System.out.println("Recovered from following exception:");
                        except.printStackTrace();
                    }
                }
            }
            this.currentHostname = this.nameToAddr(address);
            this.currentAddress = null;
            this.securityInfo = this.getSecurityInfoForAddress(address);
        } else {
            this.transmit_state = 1;
            this.createTimeoutPeriodTimer = TimerService.scheduleWakeUp(this.createTimeoutPeriod, this, null);
        }
    }

    public void wakeUp(Object o) {
        this.transmit_state = 0;
        this.createTimeoutPeriodTimer = null;
    }

    protected void dataReceived() {
        this.timeoutCount = 0;
        this.transmit_state = 0;
        if (this.createTimeoutPeriodTimer != null) {
            TimerService.cancelWakeUp(this.createTimeoutPeriodTimer);
            this.createTimeoutPeriodTimer = null;
        }
    }

    private SessionInfo getSecurityInfoForAddress(String address) {
        System.out.println("SnmpSession: returning old securityInfo after address change");
        return this.securityInfo;
    }

    public SessionInfo getSecurityInfo() {
        return this.securityInfo;
    }

    protected boolean isSwitching() {
        return this.switching;
    }

    public void setMaxTimeouts(int num) {
        if (num > 0) {
            this.max_consecutive_timeouts = num;
        }
    }

    static /* synthetic */ DatagramSocket access$000() {
        return timeoutSock;
    }

    class ActiveSwitcher
    extends Thread
    implements Snmp_callback {
        private SnmpSession session;
        private int foundOne = -1;
        private int numBads = 0;
        private int numSends = 0;

        ActiveSwitcher(SnmpSession s) {
            this.session = s;
        }

        public synchronized void handle_response(int reason, SnmpMetaPDU pdu, SnmpSession target, Object user_data) {
            if (this.foundOne > 0) {
                return;
            }
            System.out.println("In active Switcher callback+++++++++++++++");
            switch (((SnmpPDU)pdu).errorStatus) {
                case 100: 
                case 101: 
                case 102: 
                case 103: {
                    System.out.println("In active Switcher callback -- bad +++++++++++++++");
                    ++this.numBads;
                    break;
                }
                default: {
                    System.out.println("In active Switcher callback -- good +++++++++++++++");
                    this.foundOne = (Integer)user_data;
                    this.notifyAll();
                }
            }
            if (this.numBads >= this.numSends) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.setName("ActiveSwitcher" + this.session.primaryAddress);
            System.out.println("In active Switcher");
            if (this.session.backupAddresses != null) {
                Object d;
                String address = null;
                try {
                    Object object = this.session.backupAddressLock;
                    synchronized (object) {
                        SessionInfo tempSecInfo = null;
                        SnmpPDU pdu = this.session.makePDU();
                        pdu.operation = 0;
                        boolean setCommName = true;
                        pdu.addVarBind("1.3.6.1.2.1.1.2.0");
                        SnmpSocket s = SnmpSocket.getSocket(this.session.primaryAddress);
                        SessionInfo secInfo = this.session.getSecurityInfoForAddress(this.session.primaryAddress);
                        if (setCommName) {
                            pdu.communityString = ((SessionInfoCommString)secInfo).getCommunityNameOctet;
                            tempSecInfo = this.session.securityInfo;
                            this.session.securityInfo = null;
                        } else {
                            this.session.securityInfo = secInfo;
                        }
                        ActiveSwitcher activeSwitcher = this;
                        synchronized (activeSwitcher) {
                            System.out.println("Sending test to " + this.session.primaryAddress);
                            s.send(this.session, pdu, null, this, (Object)new Integer(0), true);
                            ++this.numSends;
                            if (setCommName) {
                                this.session.securityInfo = tempSecInfo;
                            }
                            int limit = this.session.backupAddresses.size();
                            for (int i = 0; i < limit; ++i) {
                                String addr = (String)this.session.backupAddresses.elementAt(i);
                                s = SnmpSocket.getSocket(addr);
                                secInfo = this.session.getSecurityInfoForAddress(addr);
                                if (setCommName) {
                                    pdu.communityString = ((SessionInfoCommString)secInfo).getCommunityNameOctet;
                                    tempSecInfo = this.session.securityInfo;
                                    this.session.securityInfo = null;
                                } else {
                                    this.session.securityInfo = secInfo;
                                }
                                System.out.println("Sending test to " + addr);
                                s.send(this.session, pdu, null, this, (Object)new Integer(i + 1), true);
                                ++this.numSends;
                                if (!setCommName) continue;
                                this.session.securityInfo = tempSecInfo;
                            }
                            this.wait();
                        }
                        if (this.foundOne >= 0) {
                            System.out.println("Found one = " + this.foundOne);
                            if (this.foundOne == 0) {
                                address = this.session.primaryAddress;
                                this.session.nextBackup = 0;
                            } else {
                                address = (String)this.session.backupAddresses.elementAt(this.foundOne - 1);
                                this.session.nextBackup = this.foundOne;
                            }
                            this.session.switchedDestination = true;
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("SnmpSession:Switch to backup failed");
                    e.printStackTrace();
                }
                if (this.session.pollDrivers != null) {
                    Hashtable e = this.session.pollDrivers;
                    synchronized (e) {
                        Enumeration e2 = this.session.pollDrivers.elements();
                        while (e2.hasMoreElements()) {
                            d = (PollingDriver)e2.nextElement();
                            ((PollingDriver)d).anyChanges = true;
                        }
                    }
                }
                if (this.session.switchedDestination) {
                    SnmpSocket origsocket = this.session.socket;
                    try {
                        this.session.socket = SnmpSocket.getSocket(address);
                        origsocket.closedSession(this.session);
                    }
                    catch (Exception es) {
                        this.session.socket = origsocket;
                        this.session.switching = false;
                        return;
                    }
                    System.out.println("+++++++++++ SnmpSession: Switching to backup: new addr=" + address);
                    if (this.session.watchMe != null) {
                        this.session.watchMe.parmsChanged(this.session);
                    }
                    Enumeration e = null;
                    d = this.session.addressChangeLock;
                    synchronized (d) {
                        if (this.session.addressChangeListeners != null) {
                            e = this.session.addressChangeListeners.elements();
                        }
                    }
                    if (e != null) {
                        AddressChangeEvent addressChangeEvent = new AddressChangeEvent(this, this.session.currentHostname, address);
                        while (e.hasMoreElements()) {
                            try {
                                AddressChangeListener listener = (AddressChangeListener)e.nextElement();
                                listener.ipAddressChanged(addressChangeEvent);
                            }
                            catch (Exception except) {
                                System.out.println("Recovered from following exception:");
                                except.printStackTrace();
                            }
                        }
                    }
                    this.session.currentHostname = SnmpSession.this.nameToAddr(address);
                    this.session.currentAddress = null;
                    this.session.securityInfo = this.session.getSecurityInfoForAddress(address);
                    this.session.timeoutCount = 0;
                }
            } else {
                this.session.transmit_state = 1;
                this.session.createTimeoutPeriodTimer = TimerService.scheduleWakeUp(this.session.createTimeoutPeriod, this.session, null);
            }
            this.session.switching = false;
        }
    }
}

