/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.snmp.PendingResponse;
import org.eclipse.aperi.snmp.RequestId;
import org.eclipse.aperi.snmp.SessionInfoCommString;
import org.eclipse.aperi.snmp.SnmpAsn1;
import org.eclipse.aperi.snmp.SnmpBERlength;
import org.eclipse.aperi.snmp.SnmpEncodeException;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpV2PDU;
import org.eclipse.aperi.snmp.data.Hex;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.toobighandler;
import org.eclipse.aperi.snmp.utils.Queue;
import org.eclipse.aperi.snmp.utils.Timer;
import org.eclipse.aperi.snmp.utils.TimerService;
import org.eclipse.aperi.snmp.utils.Wakeable;

class SnmpSocket
extends Thread
implements Wakeable {
    private static DatagramSocket sock;
    private boolean started = false;
    private static boolean running;
    private static SnmpSocket socket;
    private static Hashtable hosts;
    protected int useCount = 0;
    private Hashtable broadcastSessions = null;

    protected SnmpSocket(InetAddress ipAddress) throws SnmpSocketException {
        running = false;
        try {
            sock = SnmpV1API.localHost == null ? new DatagramSocket() : new DatagramSocket(SnmpV1API.localPort, InetAddress.getByName(SnmpV1API.localHost));
            sock.setSoTimeout(Integer.MAX_VALUE);
        }
        catch (Exception e) {
            sock = null;
            this.started = false;
            e.printStackTrace();
        }
        this.broadcastSessions = new Hashtable();
    }

    protected boolean isReady() {
        return this.started;
    }

    protected InetAddress getIpAddress() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Hashtable pendingRsps = null;
        this.setName("SnmpReceive");
        if (sock == null) {
            return;
        }
        byte[] pdu = new byte[32768];
        this.started = true;
        running = true;
        SnmpSocket snmpSocket = this;
        synchronized (snmpSocket) {
            this.notifyAll();
        }
        while (running) {
            block50: {
                DatagramPacket recvPdu = new DatagramPacket(pdu, pdu.length);
                try {
                    Object hostKey;
                    byte[] rspPdu;
                    sock.receive(recvPdu);
                    if (SnmpV1API.isTracing()) {
                        SnmpV1API.trace("received on socket");
                    }
                    if (0 != (rspPdu = recvPdu.getData())[0]) {
                        Integer key;
                        int version;
                        SnmpPDU rsp;
                        boolean isBroadcast;
                        block49: {
                            int id;
                            hostKey = recvPdu.getAddress().getHostAddress();
                            pendingRsps = (Hashtable)hosts.get(hostKey);
                            isBroadcast = false;
                            if (pendingRsps == null && (pendingRsps = this.getBroadcastMessage(id = SnmpAsn1.getMessageId(rspPdu))) != null) {
                                isBroadcast = true;
                            }
                            if (pendingRsps == null) {
                                String message = null;
                                try {
                                    message = hostKey != null ? "No pending queue for host " + hostKey.toString() : "Packet received - returned null for getHostAddress()";
                                    if (rspPdu != null) {
                                        byte[] b = new byte[recvPdu.getLength()];
                                        System.arraycopy(rspPdu, 0, b, 0, b.length);
                                        OctetString o = new OctetString(b);
                                        message = message + "\npacket was: " + o;
                                    }
                                }
                                catch (Throwable caught) {
                                    caught.printStackTrace();
                                }
                                if (!SnmpV1API.isTracing()) continue;
                                SnmpV1API.trace(message);
                                continue;
                            }
                            rsp = null;
                            version = 0;
                            key = null;
                            try {
                                if (rspPdu[0] != 48) {
                                    if (!SnmpV1API.isTracing()) continue;
                                    SnmpV1API.trace(Hex.toString(rspPdu, 0, recvPdu.getLength()));
                                    continue;
                                }
                                int seqLen = SnmpBERlength.size(rspPdu, 1);
                                version = rspPdu[1 + seqLen + 1] == 1 ? rspPdu[1 + seqLen + 2] : SnmpAsn1.decode_int(rspPdu, 1 + seqLen);
                                if (version == 0) {
                                    rsp = SnmpAsn1.decodePDU(rspPdu, recvPdu.getLength());
                                    break block49;
                                }
                                if (version == 1) {
                                    rsp = SnmpAsn1.decodeV2PDU(rspPdu, recvPdu.getLength());
                                    break block49;
                                }
                                if (version == 3) {
                                    key = new Integer(SnmpAsn1.getMessageId(rspPdu));
                                    if (SnmpV1API.isTracing()) {
                                        SnmpV1API.trace("SnmpSocket: looking up v3 message: MessageId is " + SnmpAsn1.getMessageId(rspPdu));
                                    }
                                    PendingResponse pend = null;
                                    SnmpSocket snmpSocket2 = this;
                                    synchronized (snmpSocket2) {
                                        pend = (PendingResponse)pendingRsps.get(key);
                                    }
                                    if (pend != null) {
                                        try {
                                            rsp = pend.session.decodeMessage(rspPdu, recvPdu.getLength());
                                            if (rsp.operation == 7 && pend.isUserPacket) {
                                                continue;
                                            }
                                        }
                                        catch (Exception e) {
                                            rsp = pend.session.makePDU();
                                            rsp.errorStatus = 103;
                                        }
                                        if (!SnmpV1API.isTracing()) break block49;
                                        SnmpV1API.trace("SnmpSocket: made PDU");
                                        break block49;
                                    }
                                    if (!SnmpV1API.isTracing()) break block49;
                                    SnmpV1API.trace("SnmpSocket: pend was null - no message decoded");
                                    break block49;
                                }
                                throw new Exception();
                            }
                            catch (Exception e) {
                                try {
                                    if (SnmpV1API.isTracing()) {
                                        SnmpV1API.trace("Received some kind of bad response.\nLength of response is:" + recvPdu.getLength());
                                    }
                                    byte[] b = new byte[recvPdu.getLength()];
                                    System.arraycopy(recvPdu, 0, b, 0, b.length);
                                    OctetString o = new OctetString(b);
                                    if (!SnmpV1API.isTracing()) continue;
                                    SnmpV1API.trace("Unable to decode the following PDU: " + o);
                                }
                                catch (Exception e2) {
                                    System.out.println("Received some kind of bad response which could not not be dumped.");
                                    e2.printStackTrace();
                                }
                                continue;
                            }
                        }
                        PendingResponse pend = null;
                        if (rsp != null) {
                            if (version != 3) {
                                key = new Integer(rsp.requestId);
                            }
                            SnmpSocket e2 = this;
                            synchronized (e2) {
                                pend = isBroadcast ? (PendingResponse)pendingRsps.get(key) : (PendingResponse)pendingRsps.remove(key);
                            }
                        }
                        if (pend != null) {
                            if (!isBroadcast) {
                                TimerService.cancelWakeUp(pend.timer);
                            }
                            if (rsp.errorStatus == 1 && rsp.varBindList.size() >= 2) {
                                if (SnmpV1API.isTracing()) {
                                    SnmpV1API.trace("SnmpSocket:Too Big handler invoked: " + rsp.toString());
                                }
                                new toobighandler(pend).start();
                            } else {
                                int elapsedTime = (int)(System.currentTimeMillis() - pend.sendTime);
                                pend.session.stats.incrReceives(elapsedTime, rsp.varBindListSize());
                                SnmpV1API.getSnmpStats().incrReceives(elapsedTime, rsp.varBindListSize());
                                rsp.correlator = pend.correlator;
                                if (SnmpV1API.isTracing()) {
                                    SnmpV1API.trace("<== Response from " + pend.session.currentHostname + " received by " + Thread.currentThread() + "\n" + rsp);
                                }
                                if (SnmpV1API.isTracing()) {
                                    SnmpV1API.trace("SnmpSocket:calling handleResponse with PDU");
                                }
                                pend.handleResponse(rsp);
                            }
                        }
                        break block50;
                    }
                    if (0 != rspPdu[0]) break block50;
                    hostKey = this;
                    synchronized (hostKey) {
                        running = false;
                        sock.close();
                    }
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            snmpSocket = null;
        }
    }

    protected static synchronized void closeSocket() {
        running = false;
        sock.close();
        socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized SnmpSocket getSocket(String hostNameOrIpAddress) throws SnmpUnknownHostException, SnmpSocketException {
        if (socket == null) {
            socket = new SnmpSocket(null);
            try {
                SnmpSocket snmpSocket = socket;
                synchronized (snmpSocket) {
                    socket.setDaemon(true);
                    socket.start();
                    socket.wait(1000L);
                }
            }
            catch (InterruptedException ie) {}
        } else {
            SnmpSocket ie = socket;
            synchronized (ie) {
                if (!running) {
                    try {
                        socket.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            String key = InetAddress.getByName(hostNameOrIpAddress).getHostAddress();
            if (hosts.get(key) == null) {
                hosts.put(key, new Hashtable());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return socket;
    }

    public synchronized void addUser() {
    }

    public synchronized void removeUser() {
    }

    public synchronized boolean inUse() {
        return true;
    }

    Hashtable getBroadcastMessage(int id) {
        Hashtable ret = null;
        ret = (Hashtable)this.broadcastSessions.get(new Integer(id));
        return ret;
    }

    protected DatagramPacket encodeThePDU(SnmpSession session, SnmpPDU pdu, boolean isPoller) {
        DatagramPacket packet = null;
        if (session.securityInfo instanceof SessionInfoCommString) {
            pdu.communityString = pdu.operation != 3 ? ((SessionInfoCommString)session.securityInfo).getCommunityNameOctet : ((SessionInfoCommString)session.securityInfo).setCommunityNameOctet;
        }
        if (running) {
            pdu.requestId = isPoller ? RequestId.newPollId() : RequestId.newRequestId();
            try {
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("encoding.... " + pdu.toString() + " ---- " + session.securityInfo.toString());
                }
                byte[] pduBER = null;
                switch (pdu.version) {
                    case 0: {
                        pduBER = SnmpAsn1.encode(pdu, session.securityInfo);
                        break;
                    }
                    case 1: {
                        pduBER = SnmpAsn1.encodeV2PDU((SnmpV2PDU)pdu, session.securityInfo);
                        break;
                    }
                    default: {
                        SnmpV1API.trace("Invalid PDU version encountered - " + pdu.toString());
                    }
                }
                packet = new DatagramPacket(pduBER, pduBER.length, session.getInetAddress(), session.remotePort);
            }
            catch (SnmpEncodeException e) {
                SnmpV1API.trace("Encode error encountered:" + e.toString());
                e.printStackTrace();
            }
        }
        return packet;
    }

    protected boolean send(SnmpSession session, SnmpPDU pdu, Queue responseQueue, Object callback, Object user_data, boolean switcher) {
        return this.send(session, pdu, true, responseQueue, callback, user_data, switcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean send(SnmpSession session, SnmpPDU pdu, boolean isUserPacket, Queue responseQueue, Object callback, Object user_data, boolean switcher) {
        if (session.closed && SnmpV1API.isTracing()) {
            SnmpV1API.trace("Closed session - " + session + ":" + pdu);
        }
        Hashtable pendingRsps = null;
        PendingResponse p = new PendingResponse(session, 0, session.retries, session.timeout, null, pdu.correlator, isUserPacket, responseQueue, callback, user_data);
        DatagramPacket packet = null;
        Timer timer = null;
        boolean sentOK = true;
        SnmpPDU errPDU = null;
        if (session.transmit_state == 1) {
            errPDU = p.session.makePDU();
            errPDU.errorStatus = 100;
        } else if (session.isSwitching() && !switcher) {
            errPDU = p.session.makePDU();
            errPDU.errorStatus = 100;
        } else {
            packet = this.encodeThePDU(session, pdu, false);
            if (packet != null && running && !session.closed) {
                p.pack = packet;
                p.reqID = pdu.getCorrelatorValue();
                Integer key = new Integer(p.reqID);
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("SnmpSocket: saving away a message: RequestId is " + pdu.requestId);
                }
                SnmpSocket snmpSocket = this;
                synchronized (snmpSocket) {
                    pendingRsps = (Hashtable)hosts.get(session.getIpAddress());
                    pendingRsps.put(key, p);
                    if (session.isBroadcast) {
                        this.broadcastSessions.put(key, p);
                    }
                    p.timer = timer = TimerService.scheduleWakeUp(session.timeout, this, p);
                }
                try {
                    if (SnmpV1API.isTracing()) {
                        SnmpV1API.trace("Sending on socket");
                    }
                    sock.send(packet);
                    p.session.stats.incrSends(pdu.varBindListSize());
                    p.session.stats.setLastUsed(p.sendTime);
                    SnmpV1API.getSnmpStats().incrSends(pdu.varBindListSize());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e instanceof IOException || e instanceof SnmpEncodeException) {
                        // empty if block
                    }
                    SnmpSocket snmpSocket2 = this;
                    synchronized (snmpSocket2) {
                        pendingRsps.remove(key);
                        TimerService.cancelWakeUp(timer);
                    }
                    sentOK = false;
                    errPDU = p.session.makePDU();
                    errPDU.errorStatus = 101;
                }
            } else {
                sentOK = false;
                errPDU = p.session.makePDU();
                errPDU.errorStatus = 102;
            }
        }
        if (errPDU == null) {
            if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("==> Sent request to " + session.currentHostname + " by " + Thread.currentThread() + "\n" + pdu);
            }
        } else {
            errPDU.requestId = pdu.requestId;
            errPDU.operation = 2;
            errPDU.correlator = pdu.correlator;
            if (SnmpV1API.isTracing()) {
                String reason = "send error";
                if (errPDU.errorStatus == 102) {
                    reason = "closed session";
                } else if (session.transmit_state == 1) {
                    reason = "timeoout without transmit to clear messages";
                }
                SnmpV1API.trace("Send failed to " + session.currentHostname + " by " + Thread.currentThread() + " due to " + reason + "\n" + pdu);
            }
            p.handleResponse(errPDU);
        }
        return sentOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean send(SnmpSession session, SnmpPDU pdu, DatagramPacket packet, Queue responseQueue, Object callback, Object user_data) {
        Hashtable pendingRsps = null;
        PendingResponse p = new PendingResponse(session, 0, session.retries, session.timeout, null, pdu.correlator, true, responseQueue, callback, user_data);
        Timer timer = null;
        boolean sentOK = true;
        SnmpPDU errPDU = null;
        int requestId = RequestId.newPollId();
        if (session.transmit_state == 1) {
            errPDU = p.session.makePDU();
            errPDU.errorStatus = 100;
        } else if (session.isSwitching()) {
            errPDU = p.session.makePDU();
            errPDU.errorStatus = 100;
        } else {
            p.pack = packet;
            p.reqID = requestId;
            pdu.requestId = requestId;
            if (packet != null && running && !session.closed) {
                byte[] ber = packet.getData();
                int offset = pdu.requestIdPos;
                ber[offset] = (byte)(requestId >> 24 & 0xFF);
                ber[offset + 1] = (byte)(requestId >> 16 & 0xFF);
                ber[offset + 2] = (byte)(requestId >> 8 & 0xFF);
                ber[offset + 3] = (byte)(requestId & 0xFF);
                Integer key = new Integer(pdu.getCorrelatorValue());
                SnmpSocket snmpSocket = this;
                synchronized (snmpSocket) {
                    pendingRsps = (Hashtable)hosts.get(session.getIpAddress());
                    pendingRsps.put(key, p);
                    p.timer = timer = TimerService.scheduleWakeUp(session.timeout, this, p);
                }
                try {
                    sock.send(packet);
                    p.session.stats.incrSends(pdu.varBindListSize());
                    SnmpV1API.getSnmpStats().incrSends(pdu.varBindListSize());
                }
                catch (IOException e) {
                    SnmpSocket snmpSocket2 = this;
                    synchronized (snmpSocket2) {
                        pendingRsps.remove(key);
                        TimerService.cancelWakeUp(timer);
                    }
                    sentOK = false;
                    errPDU = p.session.makePDU();
                    errPDU.errorStatus = 101;
                }
            } else {
                sentOK = false;
                errPDU = p.session.makePDU();
                errPDU.errorStatus = 102;
            }
        }
        if (errPDU == null) {
            if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("==> Sent request to " + session.currentHostname + " by " + Thread.currentThread() + "\n" + pdu);
            }
        } else {
            errPDU.requestId = requestId;
            errPDU.operation = 2;
            errPDU.correlator = pdu.correlator;
            if (SnmpV1API.isTracing()) {
                String reason = "send error";
                if (errPDU.errorStatus == 102) {
                    reason = "closed session";
                } else if (session.transmit_state == 1) {
                    reason = "timeoout without transmit to clear messages";
                }
                SnmpV1API.trace("Send failed to " + session.currentHostname + " by " + Thread.currentThread() + " due to " + reason + "\n" + pdu);
            }
            p.handleResponse(errPDU);
        }
        return sentOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp(Object userData) {
        Hashtable pendingRsps = null;
        PendingResponse p = (PendingResponse)userData;
        Timer timer = null;
        boolean wasPending = false;
        boolean resend = false;
        Integer key = new Integer(p.reqID);
        SnmpSocket snmpSocket = this;
        synchronized (snmpSocket) {
            pendingRsps = (Hashtable)hosts.get(p.session.getIpAddress());
            if (pendingRsps.containsKey(key)) {
                wasPending = true;
                --p.retries;
                if (p.retries < 0 || p.session.isBroadcast) {
                    pendingRsps.remove(key);
                } else {
                    resend = true;
                    p.timeout += p.timeout;
                    p.timer = timer = TimerService.scheduleWakeUp(p.timeout, this, p);
                }
            }
        }
        if (resend) {
            try {
                DatagramPacket pack = null;
                pack = p.pack != null ? p.pack : this.encodeThePDU(p.session, (SnmpPDU)p.pdu, false);
                sock.send(pack);
                p.session.stats.incrRetries();
                SnmpV1API.getSnmpStats().incrRetries();
            }
            catch (IOException e) {
                SnmpSocket snmpSocket2 = this;
                synchronized (snmpSocket2) {
                    pendingRsps.remove(key);
                    TimerService.cancelWakeUp(timer);
                }
                p.retries = -1;
            }
        }
        if (wasPending) {
            if (p.retries < 0) {
                SnmpPDU timeoutPDU = p.session.makePDU();
                timeoutPDU.errorStatus = 100;
                timeoutPDU.operation = 2;
                timeoutPDU.requestId = p.reqID;
                timeoutPDU.correlator = p.correlator;
                int elapsedTime = (int)(System.currentTimeMillis() - p.sendTime);
                p.session.stats.incrTimeouts();
                p.session.stats.incrReceives(elapsedTime, 0);
                SnmpV1API.getSnmpStats().incrTimeouts();
                SnmpV1API.getSnmpStats().incrReceives(elapsedTime, 0);
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("<== Response " + p.reqID + " from " + p.session.currentHostname + " timed out by " + Thread.currentThread());
                }
                p.handleResponse(timeoutPDU);
            } else if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("<== Response " + p.reqID + " from " + p.session.currentHostname + " remaining retries = " + p.retries + " out of " + p.session.retries + ", timeout = " + p.timeout / 2 + ", by " + Thread.currentThread());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closedSession(SnmpSession sess) {
        Hashtable pendingRsps = (Hashtable)hosts.get(sess.getIpAddress());
        while (pendingRsps.size() > 0) {
            Hashtable h = (Hashtable)pendingRsps.clone();
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                PendingResponse p;
                Integer key = (Integer)e.nextElement();
                SnmpSocket snmpSocket = this;
                synchronized (snmpSocket) {
                    p = (PendingResponse)pendingRsps.get(key);
                    if (p != null && p.session == sess) {
                        pendingRsps.remove(key);
                    } else {
                        p = null;
                    }
                }
                if (p == null) continue;
                SnmpPDU pdu = p.session.makePDU();
                pdu.errorStatus = 102;
                pdu.requestId = p.reqID;
                pdu.operation = 2;
                pdu.correlator = p.correlator;
                p.handleResponse(pdu);
            }
        }
    }

    protected int getLocalPort() {
        int retval = 0;
        if (sock != null) {
            retval = sock.getLocalPort();
        }
        return retval;
    }

    static {
        socket = null;
        hosts = new Hashtable();
    }
}

