/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.aperi.snmp.SnmpAsn1;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;

public class SnmpTarget {
    protected InetAddress destination;
    protected int port;
    protected boolean canReplayMessages;
    int useCount = 0;

    protected SnmpTarget() {
    }

    protected SnmpTarget(String address, int port) throws SnmpUnknownHostException {
        try {
            this.destination = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new SnmpUnknownHostException();
        }
        this.port = port;
        this.useCount = 1;
    }

    public void close() {
        --this.useCount;
        SnmpV1API.terminateTraps();
    }

    public static void send(SnmpTrap trap, String destination, int port) throws SnmpUnknownHostException, IOException {
        InetAddress address;
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("==> Sending Trap \n" + trap.toString());
        }
        if (SnmpV1API.trapSocket != null) {
            try {
                address = InetAddress.getByName(destination);
            }
            catch (Exception e) {
                throw new SnmpUnknownHostException();
            }
        } else {
            throw new SnmpSocketException("SnmpV1API traps not available");
        }
        byte[] buffer = SnmpAsn1.encode(trap, null);
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address, port);
        SnmpV1API.trapSocket.send(packet);
    }

    public static void send(SnmpTrap trap, String destination) throws SnmpUnknownHostException, IOException {
        SnmpTarget.send(trap, destination, 162);
    }

    public void send(SnmpTrap trap) throws IOException {
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("==> Sending Trap \n" + trap.toString());
        }
        if (SnmpV1API.trapSocket == null) {
            throw new SnmpSocketException("SnmpV1API traps not available");
        }
        byte[] buffer = SnmpAsn1.encode(trap, null);
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, this.destination, this.port);
        SnmpV1API.trapSocket.send(packet);
    }
}

