/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.util.Vector;
import org.eclipse.aperi.snmp.SnmpMetaPDU;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.TimeTicks;

public class SnmpTrap
extends SnmpMetaPDU {
    public static final int COLDSTART = 0;
    public static final int WARMSTART = 1;
    public static final int LINKDOWN = 2;
    public static final int LINKUP = 3;
    public static final int AUTHENTICATIONFAILURE = 4;
    public static final int EGPNEIGHBORLOSS = 5;
    public static final int ENTERPRISESPECIFIC = 6;
    public static final byte TRAP_TAG = -92;
    public OID enterprise;
    public IPAddress agentAddr;
    public int genericTrap = 0;
    public int specificTrap = 0;
    public TimeTicks timeStamp;

    public SnmpTrap() {
        this.communityString = new OctetString("public");
        this.enterprise = null;
        this.agentAddr = null;
        this.senderAddr = null;
        this.genericTrap = 0;
        this.specificTrap = 0;
        this.timeStamp = null;
    }

    public SnmpTrap(SnmpTrap pdu) {
        super(pdu);
        this.enterprise = new OID(pdu.enterprise);
        this.agentAddr = new IPAddress(pdu.agentAddr.toString());
        this.agentAddr = new IPAddress(pdu.senderAddr.toString());
        this.genericTrap = pdu.genericTrap;
        this.specificTrap = pdu.specificTrap;
        this.timeStamp = new TimeTicks(pdu.timeStamp.value);
    }

    public SnmpTrap(Vector vbList) {
        super(vbList);
        this.communityString = new OctetString("public");
        this.enterprise = null;
        this.agentAddr = null;
        this.genericTrap = 0;
        this.specificTrap = 0;
        this.timeStamp = null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Message :");
        buffer.append(" version=" + this.version + " communityString=" + this.communityString.toDisplayString() + "\n          enterprise=" + this.enterprise.toString() + " agentAddr=" + this.agentAddr.toString() + " genericTrap=" + this.genericTrap + "\n          specificTrap=" + this.specificTrap + " timeStamp=" + this.timeStamp + "\n          ");
        buffer.append(this.varBindListToString());
        return buffer.toString();
    }

    public void set_notify_timestamp(TimeTicks time) {
        this.timeStamp = time;
    }

    public TimeTicks get_notify_timestamp() {
        return this.timeStamp;
    }

    public void set_notify_id(OID id) {
        System.out.println("SnmpTrap:set_notify_id(id) - ID?? what is the ID in a Trap?");
    }

    public OID get_notify_id() {
        System.out.println("SnmpTrap:get_notify_id() - ID?? what is the ID in a Trap?");
        return null;
    }

    public void set_notify_enterprise(OID enterprise) {
        this.enterprise = enterprise;
    }

    public OID get_notify_enterprise() {
        return this.enterprise;
    }

    public boolean isTrapEnterpriseSpecific() {
        return this.genericTrap == 6;
    }

    public int get_generic_id() {
        return this.genericTrap;
    }

    public int get_specific_id() {
        return this.specificTrap;
    }
}

