/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.PrintStream;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.snmp.BasicConfig;
import org.eclipse.aperi.snmp.Ebcdic;
import org.eclipse.aperi.snmp.IConfig;
import org.eclipse.aperi.snmp.ITracer;
import org.eclipse.aperi.snmp.SessionSweeper;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpStatistics;
import org.eclipse.aperi.snmp.SnmpTracer;
import org.eclipse.aperi.snmp.StreamTracer;
import org.eclipse.aperi.snmp.utils.TimerService;

public class SnmpV1API {
    private static String DEFAULT_TRACER = "org.eclipse.aperi.snmp.BaseTracer";
    private static String DEFAULT_CONFIG = "org.eclipse.aperi.snmp.BasicConfig";
    static final int default_trace_port = 7777;
    public static boolean exposeSecurityInfo = true;
    static final String apiVersion = "7.2.2";
    static ITracer tracer = null;
    static SessionSweeper sweeper = null;
    static IConfig config = null;
    public static String localHost = null;
    public static int localPort = 9876;
    protected static boolean initialized = false;
    protected static boolean returnBigInteger = false;
    private static SnmpStatistics stats = null;
    protected static DatagramSocket trapSocket = null;
    private static int trapSessions = 0;

    protected SnmpV1API() {
    }

    public static synchronized void initialize(String baseDir) throws SnmpSocketException, Exception {
        SnmpV1API.initialize(baseDir, 7777, true);
    }

    public static synchronized void initialize() throws SnmpSocketException, Exception {
        SnmpV1API.initialize("", 7777, true);
    }

    public static synchronized void initialize(int port) throws SnmpSocketException, Exception {
        SnmpV1API.initialize("", port, true);
    }

    public static synchronized void initialize(String configDir, int tracePortNumber) throws SnmpSocketException, Exception {
        SnmpV1API.initialize(configDir, tracePortNumber, true);
    }

    public static synchronized void initialize(String configDir, int tracePortNumber, boolean completeInit) throws SnmpSocketException, Exception {
        SnmpV1API.initialize(configDir, tracePortNumber, completeInit, DEFAULT_TRACER, DEFAULT_CONFIG, SnmpV1API.class.getClassLoader());
    }

    public static synchronized void initialize(String configDir, int tracePortNumber, boolean completeInit, String traceClassName, String configClassName, ClassLoader loader) throws SnmpSocketException, Exception {
        if (initialized) {
            return;
        }
        if ("OS/390".equals(System.getProperty("os.name"))) {
            Ebcdic.useEBCDIC = true;
        }
        try {
            stats = new SnmpStatistics();
            TimerService.initialize();
            if (tracePortNumber > 0) {
                SnmpTracer.initialize(tracePortNumber);
            }
            if (completeInit) {
                initialized = true;
            }
        }
        catch (SocketException e) {
            if (TimerService.isReady()) {
                TimerService.terminate();
                Thread.yield();
            }
            if (SnmpTracer.isReady()) {
                SnmpTracer.terminate();
                Thread.yield();
            }
            throw new SnmpSocketException(e.getMessage());
        }
        if (traceClassName == null) {
            traceClassName = DEFAULT_TRACER;
        }
        Class<?> c = null;
        c = loader == null ? Class.forName(traceClassName) : loader.loadClass(traceClassName);
        tracer = (ITracer)c.newInstance();
        try {
            sweeper = new SessionSweeper();
        }
        catch (NoClassDefFoundError n) {
            if (!n.getMessage().equals("com/tivoli/util/Wakeable")) {
                tracer.trace(SnmpV1API.class, "NoClassDefFoundError starting SessionSweeper:" + n.toString());
            }
        }
        catch (Throwable t) {
            tracer.trace(SnmpV1API.class, "Error starting SessionSweeper:" + t.toString());
        }
        if (configClassName == null) {
            configClassName = DEFAULT_CONFIG;
        }
        try {
            c = loader == null ? Class.forName(configClassName) : loader.loadClass(configClassName);
            config = (IConfig)c.newInstance();
        }
        catch (Throwable t) {
            tracer.trace(SnmpV1API.class, "Using default configuration due to an error initializing config interface:" + t.toString());
            config = new BasicConfig();
        }
    }

    public static IConfig getConfig() {
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void terminate() {
        Vector vector = SnmpSession.sessions;
        synchronized (vector) {
            initialized = false;
            while (SnmpSession.sessions.size() > 0) {
                Enumeration e = SnmpSession.sessions.elements();
                SnmpSession s = (SnmpSession)e.nextElement();
                s.close();
            }
        }
        tracer = null;
        if (sweeper != null) {
            sweeper.stop();
            sweeper = null;
        }
        TimerService.terminate();
        Thread.yield();
        SnmpTracer.terminate();
        Thread.yield();
    }

    protected static void initializeTraps() throws SocketException {
        if (trapSocket == null) {
            try {
                trapSocket = (DatagramSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new DatagramSocket();
                    }
                });
            }
            catch (Exception e) {
                throw new SnmpSocketException(e.getMessage());
            }
        }
        ++trapSessions;
    }

    public static void terminateTraps() {
        if (--trapSessions <= 0 && trapSocket != null) {
            trapSocket.close();
            trapSocket = null;
        }
    }

    public static boolean isTracing() {
        if (tracer != null) {
            return tracer.isTracing();
        }
        return false;
    }

    public static void trace(Object o, String mess) {
        try {
            tracer.trace(o, mess);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void trace(String mess) {
        try {
            tracer.trace(tracer, mess);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static SnmpStatistics getSnmpStats() {
        return stats;
    }

    public static synchronized void startTrace(PrintStream traceOutputFile) {
        if (tracer instanceof StreamTracer) {
            ((StreamTracer)((Object)tracer)).setOutputStream(traceOutputFile);
        }
        tracer.startTracing();
    }

    public static synchronized void stopTrace() {
        if (tracer.isTracing()) {
            tracer.stopTracing();
        }
    }

    public static void setSecurityInfoPolicy(boolean print) {
        exposeSecurityInfo = print;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public static void useBigInteger() {
        returnBigInteger = true;
    }

    public static void useBigInteger(boolean returnBigInteger) {
        SnmpV1API.returnBigInteger = returnBigInteger;
    }

    public static void useLong() {
        returnBigInteger = false;
    }

    public static boolean isCounter64Full() {
        return returnBigInteger;
    }

    public static void main(String[] args) {
        System.out.println("This is the Java SNMP protocol stack version 7.2.2");
    }
}

