/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.TablePoller;
import org.eclipse.aperi.snmp.TablePollingInfo;
import org.eclipse.aperi.snmp.TableWalker;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.utils.Queue;

class WalkThread
extends Thread {
    private TableWalker walker;

    public WalkThread(TableWalker tableWalker) {
        this.walker = tableWalker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setName("Walker - " + this.walker.trustedColumn.toString());
        Queue rspQ = new Queue(true);
        boolean done = false;
        boolean noErrors = true;
        SnmpSession session = this.walker.session;
        Vector<OID> rows = new Vector<OID>();
        SnmpPDU pdu = session.makePDU();
        pdu.operation = 1;
        OID oid = this.walker.trustedColumn.concatenate(this.walker.index);
        pdu.addVarBind(oid);
        while (!done) {
            if (!this.walker.removed) {
                session.send(pdu, rspQ);
                SnmpPDU rsp = (SnmpPDU)rspQ.dequeue();
                if (rsp.errorStatus == 0) {
                    OID rowOID = rsp.varBindAt(0).get_oid();
                    if (rowOID.startsWith(oid)) {
                        rows.addElement(rowOID);
                        pdu = rsp;
                        pdu.operation = 1;
                        continue;
                    }
                    done = true;
                    continue;
                }
                done = true;
                noErrors = false;
                if (rsp.errorStatus != 100) continue;
                rows.removeAllElements();
                pdu = this.walker.session.makePDU();
                pdu.operation = 1;
                pdu.addVarBind(oid);
                try {
                    Thread.currentThread();
                    Thread.sleep(this.walker.interval);
                }
                catch (Exception e) {
                    // empty catch block
                }
                done = false;
                noErrors = true;
                continue;
            }
            done = true;
            noErrors = false;
        }
        if (noErrors) {
            TableWalker tableWalker = this.walker;
            synchronized (tableWalker) {
                int j;
                int i;
                int ix = 0;
                if (this.walker.polling) {
                    try {
                        this.walker.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                for (i = 0; i < this.walker.pollers.size(); ++i) {
                    TablePollingInfo info = (TablePollingInfo)this.walker.pollers.elementAt(i);
                    info.anyChanges = false;
                }
                i = 0;
                while (i < rows.size()) {
                    int j2;
                    if (ix >= this.walker.rows.size()) {
                        OID rowOID = (OID)rows.elementAt(i);
                        this.walker.rows.addElement(rowOID);
                        for (j2 = 0; j2 < this.walker.pollers.size(); ++j2) {
                            TablePollingInfo info = (TablePollingInfo)this.walker.pollers.elementAt(j2);
                            int numVals = ((TablePoller)info.poller).oids.length;
                            info.anyChanges = true;
                            info.newValues.addElement(new Serializable[numVals]);
                            info.oldValues.addElement(new Serializable[numVals]);
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("SnmpSession called rowAdded (" + info.cookie + "," + rowOID + ")");
                            }
                            Object rowCookie = ((TablePoller)info.poller).tableRef.rowAdded(info.cookie, rowOID);
                            info.rowCookie.addElement(rowCookie);
                        }
                        ++i;
                        ++ix;
                        continue;
                    }
                    int c = ((OID)this.walker.rows.elementAt(ix)).compareTo((OID)rows.elementAt(i));
                    if (c < 0) {
                        for (j2 = 0; j2 < this.walker.pollers.size(); ++j2) {
                            TablePollingInfo info = (TablePollingInfo)this.walker.pollers.elementAt(j2);
                            info.anyChanges = true;
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("SnmpSession called rowDeleted (" + info.cookie + "," + info.rowCookie.elementAt(ix) + ")");
                            }
                            ((TablePoller)info.poller).tableRef.rowDeleted(info.cookie, info.rowCookie.elementAt(ix));
                            info.rowCookie.removeElementAt(ix);
                            info.newValues.removeElementAt(ix);
                            info.oldValues.removeElementAt(ix);
                        }
                        this.walker.rows.removeElementAt(ix);
                        continue;
                    }
                    if (c > 0) {
                        OID rowOID = (OID)rows.elementAt(i);
                        this.walker.rows.insertElementAt(rowOID, ix);
                        for (int j3 = 0; j3 < this.walker.pollers.size(); ++j3) {
                            TablePollingInfo info = (TablePollingInfo)this.walker.pollers.elementAt(j3);
                            info.anyChanges = true;
                            int numVals = ((TablePoller)info.poller).oids.length;
                            info.newValues.insertElementAt(new Serializable[numVals], ix);
                            info.oldValues.insertElementAt(new Serializable[numVals], ix);
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("SnmpSession called rowAdded (" + info.cookie + "," + rowOID + ")");
                            }
                            Object rowCookie = ((TablePoller)info.poller).tableRef.rowAdded(info.cookie, rowOID);
                            info.rowCookie.insertElementAt(rowCookie, ix);
                        }
                        ++i;
                        ++ix;
                        continue;
                    }
                    ++i;
                    ++ix;
                }
                while (ix < this.walker.rows.size()) {
                    for (j = 0; j < this.walker.pollers.size(); ++j) {
                        TablePollingInfo info = (TablePollingInfo)this.walker.pollers.elementAt(j);
                        if (SnmpV1API.isTracing()) {
                            SnmpV1API.trace("SnmpSession called rowDeleted (" + info.cookie + "," + info.rowCookie.elementAt(ix) + ")");
                        }
                        ((TablePoller)info.poller).tableRef.rowDeleted(info.cookie, info.rowCookie.elementAt(ix));
                        info.anyChanges = true;
                        info.newValues.removeElementAt(ix);
                        info.oldValues.removeElementAt(ix);
                        info.rowCookie.removeElementAt(ix);
                    }
                    this.walker.rows.removeElementAt(ix);
                }
                if (ix == 0 && rows.size() == 0) {
                    while (this.walker.rows.size() > 0) {
                        for (j = 0; j < this.walker.pollers.size(); ++j) {
                            TablePollingInfo info = (TablePollingInfo)this.walker.pollers.elementAt(j);
                            info.anyChanges = true;
                            ((TablePoller)info.poller).tableRef.rowDeleted(info.cookie, info.rowCookie.elementAt(0));
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("SnmpSession called rowDeleted - empty table (" + info.cookie + "," + info.rowCookie.elementAt(0) + ")");
                            }
                            info.newValues.removeElementAt(0);
                            info.oldValues.removeElementAt(0);
                            info.rowCookie.removeElementAt(0);
                        }
                        this.walker.rows.removeElementAt(0);
                    }
                }
            }
        }
    }
}

