/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import java.util.Hashtable;
import org.eclipse.aperi.snmp.utils.Timer;
import org.eclipse.aperi.snmp.utils.TimerService;
import org.eclipse.aperi.snmp.utils.Wakeable;

public class Cache
implements Wakeable {
    Hashtable elements;
    Hashtable timers;
    int defaultLifespan = 0;
    Object currentKey = null;

    public Cache() {
        this(100);
    }

    public Cache(int initialSize) {
        this.elements = new Hashtable(initialSize);
        this.timers = new Hashtable(initialSize);
    }

    public synchronized void setDefaultLifespan(int lifespan) {
        this.defaultLifespan = lifespan;
    }

    public synchronized int getDefaultLifespan() {
        return this.defaultLifespan;
    }

    public synchronized void put(Object key, Object element) {
        this.put(key, element, this.defaultLifespan);
    }

    public synchronized void put(Object key, Object element, int lifespan) {
        this.remove(key);
        this.elements.put(key, element);
        if (lifespan != 0) {
            Timer timer = TimerService.scheduleWakeUp(lifespan * 1000, this, key);
            this.timers.put(key, timer);
        }
    }

    public synchronized void remove(Object key) {
        this.currentKey = key;
        Timer t = (Timer)this.timers.get(key);
        if (t != null) {
            TimerService.cancelWakeUp(t);
            this.elements.remove(key);
            this.timers.remove(key);
        }
        this.currentKey = null;
    }

    public synchronized Object get(Object key) {
        return this.elements.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp(Object userData) {
        if (userData == this.currentKey) {
            return;
        }
        Cache cache = this;
        synchronized (cache) {
            this.timers.remove(userData);
            this.elements.remove(userData);
        }
    }

    public synchronized int size() {
        return this.elements.size();
    }
}

