/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.utils.CallbackThread;
import org.eclipse.aperi.snmp.utils.OrderedQueue;
import org.eclipse.aperi.snmp.utils.Timer;
import org.eclipse.aperi.snmp.utils.Wakeable;

public class TimerService
extends Thread {
    private static boolean running = false;
    private static boolean started = false;
    private static boolean waiting = false;
    private static OrderedQueue timerQ = new OrderedQueue();
    private static TimerService inst = null;
    private static Object lock = new Object();

    private TimerService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Object object = lock;
        synchronized (object) {
            if (!started) {
                started = true;
                inst = new TimerService();
                inst.setDaemon(true);
                inst.start();
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("TimerService: initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReady() {
        boolean retval;
        Object object = lock;
        synchronized (object) {
            retval = started && waiting;
        }
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("TimerService: isReady=" + retval);
        }
        return retval;
    }

    public static Timer scheduleWakeUp(int msec_delay, Wakeable wakeMeUp) {
        return TimerService.scheduleWakeUp(msec_delay, wakeMeUp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timer scheduleWakeUp(int msec_delay, Wakeable wakeMeUp, Object userData) {
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("TimerService: scheduling wakeup");
        }
        if (!started) {
            TimerService.initialize();
        }
        if (!running) {
            return null;
        }
        Timer t = new Timer(msec_delay, wakeMeUp, userData);
        Object object = lock;
        synchronized (object) {
            boolean isFirst;
            timerQ.enqueue(t);
            boolean bl = isFirst = t == (Timer)timerQ.peek();
            if (isFirst && waiting) {
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("TimerService: wakeup is first, notifying");
                }
                lock.notify();
            }
        }
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("TimerService: scheduled wakeup");
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cancelWakeUp(Timer t) {
        boolean retval;
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("TimerService: canceling wakeup");
        }
        Object object = lock;
        synchronized (object) {
            boolean wasFirst = t == (Timer)timerQ.peek();
            retval = timerQ.dequeue(t);
            if (wasFirst && waiting) {
                lock.notify();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setName("TimerService");
        boolean delayed = false;
        started = true;
        running = true;
        Object object = lock;
        synchronized (object) {
            waiting = true;
            lock.notify();
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        while (running) {
            Timer t = null;
            long delay = -1L;
            object = lock;
            synchronized (object) {
                if (!timerQ.isEmpty()) {
                    delayed = false;
                    t = (Timer)timerQ.peek();
                    delay = t.getPopTime() - System.currentTimeMillis();
                    if (delay <= 0L) {
                        t = (Timer)timerQ.dequeue();
                        if (delay < 0L) {
                            delayed = true;
                        }
                    } else {
                        waiting = true;
                        try {
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("TimerService: waiting(1) " + delay);
                            }
                            lock.wait(delay);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        waiting = false;
                        t = null;
                    }
                } else {
                    waiting = true;
                    try {
                        if (SnmpV1API.isTracing()) {
                            SnmpV1API.trace("TimerService: waiting(2) ");
                        }
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    waiting = false;
                }
            }
            if (t == null) continue;
            if (delayed) {
                CallbackThread cb = new CallbackThread(t);
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("TimerService: starting thread");
                }
                cb.start();
                continue;
            }
            if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("TimerService: waking up");
            }
            t.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminate() {
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("TimerService: terminating");
        }
        Object object = lock;
        synchronized (object) {
            if (running) {
                running = false;
                if (waiting) {
                    lock.notify();
                    Thread.yield();
                }
            }
        }
        started = false;
        running = false;
        waiting = false;
        inst = null;
    }
}

