/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.configure;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;
import org.apache.derby.drda.NetworkServerControl;
import org.eclipse.aperi.download.DownloadConfig;
import org.eclipse.aperi.download.interfaces.IDownload;
import org.eclipse.aperi.download.interfaces.IMirror;
import org.eclipse.aperi.guid.impl.GUIDImpl;
import org.eclipse.aperi.repository.Transform;
import org.eclipse.aperi.util.SRMCrypto;

public class ConfigureAperi {
    final String lockDirectory = "/etc/Tivoli/TSRM/lock";
    Properties properties;
    boolean isWindows = false;
    String slash;
    String script;
    String javaHome = "";
    String installDir = "";
    String serverHostName = "";
    String dataServerPort = "";
    String dataSvrHttpPort = "";
    String deviceServerPort = "";
    String agentPort = "";
    RDBMS rdbms = RDBMS.DERBY;
    String dbType;
    String dbDriver;
    String dbUsername = "";
    String dbPassword = "";
    String dbPort = "";
    String dbPasswordDeviceEncrypted = "";
    String dbPasswordDataEncrypted = "";
    String authPassword = "";
    String authPasswordEncrypted = "";
    boolean configureAgent = false;
    boolean configureServer = false;
    boolean configureGUI = false;
    boolean download3rdParty = false;
    DownloadConfig downloadConfig = null;
    String export;
    String colon;
    String comment;

    public static void main(String[] args) {
        ConfigureAperi.configure(args, new ConfigureAperi());
    }

    public static void configure(String[] args, ConfigureAperi ca) {
        boolean easy = false;
        String props = "";
        if (args.length == 1) {
            if (args[0].trim().equals("easy")) {
                easy = true;
            } else {
                props = args[0];
            }
        } else if (args.length > 0) {
            System.out.println("usage: cfgaperi [easy | <properties-file-name>]");
            System.exit(1);
        }
        try {
            ca.run(easy, props);
        }
        catch (Exception e) {
            System.out.println("Error while configuring.");
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    void run(boolean easy, String props) throws Exception {
        Properties defaults = new Properties();
        try {
            defaults.load(new FileInputStream("../configure/default.properties"));
        }
        catch (IOException e) {
            this.println("problem with default.properties");
            e.printStackTrace();
            System.exit(-1);
        }
        if (!props.equals("")) {
            this.properties = new Properties(defaults);
            try {
                if (!props.startsWith(".")) {
                    props = "../configure/" + props;
                }
                this.properties.load(new FileInputStream(props));
                easy = true;
            }
            catch (IOException e) {
                this.println("problem with " + props);
                e.printStackTrace();
                System.exit(-1);
            }
        } else {
            this.properties = defaults;
        }
        this.println("");
        this.println("Aperi Storage Manager Configuration");
        this.println("");
        this.println("This program will ask you a series of questions, then configure Aperi ");
        this.println("Default values are displayed in [square brackets].");
        if (easy) {
            this.println("");
            this.download3rdParty = this.shouldDownload3rdPartyBinaries("Download third party software", true);
        }
        this.println("");
        if (easy) {
            this.println("This program will configure Aperi using default values.");
        }
        this.println("");
        this.isWindows = System.getProperty("os.name").startsWith("Windows");
        this.export = this.isWindows ? "set" : "export";
        this.colon = this.isWindows ? ";" : ":";
        this.comment = this.isWindows ? "REM " : "# ";
        this.script = this.isWindows ? ".bat" : "";
        this.slash = System.getProperty("file.separator");
        this.checkJava();
        String cwd = System.getProperty("user.dir");
        int i = cwd.lastIndexOf(this.slash.charAt(0));
        if (i < 0) {
            this.println("Unexpected install directory path");
            System.exit(1);
        }
        this.installDir = cwd.substring(0, i);
        this.javaHome = System.getProperty("java.home");
        if (easy) {
            this.configureAgent = true;
            this.configureServer = true;
            this.configureGUI = true;
            this.serverHostName = this.getDefaultServerHostName();
            this.dataServerPort = this.properties.getProperty("dataServerPort");
            this.dataSvrHttpPort = this.properties.getProperty("dataServerHTTPPort");
            this.deviceServerPort = this.properties.getProperty("deviceServerPort");
            this.agentPort = this.properties.getProperty("agentPort");
            String s = this.properties.getProperty("rdbms");
            if (s.equals("derby")) {
                this.setDB(RDBMS.DERBY);
            } else if (s.equals("db2")) {
                this.setDB(RDBMS.DB2);
            } else {
                this.println("Unknown rdbms value.");
                System.exit(-1);
            }
            if (this.rdbms == RDBMS.DERBY) {
                this.dbUsername = this.properties.getProperty("derbyUsername");
                this.dbPassword = this.properties.getProperty("derbyPassword");
                this.dbPort = this.properties.getProperty("derbyPort");
            } else {
                this.dbUsername = this.properties.getProperty("db2Username");
                this.dbPassword = this.properties.getProperty("db2Password");
                this.dbPort = this.properties.getProperty("db2Port");
            }
            this.dbPasswordDeviceEncrypted = SRMCrypto.encrypt((String)this.dbPassword);
            this.dbPasswordDataEncrypted = Transform.transformString((String)this.dbPassword);
            this.authPassword = this.properties.getProperty("authPassword");
            this.authPasswordEncrypted = SRMCrypto.encrypt((String)this.authPassword);
        } else {
            this.components();
            if (!(this.configureAgent || this.configureServer || this.configureGUI)) {
                this.println("Nothing to configure.");
                return;
            }
            this.collectInput();
        }
        if (this.download3rdParty) {
            try {
                this.downloadConfig = new DownloadConfig("../configure/download.xml");
            }
            catch (Exception e) {
                this.println("Error while loading the third party software configuration.");
                e.printStackTrace();
                System.exit(-1);
            }
            if (!easy) {
                this.manualMirrorSelection();
            }
        }
        this.println("");
        this.println("Ready to configure.");
        this.println("");
        if (this.download3rdParty) {
            if (easy) {
                this.automaticMirrorSelection();
            }
            this.download3rdPartySoftware();
        }
        if (this.configureAgent) {
            this.agent();
        }
        if (this.configureServer) {
            this.rdbms();
            this.deviceserver();
            this.dataserver();
        }
        if (this.configureGUI) {
            this.gui();
        }
        if (this.configureAgent || this.configureServer) {
            this.startScript();
        }
        if (this.configureAgent || this.configureServer) {
            this.guid();
        }
        if (this.configureServer) {
            this.schema();
        }
        this.println("");
        if (this.configureServer && this.configureAgent) {
            this.println("To bring up the Aperi server and agent, run aperi" + this.script);
        } else if (this.configureServer) {
            this.println("To bring up the Aperi server, run aperi" + this.script);
            this.println("Or you can bring up individual components with the");
            this.println("startup scripts in the derby, datasvr, and devsvr");
            this.println("directories.");
        } else if (this.configureAgent) {
            this.println("To bring up the Aperi server, run aperi" + this.script);
            this.println("Or you can bring it up with agent/agent" + this.script);
        }
        if (this.configureGUI) {
            this.println("To start the GUI, run gui/gui" + this.script);
        }
        this.println("Aperi configuration is complete.");
        this.println("");
    }

    void checkJava() {
        String javaVersion = System.getProperty("java.version");
        this.println("");
        this.print("Checking Java installation...");
        try {
            String[] tokes = javaVersion.split("\\.");
            String major = tokes[0];
            String minor = tokes[1];
            if (major.equals("1") && minor.equals("5")) {
                this.println("passed: " + javaVersion);
            } else {
                this.println("WARNING");
                this.println("Java " + javaVersion + " was unexpected. Continuing may have unpredictable results.");
            }
        }
        catch (Exception e) {
            this.println("Java " + javaVersion + " was unexpected. Continuing may have unpredictable results.");
        }
    }

    void components() throws Exception {
        this.println("");
        this.println("The Aperi Storage Manager consists of three major components:");
        this.println("The host-based agent, the server, and the GUI.");
        this.println("You can configure any or all of these to run on this computer.");
        this.println("");
        this.println("Which components do you want to configure? Answer with Yes or No. ");
        this.println("");
        this.configureAgent = this.shouldConfigure("Agent ", true);
        this.configureServer = this.shouldConfigure("Server", true);
        this.configureGUI = this.shouldConfigure("GUI   ", true);
    }

    void collectInput() throws Exception {
        if (this.configureAgent) {
            this.println("");
            this.println("Enter values to configure the agent.");
            this.println("");
            this.agentPort = this.getInteger("Agent port", this.properties.getProperty("agentPort"), 0, 65535);
        }
        if (this.configureServer || this.configureAgent) {
            this.println("");
            if (this.configureServer) {
                this.println("Enter values to configure the device server.");
            } else {
                this.println("Enter values to configure how the agent communicates with the device server.");
                this.println("These must match how the device server is configured.");
            }
            this.println("");
            this.serverHostName = this.getServerHostName("Hostname");
            this.deviceServerPort = this.getInteger("Port", this.properties.getProperty("deviceServerPort"), 0, 65535);
            this.authPassword = this.getString("Password", this.properties.getProperty("authPassword"));
            this.authPasswordEncrypted = SRMCrypto.encrypt((String)this.authPassword);
        }
        if (this.configureServer || this.configureGUI || this.configureAgent) {
            this.println("");
            if (this.configureServer) {
                this.println("Enter values to configure the data server.");
            } else {
                this.println("Enter values to configure how the GUI and agents communicate with the data server.");
                this.println("These must match how the data server is configured.");
            }
            this.println("");
            if (!this.configureServer) {
                this.serverHostName = this.getServerHostName("Hostname ");
            }
            this.dataServerPort = this.getInteger("Port", this.properties.getProperty("dataServerPort"), 0, 65535);
            this.dataSvrHttpPort = this.getInteger("HTTP Port", this.properties.getProperty("dataServerHTTPPort"), 0, 65535);
        }
        if (this.configureServer) {
            this.println("");
            boolean gotdb = false;
            while (!gotdb) {
                boolean ret = false;
                ret = this.shouldConfigure("Do you want to use Derby as the Aperi repository", true);
                if (ret) {
                    this.setDB(RDBMS.DERBY);
                    gotdb = true;
                    continue;
                }
                ret = this.shouldConfigure("Do you want to use IBM DB2 as the Aperi repository", true);
                if (ret) {
                    this.println("DB2 should installed and running with database created named 'Aperi'.");
                    this.println("You also need to have installed the com.ibm.db2 plugin.");
                    ret = this.shouldConfigure("Is DB2 ready", true);
                    if (ret) {
                        this.setDB(RDBMS.DB2);
                        gotdb = true;
                        continue;
                    }
                    this.println("You'll have to install DB2 and rerun cfgaperi.");
                    System.exit(-1);
                    continue;
                }
                this.println("You have to pick one or the other.");
            }
            if (this.rdbms == RDBMS.DERBY) {
                this.collectDerbyInput();
            } else {
                this.collectDB2Input();
            }
        }
        this.download3rdParty = this.shouldDownload3rdPartyBinaries("Download third party software", true);
    }

    private void collectDerbyInput() throws Exception {
        this.println("Enter values to configure Derby.");
        this.println("");
        this.dbPort = this.getInteger("Port", this.properties.getProperty("derbyPort"), 0, 65535);
        this.dbUsername = this.properties.getProperty("derbyUsername");
        this.dbPassword = this.properties.getProperty("derbyPassword");
        this.dbPasswordDeviceEncrypted = SRMCrypto.encrypt((String)this.dbPassword);
        this.dbPasswordDataEncrypted = Transform.transformString((String)this.dbPassword);
    }

    private void collectDB2Input() throws Exception {
        this.println("Enter values to configure DB2.");
        this.println("");
        this.dbPort = this.getInteger("Port", this.properties.getProperty("db2Port"), 0, 65535);
        this.dbUsername = this.getString("DB2 username", this.properties.getProperty("db2Username"));
        this.dbPassword = this.getString("Password", "");
        this.dbPasswordDeviceEncrypted = SRMCrypto.encrypt((String)this.dbPassword);
        this.dbPasswordDataEncrypted = Transform.transformString((String)this.dbPassword);
    }

    String getJavaPath() {
        return "\"" + this.javaHome + this.slash + "bin" + this.slash + "java\" ";
    }

    void agent() throws Exception {
        this.println("");
        this.println("Configuring the agent...");
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("manager.loc", this.serverHostName);
        ht.put("manager.port", this.deviceServerPort);
        ht.put("agent.port", this.agentPort);
        ht.put("installLocation", this.installDir);
        ht.put("tsnm.type", "agent");
        ht.put("installationPass", this.authPasswordEncrypted);
        String fname = "../agent/configuration/setup.properties";
        this.println(" " + fname);
        this.configureProperties(fname, ht);
        ht.clear();
        ht.put("installLocation", "\"" + this.installDir + "\"");
        ht.put("serverHost", this.serverHostName);
        ht.put("serverPort", this.dataServerPort);
        ht.put("agent.port", this.agentPort);
        fname = "../agent/configuration/agent.config";
        this.println(" " + fname);
        this.configureProperties(fname, ht);
        String startAgentScript = "../agent/agent" + this.script;
        this.println(" " + startAgentScript);
        PrintWriter out = new PrintWriter(new FileWriter(startAgentScript));
        this.prologue(out);
        out.println(this.comment + "launch script for Aperi Agent");
        this.fixLibPath(out);
        out.println("cd " + this.installDir + this.slash + "agent");
        out.println(this.getJavaPath() + this.getAgentHeapSize() + "-Declipse.application.noDefault=true" + " -Dconnector.ssl.enabled=true " + " -Dorg.osgi.service.http.port=" + this.agentPort + " -cp startup.jar " + "org.eclipse.core.launcher.Main");
        out.close();
        this.chmodx(startAgentScript);
        this.createLockDirectory();
    }

    private String getAgentHeapSize() {
        return " " + this.properties.getProperty("jvmHeapSizeFlag") + this.properties.getProperty("dataAgentHeapSize") + " ";
    }

    private String getDerbyHeapSize() {
        return " " + this.properties.getProperty("jvmHeapSizeFlag") + this.properties.getProperty("derbyHeapSize") + " ";
    }

    void rdbms() throws Exception {
        if (this.rdbms == RDBMS.DERBY) {
            this.derby();
        } else {
            this.db2();
        }
    }

    void db2() throws Exception {
        String aperiSchemaScript = "../db/aperi-schema" + this.script;
        this.println(" " + aperiSchemaScript);
        PrintWriter out = new PrintWriter(new FileWriter(aperiSchemaScript));
        String lib = "." + this.slash;
        this.prologue(out);
        out.println(this.export + " JAVA_HOME=" + this.javaHome);
        out.print(this.export + " CLASSPATH=" + this.value("CLASSPATH") + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.common_5.0.0.jar" + this.colon);
        out.print(".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.colon);
        out.println(".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.common.utils_1.0.0.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.server.data_5.0.0.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.log_5.0.0.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.equinox.registry_3.2.0.v20060601.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.equinox.common_3.2.0.v20060603.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.osgi_3.2.0.v20060601.jar" + this.colon + ".." + this.slash + "configure" + this.slash + "soap.jar" + this.colon + ".." + this.slash + "configure" + this.slash + "j2ee.jar" + this.colon);
        out.println("cd " + this.installDir + this.slash + "db");
        out.println("\"" + this.value("JAVA_HOME") + this.slash + "bin" + this.slash + "java\" " + "-Dorg.eclipse.aperi.sanmgmt.logging.disable=true " + "org.eclipse.aperi.install.SilentDatabaseInstall -mode install " + "-jdbcdriver com.ibm.db2.jcc.DB2Driver " + "-schema Aperi -database Aperi -dbmstype db2 " + "-dbhost " + this.serverHostName + " -dbport " + this.dbPort + " -dbuser " + this.dbUsername + " -dbpassword  " + this.dbPasswordDeviceEncrypted + " -path " + this.installDir + this.slash + "db" + this.slash + "schema");
        out.close();
        this.chmodx(aperiSchemaScript);
    }

    void derby() throws Exception {
        this.println("");
        this.println("Configuring derby...");
        String startDerbyScript = "../db/derby" + this.script;
        this.println(" " + startDerbyScript);
        PrintWriter out = new PrintWriter(new FileWriter(startDerbyScript));
        this.prologue(out);
        out.println(this.export + " JAVA_HOME=" + this.javaHome);
        out.println(this.export + " DERBY_INSTALL=" + this.installDir + this.slash + "db");
        String lib = "." + this.slash;
        out.println(this.export + " CLASSPATH=" + this.value("CLASSPATH") + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derby.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derbynet.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derbyclient.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derbytools.jar" + this.colon);
        out.println("cd " + this.value("DERBY_INSTALL"));
        out.println("\"" + this.value("JAVA_HOME") + this.slash + "bin" + this.slash + "java\" " + "-Dorg.eclipse.aperi.sanmgmt.logging.disable=true " + this.getDerbyHeapSize() + "org.apache.derby.drda.NetworkServerControl start -h " + this.serverHostName + " -p " + this.dbPort);
        out.close();
        this.chmodx(startDerbyScript);
        String stopDerbyScript = "../db/derbystop" + this.script;
        this.println(" " + stopDerbyScript);
        out = new PrintWriter(new FileWriter(stopDerbyScript));
        this.prologue(out);
        out.println(this.export + " JAVA_HOME=" + this.javaHome);
        out.println(this.export + " DERBY_INSTALL=" + this.installDir + this.slash + "db");
        out.println(this.export + " CLASSPATH=" + this.value("CLASSPATH") + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derby.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derbynet.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derbyclient.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derbytools.jar" + this.colon);
        out.println("cd " + this.value("DERBY_INSTALL"));
        out.println("\"" + this.value("JAVA_HOME") + this.slash + "bin" + this.slash + "java\" " + "org.apache.derby.drda.NetworkServerControl shutdown -h " + this.serverHostName + " -p " + this.dbPort);
        out.close();
        this.chmodx(stopDerbyScript);
        String aperiSchemaScript = "../db/aperi-schema" + this.script;
        this.println(" " + aperiSchemaScript);
        out = new PrintWriter(new FileWriter(aperiSchemaScript));
        this.prologue(out);
        out.println(this.export + " JAVA_HOME=" + this.javaHome);
        out.println(this.export + " DERBY_INSTALL=" + this.installDir + this.slash + "db");
        out.print(this.export + " CLASSPATH=" + this.value("CLASSPATH") + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.common_5.0.0.jar" + this.colon);
        out.print(".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derby.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derbynet.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derbyclient.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derbytools.jar" + this.colon);
        out.println(".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.common.utils_1.0.0.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.server.data_5.0.0.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.log_5.0.0.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.equinox.registry_3.2.0.v20060601.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.equinox.common_3.2.0.v20060603.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.osgi_3.2.0.v20060601.jar" + this.colon + ".." + this.slash + "configure" + this.slash + "soap.jar" + this.colon + ".." + this.slash + "configure" + this.slash + "j2ee.jar" + this.colon);
        out.println("cd " + this.value("DERBY_INSTALL"));
        out.println("\"" + this.value("JAVA_HOME") + this.slash + "bin" + this.slash + "java\" " + "-Dorg.eclipse.aperi.sanmgmt.logging.disable=true " + "org.eclipse.aperi.install.SilentDatabaseInstall -mode install " + "-jdbcdriver org.apache.derby.jdbc.ClientDriver " + "-schema Aperi -database Aperi -dbmstype derby " + "-dbhost " + this.serverHostName + " -dbport " + this.dbPort + " -dbuser Aperi -dbpassword 1r2vtvWB10o= " + "-path " + this.installDir + this.slash + "db" + this.slash + "schema");
        out.close();
        this.chmodx(aperiSchemaScript);
        String aperiIJScript = "../db/aperi-ij" + this.script;
        this.println(" " + aperiIJScript);
        out = new PrintWriter(new FileWriter(aperiIJScript));
        this.prologue(out);
        out.println(this.export + " JAVA_HOME=" + this.javaHome);
        out.println(this.export + " DERBY_INSTALL=" + this.installDir + this.slash + "db");
        out.println(this.export + " CLASSPATH=" + this.value("CLASSPATH") + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derby.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derbynet.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derbyclient.jar" + this.colon + ".." + this.slash + "datasvr" + this.slash + "plugins" + this.slash + "org.eclipse.aperi.db_1.0.0" + this.slash + "derbytools.jar" + this.colon);
        out.println("cd " + this.value("DERBY_INSTALL"));
        out.println("\"" + this.value("JAVA_HOME") + this.slash + "bin" + this.slash + "java\" " + "-Dij.driver=org.apache.derby.jdbc.ClientDriver " + "-Dij.protocol=jdbc:derby://" + this.serverHostName + ":" + this.dbPort + "/ -Dij.user=" + this.dbUsername + " -Dij.password=" + this.dbPassword + " org.apache.derby.tools.ij");
        out.close();
        this.chmodx(aperiIJScript);
    }

    void dataserver() throws Exception {
        this.println("");
        this.println("Configuring the data server... ");
        String fname = "datasvr/configuration/server.config";
        this.println(" " + fname);
        PrintWriter out = new PrintWriter(new FileWriter("../" + fname));
        BufferedReader in = new BufferedReader(new FileReader("../" + fname + ".in"));
        String line = "";
        while ((line = in.readLine()) != null) {
            if (line.startsWith("name") && line.indexOf("SERVERHOST") > 0) {
                out.println("name=\"" + this.serverHostName + "\"");
                continue;
            }
            if (line.startsWith("port")) {
                out.println("port=" + this.dataServerPort);
                continue;
            }
            if (line.startsWith("driver")) {
                out.println("driver=" + this.dbDriver);
                continue;
            }
            if (line.startsWith("url")) {
                out.println("url=\"jdbc:" + this.dbType + "://" + this.serverHostName + ":" + this.dbPort + "/Aperi\"");
                continue;
            }
            if (line.startsWith("user")) {
                out.println("user=" + this.dbUsername);
                continue;
            }
            if (line.startsWith("schema")) {
                out.println("schema=Aperi");
                continue;
            }
            out.println(line);
        }
        out.close();
        fname = "../datasvr/configuration/repository.config";
        if (!Transform.putTransformed((String)this.dbPassword, (String)fname)) {
            System.out.println("can't write repository.config");
            System.exit(-1);
        }
        String startDataSvrScript = "../datasvr/datasvr" + this.script;
        this.println(" " + startDataSvrScript);
        out = new PrintWriter(new FileWriter(startDataSvrScript));
        this.prologue(out);
        out.println(this.comment + "launch script for Aperi Data Server");
        this.fixLibPath(out);
        out.println("cd " + this.installDir + this.slash + "datasvr");
        out.println(this.getJavaPath() + this.getDataServerHeapSize() + "-Declipse.application.noDefault=true " + "-Dconnector.ssl.enabled=true " + "-Dorg.osgi.service.http.port=" + this.dataSvrHttpPort + " -cp startup.jar " + "org.eclipse.core.launcher.Main" + " -console");
        out.close();
        this.chmodx(startDataSvrScript);
    }

    private String getDataServerHeapSize() {
        return " " + this.properties.getProperty("jvmHeapSizeFlag") + this.properties.getProperty("dataServerHeapSize") + " ";
    }

    void deviceserver() throws Exception {
        this.println("");
        this.println("Configuring the device server...");
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("manager.loc", "localhost");
        ht.put("manager.port", this.deviceServerPort);
        ht.put("agent.port", this.agentPort);
        ht.put("installLocation", this.installDir);
        ht.put("tsnm.type", "manager");
        ht.put("installationPass", this.authPasswordEncrypted);
        String fname = "devsvr/configuration/setup.properties";
        this.println(" " + fname);
        this.configureProperties("../" + fname, ht);
        ht.clear();
        ht.put("tivoli.sanmgmt.jdbc.dbDriver", this.dbDriver);
        ht.put("tivoli.sanmgmt.jdbc.dbURL", "jdbc:" + this.dbType + "://" + this.serverHostName + ":" + this.dbPort + "/Aperi");
        ht.put("tivoli.sanmgmt.jdbc.dbUser", this.dbUsername);
        ht.put("tivoli.sanmgmt.jdbc.dbPassword", this.dbPasswordDeviceEncrypted);
        ht.put("tivoli.sanmgmt.jdbc.dbAdmin", this.dbUsername);
        ht.put("tivoli.sanmgmt.jdbc.database", "Aperi");
        ht.put("tivoli.sanmgmt.jdbc.dbSchema", "Aperi");
        fname = "devsvr/configuration/tsnmdbparms.properties";
        this.println(" " + fname);
        this.configureProperties("../" + fname, ht);
        String startDevSvrScript = "../devsvr/devsvr" + this.script;
        this.println(" " + startDevSvrScript);
        PrintWriter out = new PrintWriter(new FileWriter(startDevSvrScript));
        this.prologue(out);
        out.println(this.comment + "launch script for Aperi Device Server");
        this.fixLibPath(out);
        out.println("cd " + this.installDir + this.slash + "devsvr");
        out.println(this.getJavaPath() + this.getDeviceServerHeapSize() + "-Declipse.application.noDefault=true" + " -Dconnector.ssl.enabled=true " + " -Dorg.osgi.service.http.port=" + this.deviceServerPort + " -cp startup.jar " + "org.eclipse.core.launcher.Main" + " -console");
        out.close();
        this.chmodx(startDevSvrScript);
    }

    private String getDeviceServerHeapSize() {
        return " " + this.properties.getProperty("jvmHeapSizeFlag") + this.properties.getProperty("deviceServerHeapSize") + " ";
    }

    void gui() throws Exception {
        this.println("");
        this.println("Configuring the gui...");
        PrintWriter out = new PrintWriter(new FileWriter("../gui/gui.properties"));
        out.println("server = " + this.serverHostName + ":" + this.dataServerPort);
        out.close();
        String startGUIScript = "../gui/gui" + this.script;
        this.println(" " + startGUIScript);
        out = new PrintWriter(new FileWriter(startGUIScript));
        this.prologue(out);
        out.println(this.comment + "launch script for Aperi GUI");
        out.println("cd " + this.installDir + this.slash + "gui");
        out.println(this.getJavaPath() + this.getGuiHeapSize() + "-Declipse.application.noDefault=true " + "-cp startup.jar " + "org.eclipse.core.launcher.Main");
        out.close();
        this.chmodx(startGUIScript);
    }

    private String getGuiHeapSize() {
        return " " + this.properties.getProperty("jvmHeapSizeFlag") + this.properties.getProperty("guiHeapSize") + " ";
    }

    void startScript() throws Exception {
        this.println("");
        this.println("Generating start script...");
        String startScript = "../aperi" + this.script;
        this.println(" " + startScript);
        PrintWriter out = new PrintWriter(new FileWriter(startScript));
        this.prologue(out);
        out.println(this.comment + "launch script for Aperi server and agent");
        out.println("cd " + this.installDir);
        String[] stubs = new String[]{"db", "datasvr", "devsvr", "agent"};
        for (int i = 0; i < stubs.length; ++i) {
            if (this.rdbms == RDBMS.DB2 && stubs[i].equals("db")) continue;
            String scriptName = "";
            String cmd = "";
            scriptName = stubs[i].equals("db") ? "derby" : stubs[i];
            cmd = stubs[i] + this.slash + scriptName + this.script;
            if (this.isWindows) {
                out.println("if exist " + cmd + " ( start " + cmd + " )");
                if (i >= stubs.length - 1) continue;
                out.println("pause");
                continue;
            }
            out.println("if [ -x " + cmd + " ]; then");
            out.println("  " + cmd + " &");
            if (i < stubs.length - 1) {
                out.println("  sleep 10");
            }
            out.println("fi");
        }
        out.close();
        this.chmodx(startScript);
    }

    void guid() throws Exception {
        this.println("");
        this.println("Generating GUID for this host...");
        UUID uuid = UUID.randomUUID();
        GUIDImpl guid = new GUIDImpl(uuid);
        this.println("GUID is " + uuid);
        String file = this.installDir + this.slash + "guid.txt";
        this.println("Storing in " + file);
        PrintWriter out = new PrintWriter(new FileWriter(file));
        out.println(guid);
        out.close();
    }

    void schema() throws Exception {
        this.println("");
        if (this.rdbms == RDBMS.DERBY) {
            this.println("Next, the Derby RDBMS will be started");
            this.println("and the Aperi schema created.");
        } else {
            this.println("Next, the Aperi schema will be created.");
        }
        NetworkServerControl server = null;
        if (this.rdbms == RDBMS.DERBY) {
            String schema = this.installDir + this.slash + "db" + this.slash + "Aperi";
            File f = new File(schema);
            if (f.exists()) {
                this.println("");
                this.println("The schema already exists. This configure script must exit.");
                this.println("You may wish to delete the schema directory (" + schema + ")");
                this.println("and re-run this script.");
                System.exit(-1);
            }
            DerbyThread derby = new DerbyThread();
            derby.start();
            server = new NetworkServerControl(InetAddress.getByName(this.serverHostName), Integer.parseInt(this.dbPort));
            for (int i = 1; i <= 10; ++i) {
                try {
                    this.print(".");
                    Thread.sleep(500L);
                    server.ping();
                    break;
                }
                catch (Exception e) {
                    if (i != 10) continue;
                    this.println("");
                    this.println("Derby did not come up. Consult the installation");
                    this.println("documentation for more information.");
                    return;
                }
            }
            this.println("");
            this.println("Now the schema will be loaded.");
        }
        this.runSilentDatabaseInstall();
        this.println("The output above should indicate that the schema was created");
        this.println("successfully on your system. If there was an error,");
        this.println("Aperi will not function correctly. Consult the installation");
        this.println("documentation for more information.");
        this.println("");
        if (this.rdbms == RDBMS.DERBY) {
            this.println("Shutting Derby down.");
            server.shutdown();
        }
    }

    int runSilentDatabaseInstall() throws Exception {
        return this.runCmd("." + this.slash + "aperi-schema" + this.script);
    }

    String getDefaultServerHostName() throws Exception {
        String name = this.properties.getProperty("serverHostName");
        if (name == null || name.equals("")) {
            name = InetAddress.getLocalHost().getHostName();
        }
        return name;
    }

    String getServerHostName(String prompt) throws Exception {
        String hostName = "";
        boolean needGoodHost = true;
        while (needGoodHost) {
            String host = InetAddress.getLocalHost().getHostName();
            this.print(prompt + " [" + host + "]: ");
            hostName = this.getLine();
            if (hostName.equals("")) {
                hostName = host;
            }
            try {
                InetAddress.getByName(hostName);
                needGoodHost = false;
            }
            catch (UnknownHostException e) {
                this.println("Unknown host.");
            }
        }
        return hostName;
    }

    String getString(String thingy, String defValue) throws Exception {
        String s = "";
        boolean needGoodString = true;
        while (needGoodString) {
            this.print(thingy);
            if (!defValue.equals("")) {
                this.print(" [" + defValue + "]");
            }
            this.print(": ");
            s = this.getLine();
            if (s.equals("")) {
                s = defValue;
            }
            if (s.equals("")) {
                this.println("Value must not be blank.");
                continue;
            }
            needGoodString = false;
        }
        return s;
    }

    boolean shouldConfigure(String thingy, boolean defVal) throws Exception {
        return this.yorn(thingy + (defVal ? " [Yes]? " : " [No]? "), true);
    }

    String getLine() throws Exception {
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    boolean yorn(String msg, boolean defValue) throws Exception {
        boolean yorn = false;
        boolean needGoodValue = true;
        while (needGoodValue) {
            this.print(msg);
            String s = this.getLine();
            s = s.toUpperCase();
            if (s.startsWith("Y")) {
                yorn = true;
            }
            if (s.equals("")) {
                yorn = defValue;
            }
            if (!s.startsWith("Y") && !s.startsWith("N") && !s.equals("")) continue;
            needGoodValue = false;
        }
        return yorn;
    }

    void configureProperties(String path, Hashtable ht) throws Exception {
        Properties p = new Properties();
        FileInputStream fis = new FileInputStream(path);
        p.load(fis);
        fis.close();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)ht.get(key);
            p.setProperty(key, value);
        }
        FileOutputStream fos = new FileOutputStream(path);
        p.store(fos, null);
        fos.close();
    }

    void print(String s) {
        System.out.print(s);
    }

    void println(String s) {
        System.out.println(s);
    }

    void prologue(PrintWriter out) {
        if (this.isWindows) {
            out.println("@echo off");
        } else {
            out.println("#!/bin/sh");
        }
    }

    String value(String var) {
        var = this.isWindows ? "%" + var + "%" : "$" + var;
        return var;
    }

    int runCmd(String cmd) throws Exception {
        this.println("Running " + cmd);
        this.println("----");
        Process p = Runtime.getRuntime().exec(cmd);
        ReaderThread reader = new ReaderThread(p);
        reader.run();
        int ret = p.waitFor();
        this.println("----");
        return ret;
    }

    int chmodx(String fname) throws Exception {
        int ret = 0;
        if (!this.isWindows) {
            Process p = Runtime.getRuntime().exec("chmod +x " + fname);
            ret = p.waitFor();
        }
        return ret;
    }

    void fixLibPath(PrintWriter out) {
        if (this.isWindows) {
            out.println("set PATH=" + this.installDir + "\\lib\\w32-ix86;%PATH%");
        } else {
            out.println("export LD_LIBRARY_PATH=" + this.installDir + "/lib/linux-ix86:$LD_LIBRARY_PATH");
        }
    }

    void createLockDirectory() {
        File lockDir;
        if (!(this.isWindows || (lockDir = new File("/etc/Tivoli/TSRM/lock")).exists() && lockDir.isDirectory())) {
            this.println("Creating the lock directory /etc/Tivoli/TSRM/lock");
            if (!lockDir.mkdirs()) {
                this.println("Failed to create the lock direcgtory");
            }
        }
    }

    void setDB(RDBMS db) {
        this.rdbms = db;
        switch (this.rdbms) {
            case DERBY: {
                this.dbDriver = "org.apache.derby.jdbc.ClientDriver";
                this.dbType = "derby";
                break;
            }
            case DB2: {
                this.dbDriver = "com.ibm.db2.jcc.DB2Driver";
                this.dbType = "db2";
                break;
            }
            default: {
                System.out.println("Unknown RDBMS value");
                System.exit(-1);
            }
        }
    }

    private void manualMirrorSelection() {
        Vector<IDownload> mirroredDownloads = this.downloadConfig.getMirroredDownloads();
        for (IDownload download : mirroredDownloads) {
            this.println("");
            this.println("Please select a mirror for " + download.getDescription() + ":");
            try {
                Vector<IMirror> mirrors = download.getMirrors();
                for (int mirrorItr = 0; mirrorItr < mirrors.size(); ++mirrorItr) {
                    this.println(mirrorItr + ". " + mirrors.elementAt(mirrorItr).getDescription());
                }
                int choice = Integer.parseInt(this.getInteger("Mirror", "0", 0, mirrors.size()));
                download.setFileUrl(mirrors.elementAt(choice).getFileUrl());
            }
            catch (Exception e) {
                this.println("Failed to retrieve the list of mirrors.");
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    private void automaticMirrorSelection() {
        Vector<IDownload> mirroredDownloads = this.downloadConfig.getMirroredDownloads();
        Iterator<IDownload> downloadItr = mirroredDownloads.iterator();
        while (downloadItr.hasNext()) {
            this.println("");
            IDownload download = downloadItr.next();
            try {
                Vector<IMirror> mirrors = download.getMirrors();
                download.setFileUrl(mirrors.elementAt(0).getFileUrl());
                this.println("Selected mirror " + mirrors.elementAt(0).getDescription() + "\n" + "for " + download.getDescription());
            }
            catch (Exception e) {
                this.println("Failed to retrieve the list of mirrors for " + download.getDescription());
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    boolean shouldDownload3rdPartyBinaries(String msg, boolean defVal) throws Exception {
        this.println("");
        return this.yorn(msg + (defVal ? " [Yes]? " : " [No]? "), true);
    }

    void printDownloads(String[] descriptions, int startNumber) {
        for (int i = 0; i < descriptions.length; ++i) {
            StringBuffer msg = new StringBuffer();
            msg.append(startNumber++);
            msg.append(". ");
            msg.append(descriptions[i]);
            this.print(msg.toString());
        }
    }

    void download3rdPartySoftware() {
        this.println("");
        this.println("Downloading the third party software.");
        File tempDir = new File(this.installDir + File.separator + "download");
        if (!tempDir.exists()) {
            tempDir.mkdir();
        }
        Vector<IDownload> downloads = this.downloadConfig.getDownloads();
        for (IDownload download : downloads) {
            try {
                download.downloadFile(tempDir.getAbsolutePath(), this.installDir);
            }
            catch (Exception e) {
                this.println("Download failed: " + download.getDescription());
                e.printStackTrace();
                System.exit(-1);
            }
        }
        this.println("Downloads complete.");
    }

    String getInteger(String description, String defaultVal, int min, int max) throws Exception {
        String intString = "";
        boolean needGoodInt = true;
        while (needGoodInt) {
            this.print(description + " [" + defaultVal + "]: ");
            intString = this.getLine();
            if (intString.equals("")) {
                intString = defaultVal;
            }
            try {
                int p = Integer.parseInt(intString);
                if (p < min || p > max) {
                    this.println(description + " must be a number from " + min + " to " + max + ".");
                    continue;
                }
                needGoodInt = false;
            }
            catch (NumberFormatException e) {
                this.println("Port must be a number from 0 to 65535.");
            }
        }
        return intString;
    }

    class ReaderThread
    extends Thread {
        Process proc;

        ReaderThread(Process p) {
            this.proc = p;
        }

        public void run() {
            try {
                BufferedReader stdout = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
                String line = stdout.readLine();
                while (line != null) {
                    ConfigureAperi.this.print("   ");
                    ConfigureAperi.this.println(line);
                    line = stdout.readLine();
                }
                BufferedReader stderr = new BufferedReader(new InputStreamReader(this.proc.getErrorStream()));
                String line2 = stderr.readLine();
                while (line2 != null) {
                    ConfigureAperi.this.print("   ");
                    ConfigureAperi.this.println(line2);
                    line2 = stderr.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class DerbyThread
    extends Thread {
        DerbyThread() {
        }

        public void run() {
            try {
                NetworkServerControl server = new NetworkServerControl(InetAddress.getByName(ConfigureAperi.this.serverHostName), Integer.parseInt(ConfigureAperi.this.dbPort));
                server.start(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RDBMS {
        DERBY,
        DB2;

    }
}

