/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.configure;

import java.util.ArrayList;
import org.eclipse.aperi.configure.ConfigureAperi;
import org.eclipse.aperi.install.SilentDatabaseInstall;
import org.eclipse.aperi.util.SRMCrypto;

public class ConfigureAperiIDE
extends ConfigureAperi {
    public static void main(String[] args) {
        ConfigureAperi.configure(args, new ConfigureAperiIDE());
    }

    String getDefaultServerHostName() {
        return "localhost";
    }

    int runSilentDatabaseInstall() throws Exception {
        String driverName = "";
        String dbType = "";
        if (this.rdbms == ConfigureAperi.RDBMS.DERBY) {
            dbType = "derby";
            driverName = "org.apache.derby.jdbc.ClientDriver";
        } else {
            dbType = "db2";
            driverName = "com.ibm.db2.jcc.DB2Driver";
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-mode");
        arguments.add("install");
        arguments.add("-jdbcdriver");
        arguments.add(driverName);
        arguments.add("-schema");
        arguments.add("Aperi");
        arguments.add("-database");
        arguments.add("Aperi");
        arguments.add("-dbmstype");
        arguments.add(dbType);
        arguments.add("-dbhost");
        arguments.add(this.serverHostName);
        arguments.add("-dbport");
        arguments.add(this.dbPort);
        arguments.add("-dbuser");
        arguments.add(this.dbUsername);
        arguments.add("-dbpassword");
        String pw = SRMCrypto.encrypt((String)this.dbPassword);
        arguments.add(pw);
        arguments.add("-path");
        arguments.add(this.installDir + this.slash + "db" + this.slash + "schema");
        SilentDatabaseInstall.exitOnComplete = false;
        SilentDatabaseInstall.main(arguments.toArray(new String[arguments.size()]));
        this.println("");
        return 0;
    }

    boolean shouldDownload3rdPartyBinaries(String msg, boolean defVal) throws Exception {
        return false;
    }
}

