/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.download;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Vector;
import org.eclipse.aperi.download.ConfigurationException;
import org.eclipse.aperi.download.Util;
import org.eclipse.aperi.download.interfaces.IDownload;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadConfig {
    public static final String ATTR_DOWNLOAD = "download";
    public static final String ATTR_TYPE = "type";
    private Vector<IDownload> _downloads = new Vector();

    public DownloadConfig(String configFileName) throws SAXException, IOException, ConfigurationException {
        Document configDoc = this.loadConfig(configFileName);
        NodeList downloads = configDoc.getElementsByTagName(ATTR_DOWNLOAD);
        for (int i = 0; i < downloads.getLength(); ++i) {
            Node downloadNode = downloads.item(i);
            String type = Util.getNamedAttribute(downloadNode.getAttributes(), ATTR_TYPE, true);
            try {
                Class<?> clazz = Class.forName(type);
                Constructor<?> constructor = clazz.getConstructor(Node.class);
                this._downloads.add((IDownload)constructor.newInstance(downloadNode));
                continue;
            }
            catch (Exception e) {
                throw new ConfigurationException("Invalid download type: " + type, e);
            }
        }
    }

    private Document loadConfig(String fileName) throws SAXException, IOException {
        File file = new File(fileName);
        DOMParser parser = new DOMParser();
        FileInputStream fileInputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource(fileInputStream);
        parser.parse(inputSource);
        return parser.getDocument();
    }

    public Vector<IDownload> getDownloads() {
        return this._downloads;
    }

    public Vector<IDownload> getMirroredDownloads() {
        Vector<IDownload> mirroredDownloads = new Vector<IDownload>();
        for (IDownload download : this._downloads) {
            if (!download.isMirrored()) continue;
            mirroredDownloads.add(download);
        }
        return mirroredDownloads;
    }
}

