/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.install;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.SoftwareVersion;

public class AlterFileList {
    private static final String PREFIX = "AlterVersion";
    private static final String SUFFIX = ".sql";

    public static String[] getFiles(SoftwareVersion sv, String path) throws GeneralException {
        int index;
        File sqlDir = new File(path);
        if (!sqlDir.isDirectory() || !sqlDir.canRead()) {
            throw new GeneralException("No valid sql directory");
        }
        Object[] sqlFiles = sqlDir.listFiles(new SQLFileNameFilter());
        if (sqlFiles == null | sqlFiles.length == 0) {
            return null;
        }
        Arrays.sort(sqlFiles);
        if (sv != null) {
            int sqlFileVRM;
            int softwareVRM = SoftwareVersion.encode((int)sv.svVendor, (int)sv.svVersion, (int)sv.svRelease, (int)sv.svModification, (int)sv.svSubModification);
            for (index = 0; index < sqlFiles.length && (sqlFileVRM = AlterFileList.getFileVRM(((File)sqlFiles[index]).getName())) <= softwareVRM; ++index) {
            }
        }
        if (index >= sqlFiles.length) {
            return null;
        }
        ArrayList<String> nameArray = new ArrayList<String>();
        while (index < sqlFiles.length) {
            nameArray.add(((File)sqlFiles[index]).getName());
            ++index;
        }
        return nameArray.toArray(new String[nameArray.size()]);
    }

    public static int getFileVRM(String name) {
        String vrm = name.substring(PREFIX.length(), name.indexOf(46));
        return Integer.parseInt(vrm);
    }

    private static class SQLFileNameFilter
    implements FilenameFilter {
        private SQLFileNameFilter() {
        }

        public boolean accept(File dir, String name) {
            boolean status = false;
            try {
                if (name.startsWith(AlterFileList.PREFIX) && name.endsWith(AlterFileList.SUFFIX)) {
                    AlterFileList.getFileVRM(name);
                    status = true;
                }
            }
            catch (NumberFormatException ingored) {
                // empty catch block
            }
            return status;
        }
    }
}

