/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.install.AlterFileList;
import org.eclipse.aperi.install.StorageAlertOSRepoInstall;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.util.SRMCrypto;
import org.eclipse.aperi.xmsg.MessageLog;

public class SilentDatabaseInstall {
    public static boolean exitOnComplete = true;
    public static final Object[] derbyFileParms = new Object[]{"integer", "smallint", "varchar(20) for bit data", "timestamp", "varchar(32000)", "long varchar for bit data", "", "", "current_timestamp", "' '", "", "", "double precision", "varchar(60) for bit data", "", "modify", "", "", "column", "X'4e'", "partition", "default null", "", "varchar(256)", "varchar(512)", "x'000000000000000000000000000000000000000000000000'", "SQL_DESC_DEFAULT_GROUP", "SQL_DESC_DEFAULT_OS_GROUP", "SQL_DESC_DEFAULT_FILESYSTEM_GROUP", "SQL_DESC_DEFAULT_COMPUTER_GROUP", "SQL_DESC_DISCOVERY_ALERT", "SQL_DESC_DISCOVERY_SCHEDULE", "SQL_DESC_HISTORY_ALERT", "SQL_DESC_HISTORY_SCHEDOLE", "SQL_DESC_STAT_BY_OWNER", "SQL_DESC_DATA_LARGEST_DIR", "SQL_DESC_SUM_STATS", "SQL_DESC_MOST_EXTENTS", "SQL_DESC_MOST_UNUSED_SPACE", "SQL_DESC_TABLESPACE_GROUP", "SQL_DESC_PROBE_ALERT", "SQL_DESC_PROBE_COMP_GROUP", "SQL_DESC_SCAN_ALERT", "SQL_DESC_SCAN_TABLESPACE_GROUP", "SQL_DESC_STAT_FILES_SYSTEM", "SQL_DESC_STAT_FILE_SIZE", "SQL_DESC_STAT_FILE_GROUP", "SQL_DESC_STAT_LAST_ACCESSED", "SQL_DESC_STAT_LAST_MODIFIED", "SQL_DESC_STAT_CREAT_TIME", "SQL_DESC_STAT_LAST_MODIFIED_NONBACKEDUP", "SQL_DESC_DATA_LARGEST_FILES", "SQL_DESC_DATA_RECENTLY_ACCESSED", "SQL_DESC_DATA_RECENTLY_MODIFIED_NONBACKEDUP", "SQL_DESC_DATA_LARGEST_ORPHANED", "SQL_DESC_DATA_RECENTLY_ACCESSED_ORPHANED", "SQL_DESC_NON_OS_FILES", "SQL_DESC_OBSOLETE_FILES_ALERT", "SQL_DESC_FORBID_NON_OS_FILES", "SQL_DESC_ORPHANED_FILES_ALERT", "SQL_DESC_FORBID_ORPHANED_FILES", "SQL_DESC_AT_RISK_FILE_ALERT", "SQL_DESC_NON_OS_NON_BACKEDUP", "SQL_DESC_PING_ALERT", "SQL_DESC_PING_DEFAULT_GROUP", "SQL_DESC_SCAN_DEFAULT_FILESYSTEM_GROUP", "SQL_NAME_DEFAULT_USER_GROUP", "SQL_NAME_DEFAULT_OS_GROUP", "SQL_NAME_DEFAULT_FS_GROUP", "SQL_NAME_DEFAULT_COMPUTER_GROUP", "SQL_NAME_DISCOVERY", "SQL_NAME_AGGREGATOR", "SQL_NAME_DB_USERSPACE", "SQL_NAME_LARGESTTABLES", "SQL_NAME_SUMMARY", "SQL_NAME_SEGMENTMOSTEXTENTS", "SQL_NAME_SEGMENTUNUSED", "SQL_NAME_DEFAULT_TABLESPACEGROUP", "SQL_NAME_DEFAULT_DBPROBE", "SQL_NAME_DEFAULT_DBSCAN", "SQL_NAME_FILE_SIZE", "SQL_NAME_SUMMARY_FILESYS", "SQL_NAME_SUMMARY_OWNER", "SQL_NAME_SUMMARY_GROUP", "SQL_NAME_BYACCESS", "SQL_NAME_BYMODIFICATION", "SQL_NAME_BYCREATION", "SQL_NAME_BYMOD", "SQL_NAME_LARGESTFILES", "SQL_NAME_LARGESTDIR", "SQL_NAME_OBSOLETEFILES", "SQL_NAME_ATRISK", "SQL_NAME_LARGESTORPHANS", "SQL_NAME_OLDESTORPHANS", "SQL_NAME_WASTED", "SQL_NAME_CONSTRAIT", "SQL_NAME_OBSOLETECONSTR", "SQL_NAME_ORPHANEDCONSTR", "SQL_NAME_ATRISKCONSTR", "SQL_NAME_PING", "SQL_NAME_PROBE", "SQL_NAME_SCAN", "SQL_DESC_TEMPFILE", "SQL_NAME_TEMPFILES", "RTRIM (CAST (g.group_id as char(128)))", "SQL_NAME_SUMMARY_FILEEXT", "SQL_DESC_FILE_TYPE", "SQL_NAME_DEFAULT_SS_GROUP", "SQL_DESC_DEFAULT_SS_GROUP", "Default", "x'00'", "bigint", "SQL_NAME_CIMOM_DISCOVERY", "SQL_DESC_CIMOM_DISCOVERY_ALERT", "SQL_DESC_CIMOM_DISCOVERY_SCHEDULE", "SQL_NAME_SNMP_DISCOVERY", "SQL_DESC_SNMP_DISCOVERY_ALERT", "SQL_DESC_SNMP_DISCOVERY_SCHEDULE", "SQL_NAME_NETWARE_DISCOVERY", "SQL_DESC_NETWARE_DISCOVERY_ALERT", "SQL_DESC_NETWARE_DISCOVERY_SCHEDULE", "", "", "", "SQL_DESC_DEFAULT_DISK_JOBS", "SQL_DESC_DEFAULT_FABRIC_JOBS", "SQL_NAME_EXTERNAL_NOTIFICATION", "SQL_DESC_EXTERNAL_NOTIFICATION_ALERT", "SQL_NAME_DISK_ARRAY_DISCOVERY", "SQL_DESC_DISK_ARRAY_DISCOVERY_ALERT", "SQL_NAME_TAPE_ALERT", "SQL_DESC_TAPE_ALERT", "SQL_NAME_DEFAULT_FABRIC_GROUP", "SQL_DESC_DEFAULT_FABRIC_GROUP", "SQL_NAME_DEFAULT_LIBRARIES_GROUP", "SQL_DESC_DEFAULT_LIBRARIES_GROUP"};
    public static final Object[] udbFileParms = new Object[]{"integer", "smallint", "varchar(20) for bit data", "timestamp", "long varchar", "long varchar for bit data", "", "", "current timestamp", "' '", "", "", "float", "varchar(60) for bit data", "", "alter", "set data type", "", "", "x'4e'", "\"partition\"", "", "", "varchar(256)", "varchar(512)", "x'000000000000000000000000000000000000000000000000'", "SQL_DESC_DEFAULT_GROUP", "SQL_DESC_DEFAULT_OS_GROUP", "SQL_DESC_DEFAULT_FILESYSTEM_GROUP", "SQL_DESC_DEFAULT_COMPUTER_GROUP", "SQL_DESC_DISCOVERY_ALERT", "SQL_DESC_DISCOVERY_SCHEDULE", "SQL_DESC_HISTORY_ALERT", "SQL_DESC_HISTORY_SCHEDOLE", "SQL_DESC_STAT_BY_OWNER", "SQL_DESC_DATA_LARGEST_DIR", "SQL_DESC_SUM_STATS", "SQL_DESC_MOST_EXTENTS", "SQL_DESC_MOST_UNUSED_SPACE", "SQL_DESC_TABLESPACE_GROUP", "SQL_DESC_PROBE_ALERT", "SQL_DESC_PROBE_COMP_GROUP", "SQL_DESC_SCAN_ALERT", "SQL_DESC_SCAN_TABLESPACE_GROUP", "SQL_DESC_STAT_FILES_SYSTEM", "SQL_DESC_STAT_FILE_SIZE", "SQL_DESC_STAT_FILE_GROUP", "SQL_DESC_STAT_LAST_ACCESSED", "SQL_DESC_STAT_LAST_MODIFIED", "SQL_DESC_STAT_CREAT_TIME", "SQL_DESC_STAT_LAST_MODIFIED_NONBACKEDUP", "SQL_DESC_DATA_LARGEST_FILES", "SQL_DESC_DATA_RECENTLY_ACCESSED", "SQL_DESC_DATA_RECENTLY_MODIFIED_NONBACKEDUP", "SQL_DESC_DATA_LARGEST_ORPHANED", "SQL_DESC_DATA_RECENTLY_ACCESSED_ORPHANED", "SQL_DESC_NON_OS_FILES", "SQL_DESC_OBSOLETE_FILES_ALERT", "SQL_DESC_FORBID_NON_OS_FILES", "SQL_DESC_ORPHANED_FILES_ALERT", "SQL_DESC_FORBID_ORPHANED_FILES", "SQL_DESC_AT_RISK_FILE_ALERT", "SQL_DESC_NON_OS_NON_BACKEDUP", "SQL_DESC_PING_ALERT", "SQL_DESC_PING_DEFAULT_GROUP", "SQL_DESC_SCAN_DEFAULT_FILESYSTEM_GROUP", "SQL_NAME_DEFAULT_USER_GROUP", "SQL_NAME_DEFAULT_OS_GROUP", "SQL_NAME_DEFAULT_FS_GROUP", "SQL_NAME_DEFAULT_COMPUTER_GROUP", "SQL_NAME_DISCOVERY", "SQL_NAME_AGGREGATOR", "SQL_NAME_DB_USERSPACE", "SQL_NAME_LARGESTTABLES", "SQL_NAME_SUMMARY", "SQL_NAME_SEGMENTMOSTEXTENTS", "SQL_NAME_SEGMENTUNUSED", "SQL_NAME_DEFAULT_TABLESPACEGROUP", "SQL_NAME_DEFAULT_DBPROBE", "SQL_NAME_DEFAULT_DBSCAN", "SQL_NAME_FILE_SIZE", "SQL_NAME_SUMMARY_FILESYS", "SQL_NAME_SUMMARY_OWNER", "SQL_NAME_SUMMARY_GROUP", "SQL_NAME_BYACCESS", "SQL_NAME_BYMODIFICATION", "SQL_NAME_BYCREATION", "SQL_NAME_BYMOD", "SQL_NAME_LARGESTFILES", "SQL_NAME_LARGESTDIR", "SQL_NAME_OBSOLETEFILES", "SQL_NAME_ATRISK", "SQL_NAME_LARGESTORPHANS", "SQL_NAME_OLDESTORPHANS", "SQL_NAME_WASTED", "SQL_NAME_CONSTRAIT", "SQL_NAME_OBSOLETECONSTR", "SQL_NAME_ORPHANEDCONSTR", "SQL_NAME_ATRISKCONSTR", "SQL_NAME_PING", "SQL_NAME_PROBE", "SQL_NAME_SCAN", "SQL_DESC_TEMPFILE", "SQL_NAME_TEMPFILES", "RTRIM (CAST (g.group_id as char(128)))", "SQL_NAME_SUMMARY_FILEEXT", "SQL_DESC_FILE_TYPE", "SQL_NAME_DEFAULT_SS_GROUP", "SQL_DESC_DEFAULT_SS_GROUP", "Default", "x'00'", "bigint", "SQL_NAME_CIMOM_DISCOVERY", "SQL_DESC_CIMOM_DISCOVERY_ALERT", "SQL_DESC_CIMOM_DISCOVERY_SCHEDULE", "SQL_NAME_SNMP_DISCOVERY", "SQL_DESC_SNMP_DISCOVERY_ALERT", "SQL_DESC_SNMP_DISCOVERY_SCHEDULE", "SQL_NAME_NETWARE_DISCOVERY", "SQL_DESC_NETWARE_DISCOVERY_ALERT", "SQL_DESC_NETWARE_DISCOVERY_SCHEDULE", "", "", "", "SQL_DESC_DEFAULT_DISK_JOBS", "SQL_DESC_DEFAULT_FABRIC_JOBS", "SQL_NAME_EXTERNAL_NOTIFICATION", "SQL_DESC_EXTERNAL_NOTIFICATION_ALERT", "SQL_NAME_DISK_ARRAY_DISCOVERY", "SQL_DESC_DISK_ARRAY_DISCOVERY_ALERT", "SQL_NAME_TAPE_ALERT", "SQL_DESC_TAPE_ALERT", "SQL_NAME_DEFAULT_FABRIC_GROUP", "SQL_DESC_DEFAULT_FABRIC_GROUP", "SQL_NAME_DEFAULT_LIBRARIES_GROUP", "SQL_DESC_DEFAULT_LIBRARIES_GROUP"};
    private int fileIndex;
    private String[] sqlFiles;
    private static final String MODE_LABEL = "mode";
    private static final String JDBC_DRIVER_LABEL = "jdbcdriver";
    private static final String DBMS_TYPE_LABEL = "dbmstype";
    private static final String SCHEMA_LABEL = "schema";
    private static final String DATABASE_LABEL = "database";
    private static final String DB_HOST_LABEL = "dbhost";
    private static final String DB_PORT_LABEL = "dbport";
    private static final String DB_USER_LABEL = "dbuser";
    private static final String DB_PASSWORD_LABEL = "dbpassword";
    private static final String PATH_LABEL = "path";
    public String m_sMode;
    private String m_sJdbcDriver;
    private String m_sDbmsType;
    private String m_sSchema;
    private String m_sDatabase;
    private String m_sDbPort;
    private String m_sDbUser;
    private String m_sDbPassWord;
    private String m_sHost;
    private String m_sUrl;
    private DBConnPoolDataSource m_dbConnPool;
    private DBConnection m_dbConn;
    private String m_sSchemaPath;

    private int prepFiles(BufferedReader[] reader) {
        int count = 0;
        try {
            this.fileIndex = 0;
            while (this.fileIndex < reader.length) {
                String sqlFile = this.m_sSchemaPath + File.separator + this.sqlFiles[this.fileIndex];
                this.trace("DEBUG SDI prepFiles sqlFile " + sqlFile);
                FileInputStream fis = new FileInputStream(sqlFile);
                reader[this.fileIndex] = new BufferedReader(new InputStreamReader(fis));
                String countLine = reader[this.fileIndex].readLine();
                if (countLine != null && countLine.regionMatches(true, 0, "sqlcount", 0, 8)) {
                    StringTokenizer t = new StringTokenizer(countLine, " =", false);
                    t.nextToken();
                    count += Integer.parseInt(t.nextToken());
                }
                ++this.fileIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    private void formatLine(String line, StringBuffer buffer, Object[] parms) {
        boolean isInQuote = false;
        for (int position = 0; position < line.length(); ++position) {
            char c = line.charAt(position);
            if (c == '{') {
                int parmIndex = 0;
                while (Character.isDigit(line.charAt(++position))) {
                    parmIndex *= 10;
                    parmIndex += line.charAt(position) - 48;
                }
                buffer.append(parms[parmIndex].toString());
                continue;
            }
            if (c == '\'') {
                isInQuote = !isInQuote;
            }
            if (!isInQuote && c == '#') {
                position = line.length();
                continue;
            }
            buffer.append(c);
        }
        buffer.append(" ");
    }

    public void executeSql(Statement stmt, String sqlText) {
        try {
            stmt.executeUpdate(sqlText);
        }
        catch (SQLException e) {
            System.err.println(sqlText);
            e.printStackTrace();
        }
    }

    private void executeSql(String sqlText) {
        try {
            Statement stmt = null;
            stmt = this.m_dbConn.getConnection().createStatement();
            this.executeSql(stmt, sqlText);
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            System.err.println(sqlText);
            e.printStackTrace();
        }
    }

    private void trace(String sText) {
        System.out.println(sText);
    }

    private void printUsage() {
        System.out.println("SilentDatabaseInstall Error");
        System.out.println("Usage: SilentDatabaseInstall <parameters> ");
        System.out.println("where parameters are: ");
        System.out.println("");
        System.out.println("required overall parameters");
        System.out.println("  -mode                 [install,uninstall,upgrade]");
        System.out.println("  -jdbcdriver           <jdbcdriver>");
        System.out.println("  -dbmstype             [derby]");
        System.out.println("  -schema               <schema>");
        System.out.println("  -database             <database>");
        System.out.println("  -dbport               <dbport>");
        System.out.println("  -dbuser               <dbuser>");
        System.out.println("  -dbpassword           <dbpassword>");
        System.out.println("  -path           <path>");
    }

    private void initialize() {
        this.m_sMode = null;
        this.m_sJdbcDriver = null;
        this.m_sDbmsType = null;
        this.m_sSchema = null;
        this.m_sDatabase = null;
        this.m_sDbPort = null;
        this.m_sDbUser = null;
        this.m_sDbPassWord = null;
        this.m_sHost = "localhost";
        this.m_sUrl = null;
        this.m_sSchemaPath = null;
    }

    private void parseParameters(String[] args) throws Exception {
        int index = 0;
        for (index = 0; index < args.length; index += 2) {
            String passwordDecr;
            if (args[index].length() < 2) {
                if (args[index].compareTo("<") == 0 && args[index + 1].compareTo("NUL") == 0) continue;
                throw new Exception("Invalid Parameter Name: " + args[index]);
            }
            String sLabel = args[index].substring(1);
            String sValue = args[index + 1];
            if (sLabel.equals(MODE_LABEL)) {
                this.m_sMode = sValue;
                continue;
            }
            if (sLabel.equals(JDBC_DRIVER_LABEL)) {
                this.m_sJdbcDriver = sValue;
                continue;
            }
            if (sLabel.equals(DBMS_TYPE_LABEL)) {
                this.m_sDbmsType = sValue;
                continue;
            }
            if (sLabel.equals(SCHEMA_LABEL)) {
                this.m_sSchema = sValue;
                continue;
            }
            if (sLabel.equals(DATABASE_LABEL)) {
                this.m_sDatabase = sValue;
                continue;
            }
            if (sLabel.equals(DB_PORT_LABEL)) {
                this.m_sDbPort = sValue;
                continue;
            }
            if (sLabel.equals(DB_HOST_LABEL)) {
                this.m_sHost = sValue;
                continue;
            }
            if (sLabel.equals(DB_USER_LABEL)) {
                this.m_sDbUser = sValue;
                continue;
            }
            if (sLabel.equals(PATH_LABEL)) {
                this.m_sSchemaPath = sValue;
                continue;
            }
            if (!sLabel.equals(DB_PASSWORD_LABEL)) continue;
            try {
                passwordDecr = SRMCrypto.decrypt((String)sValue);
            }
            catch (Exception e) {
                throw new Exception();
            }
            this.m_sDbPassWord = passwordDecr;
        }
        this.doRepositoryOption();
    }

    public int executeCommand(String[] cmd) throws Exception {
        Process process = null;
        int retval = 0;
        try {
            process = Runtime.getRuntime().exec(cmd);
            StrmCopier outcp = new StrmCopier(process.getInputStream(), System.out);
            StrmCopier errcp = new StrmCopier(process.getErrorStream(), System.err);
            outcp.start();
            errcp.start();
            process.getOutputStream().close();
            process.waitFor();
            outcp.join();
            errcp.join();
        }
        catch (Exception e) {
            retval = -1;
            e.printStackTrace();
        }
        return retval;
    }

    static boolean isDefined(String string) {
        return string != null && string.length() > 0;
    }

    private void doRepositoryOption() throws Exception {
        if (this.m_sDbmsType.equals("derby")) {
            SQLUtil.repositoryType = (byte)7;
        } else if (this.m_sDbmsType.equals("db2")) {
            SQLUtil.repositoryType = (byte)5;
        } else {
            System.err.println("Unrecognized database type " + this.m_sDbmsType);
            if (exitOnComplete) {
                System.exit(1);
            }
        }
    }

    private Object[] getFileSqlParms() {
        Object[] fileSqlParms = null;
        switch (SQLUtil.repositoryType) {
            case 7: {
                fileSqlParms = derbyFileParms;
                break;
            }
            case 5: {
                fileSqlParms = udbFileParms;
            }
        }
        return fileSqlParms;
    }

    private void doDerbyRepositoryCreate() {
        String[] createStrs = new String[]{"CREATE SCHEMA " + this.m_sSchema, "SET SCHEMA=" + this.m_sSchema};
        for (int i = 0; i < createStrs.length; ++i) {
            this.trace("DEBUG SDI doInstall 1.5 " + createStrs[i]);
            this.executeSql(createStrs[i]);
        }
    }

    private void doRepositoryCreate() {
        if (SQLUtil.repositoryType == 7) {
            this.doDerbyRepositoryCreate();
        }
    }

    private void doDerbyRepositoryUpgrade() {
        String[] upgradeStrs = new String[]{"SET SCHEMA=" + this.m_sSchema};
        for (int i = 0; i < upgradeStrs.length; ++i) {
            this.trace("DEBUG SDI doUpgrade 1.5 " + upgradeStrs[i]);
            this.executeSql(upgradeStrs[i]);
        }
    }

    private void doRepositoryUpgrade() {
        if (SQLUtil.repositoryType == 7) {
            this.doDerbyRepositoryUpgrade();
        }
    }

    private void doInstall() throws Exception {
        this.trace("DEBUG SDI doInstall begin");
        Object[] fileSqlParms = null;
        this.trace("DEBUG SDI doInstall 1 calling doRepositorySpace");
        this.doRepositoryCreate();
        fileSqlParms = this.getFileSqlParms();
        this.createTables(fileSqlParms, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTables(Object[] fileSqlParms, SoftwareVersion sv) throws Exception {
        block20: {
            BufferedReader[] reader = null;
            this.trace("DEBUG SDI doInstall 2 1 ");
            try {
                this.sqlFiles = AlterFileList.getFiles(sv, this.m_sSchemaPath);
                reader = new BufferedReader[this.sqlFiles.length];
                this.trace("DEBUG SDI doInstall 2 4 ");
                this.prepFiles(reader);
                this.trace("DEBUG SDI doInstall 3");
                this.trace("DEBUG SDI doInstall 8");
                StringBuffer buffer = new StringBuffer(1024);
                int vrm = 0;
                this.fileIndex = 0;
                while (this.fileIndex < this.sqlFiles.length) {
                    String line;
                    BufferedReader r = reader[this.fileIndex];
                    vrm = AlterFileList.getFileVRM(this.sqlFiles[this.fileIndex]);
                    this.trace("DEBUG SDI doInstall 8.5 fileIndex = " + this.fileIndex);
                    while ((line = r.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        int i = 0;
                        boolean skip = false;
                        while (line.charAt(i) == ' ' || line.charAt(i) == '\t') {
                            if (++i != line.length()) continue;
                            line = "";
                            skip = true;
                            break;
                        }
                        if (skip || line.charAt(i) == '#' || line.startsWith("--", i) || line.startsWith("sqlcount", i)) continue;
                        if (line.charAt(i) == ';') {
                            this.trace("DEBUG SDI doInstall 9 " + buffer.toString());
                            this.executeSql(buffer.toString());
                            buffer.setLength(0);
                            continue;
                        }
                        this.formatLine(line, buffer, fileSqlParms);
                    }
                    ++this.fileIndex;
                }
                this.trace("DEBUG SDI doInstall 11");
                boolean stepStatus = false;
                StorageAlertOSRepoInstall rip = new StorageAlertOSRepoInstall(this.m_dbConn);
                stepStatus = rip.process();
                this.trace("DEBUG SDI doInstall 12 status " + stepStatus);
                try {
                    SoftwareVersion current = SoftwareVersion.decodeToSV((int)vrm);
                    if (sv == null) {
                        this.insertIntoUpgradeLog(current);
                    } else {
                        this.finishOffUpgradeLog(current);
                    }
                    this.m_dbConn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.trace("DEBUG SDI doInstall 14");
                if (reader == null) break block20;
                for (int i = 0; i < reader.length; ++i) {
                    if (reader[i] == null) continue;
                    try {
                        reader[i].close();
                        continue;
                    }
                    catch (IOException e) {
                        this.trace("SilentDatabaseInstall::doInstall ignored io " + e);
                    }
                }
            }
        }
        this.trace("DEBUG SDI doInstall 15");
    }

    private void insertIntoUpgradeLog(SoftwareVersion sv) throws Exception {
        Statement stmt = this.m_dbConn.getConnection().createStatement();
        StringBuffer buf = new StringBuffer(100);
        buf.append("insert into t_upgrade_log values ('");
        buf.append(sv.svVendor);
        buf.append("', ");
        buf.append(sv.svVersion);
        buf.append(", ");
        buf.append(sv.svRelease);
        buf.append(", ");
        buf.append(sv.svModification);
        buf.append(", ");
        buf.append(sv.svSubModification);
        buf.append(", 0)");
        this.executeSql(stmt, buf.toString());
        stmt.close();
    }

    private void finishOffUpgradeLog(SoftwareVersion current) throws Exception {
        Statement stmt = this.m_dbConn.getConnection().createStatement();
        StringBuffer buf = new StringBuffer(100);
        buf.setLength(0);
        buf.append("update t_upgrade_log set vendor = '");
        buf.append(current.svVendor);
        buf.append("', versn = ");
        buf.append(current.svVersion);
        buf.append(", release = ");
        buf.append(current.svRelease);
        buf.append(", modification = ");
        buf.append(current.svModification);
        buf.append(", submodification = ");
        buf.append(current.svSubModification);
        buf.append(", statement_number = 0");
        this.executeSql(stmt, buf.toString());
        stmt.close();
    }

    private void doUninstall() throws Exception {
    }

    private void doUpgrade() throws Exception {
        this.trace("DEBUG SDI doUpgrade begin");
        try {
            this.doRepositoryUpgrade();
            Object[] fileSqlParms = null;
            SoftwareVersion currentSWVersion = this.getCurrentSWVersion();
            fileSqlParms = this.getFileSqlParms();
            this.createTables(fileSqlParms, currentSWVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.trace("DEBUG SDI doUpgrade end");
    }

    private SoftwareVersion getCurrentSWVersion() {
        ResultSet resultSet = null;
        SoftwareVersion current = new SoftwareVersion();
        try {
            Statement stmt = this.m_dbConn.getConnection().createStatement();
            resultSet = stmt.executeQuery("select versn, release, modification, submodification, vendor from t_upgrade_log");
            if (resultSet.next()) {
                current.svVersion = resultSet.getByte(1);
                current.svRelease = resultSet.getByte(2);
                current.svModification = resultSet.getShort(3);
                current.svSubModification = resultSet.getShort(4);
                current.svVendor = resultSet.getByte(5);
            }
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return current;
    }

    public SilentDatabaseInstall() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        SilentDatabaseInstall sdi;
        block21: {
            sdi = new SilentDatabaseInstall();
            String[] parameters = args;
            DBConstants.useLogging = false;
            System.setProperty("tpc.environment", "Device_Server");
            System.setProperty("tsnm.baseDir", "C:\\");
            try {
                sdi.parseParameters(parameters);
                sdi.trace("DEBUG SDI calling analyzeParameters");
            }
            catch (Exception sie) {
                sie.printStackTrace();
                sdi.printUsage();
                if (!exitOnComplete) break block21;
                System.exit(1);
            }
        }
        try {
            sdi.initializeApi(SQLUtil.repositoryType);
            sdi.trace("DEBUG SDI thats it for now");
            if (sdi.m_sMode.equals("install")) {
                sdi.doInstall();
            } else if (sdi.m_sMode.equals("uninstall")) {
                sdi.doUninstall();
            } else if (sdi.m_sMode.equals("upgrade")) {
                sdi.doUpgrade();
            } else {
                MessageLog.logMessage((String)("ERROR SilentDatabaseInstall Invalid mode " + sdi.m_sMode));
            }
        }
        catch (Exception sie) {
            sie.printStackTrace();
            if (exitOnComplete) {
                System.exit(1);
            }
        }
        finally {
            try {
                sdi.terminateApi();
            }
            catch (Exception exception) {}
        }
        System.out.println("Database installation successful.");
        if (exitOnComplete) {
            System.exit(0);
        }
    }

    void initializeApi(byte aDbType) throws Exception {
        if (aDbType == 7) {
            this.m_sUrl = "jdbc:derby://" + this.m_sHost + ":" + this.m_sDbPort + "/" + this.m_sDatabase + ";create=true";
        } else if (aDbType == 5) {
            this.m_sUrl = "jdbc:db2://" + this.m_sHost + ":" + this.m_sDbPort + "/" + this.m_sDatabase;
        }
        DBConnPoolDataSource.initialize((String)this.m_sJdbcDriver, (String)this.m_sUrl, (String)this.m_sSchema, (String)this.m_sDbUser, (String)this.m_sDbPassWord, (int)2);
        this.m_dbConnPool = DBConnPoolDataSource.getInstance();
        try {
            this.m_dbConn = (DBConnection)this.m_dbConnPool.getPooledConnection();
            this.m_dbConn.setSchema(this.m_sSchema);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            String errorMsg = SQLUtil.getSQLExceptionMsg("INS2071E", sqle, null);
            throw new Exception(errorMsg + " initializeApi failed in getPooledConnection");
        }
    }

    void terminateApi() throws Exception {
        if (this.m_dbConn != null) {
            try {
                this.m_dbConn.close();
                this.m_dbConn = null;
            }
            catch (SQLException sqle) {
                throw new Exception("terminatepi failed in close");
            }
        }
    }

    private class StrmCopier
    extends Thread {
        InputStream instrm = null;
        PrintStream outstrm = null;

        StrmCopier(InputStream istrm, PrintStream ostrm) {
            this.instrm = istrm;
            this.outstrm = ostrm;
        }

        public void run() {
            try {
                byte[] buf = new byte[1024];
                int len = this.instrm.read(buf);
                while (len >= 0) {
                    if (len > 0) {
                        this.outstrm.write(buf, 0, len);
                    }
                    len = this.instrm.read(buf);
                }
                this.instrm.close();
            }
            catch (IOException e) {
                this.outstrm.println("Could not copy stream!!");
                e.printStackTrace();
                e.printStackTrace(this.outstrm);
            }
        }
    }
}

