/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class RaceConditionChecker
extends RepositoryAccessor {
    private long guiTimestamp;
    private String sqlText;
    private String objectType;
    private String creatorName;
    public String message;
    public boolean wasDeleted;

    public RaceConditionChecker(Connection dbc, String pTableName, String idColumnName, CreateHeader requestData, String pObjectType) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RaceConditionChecker.class.getName(), (String)"RaceConditionChecker", (String)"dbc, pTableName, idColumnName, requestData, pObjectType");
        }
        this.tableName = pTableName;
        this.guiTimestamp = requestData.lastModified;
        this.objectType = pObjectType;
        StringBuffer buf = new StringBuffer(120);
        buf.append(requestData.creator);
        buf.append('.');
        buf.append(requestData.getName());
        this.creatorName = buf.toString();
        buf.setLength(0);
        buf.append("SELECT last_modified, last_mod_user FROM ");
        buf.append(this.tableName);
        buf.append(" WHERE ");
        buf.append(idColumnName);
        buf.append(" = ");
        buf.append(Integer.toString(requestData.ID));
        this.sqlText = buf.toString();
        this.message = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RaceConditionChecker.class.getName(), (String)"RaceConditionChecker");
        }
    }

    public void check() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RaceConditionChecker.class.getName(), (String)"check", (String)"");
        }
        String user = null;
        long timestamp = 0L;
        this.selectStmt = this.prepareStmt(this.sqlText);
        this.stmtType = 0;
        this.stmtPhase = 3;
        try {
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 2;
            if (this.resultSet.next()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                timestamp = this.getLong(this.resultSet);
                user = this.getString(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RaceConditionChecker.class.getName(), (String)"check", (Throwable)e);
            }
            this.sqlError(e);
        }
        this.closeResultSet();
        this.closeSelect();
        if (this.stmtPhase == 2) {
            Object[] args = new Object[]{this.objectType, this.creatorName};
            this.message = MessageLog.getMessage((String)"SRV0093W", (Object[])args);
            this.wasDeleted = true;
        } else if (timestamp > this.guiTimestamp) {
            Object[] args = new Object[]{this.objectType, this.creatorName, user};
            this.message = MessageLog.getMessage((String)"SRV0094W", (Object[])args);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RaceConditionChecker.class.getName(), (String)"check");
        }
    }
}

