/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.util.HashMap;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StatDeleter;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TFoundComputer;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.alert.StormAlerter;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public class UnmanagedSaver {
    private int[][] varBindOIDs;
    private String[] tecSlotNames;
    private Connection dbc;
    protected static final int RESOURCE_NAME = 1;
    protected static final int RESOURCE_TYPE = 2;
    protected static final int ALERT_NAME = 3;
    protected static final int ALERT_TYPE = 4;

    public UnmanagedSaver(Connection pDBC) {
        this.dbc = pDBC;
    }

    private static boolean differ(FoundComputer one, FoundComputer another) {
        return !one.fcIPAddress.equals(another.fcIPAddress) || one.fcOSType != another.fcOSType || one.fcNameIsLocal != another.fcNameIsLocal || one.fcTimesMissing != another.fcTimesMissing;
    }

    private void genAlert(FoundComputer fc, AlertDefinition alertDef) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UnmanagedSaver.class.getName(), (String)"genAlert", (String)"fc, alertDef");
        }
        String[] parms = new String[]{TFoundComputer.canonicalName(fc), MessageLog.getMessageNoID((String)"ALR1022W")};
        Alert alert = new Alert(fc.fcID, -1, 32, alertDef, parms, 17, this.varBindOIDs, this.tecSlotNames);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UnmanagedSaver.class.getName(), (String)"genAlert");
        }
    }

    private AlertDefinition retrievePredefinedAlert() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UnmanagedSaver.class.getName(), (String)"retrievePredefinedAlert", (String)"");
        }
        TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
        alertAccessor.prepSelectByID(false, false);
        AlertDefinition result = alertAccessor.getByID(100);
        if (result == null) {
            Object[] args = new Object[]{new Integer(100)};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UnmanagedSaver.class.getName(), (String)"retrievePredefinedAlert");
            }
            throw new GeneralException(MessageLog.getMessage((String)"SRV0105E", (Object[])args));
        }
        alertAccessor.closeSelect();
        this.varBindOIDs = new int[2][];
        this.varBindOIDs[0] = StormAlerter.COMPUTER_OID;
        this.varBindOIDs[1] = Alerter.ALERT_TYPE_OID;
        this.tecSlotNames = new String[2];
        this.tecSlotNames[0] = "hostname";
        this.tecSlotNames[1] = "alertType";
        AlertDefinition traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UnmanagedSaver.class.getName(), (String)"retrievePredefinedAlert", (Object)traceResult);
        }
        return traceResult;
    }

    public void save(String domain, FoundComputer discovered) throws GeneralException {
        GeneralException exception;
        block36: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)UnmanagedSaver.class.getName(), (String)"save", (String)"domain, discovered");
            }
            FoundComputer updateList = null;
            int nToInsert = 0;
            TFoundComputer accessor = new TFoundComputer(this.dbc);
            FoundComputer fc2 = accessor.selectByDomain(domain);
            boolean wereNone = fc2 == null;
            HashMap<String, FoundComputer> map = new HashMap<String, FoundComputer>();
            while (fc2 != null) {
                map.put(fc2.fcName, fc2);
                fc2 = fc2.fcNext;
            }
            FoundComputer tail = null;
            fc2 = discovered;
            while (fc2 != null) {
                FoundComputer existing = (FoundComputer)map.remove(fc2.fcName);
                if (existing != null) {
                    FoundComputer saved = fc2;
                    fc2 = fc2.fcNext;
                    if (tail != null) {
                        tail.fcNext = fc2;
                    } else {
                        discovered = fc2;
                    }
                    if (!UnmanagedSaver.differ(existing, saved)) continue;
                    saved.fcID = existing.fcID;
                    saved.fcNext = updateList;
                    updateList = saved;
                    continue;
                }
                tail = fc2;
                fc2 = fc2.fcNext;
                ++nToInsert;
            }
            if (!map.isEmpty()) {
                LinkedInteger deleteHead = null;
                for (FoundComputer fc2 : map.values()) {
                    fc2.fcTimesMissing = (short)(fc2.fcTimesMissing + 1);
                    if (fc2.fcTimesMissing < 3) {
                        fc2.fcNext = updateList;
                        updateList = fc2;
                        continue;
                    }
                    LinkedInteger element = new LinkedInteger(fc2.fcID);
                    element.next = deleteHead;
                    deleteHead = element;
                }
                if (deleteHead != null) {
                    StatDeleter deleter = new StatDeleter(this.dbc);
                    deleter.prepDeleteByID("t_found_computer", "found_computer_id");
                    while (deleteHead != null) {
                        deleteHead = deleter.deleteByID(deleteHead);
                    }
                }
            }
            map = null;
            if (discovered != null) {
                long now = 0L;
                try {
                    now = SQLUtil.getTimestamp(this.dbc).getTime();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)UnmanagedSaver.class.getName(), (String)"save", (Throwable)e);
                    }
                    return;
                }
                int id = StorageRepositoryAccessor.getIdentifier(1, nToInsert, this.dbc);
                fc2 = discovered;
                while (fc2 != null) {
                    fc2.fcID = id++;
                    fc2.fcWhenDiscovered = now;
                    fc2 = fc2.fcNext;
                }
                accessor.insert(discovered);
            }
            accessor.commit();
            if (updateList != null) {
                accessor.update(updateList);
            }
            if (wereNone || discovered == null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)UnmanagedSaver.class.getName(), (String)"save");
                }
                return;
            }
            TFoundComputer networkAccessor = accessor;
            accessor = null;
            TFoundComputer windowsAccessor = new TFoundComputer(this.dbc);
            AlertDefinition predefinedAlert = null;
            exception = null;
            try {
                networkAccessor.prepNetworkMatch();
                accessor = windowsAccessor;
                accessor.prepWindowsMatch();
                while (discovered != null) {
                    accessor = discovered.fcNameIsLocal ? windowsAccessor : networkAccessor;
                    if (!accessor.selectMatch(discovered.fcID)) {
                        if (discovered.fcNameIsLocal) {
                            accessor = networkAccessor;
                            if (!accessor.selectMatch(discovered.fcID)) {
                                if (predefinedAlert == null) {
                                    predefinedAlert = this.retrievePredefinedAlert();
                                }
                                this.genAlert(discovered, predefinedAlert);
                            }
                        } else {
                            if (predefinedAlert == null) {
                                predefinedAlert = this.retrievePredefinedAlert();
                            }
                            this.genAlert(discovered, predefinedAlert);
                        }
                    }
                    discovered = discovered.fcNext;
                }
            }
            catch (GeneralException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)UnmanagedSaver.class.getName(), (String)"save", (Throwable)e);
                }
                exception = e;
                if (accessor == null) break block36;
                try {
                    if (windowsAccessor != null) {
                        windowsAccessor.closeSelect();
                    }
                    if (networkAccessor != null) {
                        networkAccessor.closeSelect();
                    }
                }
                catch (GeneralException exc) {
                    // empty catch block
                }
            }
        }
        if (exception != null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UnmanagedSaver.class.getName(), (String)"save");
            }
            throw exception;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UnmanagedSaver.class.getName(), (String)"save");
        }
    }
}

