/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.SpaceHistory;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptUserSpace;

public class RptDiskHist
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    private static final String SELECT = "select disk_id, statistic_time, statistic_type, capacity, free_space from t_stat_disk_hist ";
    private static final String DISK_COL = "disk_id";

    public RptDiskHist(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDiskHist.class.getName(), (String)"RptDiskHist", (String)"dbc");
        }
        this.tableName = "T_STAT_DISK_HIST";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDiskHist.class.getName(), (String)"RptDiskHist");
        }
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDiskHist.class.getName(), (String)"getReportData", (String)"grr");
        }
        SpaceHistory resultList = null;
        int totalRows = 0;
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(SELECT);
        buffer.append(" where statistic_type in ('");
        buffer.append(grr.histType);
        if (grr.histType == 0) {
            buffer.append("','3') and");
        } else {
            buffer.append("') and");
        }
        if (grr.startTime > 0L) {
            buffer.append(" statistic_time between ? and ? and");
        }
        SQLUtil.appendInClause(buffer, DISK_COL, grr.selectedResources);
        try {
            this.selectStmt = this.prepareStmt(buffer.toString());
            if (grr.startTime > 0L) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.selectStmt, grr.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, grr.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            SpaceHistory sh = new SpaceHistory();
            while (this.resultSet.next()) {
                this.colIndex = 1;
                sh.shLegendID1 = this.getInt(this.resultSet);
                sh.shLegendID2 = Integer.MIN_VALUE;
                sh.shStatisticTime = this.getTimestamp(this.resultSet);
                byte statType = this.getByte(this.resultSet);
                long capacity = this.getLong(this.resultSet);
                if (capacity <= 0L) continue;
                if (grr.histSubtype == 5) {
                    sh.shTotalSize = capacity;
                } else {
                    sh.shTotalSize = this.getLong(this.resultSet);
                    if (sh.shTotalSize < 0L) continue;
                    if (grr.histSubtype == 2) {
                        sh.shFileCount = (int)(sh.shTotalSize * 100L / capacity);
                    }
                }
                sh.shNext = resultList;
                resultList = sh;
                sh = new SpaceHistory();
                ++totalRows;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptDiskHist.class.getName(), (String)"getReportData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        SpaceHistory[] traceResult = RptUserSpace.packUpHistory(resultList, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDiskHist.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }
}

