/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.San.server.guireq.RespEndToEnd;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.report.filter.ReportFilter;

public class RptEndToEnd
extends RepositoryAccessor
implements GuiDataProvider {
    private static final short LD = 11;
    private static final String MOST_RECENT = "'" + Integer.toString(3) + "'";
    private static final String COMPUTER_TO_DISK_SS = " select distinct c.computer_id, sd.disk_id, c.host_name, ss_chunk.chunk_size,   ss.os_type, case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name else ss.display_name end display_name, ss.name,  vendor.vendor_name,   ss_pv.device_id, model.model_name, ss_pv.serial_number,  ss_chunk.offset, sv.unique_id  from  t_stat_disk sd , t_res_vendor vendor , t_res_model model ,       t_res_chunk ss_chunk , t_res_storage_subsystem ss , t_res_host c ,       t_res_view_ssluncmp ssluncmp ,       t_res_storage_volume sv , t_res_physical_volume ss_pv  where ssluncmp.svid = sv.svid       and ssluncmp.computer_id = c.computer_id       and ssluncmp.subsystem_id = ss.subsystem_id       and ss_pv.vendor_id=vendor.vendor_id       and ss_pv.model_id=model.model_id       and ss_pv.physical_volume_id = sd.disk_id       and ss_chunk.logical_disk_id = sv.svid       and ss_chunk.disk_id = ss_pv.physical_volume_id ";
    private static final String COMPUTER_TO_DISK_SVC = " select distinct c.computer_id, sd.disk_id, c.host_name, svc_chunk.chunk_size,   ss.os_type, case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name else ss.display_name end display_name, ss.name,  cast(null as char),   svc_se.element_name, cast(null as char), cast(null as char),  svc_chunk.offset, sv.unique_id  from  t_stat_disk sd , t_res_vendor vendor , t_res_model model ,       t_res_chunk svc_chunk , t_res_storage_subsystem ss , t_res_host c ,       t_res_view_ssluncmp ssluncmp ,       t_res_storage_volume sv , t_res_storage_extent svc_se  where ssluncmp.svid = sv.svid       and ssluncmp.computer_id = c.computer_id       and ssluncmp.subsystem_id = ss.subsystem_id       and ss.vendor_id=vendor.vendor_id       and ss.model_id=model.model_id       and svc_se.storage_extent_id = sd.disk_id       and svc_chunk.logical_disk_id = sv.svid       and svc_chunk.disk_id = svc_se.storage_extent_id ";
    private static final String LVID_SIMPLE_TO_DISK_SS = " select distinct ld.logical_disk_id, ss_chunk.chunk_size, ss.os_type,  case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name  else ss.display_name end display_name, ss.name, ss_pv.physical_volume_id,  ss_pv.device_id, vendor.vendor_name,  model.model_name, ss_pv.serial_number, ss_chunk.offset, sv.unique_id  from  t_res_logical_disk ld  , t_res_chunk ss_chunk  , t_res_chunk computer_chunk  , t_res_storage_subsystem ss  , t_res_vendor vendor  , t_res_model model  , t_res_view_ssluncmp ssluncmp  , t_res_physical_volume computer_pv  , t_res_physical_volume ss_pv  , t_res_storage_volume sv  where  ssluncmp.subsystem_id = ss.subsystem_id   and ssluncmp.svid = sv.svid  and ssluncmp.physical_volume_id = computer_pv.physical_volume_id  and computer_pv.physical_volume_id = computer_chunk.disk_id and ld.logical_disk_id = computer_chunk.logical_disk_id  and sv.svid = ss_chunk.logical_disk_id  and ss_chunk.disk_id = ss_pv.physical_volume_id  and ss_pv.vendor_id = vendor.vendor_id  and ss_pv.model_id = model.model_id ";
    private static final String LVID_SIMPLE_TO_DISK_SVC = " select distinct ld.logical_disk_id, svc_chunk.chunk_size, ss.os_type,  case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name  else ss.display_name end display_name, ss.name, svc_se.storage_extent_id,  svc_se.element_name, cast(null as char),  cast(null as char), cast(null as char), svc_chunk.offset, sv.unique_id  from  t_res_logical_disk ld  , t_res_chunk svc_chunk  , t_res_chunk computer_chunk  , t_res_storage_subsystem ss  , t_res_vendor vendor  , t_res_model model  , t_res_view_ssluncmp ssluncmp  , t_res_physical_volume computer_pv  , t_res_storage_extent svc_se  , t_res_storage_volume sv  where  ssluncmp.subsystem_id = ss.subsystem_id   and ssluncmp.svid = sv.svid  and ssluncmp.physical_volume_id = computer_pv.physical_volume_id  and computer_pv.physical_volume_id = computer_chunk.disk_id and ld.logical_disk_id = computer_chunk.logical_disk_id  and sv.svid = svc_chunk.logical_disk_id  and svc_chunk.disk_id = svc_se.storage_extent_id  and ss.vendor_id = vendor.vendor_id  and ss.model_id = model.model_id ";
    private static final String LVID_COMPOUND_TO_DISK = "select distinct l2.logical_disk_id, h1.chunk_size, c.os_type, c.host_url, cast(null as char), d1.disk_id, a.path, v.vendor_id, v.model_id,  case when v.subsystem_serial_number is not null then       v.subsystem_serial_number || '/' || v.serial_number  else v.serial_number end,  h1.offset, cast(null as char) from t_res_logical_disk l2, t_res_logical_disk l, t_res_chunk h1, t_res_chunk h2, t_stat_disk d1, t_stat_disk d2, t_res_share s, t_res_physical_volume v, t_res_dev_access a, t_res_host c where (l2.parent_logdisk_id <= 0) and (l.parent_logdisk_id = l2.logical_disk_id) and (h2.logical_disk_id = l.logical_disk_id) and (d2.disk_id = h2.disk_id) and (s.resource_type = 11) and (s.resource_id = d2.logical_disk_id) and (h1.logical_disk_id = s.resource_id) and (h1.logical_disk_id = d2.logical_disk_id) and (c.computer_id = s.computer_id) and (d1.disk_id = h1.disk_id) and (v.physical_volume_id = h1.disk_id) and (v.physical_volume_id = d1.disk_id) and (a.device_id = v.physical_volume_id) and (a.device_id = d1.disk_id)";
    private static final String FILESYSTEM_INFO = " select c.host_name, fs.mount_point, fs.capacity, fs.free_space,   fs.filesystem_id, vendor.vendor_name  from  t_res_host c  , t_res_filesystem fs  , t_res_chunk chunk  , t_res_physical_volume pv  , t_res_vendor vendor  where    (fs.logical_disk_id = ?)  and (c.computer_id = fs.computer_id)  and (fs.logical_disk_id = chunk.logical_disk_id)  and (chunk.disk_id = pv.physical_volume_id)  and (pv.vendor_id = vendor.vendor_id) ";
    private static final String LV_INFO = "select c.host_name, s.path,  l.capacity from t_res_host c, t_res_share s, t_res_logical_disk l where (s.resource_type = 11) and (l.logical_disk_id = s.resource_id) and (l.logical_disk_id = ?) and (s.resource_id = ?) and (l.parent_logdisk_id <= 0) and (c.computer_id = s.computer_id)";
    private static final String FILESYSTEM_SIMPLE_TO_LUN = "   select distinct fs2lun.logical_disk_id, fs2lun.sd_disk_id, host_name  \t,  ss_vendor_name, fs2lun.mount_point, fs2lun.fs_capacity   \t,  fs2lun.fs_free_space, fs2lun.filesystem_id , da_path   \t,  ss_os_type,  ss_display_name, ss_name    \t, share.name, sv_display_name,  sd_capacity    \t, sv_unique_id, sv_display_name, cimv_device_id    from   t_res_fs2lun fs2lun    \t\t,t_res_share share    where fs2lun.logical_disk_id = share.resource_id    \tand share.resource_type = 11 ";
    private static final String FILESYSTEM_COMPOUND_TO_LUN = "select distinct f.logical_disk_id, d.disk_id, c2.host_name, c1.vendor_id, f.mount_point, f.capacity, f.free_space, f.filesystem_id, a.path, c1.os_type, case when c1.user_provided_name is not null  and c1.user_provided_name not in ('')  then c1.user_provided_name  else c1.display_name end display_name, c1.name, share.name, share.path, d.capacity, sv.unique_id, sv.display_name, cimv.device_id  from t_res_filesystem f, t_res_storage_subsystem c1, t_res_host c2, t_res_share share, t_res_logical_disk l2, t_res_logical_disk l, t_res_chunk h, t_stat_disk d, t_res_dev_access a, t_res_controller n , t_res_vendor vendor  , t_res_view_ssluncmp ssluncmp  , t_res_storage_volume sv  , t_res_cimkey_volume cimv  where (l2.parent_logdisk_id <= 0) and (f.logical_disk_id = l2.logical_disk_id) and (l.parent_logdisk_id = l2.logical_disk_id) and (l.parent_logdisk_id = f.logical_disk_id) and (h.logical_disk_id = l.logical_disk_id) and (c2.computer_id = f.computer_id) and (d.disk_id = h.disk_id) and (a.device_id = d.disk_id) and (a.device_id = h.disk_id) and (n.computer_id = f.computer_id) and (n.computer_id = c2.computer_id) and ssluncmp.computer_id = c2.computer_id  and ssluncmp.svid = sv.svid  and sv.svid = cimv.volume_id  and ssluncmp.subsystem_id = c1.subsystem_id  and c1.vendor_id = vendor.vendor_id  and ssluncmp.physical_volume_id = d.disk_id  and ssluncmp.physical_volume_id = a.device_id  and (a.controller_id = n.controller_id) and (share.resource_type = 11) and (share.resource_id = d.logical_disk_id) and (c1.subsystem_id = share.computer_id)";
    private static final String LV_SIMPLE_TO_LUN = "   select distinct lv2lun.logical_disk_id, physical_volume_id  , host_name   \t, ss_vendor_name, share.path ,ld_capacity    \t,  da_path, ss_os_type, ss_display_name, ss_name, share.name    \t, sv_display_name, sd_capacity, sv_unique_id, sv_display_name,   cimv_device_id  from   t_res_lv2lun lv2lun         ,t_res_share share  where   share.resource_id = lv2lun.logical_disk_id  and share.computer_id = lv2lun.computer_id ";
    private static final String LV_COMPOUND_TO_LUN = "select distinct l2.logical_disk_id, d.disk_id, c2.host_name, c1.vendor_id, s2.path, l.capacity, a.path, c1.os_type, case when c1.user_provided_name is not null  and c1.user_provided_name not in ('')  then c1.user_provided_name else c1.display_name end display_name, c1.name,  share.name, share.path, d.capacity, sv.unique_id, sv.display_name, cimv.device_id  from t_res_logical_disk l2, t_res_logical_disk l, t_res_storage_subsystem c1, t_res_host c2, t_res_share share, t_res_share s2, t_res_dev_access a, t_res_chunk h, t_stat_disk d, t_res_controller n , t_res_vendor vendor  , t_res_view_ssluncmp ssluncmp  , t_res_storage_volume sv  , t_res_cimkey_volume cimv  where (l2.parent_logdisk_id <= 0) and (l.parent_logdisk_id = l2.logical_disk_id) and (s2.resource_type = 11) and (s2.resource_id = l2.logical_disk_id) and (s2.resource_id = l.parent_logdisk_id) and (c2.computer_id = s2.computer_id) and (h.logical_disk_id = l.logical_disk_id) and (d.disk_id = h.disk_id) and (a.device_id = d.disk_id) and (a.device_id = h.disk_id) and (n.computer_id = c2.computer_id) and (n.computer_id = s2.computer_id) and ssluncmp.computer_id = c2.computer_id  and ssluncmp.svid = sv.svid  and sv.svid = cimv.volume_id  and ssluncmp.subsystem_id = c1.subsystem_id  and c1.vendor_id = vendor.vendor_id  and ssluncmp.physical_volume_id = d.disk_id  and ssluncmp.physical_volume_id = a.device_id  and (a.controller_id = n.controller_id) and (share.resource_type = 11) and (c1.subsystem_id = share.computer_id) and (share.resource_id = d.logical_disk_id)";
    private static final String COMPUTER_TO_LUN = "  select \tdistinct comp2lun.computer_id, sd_disk_id, host_name   \t, da_path, ss_os_type, ss_display_name    \t, ss_name, ss_vendor_name, sv_display_name    \t, share.path, sd_capacity, sdh_free_space    \t, sv_unique_id, sv_display_name, cimv_device_id   from   \tt_res_comp2lun comp2lun    \t, t_res_share share   where \tcomp2lun.physical_volume_id = share.resource_id ";
    private static final String COMPUTER_TO_LUN_OLD = "select   c.computer_id, sd.disk_id, c.host_name, da.path, ss.os_type, case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name else ss.display_name end display_name,  ss.name, ss.vendor_id, pv.serial_number, share.path, sd.capacity,  sdh.free_space, sv.unique_id, sv.display_name, cimv.device_id  from  t_res_view_ssluncmp ssluncmp  , t_res_dev_access da  , t_res_host   c  , t_res_storage_subsystem ss  , t_res_share share  , t_res_storage_volume sv  , t_res_physical_volume pv  , t_stat_disk sd  , t_stat_disk_hist sdh  , t_res_cimkey_volume cimv  where ssluncmp.computer_id = c.computer_id  and ssluncmp.subsystem_id = ss.subsystem_id  and ssluncmp.physical_volume_id = pv.physical_volume_id  and pv.physical_volume_id = da.device_id  and pv.physical_volume_id = share.resource_id  and pv.physical_volume_id = sd.disk_id  and pv.physical_volume_id = sdh.disk_id  and sdh.statistic_type = " + MOST_RECENT + " " + " and ssluncmp.svid = sv.svid " + " and sv.svid = cimv.volume_id";
    private static final String LVID_SIMPLE_TO_DISK_ARRAY = " select distinct ldisk.logical_disk_id,  ss.os_type, case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name else ss.display_name end display_name,  ss.name, vendor.vendor_name  from  t_res_logical_disk ldisk  , t_res_chunk chunk  , t_res_host c  , t_res_physical_volume pv  , t_res_storage_subsystem ss  , t_res_vendor vendor  , t_res_view_ssluncmp ssluncmp  where ssluncmp.computer_id = c.computer_id  and pv.physical_volume_id=ssluncmp.physical_volume_id  and ssluncmp.subsystem_id=ss.subsystem_id  and pv.physical_volume_id = chunk.disk_id  and chunk.logical_disk_id = ldisk.logical_disk_id  and pv.vendor_id = vendor.vendor_id ";
    private static final String LVID_COMPOUND_TO_DISK_ARRAY = "select distinct l2.logical_disk_id, ss.os_type, case when ss.user_provided_name  is not null then ss.user_provided_name else ss.display_name end  display_name, ss.name, ss.vendor_id from t_res_logical_disk l2, t_res_logical_disk l, t_res_storage_subsystem ss, t_stat_disk d, t_res_chunk h, t_res_share s where (l2.parent_logdisk_id <= 0) and (l.parent_logdisk_id = l2.logical_disk_id) and (h.logical_disk_id = l.logical_disk_id) and (d.disk_id = h.disk_id) and (s.resource_type = 11) and (s.resource_id = d.logical_disk_id) and (ss.subsystem_id = s.computer_id)";
    private static final String COMPUTER_TO_DISK_ARRAY_SS = " select distinct c.computer_id, ss.subsystem_id, ssluncmp.lun_id,  ss_chunk.chunk_size, computer_sd.capacity, computer_sdh.free_space,  c.host_name, ss.os_type, case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name else ss.display_name end display_name,  ss.name, ss_chunk.offset, ss_chunk.disk_id  from t_res_host c,  t_res_storage_subsystem ss,  t_res_storage_volume sv,  t_res_chunk ss_chunk,  t_res_view_ssluncmp ssluncmp,  t_res_physical_volume ss_pv,  t_res_physical_volume computer_pv,  t_stat_disk computer_sd,  t_stat_disk_hist computer_sdh  where ssluncmp.subsystem_id = ss.subsystem_id  and ssluncmp.computer_id = c.computer_id  and ssluncmp.svid = sv.svid  and ssluncmp.physical_volume_id = computer_pv.physical_volume_id  and ss_pv.physical_volume_id = ss_chunk.disk_id  and computer_pv.physical_volume_id = computer_sd.disk_id  and computer_pv.physical_volume_id = computer_sdh.disk_id  and computer_sdh.statistic_type = " + MOST_RECENT + " " + " and sv.svid = ss_chunk.logical_disk_id ";
    private static final String COMPUTER_TO_DISK_ARRAY_SVC = " select distinct c.computer_id, ss.subsystem_id, ssluncmp.lun_id,  svc_chunk.chunk_size, computer_sd.capacity, computer_sdh.free_space,  c.host_name, ss.os_type, case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name else ss.display_name end display_name,  ss.name, svc_chunk.offset, svc_chunk.disk_id  from t_res_host c,  t_res_storage_subsystem ss,  t_res_storage_volume sv,  t_res_chunk svc_chunk,  t_res_view_ssluncmp ssluncmp,  t_res_storage_extent svc_se,  t_res_physical_volume computer_pv,  t_stat_disk computer_sd,  t_stat_disk_hist computer_sdh  where ssluncmp.subsystem_id = ss.subsystem_id  and ssluncmp.computer_id = c.computer_id  and ssluncmp.svid = sv.svid  and ssluncmp.physical_volume_id = computer_pv.physical_volume_id  and svc_se.storage_extent_id = svc_chunk.disk_id  and computer_pv.physical_volume_id = computer_sd.disk_id  and computer_pv.physical_volume_id = computer_sdh.disk_id  and computer_sdh.statistic_type = " + MOST_RECENT + " " + " and sv.svid = svc_chunk.logical_disk_id ";

    public RptEndToEnd(Connection pDBC) {
        super(pDBC);
        this.tableName = "t_res_storage_subsystem+";
    }

    private RespEndToEnd getFSAndLVInfo(RespEndToEnd ree) throws GeneralException {
        RespEndToEnd head = null;
        RespEndToEnd fsHead = null;
        RespEndToEnd last = null;
        int lastLDID = -1;
        this.selectStmt = this.prepareStmt(FILESYSTEM_INFO);
        while (ree != null) {
            RespEndToEnd next = ree.reeNext;
            if (ree.reeLogicalDiskID != lastLDID) {
                lastLDID = ree.reeLogicalDiskID;
                this.setPhase();
                try {
                    this.setInt(this.selectStmt, lastLDID);
                    this.stmtPhase = 3;
                    this.resultSet = this.selectStmt.executeQuery();
                    if (!this.nextResult()) {
                        last = null;
                    } else {
                        this.getPhase();
                        last = new RespEndToEnd();
                        last.reeComputer = this.getString(this.resultSet);
                        last.reeLVFSPath = this.getString(this.resultSet);
                        last.reeCapacity = this.getLong(this.resultSet);
                        last.reeFreeSpace = this.getLong(this.resultSet);
                        last.reeFilesystemID = this.getLong(this.resultSet);
                        last.reeManufacturer = this.getString(this.resultSet);
                        if (last.reeManufacturer != null && last.reeManufacturer.equals("HP")) {
                            last.reeManufacturer = "Hewlett-Packard";
                        }
                    }
                }
                catch (SQLException e) {
                    this.stmtType = 0;
                    this.sqlError(e);
                }
                this.closeResultSet();
            }
            if (last == null) {
                ree.reeNext = head;
                head = ree;
            } else {
                ree.reeComputer = last.reeComputer;
                ree.reeLVFSPath = last.reeLVFSPath;
                ree.reeCapacity = last.reeCapacity;
                ree.reeFreeSpace = last.reeFreeSpace;
                ree.reeFilesystemID = last.reeFilesystemID;
                ree.reeManufacturer = last.reeManufacturer;
                ree.reeNext = fsHead;
                fsHead = ree;
            }
            ree = next;
        }
        this.closeSelect();
        if (head == null) {
            return fsHead;
        }
        last = null;
        lastLDID = -1;
        boolean ldFound = false;
        this.selectStmt = this.prepareStmt(LV_INFO);
        ree = head;
        while (ree != null) {
            if (ree.reeLogicalDiskID == lastLDID) {
                if (ldFound) {
                    ree.reeComputer = last.reeComputer;
                    ree.reeLVFSPath = last.reeLVFSPath;
                    ree.reeCapacity = last.reeCapacity;
                } else if (last != null) {
                    last.reeNext = ree.reeNext;
                } else {
                    head = ree.reeNext;
                }
            } else {
                lastLDID = ree.reeLogicalDiskID;
                this.setPhase();
                try {
                    this.setInt(this.selectStmt, lastLDID);
                    this.setInt(this.selectStmt, lastLDID);
                    this.stmtPhase = 3;
                    this.resultSet = this.selectStmt.executeQuery();
                    ldFound = this.nextResult();
                    if (!ldFound) {
                        if (last != null) {
                            last.reeNext = ree.reeNext;
                        } else {
                            head = ree.reeNext;
                        }
                    } else {
                        this.getPhase();
                        ree.reeComputer = this.getString(this.resultSet);
                        ree.reeLVFSPath = this.getString(this.resultSet);
                        ree.reeCapacity = this.getLong(this.resultSet);
                        last = ree;
                    }
                }
                catch (SQLException e) {
                    this.stmtType = 0;
                    this.sqlError(e);
                }
                this.closeResultSet();
            }
            ree = ree.reeNext;
        }
        this.closeSelect();
        if (last != null) {
            last.reeNext = fsHead;
        } else {
            head = fsHead;
        }
        return head;
    }

    private StringBuffer lvToDiskSQL(String sqlText, GuiReportReq req, String ldCorrelationName, StringBuffer buf, boolean compound, boolean SVC) {
        if (buf == null) {
            buf = new StringBuffer(1000);
        } else {
            buf.append(" UNION ");
        }
        buf.append(sqlText);
        String qualifiedColumn = req.reportSubtype == 76 ? (compound ? ldCorrelationName + ".logical_disk_id" : (SVC ? "svc_se.storage_extent_id" : "ss_pv.physical_volume_id")) : ldCorrelationName + ".logical_disk_id";
        SQLUtil.appendInClause(buf, qualifiedColumn, req.selectedResources, req.isResourceInList, true);
        return buf;
    }

    private RespEndToEnd lvToDisk(GuiReportReq req, RespEndToEnd head) throws GeneralException {
        StringBuffer buf = null;
        if (head == null) {
            buf = this.lvToDiskSQL(LVID_SIMPLE_TO_DISK_SS, req, "ld", null, false, false);
            buf = this.lvToDiskSQL(LVID_SIMPLE_TO_DISK_SVC, req, "ld", buf, false, true);
        } else {
            buf = this.lvToDiskSQL(LVID_COMPOUND_TO_DISK, req, "l2", null, true, false);
        }
        buf.append(" order by 1, 4");
        String sqlText = buf.toString();
        buf = null;
        int lastLDID = -1;
        int lastDiskID = -1;
        this.setSQLText(sqlText);
        RespEndToEnd structure = null;
        try {
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(sqlText);
            while (this.nextResult()) {
                this.getPhase();
                int ldID = this.getInt(this.resultSet);
                long chunkSize = this.getLong(this.resultSet);
                short osType = this.getShort(this.resultSet);
                String diskArrayName = this.getString(this.resultSet);
                String diskArrayUniqueName = this.getString(this.resultSet);
                int diskID = this.getInt(this.resultSet);
                if (ldID != lastLDID || diskID != lastDiskID) {
                    lastLDID = ldID;
                    lastDiskID = diskID;
                    if (structure != null) {
                        structure.reeNext = head;
                        head = structure;
                    }
                    structure = new RespEndToEnd();
                    structure.reeLogicalDiskID = ldID;
                    structure.reeDiskArray = diskArrayName;
                    structure.reeDiskArrayName = diskArrayUniqueName;
                    structure.reeOSType = osType;
                    structure.reeArraySidePath = this.getString(this.resultSet);
                    structure.reeManufacturer = this.getString(this.resultSet);
                    structure.reeModel = this.getString(this.resultSet);
                    structure.reeSerialNumber = this.getString(this.resultSet);
                    long chunkOffset = this.getLong(this.resultSet);
                    structure.reeUniqueID = this.getString(this.resultSet);
                }
                structure.reePhysicalAlloc += chunkSize;
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        this.closeStaticStmt();
        if (structure != null) {
            structure.reeNext = head;
            head = structure;
        }
        return head;
    }

    private RespEndToEnd lvToDisk(GuiReportReq req) throws GeneralException {
        RespEndToEnd result = this.lvToDisk(req, null);
        if ((result = this.lvToDisk(req, result)) != null) {
            result = this.getFSAndLVInfo(result);
        }
        return result;
    }

    private RespEndToEnd lvToDiskArray(GuiReportReq req, String sqlText, String ldCorrelName, RespEndToEnd head) throws GeneralException {
        StringBuffer buf = new StringBuffer(1000);
        buf.append(sqlText);
        String qualifiedColumn = req.reportSubtype == 74 ? "ss.subsystem_id" : ldCorrelName + ".logical_disk_id";
        SQLUtil.appendInClause(buf, qualifiedColumn, req.selectedResources, req.isResourceInList, true);
        buf.append(" order by 1");
        sqlText = buf.toString();
        buf = null;
        this.setSQLText(sqlText);
        try {
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(sqlText);
            while (this.nextResult()) {
                this.getPhase();
                RespEndToEnd structure = new RespEndToEnd();
                structure.reeLogicalDiskID = this.getInt(this.resultSet);
                structure.reeOSType = this.getShort(this.resultSet);
                structure.reeDiskArray = this.getString(this.resultSet);
                structure.reeDiskArrayName = this.getString(this.resultSet);
                structure.reeManufacturer = this.getString(this.resultSet);
                structure.reeNext = head;
                head = structure;
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        this.closeStaticStmt();
        return head;
    }

    private RespEndToEnd lvToDiskArray(GuiReportReq req) throws GeneralException {
        RespEndToEnd result = this.lvToDiskArray(req, LVID_SIMPLE_TO_DISK_ARRAY, "ldisk", null);
        if ((result = this.lvToDiskArray(req, LVID_COMPOUND_TO_DISK_ARRAY, "l2", result)) != null) {
            result = this.getFSAndLVInfo(result);
        }
        return result;
    }

    private RespEndToEnd lvToLUN(GuiReportReq req, String sqlText, String correlationName, RespEndToEnd head, Map map) throws GeneralException {
        StringBuffer buf = new StringBuffer(1000);
        buf.append(sqlText);
        String qualifiedColumn = req.reportSubtype == 75 ? "share.resource_id" : correlationName + ".logical_disk_id";
        SQLUtil.appendInClause(buf, qualifiedColumn, req.selectedResources, req.isResourceInList, true);
        buf.append(" order by 1, 2");
        sqlText = buf.toString();
        buf = null;
        this.setSQLText(sqlText);
        int lastLDID = -1;
        int lastDiskID = -1;
        MutableInteger key = new MutableInteger();
        try {
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(sqlText);
            while (this.nextResult()) {
                this.getPhase();
                int ldID = this.getInt(this.resultSet);
                int diskID = this.getInt(this.resultSet);
                if (ldID == lastLDID && diskID == lastDiskID) continue;
                lastLDID = ldID;
                lastDiskID = diskID;
                if (map != null) {
                    key.value = ldID;
                    if (map.get(key) != null) continue;
                }
                RespEndToEnd structure = new RespEndToEnd();
                structure.reeLogicalDiskID = ldID;
                structure.reeComputer = this.getString(this.resultSet);
                structure.reeManufacturer = this.getString(this.resultSet);
                structure.reeLVFSPath = this.getString(this.resultSet);
                structure.reeCapacity = this.getLong(this.resultSet);
                if (map == null) {
                    structure.reeFreeSpace = this.getLong(this.resultSet);
                    structure.reeFilesystemID = this.getLong(this.resultSet);
                }
                structure.reeCompLUNPath = this.getString(this.resultSet);
                structure.reeOSType = this.getShort(this.resultSet);
                structure.reeDiskArray = this.getString(this.resultSet);
                structure.reeDiskArrayName = this.getString(this.resultSet);
                String name = this.getString(this.resultSet);
                if (SQLUtil.isNullString(name)) {
                    structure.reeLUNWWN = null;
                    structure.reeArraySidePath = this.getString(this.resultSet);
                } else {
                    structure.reeLUNWWN = this.getString(this.resultSet);
                    structure.reeArraySidePath = name;
                }
                if (structure.reeOSType == 14) {
                    structure.reeLUNWWN = null;
                }
                structure.reeLUNCapacity = this.getLong(this.resultSet);
                structure.reeUniqueID = this.getString(this.resultSet);
                String displayName = this.getString(this.resultSet);
                String deviceId = this.getString(this.resultSet);
                if (structure.reeOSType == 25 || structure.reeOSType == 27 || structure.reeOSType == 21) {
                    if (SQLUtil.isNullString(displayName)) {
                        structure.reeArraySidePath = deviceId;
                        structure.reeLUNWWN = null;
                    } else {
                        structure.reeArraySidePath = displayName;
                        structure.reeLUNWWN = deviceId;
                    }
                }
                structure.reeNext = head;
                head = structure;
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        this.closeStaticStmt();
        return head;
    }

    private RespEndToEnd lvToLUN(GuiReportReq req) throws GeneralException {
        RespEndToEnd result = this.lvToLUN(req, FILESYSTEM_SIMPLE_TO_LUN, "fs2lun", null, null);
        result = this.lvToLUN(req, FILESYSTEM_COMPOUND_TO_LUN, "f", result, null);
        int lastLDID = -1;
        HashMap<MutableInteger, RespEndToEnd> map = new HashMap<MutableInteger, RespEndToEnd>();
        RespEndToEnd ree = result;
        while (ree != null) {
            if (ree.reeLogicalDiskID != lastLDID) {
                lastLDID = ree.reeLogicalDiskID;
                MutableInteger key = new MutableInteger(lastLDID);
                map.put(key, ree);
            }
            ree = ree.reeNext;
        }
        result = this.lvToLUN(req, LV_SIMPLE_TO_LUN, "lv2lun", result, map);
        result = this.lvToLUN(req, LV_COMPOUND_TO_LUN, "l2", result, map);
        return result;
    }

    private StringBuffer computerToDiskSQL(String sqlText, GuiReportReq req, StringBuffer buf) {
        if (buf == null) {
            buf = new StringBuffer(1000);
        } else {
            buf.append(" UNION ");
        }
        buf.append(sqlText);
        String qualifiedColumn = null;
        qualifiedColumn = req.reportSubtype == 76 ? "sd.disk_id" : "c.computer_id";
        SQLUtil.appendInClause(buf, qualifiedColumn, req.selectedResources, req.isResourceInList, true);
        return buf;
    }

    private RespEndToEnd computerToDisk(GuiReportReq req) throws GeneralException {
        StringBuffer buf = this.computerToDiskSQL(COMPUTER_TO_DISK_SS, req, null);
        buf = this.computerToDiskSQL(COMPUTER_TO_DISK_SVC, req, buf);
        buf.append(" order by 1, 2");
        String sqlText = buf.toString();
        buf = null;
        RespEndToEnd head = null;
        RespEndToEnd structure = null;
        int lastComputerID = -1;
        int lastDiskID = -1;
        this.setSQLText(sqlText);
        try {
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(sqlText);
            while (this.nextResult()) {
                this.getPhase();
                int computerID = this.getInt(this.resultSet);
                int diskID = this.getInt(this.resultSet);
                String computerName = this.getString(this.resultSet);
                long chunkSize = this.getLong(this.resultSet);
                if (computerID != lastComputerID || diskID != lastDiskID) {
                    lastComputerID = computerID;
                    lastDiskID = diskID;
                    if (structure != null) {
                        structure.reeNext = head;
                        head = structure;
                    }
                    structure = new RespEndToEnd();
                    structure.reeComputer = computerName;
                    structure.reeOSType = this.getShort(this.resultSet);
                    structure.reeDiskArray = this.getString(this.resultSet);
                    structure.reeDiskArrayName = this.getString(this.resultSet);
                    structure.reeManufacturer = this.getString(this.resultSet);
                    structure.reeArraySidePath = this.getString(this.resultSet);
                    structure.reeModel = this.getString(this.resultSet);
                    structure.reeSerialNumber = this.getString(this.resultSet);
                    long chunkOffset = this.getLong(this.resultSet);
                    structure.reeUniqueID = this.getString(this.resultSet);
                }
                structure.reePhysicalAlloc += chunkSize;
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        this.closeStaticStmt();
        if (structure != null) {
            structure.reeNext = head;
            head = structure;
        }
        return head;
    }

    private RespEndToEnd computerToLUN(GuiReportReq req) throws GeneralException {
        StringBuffer buf = new StringBuffer(1000);
        buf.append(COMPUTER_TO_LUN);
        RespEndToEnd head = null;
        String qualifiedColumn = req.reportSubtype == 75 ? "share.resource_id" : "comp2lun.computer_id";
        SQLUtil.appendInClause(buf, qualifiedColumn, req.selectedResources, req.isResourceInList, true);
        buf.append(" order by 1, 2");
        String sqlText = buf.toString();
        buf = null;
        int lastComputerID = -1;
        String lastDiskID = "-1";
        this.setSQLText(sqlText);
        try {
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(sqlText);
            while (this.nextResult()) {
                this.getPhase();
                int computerID = this.getInt(this.resultSet);
                String diskID = this.getString(this.resultSet);
                if (computerID == lastComputerID && diskID.compareTo(lastDiskID) == 0) continue;
                lastComputerID = computerID;
                lastDiskID = diskID;
                RespEndToEnd structure = new RespEndToEnd();
                structure.reeComputer = this.getString(this.resultSet);
                structure.reeCompLUNPath = this.getString(this.resultSet);
                structure.reeOSType = this.getShort(this.resultSet);
                structure.reeDiskArray = this.getString(this.resultSet);
                structure.reeDiskArrayName = this.getString(this.resultSet);
                structure.reeManufacturer = this.getString(this.resultSet);
                String name = this.getString(this.resultSet);
                if (SQLUtil.isNullString(name)) {
                    structure.reeArraySidePath = this.getString(this.resultSet);
                    structure.reeLUNWWN = null;
                } else {
                    structure.reeArraySidePath = name;
                    structure.reeLUNWWN = this.getString(this.resultSet);
                }
                if (structure.reeOSType == 14) {
                    structure.reeLUNWWN = null;
                }
                structure.reeCapacity = this.getLong(this.resultSet);
                structure.reeFreeSpace = this.getLong(this.resultSet);
                structure.reeUniqueID = this.getString(this.resultSet);
                String displayName = this.getString(this.resultSet);
                String deviceId = this.getString(this.resultSet);
                if (structure.reeOSType == 25 || structure.reeOSType == 27 || structure.reeOSType == 21) {
                    if (SQLUtil.isNullString(displayName)) {
                        structure.reeArraySidePath = deviceId;
                        structure.reeLUNWWN = null;
                    } else {
                        structure.reeArraySidePath = displayName;
                        structure.reeLUNWWN = structure.reeOSType == 21 ? GuiUtil.getString((String)"STG0019T") : deviceId;
                    }
                }
                if (structure.reeFreeSpace > structure.reeCapacity) {
                    structure.reeFreeSpace = structure.reeCapacity;
                }
                structure.reeNext = head;
                head = structure;
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        this.closeStaticStmt();
        return head;
    }

    private StringBuffer computerToDiskArraySQL(String sqlText, GuiReportReq req, StringBuffer buf) {
        if (buf == null) {
            buf = new StringBuffer(1000);
        } else {
            buf.append(" UNION ");
        }
        buf.append(sqlText);
        String qualifiedColumn = null;
        qualifiedColumn = req.reportSubtype == 74 ? "ss.subsystem_id" : "c.computer_id";
        SQLUtil.appendInClause(buf, qualifiedColumn, req.selectedResources, req.isResourceInList, true);
        return buf;
    }

    private RespEndToEnd computerToDiskArray(GuiReportReq req) throws GeneralException {
        StringBuffer buf = this.computerToDiskArraySQL(COMPUTER_TO_DISK_ARRAY_SS, req, null);
        buf = this.computerToDiskArraySQL(COMPUTER_TO_DISK_ARRAY_SVC, req, buf);
        buf.append(" order by 1, 2, 3");
        String sqlString = buf.toString();
        buf = null;
        RespEndToEnd head = null;
        int lastComputerID = -1;
        int lastArrayID = -1;
        String lastLdID = "-1";
        RespEndToEnd structure = null;
        this.setSQLText(sqlString);
        try {
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(sqlString);
            while (this.nextResult()) {
                this.getPhase();
                int computerID = this.getInt(this.resultSet);
                int arrayID = this.getInt(this.resultSet);
                String ldID = this.getString(this.resultSet);
                long chunkSize = this.getLong(this.resultSet);
                long capacity = this.getLong(this.resultSet);
                long freespace = this.getLong(this.resultSet);
                if (computerID != lastComputerID || arrayID != lastArrayID) {
                    lastComputerID = computerID;
                    lastArrayID = arrayID;
                    lastLdID = "-1";
                    if (structure != null) {
                        structure.reeNext = head;
                        head = structure;
                    }
                    structure = new RespEndToEnd();
                    structure.reeComputer = this.getString(this.resultSet);
                    structure.reeOSType = this.getShort(this.resultSet);
                    structure.reeDiskArray = this.getString(this.resultSet);
                    structure.reeDiskArrayName = this.getString(this.resultSet);
                } else {
                    String tempStr = this.getString(this.resultSet);
                    short st = this.getShort(this.resultSet);
                    tempStr = this.getString(this.resultSet);
                    tempStr = this.getString(this.resultSet);
                }
                int chunkId = this.getInt(this.resultSet);
                if (ldID.compareTo(lastLdID) != 0) {
                    lastLdID = ldID;
                    structure.reeCapacity += capacity;
                    structure.reeFreeSpace += freespace;
                }
                structure.reePhysicalAlloc += chunkSize;
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        this.closeStaticStmt();
        if (structure != null) {
            structure.reeNext = head;
            head = structure;
        }
        return head;
    }

    public Serializable getReportData(GuiReportReq req) throws GeneralException {
        RespEndToEnd unfiltered;
        int minorSubtype;
        int majorSubtype;
        if (req.reportSubtype == 12 || req.reportSubtype == 73) {
            majorSubtype = req.reportSubtype;
            minorSubtype = req.bySubtype;
        } else {
            majorSubtype = req.bySubtype;
            minorSubtype = req.reportSubtype;
        }
        if (majorSubtype == 73) {
            switch (minorSubtype) {
                case 76: {
                    unfiltered = this.lvToDisk(req);
                    break;
                }
                case 75: {
                    unfiltered = this.lvToLUN(req);
                    break;
                }
                default: {
                    unfiltered = this.lvToDiskArray(req);
                    break;
                }
            }
        } else {
            switch (minorSubtype) {
                case 76: {
                    unfiltered = this.computerToDisk(req);
                    break;
                }
                case 75: {
                    unfiltered = this.computerToLUN(req);
                    break;
                }
                default: {
                    unfiltered = this.computerToDiskArray(req);
                }
            }
        }
        RespEndToEnd unpacked = unfiltered;
        if (unfiltered != null && req.columnFilters != null) {
            unpacked = null;
            ReportFilter filter = new ReportFilter(req, unfiltered);
            RespEndToEnd node = unfiltered;
            while (unfiltered != null) {
                node = unfiltered;
                unfiltered = node.reeNext;
                RespEndToEnd clone = (RespEndToEnd)node.clone();
                if (!filter.isSelected(clone)) continue;
                node.reeNext = unpacked;
                unpacked = node;
            }
        }
        return (Serializable)Packer.pack((Packable)unpacked);
    }
}

