/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.Group2ResSqlUtil;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptFsHist;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptFilesystemSpc
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private StringBuffer buf = new StringBuffer(2000);
    private GuiReportReq grr;
    private static final String NETWORK = MessageLog.getMessageNoID((String)"STG5048L");
    private static final String FS_SELECT = "select f.computer_id, f.filesystem_id, f.mount_point, f.used_inodes, f.free_inodes, f.used_space, f.free_space, f.capacity, f.file_count, f.directory_count";
    private static final String FS_VOLGRP_SELECT = "select v.name, l.capacity, l.overhead  from t_res_filesystem f,  t_res_logical_disk l, t_res_volgroup v where f.logical_disk_id = l.logical_disk_id  and l.volgroup_id = v.volgroup_id  and f.filesystem_id = ";
    private static final String FROM_FS = " from t_res_filesystem f";
    private static final String GROUP_LIST = " g.group_id, g.creator, g.name";
    private static final String SELECT_SUM = ", sum(f.used_inodes), sum(f.free_inodes), sum(f.used_space), sum(f.free_space), sum(f.capacity), sum(f.file_count), sum(f.directory_count)";
    private static final String FS_GROUP_FROM = " from t_res_filesystem f, t_group g, ";
    private static final String FS_GROUP_WHERE = " where f.filesystem_id = gr.resource_id and gr.group_id = g.group_id";
    private static final String COMPUTER_GROUP_FROM = " from t_res_filesystem f, t_group g, t_view_group2res gr ";
    private static final String COMPUTER_GROUP_WHERE = " where f.computer_id = gr.resource_id and gr.group_id = g.group_id";
    private static final String COMPUTER_LIST = " f.computer_id, ' ', '2'";
    private static final String DOMAIN_LIST = " d.domain_id, ' ', d.name";
    private static final String DOMAIN_FROM = " from t_res_filesystem f, t_stat_computer c, t_res_domain d where f.computer_id = c.computer_id and c.domain_id = d.domain_id";
    private static final String GROUP_BY_DOMAIN = " group by d.domain_id, d.name";
    private static final String NETWORK_LIST = " -3, '1', '2'";

    public RptFilesystemSpc(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptFilesystemSpc.class.getName(), (String)"RptFilesystemSpc", (String)"dbc");
        }
        this.tableName = "t_res_filesystem";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptFilesystemSpc.class.getName(), (String)"RptFilesystemSpc");
        }
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptFilesystemSpc.class.getName(), (String)"getReportData", (String)"grr");
        }
        this.grr = grr;
        if (grr.reportSubtype == 28) {
            grr.productCode = 1;
            RptFsHist histRtn = new RptFsHist(this.dbc);
            Serializable traceResult = histRtn.getReportData(grr);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptFilesystemSpc.class.getName(), (String)"getReportData", (Object)traceResult);
            }
            return traceResult;
        }
        RespFSspace head = new RespFSspace();
        RespFSspace curr = new RespFSspace();
        int totalRows = 0;
        boolean rowSelected = true;
        ReportFilter filter = null;
        if (grr.columnFilters != null) {
            filter = new ReportFilter(grr, curr);
        }
        try {
            switch (grr.reportSubtype) {
                case 10: {
                    this.buf.append(FS_SELECT);
                    this.buf.append(FROM_FS);
                    if (grr.idSubtype == 11) {
                        this.buf.append(", t_view_group2res gr ");
                    }
                    if (grr.selectedResources == null && grr.idSubtype != 11) break;
                    this.buf.append(" where");
                    TResFS.appendInClause(this.buf, "f.filesystem_id", "gr.group_id", grr, false);
                    if (grr.idSubtype != 11) break;
                    this.buf.append(" and f.filesystem_id = gr.resource_id");
                    break;
                }
                case 11: {
                    this.buf.append("select distinct");
                    this.buf.append(GROUP_LIST);
                    this.buf.append(SELECT_SUM);
                    this.buf.append(FS_GROUP_FROM);
                    this.buf.append(" t_view_group2res gr ");
                    this.buf.append(FS_GROUP_WHERE);
                    Group2ResSqlUtil.appendG2RWhere(this.buf, grr.selectedResources, grr.isResourceInList, true, grr.reportSubtype, "gr");
                    this.buf.append(" group by");
                    this.buf.append(GROUP_LIST);
                    break;
                }
                case 12: {
                    this.buf.append("select");
                    this.buf.append(COMPUTER_LIST);
                    this.buf.append(SELECT_SUM);
                    this.buf.append(FROM_FS);
                    if (grr.selectedResources != null) {
                        this.buf.append(" where");
                        SQLUtil.appendInClause(this.buf, "f.computer_id", grr.selectedResources, grr.isResourceInList, false);
                    }
                    this.buf.append(" group by f.computer_id");
                    break;
                }
                case 13: 
                case 82: {
                    this.buf.append("select distinct");
                    this.buf.append(GROUP_LIST);
                    this.buf.append(SELECT_SUM);
                    this.buf.append(COMPUTER_GROUP_FROM);
                    this.buf.append(COMPUTER_GROUP_WHERE);
                    if (grr.reportSubtype == 13) {
                        this.buf.append(" and g.group_type <> 99");
                    } else {
                        this.buf.append(" and g.group_type = 99");
                    }
                    Group2ResSqlUtil.appendG2RWhere(this.buf, grr.selectedResources, grr.isResourceInList, true, grr.reportSubtype, "gr");
                    this.buf.append(" group by");
                    this.buf.append(GROUP_LIST);
                    break;
                }
                case 14: {
                    this.buf.append("select");
                    this.buf.append(DOMAIN_LIST);
                    this.buf.append(SELECT_SUM);
                    this.buf.append(DOMAIN_FROM);
                    SQLUtil.appendInClause(this.buf, "d.domain_id", grr.selectedResources, grr.isResourceInList, true);
                    this.buf.append(GROUP_BY_DOMAIN);
                    break;
                }
                case 15: {
                    this.buf.append("select");
                    this.buf.append(NETWORK_LIST);
                    this.buf.append(SELECT_SUM);
                    this.buf.append(FROM_FS);
                    break;
                }
                default: {
                    Object[] args = new Object[]{new Integer(grr.reportType), new Integer(grr.reportSubtype)};
                    String errmsg = MessageLog.getMessage((String)"GEN0125E", (Object[])args);
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)RptFilesystemSpc.class.getName(), (String)"getReportData");
                    }
                    throw new GeneralException(errmsg);
                }
            }
            this.selectStmt = this.prepareStmt(this.buf.toString());
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            RespFSspace last = head;
            while (this.nextResult()) {
                this.colIndex = 1;
                if (curr == null) {
                    curr = new RespFSspace();
                }
                curr.id = this.getInt(this.resultSet);
                if (grr.reportSubtype == 10) {
                    curr.fs_id = this.getInt(this.resultSet);
                    curr.creator = " ";
                } else {
                    curr.creator = this.getString(this.resultSet);
                }
                curr.setName(this.getString(this.resultSet));
                curr.usedInodes = this.getLong(this.resultSet);
                curr.freeInodes = this.getLong(this.resultSet);
                curr.usedSpace = this.getLong(this.resultSet);
                curr.freeSpace = this.getLong(this.resultSet);
                curr.capacity = this.getLong(this.resultSet);
                curr.fileCount = this.getLong(this.resultSet);
                curr.directoryCount = this.getLong(this.resultSet);
                if (grr.reportSubtype == 10) {
                    this.getVolGroup(curr);
                }
                if (filter != null) {
                    RespFSspace clone = (RespFSspace)curr.clone();
                    this.getComputerNames(clone);
                    rowSelected = filter.isSelected(clone);
                }
                if (!rowSelected) continue;
                last.next = curr;
                last = curr;
                curr = null;
                ++totalRows;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptFilesystemSpc.class.getName(), (String)"getReportData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (grr.isBatchReport) {
            this.getComputerNames(head.next);
        }
        RespFSspace[] traceResult = RptFilesystemSpc.packItUp(head.next, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptFilesystemSpc.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }

    private void getVolGroup(RespFSspace node) throws GeneralException {
        StringBuffer volbuf = new StringBuffer(FS_VOLGRP_SELECT.length() + 25);
        node.serialNumber = new String(MessageLog.getMessageNoID((String)"GEN0185T"));
        try {
            volbuf.append(FS_VOLGRP_SELECT);
            volbuf.append(node.fs_id);
            this.updateStmt = this.prepareStmt(volbuf.toString());
            this.stmtPhase = 3;
            ResultSet resultSet2 = this.updateStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult(resultSet2)) {
                long capacity = 0L;
                long overhead = 0L;
                this.colIndex = 1;
                node.serialNumber = this.getString(resultSet2);
                capacity = this.getLong(resultSet2);
                overhead = this.getLong(resultSet2);
                node.unknown = capacity + overhead;
            }
            this.closeUpdate();
        }
        catch (SQLException e) {
            this.stmtType = 2;
            this.sqlError(e);
        }
    }

    private void getComputerNames(RespFSspace node) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptFilesystemSpc.class.getName(), (String)"getComputerNames", (String)"node");
        }
        AgentManager agentManager = Server.getAgentManager();
        while (node != null) {
            switch (this.grr.reportSubtype) {
                case 10: {
                    node.creator = agentManager.getAgentName(node.id);
                    break;
                }
                case 12: {
                    node.setName(agentManager.getAgentName(node.id));
                }
                case 14: {
                    node.creator = " ";
                    break;
                }
                case 15: {
                    node.setName(NETWORK);
                    node.creator = " ";
                }
            }
            node = node.next;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptFilesystemSpc.class.getName(), (String)"getComputerNames");
        }
    }

    public static RespFSspace[] packItUp(RespFSspace head, int totalRows) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptFilesystemSpc.class.getName(), (String)"packItUp", (String)"head, totalRows");
        }
        RespFSspace[] result = new RespFSspace[totalRows];
        totalRows = 0;
        while (head != null) {
            RespFSspace next = head.next;
            head.next = null;
            result[totalRows] = head;
            ++totalRows;
            head = next;
        }
        RespFSspace[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptFilesystemSpc.class.getName(), (String)"packItUp", (Object)traceResult);
        }
        return traceResult;
    }
}

