/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report.filter;

import java.lang.reflect.Array;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.report.filter.BetweenEvaluator;
import org.eclipse.aperi.repository.report.filter.EqEvaluator;
import org.eclipse.aperi.repository.report.filter.FilterEvaluator;
import org.eclipse.aperi.repository.report.filter.GtEvaluator;
import org.eclipse.aperi.repository.report.filter.LtEvaluator;
import org.eclipse.aperi.repository.report.filter.StringEvaluator;

public class ReportFilter {
    private GuiReportReq grr;
    private CustomReportDataAdjuster adjuster;
    private ColumnFilter filterList;
    private FilterEvaluator evaluatorList;
    private Object[] dataArray;
    private int frozenRows;
    private boolean breakCondition;

    public ReportFilter(GuiReportReq grr, Object dataRecord) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ReportFilter.class.getName(), (String)"ReportFilter", (String)"grr, dataRecord");
        }
        this.grr = grr;
        this.filterList = ColumnFilter.unpack((ColumnFilter[])grr.columnFilters);
        this.breakCondition = grr.orFilters;
        this.dataArray = (Object[])Array.newInstance(dataRecord.getClass(), 1);
        this.dataArray[0] = dataRecord;
        String className = "";
        this.adjuster = ReportDataAdjuster.makeCustomAdjuster((GuiReportReq)grr);
        this.adjuster.adjustInit(this.dataArray, true);
        this.frozenRows = this.adjuster.getNumberFrozenRows();
        ColumnFilter filter = this.filterList;
        while (filter != null) {
            this.convertValueIDs(filter);
            FilterEvaluator evaluator = this.makeEvaluator(filter, this.adjuster);
            if (evaluator != null) {
                evaluator.nextEvaluator = this.evaluatorList;
                this.evaluatorList = evaluator;
            }
            filter = filter.clfNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ReportFilter.class.getName(), (String)"ReportFilter");
        }
    }

    private void convertValueIDs(ColumnFilter filter) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ReportFilter.class.getName(), (String)"convertValueIDs", (String)"filter");
        }
        ColumnFilterValue value = filter.clfValueList;
        while (value != null) {
            if (value.fvValueID >= 0) {
                value.fvValue = ColumnDescriptor.getValue((int)value.fvValueID, (int)filter.clfColumnID, (int)this.grr.reportType);
            }
            value = value.fvNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ReportFilter.class.getName(), (String)"convertValueIDs");
        }
    }

    private FilterEvaluator makeEvaluator(ColumnFilter filter, CustomReportDataAdjuster adjuster) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ReportFilter.class.getName(), (String)"makeEvaluator", (String)"filter, adjuster");
        }
        if (filter.clfCondition == 13 || filter.clfCondition == 14) {
            this.convertNullFilter(filter);
            FilterEvaluator traceResult = ReportFilter.makeDefaultEvaluator(this.grr, filter, adjuster);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ReportFilter.class.getName(), (String)"makeEvaluator", (Object)traceResult);
            }
            return traceResult;
        }
        switch (filter.clfDataType) {
            case 1: {
                FilterEvaluator traceResult = StringEvaluator.makeEvaluator(this.grr, filter, adjuster);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ReportFilter.class.getName(), (String)"makeEvaluator", (Object)traceResult);
                }
                return traceResult;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                FilterEvaluator traceResult = ReportFilter.makeDefaultEvaluator(this.grr, filter, adjuster);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ReportFilter.class.getName(), (String)"makeEvaluator", (Object)traceResult);
                }
                return traceResult;
            }
            case 6: {
                this.convertOffsetFilter(filter);
                FilterEvaluator traceResult = ReportFilter.makeDefaultEvaluator(this.grr, filter, adjuster);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ReportFilter.class.getName(), (String)"makeEvaluator", (Object)traceResult);
                }
                return traceResult;
            }
        }
        Object[] args = new Object[]{Integer.toString(this.grr.reportType), Integer.toString(filter.clfColumnID), Integer.toString(filter.clfDataType)};
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ReportFilter.class.getName(), (String)"makeEvaluator");
        }
        throw new GeneralException("STS0307E", args);
    }

    private void convertNullFilter(ColumnFilter filter) throws GeneralException {
        ColumnFilterValue value;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ReportFilter.class.getName(), (String)"convertNullFilter", (String)"filter");
        }
        filter.clfValueList = value = new ColumnFilterValue();
        switch (filter.clfDataType) {
            case 2: 
            case 4: 
            case 5: {
                filter.clfCondition = filter.clfCondition == 13 ? (short)4 : (short)5;
                value.fvValue = new MutableLong(0L);
                break;
            }
            case 3: {
                filter.clfCondition = filter.clfCondition == 13 ? (short)3 : (short)6;
                value.fvValue = Constants.NULL_DATE_DATE;
                break;
            }
            default: {
                filter.clfCondition = filter.clfCondition == 13 ? (short)1 : (short)2;
                value.fvValue = "";
                value.fvNext = new ColumnFilterValue();
                value.fvNext.fvValue = " ";
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ReportFilter.class.getName(), (String)"convertNullFilter");
        }
    }

    public static FilterEvaluator makeDefaultEvaluator(GuiReportReq grr, ColumnFilter filter, CustomReportDataAdjuster adjuster) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ReportFilter.class.getName(), (String)"makeDefaultEvaluator", (String)"grr, filter, adjuster");
        }
        switch (filter.clfCondition) {
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                EqEvaluator traceResult = new EqEvaluator(filter, adjuster);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ReportFilter.class.getName(), (String)"makeDefaultEvaluator", (Object)traceResult);
                }
                return traceResult;
            }
            case 4: 
            case 5: {
                LtEvaluator traceResult = new LtEvaluator(filter, adjuster);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ReportFilter.class.getName(), (String)"makeDefaultEvaluator", (Object)traceResult);
                }
                return traceResult;
            }
            case 3: 
            case 6: {
                GtEvaluator traceResult = new GtEvaluator(filter, adjuster);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ReportFilter.class.getName(), (String)"makeDefaultEvaluator", (Object)traceResult);
                }
                return traceResult;
            }
            case 11: 
            case 12: {
                BetweenEvaluator traceResult = new BetweenEvaluator(filter, adjuster);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ReportFilter.class.getName(), (String)"makeDefaultEvaluator", (Object)traceResult);
                }
                return traceResult;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ReportFilter.class.getName(), (String)"makeDefaultEvaluator");
        }
        throw ReportFilter.badFilterCondition(grr, filter);
    }

    private void convertOffsetFilter(ColumnFilter filter) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ReportFilter.class.getName(), (String)"convertOffsetFilter", (String)"filter");
        }
        switch (filter.clfCondition) {
            case 4: {
                filter.clfCondition = (short)6;
                break;
            }
            case 5: {
                filter.clfCondition = (short)3;
                break;
            }
            case 6: {
                filter.clfCondition = (short)4;
                break;
            }
            case 3: {
                filter.clfCondition = (short)5;
                break;
            }
            case 11: 
            case 12: {
                ColumnFilterValue first = filter.clfValueList;
                ColumnFilterValue last = first.fvNext;
                last.fvNext = first;
                first.fvNext = null;
                filter.clfValueList = last;
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ReportFilter.class.getName(), (String)"convertOffsetFilter");
                }
                throw ReportFilter.badFilterCondition(this.grr, filter);
            }
        }
        long currentTime = System.currentTimeMillis();
        ColumnFilterValue value = filter.clfValueList;
        while (value != null) {
            MutableLong offset = (MutableLong)value.fvValue;
            value.fvValue = new Date(currentTime - offset.value);
            value = value.fvNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ReportFilter.class.getName(), (String)"convertOffsetFilter");
        }
    }

    public static GeneralException badFilterCondition(GuiReportReq grr, ColumnFilter filter) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ReportFilter.class.getName(), (String)"badFilterCondition", (String)"grr, filter");
        }
        Object[] args = new Object[]{Integer.toString(grr.reportType), Integer.toString(filter.clfColumnID), Integer.toString(filter.clfCondition)};
        GeneralException traceResult = new GeneralException("STS0308E", args);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ReportFilter.class.getName(), (String)"badFilterCondition", (Object)((Object)traceResult));
        }
        return traceResult;
    }

    public boolean isSelected(Object dataRecord) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ReportFilter.class.getName(), (String)"isSelected", (String)"dataRecord");
        }
        this.dataArray[0] = dataRecord;
        this.adjuster.adjustData();
        boolean selected = true;
        FilterEvaluator evaluator = this.evaluatorList;
        while (evaluator != null && (selected = evaluator.isSelected(this.frozenRows)) != this.breakCondition) {
            evaluator = evaluator.nextEvaluator;
        }
        if (selected) {
            this.adjuster.undo();
        }
        boolean traceResult = selected;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ReportFilter.class.getName(), (String)"isSelected", (boolean)traceResult);
        }
        return traceResult;
    }
}

