/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.aperi.agent.req.AgentStatusReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.dbaccess.HostAgentPingDbAccess;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.ConfigParser;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.UninstallAgentDriver;
import org.eclipse.aperi.server.handler.server.GuiToAgentHndlr;
import org.eclipse.aperi.server.req.GuiToAgentReq;
import org.eclipse.aperi.xmsg.MessageLog;

public class TAgent {
    public int serverID = Server.getServerID();
    public int port;
    public byte state = 1;
    public long timestamp;
    public TComputer computer;
    public byte modification;
    public byte[] productState;
    public byte[] productVersions;
    public int featureSet;
    public static final int PRODUCT_ENTRY_LENGTH = 3;
    private static final byte[] DUMMY_PRODUCT_STATES = new byte[]{0};
    private static final String INSERT_SQL = "insert into t_res_agent (server_id, port_number, state, time_stamp, computer_id, processor_type, processor_number, modification, product_states, product_versions, feature_set) values (?,?,?,?,?,'0',0,?,?,?,?)";
    private static final String UPDATE_CLAUSE = "update t_res_agent set server_id = ?, port_number = ?, state = ?, time_stamp = ?";
    private static final String UPDATE_VERSIONS = ", product_versions = ?";
    private static final String UPDATE_FEATURE_SET = ", feature_set = ?";
    private static final String UPDATE_WHERE = " where computer_id = ?";
    private static final String SELECT_SQL = "select a.port_number, a.state, a.time_stamp, a.computer_id, c.host_name, c.vendor_id, c.hardware_id, c.host_url, c.os_type, c.cpu_architecture, c.network_name, c.domain_name, c.ip_address, c.time_zone, a.modification, c.product_states, a.product_versions, a.feature_set from t_res_agent a, t_res_host c where a.computer_id = c.computer_id and a.server_id = ?";
    private static final String SELECT_BY_HOST = " and (c.host_name = ? or c.vendor_id = ? and c.hardware_id = ?)";

    public TAgent(String tsName, int port, long timestamp, HardwareID hwID, String netName, String ipAddress, String timezoneID, byte[] productState, SoftwareVersion[] installedProducts, int featureSet, String guid) {
        this.port = port;
        this.timestamp = timestamp;
        this.productState = productState;
        this.productVersions = TAgent.getVersionArray(installedProducts);
        this.featureSet = featureSet;
        this.computer = new TComputer(tsName, hwID, netName, ipAddress, timezoneID, productState, guid);
    }

    public TAgent() {
        this.computer = new TComputer();
    }

    public static byte[] getVersionArray(SoftwareVersion[] installedProducts) {
        byte[] productVersions = new byte[installedProducts.length * 3];
        for (int i = 0; i < installedProducts.length; ++i) {
            SoftwareVersion product = installedProducts[i];
            if (product == null) continue;
            int j = i * 3;
            productVersions[j] = product.svVersion;
            productVersions[j + 1] = product.svRelease;
            productVersions[j + 2] = (byte)product.svModification;
        }
        return productVersions;
    }

    public boolean registerAgent(TAgent repoAgent, String newAgtLogDir) {
        int status;
        Connection dbConnection = Server.getConnection();
        if (dbConnection == null) {
            return false;
        }
        if (repoAgent == null) {
            status = this.addAgentRegistry(dbConnection);
        } else {
            this.computer.computerID = repoAgent.computer.computerID;
            if (newAgtLogDir != null && repoAgent.productVersions[0] == 1 && this.productVersions[0] >= 2) {
                this.updateAgentLogLocations(newAgtLogDir, dbConnection);
            }
            status = this.updateAgentRegistry(repoAgent, dbConnection);
        }
        Server.returnConnection(dbConnection);
        if (status == 0) {
            HostAgentPingDbAccess.updateHostStatus((int)this.computer.computerID, (int)1);
        }
        return status != 16;
    }

    private int addAgentRegistry(Connection dbConnection) {
        if (this.computer.addComputer(dbConnection) != 0) {
            return 16;
        }
        PreparedStatement insert = null;
        try {
            insert = dbConnection.prepareStatement(INSERT_SQL);
            insert.setInt(1, this.serverID);
            insert.setInt(2, this.port);
            SQLUtil.setByte(insert, 3, this.state);
            insert.setTimestamp(4, new Timestamp(this.timestamp));
            insert.setInt(5, this.computer.computerID);
            SQLUtil.setByte(insert, 6, (byte)0);
            SQLUtil.setBytes(insert, 7, DUMMY_PRODUCT_STATES);
            SQLUtil.setBytes(insert, 8, this.productVersions);
            insert.setBytes(9, TAgent.intToBytes(this.featureSet));
            insert.executeUpdate();
            dbConnection.commit();
            insert.close();
        }
        catch (SQLException e) {
            SQLUtil.errorCleanup(dbConnection, insert);
            SQLUtil.logSQLException("SRV0061E", e, null);
            return 16;
        }
        return 0;
    }

    private int updateAgentRegistry(TAgent repoAgent, Connection dbConnection) {
        if (!this.computer.equalsRepositoryComputer(repoAgent.computer) && this.computer.updateComputer(repoAgent.computer, dbConnection) != 0) {
            return 16;
        }
        MutableInteger pFeatureSet = new MutableInteger(this.featureSet);
        return TAgent.updateAgent(this.computer.computerID, this.serverID, this.port, this.state, this.timestamp, this.productState, this.productVersions, pFeatureSet, dbConnection);
    }

    private int updateAgentLogLocations(String newAgtLogDir, Connection dbConnection) {
        String updateSQL = "update t_run_jobs set log_file_name = ? where log_file_name = ?";
        PreparedStatement pStmt = null;
        int index = -1;
        String oldFileLoc = null;
        StringBuffer oldFileBuf = new StringBuffer();
        StringBuffer newFileBuf = new StringBuffer();
        int logDirLen = newAgtLogDir.length();
        try {
            Vector logFiles = this.getAgentLogLocations(dbConnection);
            newFileBuf.append(newAgtLogDir);
            for (int i = 0; i < logFiles.size(); ++i) {
                oldFileLoc = (String)logFiles.get(i);
                oldFileBuf.setLength(0);
                oldFileBuf.append(oldFileLoc);
                index = oldFileLoc.lastIndexOf("\\");
                if (index <= -1 && (index = oldFileLoc.lastIndexOf("//")) <= -1 && (index = oldFileLoc.lastIndexOf("/")) <= -1) continue;
                newFileBuf.setLength(logDirLen);
                newFileBuf.append(oldFileLoc.substring(index));
                pStmt = dbConnection.prepareStatement(updateSQL);
                pStmt.setString(1, newFileBuf.toString());
                pStmt.setString(2, oldFileBuf.toString());
                int count = pStmt.executeUpdate();
                dbConnection.commit();
                pStmt.close();
            }
        }
        catch (SQLException e) {
            String s = oldFileBuf.toString() + " Statement: " + updateSQL;
            Object[] args = new Object[]{s};
            SQLUtil.errorCleanup(dbConnection, pStmt);
            SQLUtil.logSQLException("SRV0084E", e, args);
            return 16;
        }
        return 0;
    }

    private Vector getAgentLogLocations(Connection dbConnection) {
        String machineName = this.computer.tsName;
        String selectSQL = "select log_file_name from t_run_jobs where computer_id = ?";
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        Vector<String> logFiles = new Vector<String>();
        try {
            pStmt = dbConnection.prepareStatement(selectSQL);
            pStmt.setInt(1, this.computer.computerID);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                logFiles.add(rs.getString(1));
            }
            pStmt.close();
            rs.close();
        }
        catch (SQLException e) {
            String s = "the log files of computer " + this.computer.computerID + "Statement: " + selectSQL;
            Object[] args = new Object[]{s};
            SQLUtil.errorCleanup(dbConnection, pStmt);
            SQLUtil.logSQLException("SRV0082E", e, args);
        }
        return logFiles;
    }

    public static Iterator getManagedAgents(TAgent buffer, Connection dbConnection) {
        SqlQuery query = null;
        try {
            query = TAgent.queryPrepare(buffer.serverID, null, null, dbConnection);
        }
        catch (SQLException e) {
            return null;
        }
        return new AgentIterator(buffer, query);
    }

    public static TAgent getAgent(int serverID, TComputer agentComputer, Connection dbConnection) throws SQLException {
        TAgent dup;
        String tsName = agentComputer.tsName;
        HardwareID hwID = agentComputer.hwID;
        SqlQuery query = TAgent.queryPrepare(serverID, tsName, hwID, dbConnection);
        TAgent agent = new TAgent();
        if ((agent = TAgent.queryFetch(query, agent)) != null && TAgent.queryFetch(query, dup = new TAgent()) != null) {
            TAgent tempAgent = null;
            TAgent tempAgent2 = null;
            if (agentComputer.ipAddress.compareToIgnoreCase(agent.computer.ipAddress) == 0) {
                tempAgent = dup;
                tempAgent2 = agent;
            } else if (agentComputer.ipAddress.compareToIgnoreCase(dup.computer.ipAddress) == 0) {
                tempAgent = agent;
                tempAgent2 = dup;
            }
            if (tempAgent != null) {
                TAgent.contactAgent(tempAgent.computer.computerID);
                AgentManager am = Server.getAgentManager();
                AgentManager.AgentAddress agentAddr = am.getAgent(tempAgent.computer.computerID);
                if (agentAddr.state == 0 || agentAddr.state == 1 && agentAddr.consecutiveErrors > 0) {
                    String dupCompInfo = TAgent.getDupCompInfoOption();
                    if (dupCompInfo.compareToIgnoreCase("delete") == 0) {
                        byte byteValue = 0;
                        UninstallAgentDriver driver = new UninstallAgentDriver(tempAgent2.computer.computerID, byteValue);
                        driver.start();
                    } else if (dupCompInfo.compareToIgnoreCase("keep") == 0) {
                        byte state = 0;
                        String newName = "DECOMM-" + tempAgent2.computer.tsName;
                        String newNWName = "DECOMM-" + tempAgent2.computer.networkName;
                        TComputer.updateCompNames(tempAgent2.computer.computerID, newName, newNWName, dbConnection);
                        am.setState(tempAgent2.computer.computerID, state);
                    }
                }
            }
            StringBuffer buffer = new StringBuffer(40);
            MessageLog.logMessage((String)"GEN0181E", (Object)tsName);
            TAgent.logAgent(tsName, hwID, buffer);
            TAgent.logAgent(agent.computer.tsName, agent.computer.hwID, buffer);
            do {
                TAgent.logAgent(dup.computer.tsName, dup.computer.hwID, buffer);
            } while (TAgent.queryFetch(query, dup) != null);
        }
        query.close();
        if (agent == null && !Util.isEmpty((String)agentComputer.networkName) && !Util.isEmpty((String)agentComputer.domainName)) {
            agentComputer.updateRdbmsHost(dbConnection);
        }
        return agent;
    }

    private static void contactAgent(int computerID) {
        Request request = new Request();
        GuiToAgentReq gui2AgentReq = new GuiToAgentReq();
        gui2AgentReq.computerID = computerID;
        gui2AgentReq.requestHandler = "org.eclipse.aperi.agent.handler.status.StatusHandler";
        gui2AgentReq.agentData = new AgentStatusReq(false);
        request.flags = (byte)4;
        request.machineName = Server.getServerHostName();
        request.serviceName = RequestTypeManager.getInternalName((String)"org.eclipse.aperi.server.svp.ServerSvp");
        request.requestData = gui2AgentReq;
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.userName = "administrator";
        GuiToAgentHndlr gui2AgentHndlr = new GuiToAgentHndlr();
        Response response = gui2AgentHndlr.handle(request, null);
    }

    private static String getDupCompInfoOption() {
        String configFile = "server.config";
        String passwordFile = "configuration" + File.separator + "repository.config";
        ConfigParser parser = new ConfigParser("configuration" + File.separator + configFile, passwordFile);
        if (!parser.parse()) {
            return "";
        }
        return parser.dupCompInfo;
    }

    private static void logAgent(String tsName, HardwareID hwID, StringBuffer buffer) {
        buffer.setLength(0);
        for (int i = 0; i < hwID.hardwareID.length; ++i) {
            int hiNibble = hwID.hardwareID[i] >> 4 & 0xF;
            int lowNibble = hwID.hardwareID[i] & 0xF;
            buffer.append(Integer.toHexString(hiNibble));
            buffer.append(Integer.toHexString(lowNibble));
        }
        MessageLog.logMessage((String)"GEN0182I", (Object)tsName, (Object)hwID.manufacturer, (Object)buffer.toString());
    }

    public static int updateAgent(int computerID, int serverID, int port, byte state, long timestamp, byte[] productState, byte[] productVersions, MutableInteger featureSet, Connection dbConnection) {
        if (!TComputer.updateState(computerID, productState, dbConnection)) {
            return 16;
        }
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(UPDATE_CLAUSE);
        if (productVersions != null) {
            buffer.append(UPDATE_VERSIONS);
        }
        if (featureSet != null) {
            buffer.append(UPDATE_FEATURE_SET);
        }
        buffer.append(UPDATE_WHERE);
        PreparedStatement update = null;
        try {
            update = dbConnection.prepareStatement(buffer.toString());
            update.setInt(1, serverID);
            update.setInt(2, port);
            SQLUtil.setByte(update, 3, state);
            update.setTimestamp(4, new Timestamp(timestamp));
            int colIndex = 5;
            if (productVersions != null) {
                SQLUtil.setBytes(update, colIndex++, productVersions);
            }
            if (featureSet != null) {
                update.setBytes(colIndex++, TAgent.intToBytes(featureSet.value));
            }
            update.setInt(colIndex, computerID);
            update.executeUpdate();
            dbConnection.commit();
            update.close();
        }
        catch (SQLException e) {
            SQLUtil.errorCleanup(dbConnection, update);
            SQLUtil.logSQLException("SRV0060E", e, null);
            return 16;
        }
        return 0;
    }

    public static void deleteAgent(int computerID, Connection dbConnection) throws GeneralException {
        TComputer.updateState(computerID, null, dbConnection);
        Statement statement = null;
        try {
            statement = dbConnection.createStatement();
            statement.executeUpdate("delete from t_res_agent where computer_id = " + computerID);
            statement.executeUpdate("delete from t_res_host where computer_id = " + computerID + " and computer_id not in (select host_id from t_res_device_agent)" + " and computer_id not in (select computer_id from t_res_server)");
            dbConnection.commit();
        }
        catch (SQLException e) {
            SQLUtil.errorCleanup(dbConnection, statement);
            String errorMsg = SQLUtil.getSQLExceptionMsg("SRV0119E", e, null);
            throw new GeneralException(errorMsg);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }

    private static SqlQuery queryPrepare(int serverID, String tsName, HardwareID hwID, Connection dbConnection) throws SQLException {
        StringBuffer selectSql = new StringBuffer(400);
        selectSql.append(SELECT_SQL);
        if (tsName != null && hwID != null) {
            selectSql.append(SELECT_BY_HOST);
        }
        PreparedStatement select = null;
        ResultSet rs = null;
        try {
            select = dbConnection.prepareStatement(selectSql.toString());
            select.setInt(1, serverID);
            if (tsName != null && hwID != null) {
                select.setString(2, tsName);
                TResVendorModel vmAccessor = new TResVendorModel(dbConnection);
                short vendor = vmAccessor.getVendorID(hwID.manufacturer);
                select.setShort(3, vendor);
                SQLUtil.setBytes(select, 4, hwID.hardwareID);
            }
            rs = select.executeQuery();
        }
        catch (SQLException e) {
            SQLUtil.errorCleanup(dbConnection, select);
            SQLUtil.logSQLException("SRV0059E", e, null);
            throw e;
        }
        catch (GeneralException ignored) {
            // empty catch block
        }
        return new SqlQuery(dbConnection, select, rs);
    }

    private static TAgent queryFetch(SqlQuery query, TAgent agent) throws SQLException {
        ResultSet rs = query.resultSet;
        Connection dbc = Server.getConnection();
        try {
            if (!rs.next()) {
                query.close();
                return null;
            }
            TComputer c = agent.computer;
            agent.port = rs.getInt(1);
            agent.state = SQLUtil.getByte(rs, 2);
            agent.timestamp = rs.getTimestamp(3).getTime();
            c.computerID = rs.getInt(4);
            c.tsName = rs.getString(5);
            TResVendorModel vmAccessor = new TResVendorModel(dbc);
            c.hwID.manufacturer = vmAccessor.getVendorName(rs.getShort(6));
            c.hwID.hardwareID = SQLUtil.getBytes(rs, 7);
            c.hwID.hostName = rs.getString(8);
            c.hwID.osType = rs.getShort(9);
            c.hwID.cpuArchitecture = rs.getShort(10);
            c.networkName = rs.getString(11);
            c.domainName = rs.getString(12);
            c.ipAddress = rs.getString(13);
            c.timezoneID = rs.getString(14);
            agent.modification = SQLUtil.getByte(rs, 15);
            agent.productState = SQLUtil.getBytes(rs, 16);
            agent.productVersions = SQLUtil.getBytes(rs, 17);
            agent.featureSet = TAgent.bytesToInt(rs.getBytes(18));
        }
        catch (SQLException e) {
            SQLUtil.errorCleanup(query.dbConnection, query.stmt);
            SQLUtil.logSQLException("SRV0059E", e, null);
            throw e;
        }
        catch (GeneralException ignored) {
            // empty catch block
        }
        Server.returnConnection(dbc);
        return agent;
    }

    private static byte[] intToBytes(int x) {
        int size;
        int mask = -16777216;
        for (size = 4; size > 1 && (x & mask) == 0; --size) {
            mask >>= 8;
        }
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)x;
            x >>= 8;
        }
        return result;
    }

    private static int bytesToInt(byte[] array) {
        int result = 0;
        if (array != null) {
            int length = array.length;
            if (length > 4) {
                length = 4;
            }
            while (length > 0) {
                result <<= 8;
                int x = array[--length];
                result |= (x &= 0xFF);
            }
        }
        return result;
    }

    private static class AgentIterator
    implements Iterator {
        TAgent returnArea;
        SqlQuery query;
        TAgent fetchedRow;
        boolean SQLError;

        AgentIterator(TAgent returnArea, SqlQuery query) {
            this.returnArea = returnArea;
            this.query = query;
        }

        public boolean hasNext() {
            try {
                this.fetchedRow = TAgent.queryFetch(this.query, this.returnArea);
            }
            catch (SQLException e) {
                this.SQLError = true;
                this.fetchedRow = this.returnArea;
            }
            return this.fetchedRow != null;
        }

        public Object next() throws NoSuchElementException {
            if (this.fetchedRow == null || this.SQLError) {
                throw new NoSuchElementException();
            }
            this.fetchedRow = null;
            return this.returnArea;
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }

    private static class SqlQuery {
        Connection dbConnection;
        PreparedStatement stmt;
        ResultSet resultSet;

        SqlQuery(Connection dbConnection, PreparedStatement stmt, ResultSet resultSet) {
            this.dbConnection = dbConnection;
            this.stmt = stmt;
            this.resultSet = resultSet;
        }

        public void close() {
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                    this.dbConnection.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }
}

