/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TAggregator
extends StorageRepositoryAccessor {
    private Timestamp tsWeekly = new Timestamp(0L);
    private Timestamp tsMonthly = new Timestamp(0L);
    private long lastWeekly = -1L;
    private long lastMonthly = -1L;
    private static final String FETCH = "select last_weekly, last_monthly from t_aggregator";
    private static final String INSERT = "insert into t_aggregator (last_weekly, last_monthly) values (?,?)";
    private static final String UPDATE = "update t_aggregator set last_weekly = ?, last_monthly = ?";

    public TAggregator(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAggregator.class.getName(), (String)"TAggregator", (String)"dbc");
        }
        this.tableName = "T_AGGREGATOR";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAggregator.class.getName(), (String)"TAggregator");
        }
    }

    public long getLastWeekly() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAggregator.class.getName(), (String)"getLastWeekly", (String)"");
        }
        if (this.lastWeekly <= 0L) {
            this.fetch();
        }
        long traceResult = this.lastWeekly;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAggregator.class.getName(), (String)"getLastWeekly", (long)traceResult);
        }
        return traceResult;
    }

    public long getLastMonthly() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAggregator.class.getName(), (String)"getLastMonthly", (String)"");
        }
        if (this.lastMonthly <= 0L) {
            this.fetch();
        }
        long traceResult = this.lastMonthly;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAggregator.class.getName(), (String)"getLastMonthly", (long)traceResult);
        }
        return traceResult;
    }

    private void fetch() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAggregator.class.getName(), (String)"fetch", (String)"");
        }
        try {
            this.selectStmt = this.prepareStmt(FETCH);
            this.stmtType = 0;
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult()) {
                this.colIndex = 1;
                this.lastWeekly = this.getTimestamp(this.resultSet);
                this.lastMonthly = this.getTimestamp(this.resultSet);
            } else {
                try {
                    this.lastWeekly = SQLUtil.getTimestamp(this.dbc).getTime();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)TAggregator.class.getName(), (String)"fetch", (Throwable)e);
                    }
                    return;
                }
                this.lastMonthly = this.lastWeekly;
                this.insertStmt = this.prepareStmt(INSERT);
                this.stmtType = 1;
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.insertStmt, this.lastWeekly, this.tsWeekly);
                this.setTimestamp(this.insertStmt, this.lastMonthly, this.tsMonthly);
                this.executeUpdate(this.insertStmt);
                this.dbc.commit();
            }
            this.closeSelect();
            this.closeInsert();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAggregator.class.getName(), (String)"fetch", (Throwable)e);
            }
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAggregator.class.getName(), (String)"fetch");
        }
    }

    public void update(long lastWeekly, long lastMonthly) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAggregator.class.getName(), (String)"update", (String)"lastWeekly, lastMonthly");
        }
        try {
            this.lastWeekly = lastWeekly;
            this.lastMonthly = lastMonthly;
            this.updateStmt = this.prepareStmt(UPDATE);
            this.stmtType = 2;
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.updateStmt, lastWeekly, this.tsWeekly);
            this.setTimestamp(this.updateStmt, lastMonthly, this.tsMonthly);
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
            this.closeUpdate();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAggregator.class.getName(), (String)"update", (Throwable)e);
            }
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAggregator.class.getName(), (String)"update");
        }
    }
}

