/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.constants.metadata.AlertProductManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TConfigSettings;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.server.guireq.AlertLog;
import org.eclipse.aperi.server.guireq.AlertNameList;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.server.guireq.ExtAlertLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAlertLog
extends RepositoryAccessor {
    AlertLog buffer;
    private static final String ACTIVE = "'" + Integer.toString(0) + "'";
    private static final String CLEAR = "'" + Integer.toString(2) + "'";
    private static final String LOGICALLY_DELETED = "'" + Integer.toString(3) + "'";
    private static final String INSERT = "insert into t_alert_log (alert_log_id, alert_id, computer_id,  resource_id, resource_type, alert_condition, violator_id, violator_type, notify_user, product_id, threshold_type, threshold_value, violating_value, previous_value, first_alert_time, last_alert_time, alert_count, state, script_computer_id, script_log_file, script_name, msg, dbms_type, parent_id, job_log_file) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?, 1, " + ACTIVE + ",?,?,?,?,?,?,' ')";
    private static final String UPDATE = "update t_alert_log set violating_value = ?, notify_user = ?, last_alert_time = ?, script_computer_id = ?, script_log_file = ?, script_name = ?, msg = ?, threshold_value = ?, alert_count = alert_count + 1 where alert_id = ? and computer_id = ? and resource_id = ? and resource_type = ? and alert_condition = ? and violator_id = ? and violator_type = ? and state = " + ACTIVE;
    private static final String DEACTIVATE = "update t_alert_log set state = " + CLEAR + " where alert_id = ? and" + " computer_id = ? and resource_id = ? and resource_type = ? and" + " alert_condition = ? and violator_id = ? and violator_type = ?" + " and state <> " + LOGICALLY_DELETED;
    private static final String DEACTIVATE_BY_ALERT_ID = "update t_alert_log set state = " + CLEAR + " where alert_id = ? and" + " state not in (" + LOGICALLY_DELETED + "," + CLEAR + ")";
    private static final String DEACTIVATE_BY_ID = "update t_alert_log set state = ? where alert_log_id = ? and state <> " + LOGICALLY_DELETED;
    private static final String DELETE = "delete from t_alert_log where alert_log_id = ?";
    private static final String DELETE_BY_FS = "delete from t_alert_log where resource_type = " + Short.toString((short)3) + " and resource_id = ?";
    private static final String DELETE_BY_DISK = "delete from t_alert_log where resource_type = " + Short.toString((short)10) + " and resource_id = ?";
    private static final String DELETE_BY_COMPUTER = "delete from t_alert_log where resource_type = " + Short.toString((short)1) + " and resource_id = ?";
    private static final String DELETE_BY_DISKARRAY = "delete from t_alert_log where resource_type = " + Short.toString((short)78) + " and resource_id = ?";
    private static final String LOGICALLY_DELETE = "update t_alert_log set state = " + LOGICALLY_DELETED + " where alert_log_id = ? and state <> " + CLEAR;
    private static final String DELETE_LOGICALLY_DELETED = "delete from t_alert_log where alert_id = ? and state = " + LOGICALLY_DELETED;
    private static final String SELECT_ACTIVE_IDS = "select alert_condition, resource_id, computer_id, violator_id, dbms_type, violator_type, notify_user, product_id from t_alert_log where state = " + ACTIVE;
    private static final String SELECT_FOR_DELETE = "select count(*)  from t_alert_log  where alert_id    = ?  and   resource_id = ?  and   violator_id = ?  and   last_alert_time > ? ";
    private static final String FULL_SELECT_CLAUSE = "select l.alert_log_id, l.alert_id, l.alert_condition, l.notify_user, l.threshold_type, l.threshold_value, l.violating_value, l.previous_value, l.first_alert_time, l.last_alert_time, l.alert_count, l.state, l.resource_type, l.resource_id, l.violator_type, l.violator_id, d.creator, d.name, l.computer_id, l.script_computer_id, l.script_log_file, l.script_name, l.product_id, l.dbms_type, l.parent_id, l.job_log_file";
    private static final String GUI_TABLE_SELECT = "select l.alert_log_id, l.alert_id, l.alert_condition, l.notify_user, l.threshold_type, l.threshold_value, l.violating_value, l.previous_value, l.first_alert_time, l.last_alert_time, l.alert_count, l.state, l.resource_type, l.resource_id, l.violator_type, l.violator_id, d.creator, d.name, l.computer_id, l.script_computer_id, l.script_log_file, l.script_name, l.product_id, l.dbms_type, l.parent_id, l.job_log_file from t_alert_log l, t_alert_definition d where d.alert_id = l.alert_id and l.state <> " + LOGICALLY_DELETED;
    private static final String SELECT_FOR_CLEANUP = "select l.alert_log_id, l.alert_id, l.alert_condition, l.notify_user, l.threshold_type, l.threshold_value, l.violating_value, l.previous_value, l.first_alert_time, l.last_alert_time, l.alert_count, l.state, l.resource_type, l.resource_id, l.violator_type, l.violator_id, d.creator, d.name, l.computer_id, l.script_computer_id, l.script_log_file, l.script_name, l.product_id, l.dbms_type, l.parent_id, l.job_log_file from t_alert_log l, t_alert_definition d where d.alert_id = l.alert_id  and   l.last_alert_time < ? ";
    private static final String INVALIDATE_SCRIPT_LOGS = "update t_alert_log set script_computer_id = -1, script_log_file = ' ' where script_computer_id = ?";
    private static final int N_PLACES = 10;
    private static final String GET_TEXT = "SELECT msg, alert_condition FROM t_alert_log WHERE alert_log_id = ?";
    private static final short[] computerConditions = new short[]{1, 2, 3, 4, 15, 31, 55, 66, 5, 7, 8, 24, 6, 12, 73, 74, 172, 173, 174, 175, 176, 75};
    private static final short[] diskConditions = new short[]{5, 7, 8, 24, 6};
    private static final short[] filesystemConditions = new short[]{9, 10, 13, 14, 12};
    private static final short[] diskArrayConditions = new short[]{67, 68, 64, 65, 5, 7, 8, 24, 6, 123, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 111, 112, 135, 136, 137, 138};
    private static final short[] fabricConditions = new short[]{91, 92, 93, 94, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 103};
    private static final short[] switchConditions = new short[]{95, 96, 97, 98, 99, 100, 124, 125, 126, 127, 128, 129, 130, 131, 132, 107};
    private static final short[] endpointConditions = new short[]{101, 133, 134, 139, 106, 101, 102, 177, 102};
    private static final short[] tapeConditions = new short[]{157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 109};
    private static final short[] externalConditions = new short[]{178};

    public TAlertLog(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"TAlertLog", (String)"dbc");
        }
        this.tableName = "t_alert_log";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"TAlertLog");
        }
    }

    public void prepSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"prepSave", (String)"");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.updateStmt = this.prepareStmt(UPDATE);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"prepSave");
        }
    }

    public void closeSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"closeSave", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"closeSave");
        }
    }

    public void save(AlertLog alertLog, boolean cumulativeLogEntry) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"save", (String)"alertLog, cumulativeLogEntry");
        }
        try {
            int updateCount = 0;
            if (cumulativeLogEntry) {
                updateCount = this.update(alertLog);
            }
            if (updateCount == 0) {
                this.insert(alertLog);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"save", (Throwable)e);
            }
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"save");
        }
    }

    private int update(AlertLog alertLog) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"update", (String)"alertLog");
        }
        this.stmtType = 2;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.updateStmt, alertLog.alViolatingValue);
        this.setString(this.updateStmt, alertLog.alNotifyUser);
        this.setTimestamp(this.updateStmt, alertLog.alLastAlertTime);
        this.setInt(this.updateStmt, alertLog.alScriptComputerID);
        this.setString(this.updateStmt, alertLog.alScriptLogFile);
        this.setString(this.updateStmt, alertLog.alScriptName);
        this.setString(this.updateStmt, alertLog.alMessage);
        this.setInt(this.updateStmt, alertLog.alThresholdValue);
        this.setKey(this.updateStmt, alertLog);
        int status = this.executeUpdate(this.updateStmt);
        this.dbc.commit();
        int traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"update", (int)traceResult);
        }
        return traceResult;
    }

    private void setKey(PreparedStatement pStmt, AlertLog alertLog) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"setKey", (String)"pStmt, alertLog");
        }
        this.setInt(pStmt, alertLog.alAlertID);
        this.setInt(pStmt, alertLog.alComputerID);
        this.setInt(pStmt, alertLog.alResourceID);
        this.setShort(pStmt, alertLog.alResourceType);
        this.setShort(pStmt, alertLog.alAlertCondition);
        this.setInt(pStmt, alertLog.alViolatorID);
        this.setShort(pStmt, alertLog.alViolatorType);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"setKey");
        }
    }

    private void insert(AlertLog alertLog) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"insert", (String)"alertLog");
        }
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        if (alertLog.alNotifyUser == null) {
            alertLog.alNotifyUser = " ";
        }
        this.setInt(this.insertStmt, alertLog.alAlertLogID);
        this.setKey(this.insertStmt, alertLog);
        this.setString(this.insertStmt, alertLog.alNotifyUser);
        this.setInt(this.insertStmt, alertLog.alProductID);
        this.setString(this.insertStmt, Character.toString((char)(alertLog.alThresholdType + 48)));
        this.setInt(this.insertStmt, alertLog.alThresholdValue);
        this.setInt(this.insertStmt, alertLog.alViolatingValue);
        this.setInt(this.insertStmt, alertLog.alPreviousValue);
        this.setTimestamp(this.insertStmt, alertLog.alLastAlertTime);
        this.setTimestamp(this.insertStmt, alertLog.alLastAlertTime);
        this.setInt(this.insertStmt, alertLog.alScriptComputerID);
        this.setString(this.insertStmt, alertLog.alScriptLogFile);
        this.setString(this.insertStmt, alertLog.alScriptName);
        this.setString(this.insertStmt, alertLog.alMessage);
        this.setByte(this.insertStmt, alertLog.alDbmsType);
        this.setInt(this.insertStmt, alertLog.alParentID);
        this.executeUpdate(this.insertStmt);
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"insert");
        }
    }

    public void prepDeactivate() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"prepDeactivate", (String)"");
        }
        this.updateStmt = this.prepareStmt(DEACTIVATE);
        if (this.buffer == null) {
            this.buffer = new AlertLog();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"prepDeactivate");
        }
    }

    public void prepDeactivateByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"prepDeactivateByID", (String)"");
        }
        this.updateStmt = this.prepareStmt(DEACTIVATE_BY_ID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"prepDeactivateByID");
        }
    }

    public void deactivate(int alertID, int computerID, int resourceID, short resourceType, short alertCondition) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"deactivate", (String)"alertID, computerID, resourceID, resourceType, alertCondition");
        }
        this.deactivate(alertID, computerID, resourceID, resourceType, alertCondition, -1, (short)-1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"deactivate");
        }
    }

    public void deactivate(int alertID, int computerID, int resourceID, short resourceType, short alertCondition, int violatorID, short violatorType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"deactivate", (String)"alertID, computerID, resourceID, resourceType, alertCondition, violatorID, violatorType");
        }
        this.buffer.alAlertID = alertID;
        this.buffer.alComputerID = computerID;
        this.buffer.alResourceID = resourceID;
        this.buffer.alResourceType = resourceType;
        this.buffer.alAlertCondition = alertCondition;
        this.buffer.alViolatorID = violatorID;
        this.buffer.alViolatorType = violatorType;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setKey(this.updateStmt, this.buffer);
            this.executeUpdate(this.updateStmt);
            this.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"deactivate", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"deactivate");
        }
    }

    public void deactivate(int alertLogID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"deactivate", (String)"alertLogID");
        }
        byte newState = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setByte(this.updateStmt, newState);
            this.setInt(this.updateStmt, alertLogID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"deactivate", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"deactivate");
        }
    }

    public void deactivateByResource(int alertID, int[] resourceArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"deactivateByResource", (String)"alertID, resourceArray");
        }
        this.deactivate(alertID, resourceArray, "resource_id");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"deactivateByResource");
        }
    }

    public void deactivateByViolator(int alertID, int[] violatorArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"deactivateByViolator", (String)"alertID, violatorArray");
        }
        this.deactivate(alertID, violatorArray, "violator_id");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"deactivateByViolator");
        }
    }

    private void deactivate(int alertID, int[] idArray, String idColumnName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"deactivate", (String)"alertID, idArray, idColumnName");
        }
        StringBuffer buffer = new StringBuffer(200);
        buffer.append(DEACTIVATE_BY_ALERT_ID);
        buffer.append(" and ");
        buffer.append(idColumnName);
        buffer.append(" in (?,?,?,?,?,?,?,?,?,?)");
        this.updateStmt = this.prepareStmt(buffer.toString());
        int i = idArray.length - 1;
        while (i >= 0) {
            this.stmtPhase = 0;
            this.colIndex = 1;
            try {
                this.setInt(this.updateStmt, alertID);
                for (int counter = 0; counter < 10; ++counter) {
                    if (i >= 0) {
                        this.setInt(this.updateStmt, idArray[i--]);
                        continue;
                    }
                    this.setInt(this.updateStmt, -2147483647);
                }
                this.executeUpdate(this.updateStmt);
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TAlertLog.class.getName(), (String)"deactivate", (Throwable)e);
                }
                this.stmtType = 2;
                this.sqlError(e);
            }
            this.commit();
        }
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"deactivate");
        }
    }

    public void deleteByFilesystem(int filesystemID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"deleteByFilesystem", (String)"filesystemID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_FS);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, filesystemID);
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"deleteByFilesystem");
        }
    }

    public void deleteByDisk(int diskID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"deleteByDisk", (String)"diskID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_DISK);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, diskID);
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"deleteByDisk");
        }
    }

    public void deleteByComputer(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"deleteByComputer", (String)"computerID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_COMPUTER);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, computerID);
        this.closeDelete();
        this.updateStmt = this.prepareStmt(INVALIDATE_SCRIPT_LOGS);
        this.stmtType = 2;
        this.execUpdateByID(this.updateStmt, computerID);
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"deleteByComputer");
        }
    }

    public void deleteByDiskArray(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"deleteByDiskArray", (String)"computerID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_DISKARRAY);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, computerID);
        this.closeDelete();
        this.updateStmt = this.prepareStmt(INVALIDATE_SCRIPT_LOGS);
        this.stmtType = 2;
        this.execUpdateByID(this.updateStmt, computerID);
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"deleteByDiskArray");
        }
    }

    public void prepLogicalDelete() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"prepLogicalDelete", (String)"");
        }
        this.deleteStmt = this.prepareStmt(DELETE);
        this.updateStmt = this.prepareStmt(LOGICALLY_DELETE);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"prepLogicalDelete");
        }
    }

    public void deleteByID(ExtAlertLog record) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"deleteByID", (String)"record");
        }
        TResAttr tresattr = new TResAttr(this.dbc);
        tresattr.deleteByAttribute(record.alAlertLogID, (short)140);
        this.deleteStmt = this.prepareStmt(DELETE);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, record.alAlertLogID);
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"deleteByID");
        }
    }

    public void logicalDelete(ExtAlertLog record) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"logicalDelete", (String)"record");
        }
        TResAttr tresattr = new TResAttr(this.dbc);
        tresattr.deleteByAttribute(record.alAlertLogID, (short)140);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, record.alAlertLogID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"logicalDelete");
        }
    }

    public void closeLogicalDelete() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"closeLogicalDelete", (String)"");
        }
        this.closeDelete();
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"closeLogicalDelete");
        }
    }

    private int execUpdateByID(PreparedStatement stmt, int id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"execUpdateByID", (String)"stmt, id");
        }
        int rowsAffected = 0;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(stmt, id);
            rowsAffected = this.executeUpdate(stmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"execUpdateByID", (Throwable)e);
            }
            this.sqlError(e);
        }
        this.commit();
        int traceResult = rowsAffected;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"execUpdateByID", (int)traceResult);
        }
        return traceResult;
    }

    public void deleteLogicallyDeleted(int alertID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"deleteLogicallyDeleted", (String)"alertID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_LOGICALLY_DELETED);
        this.stmtType = 3;
        this.execUpdateByID(this.deleteStmt, alertID);
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"deleteLogicallyDeleted");
        }
    }

    public NameList[] selectActiveIDs(String userName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"selectActiveIDs", (String)"userName");
        }
        this.selectStmt = this.prepareStmt(SELECT_ACTIVE_IDS);
        AlertNameList head = null;
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                AlertNameList element = new AlertNameList();
                this.colIndex = 1;
                element.nlInfo = this.getShort(this.resultSet);
                element.nlID = this.getInt(this.resultSet);
                element.nlID2 = this.getInt(this.resultSet);
                element.nlID3 = this.getInt(this.resultSet);
                element.nlSubProductID = this.getByte(this.resultSet);
                short violatorType = this.getShort(this.resultSet);
                String notifyUser = this.getString(this.resultSet);
                if (userName.equals(notifyUser)) {
                    element.nlName = userName;
                }
                element.nlProductID = this.getShort(this.resultSet);
                if (element.nlProductID == 1) {
                    element.nlProductID = 0;
                }
                element.nlNext = head;
                head = element;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"selectActiveIDs", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        NameList[] traceResult = NameList.packList(head);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"selectActiveIDs", (Object)traceResult);
        }
        return traceResult;
    }

    public String getText(int alertLogID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"getText", (String)"alertLogID");
        }
        String result = null;
        int alertCondition = -1;
        this.selectStmt = this.prepareStmt(GET_TEXT);
        this.colIndex = 1;
        this.stmtPhase = 0;
        try {
            this.setInt(this.selectStmt, alertLogID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.colIndex = 1;
            if (this.nextResult()) {
                result = this.getString(this.resultSet);
                alertCondition = this.getShort(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"getText", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        TResAttr tresattr = new TResAttr(this.dbc);
        result = result + tresattr.getAffectedHosts(alertLogID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"getText", (Object)result);
        }
        return result;
    }

    private void fetch(Map<Short, ExtAlertLog> classIdAlertLogMap) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"fetch", (String)"array");
        }
        ExtAlertLog row = new ExtAlertLog();
        this.colIndex = 1;
        row.alAlertLogID = this.getInt(this.resultSet);
        row.alAlertID = this.getInt(this.resultSet);
        row.alAlertCondition = this.getShort(this.resultSet);
        short condClass = AlertConditionManager.getClassId((short)row.alAlertCondition);
        if (condClass < 0) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TAlertLog.class.getName(), (String)"fetch");
            }
            return;
        }
        row.alNotifyUser = this.getString(this.resultSet);
        row.alThresholdType = (byte)(this.getString(this.resultSet).charAt(0) - 48);
        row.alThresholdValue = this.getInt(this.resultSet);
        row.alViolatingValue = this.getInt(this.resultSet);
        row.alPreviousValue = this.getInt(this.resultSet);
        row.alFirstAlertTime = this.getTimestamp(this.resultSet);
        row.alLastAlertTime = this.getTimestamp(this.resultSet);
        row.alAlertCount = this.getInt(this.resultSet);
        row.alState = this.getByte(this.resultSet);
        short resourceType = this.getShort(this.resultSet);
        int resourceID = this.getInt(this.resultSet);
        short violatorType = this.getShort(this.resultSet);
        int violatorID = this.getInt(this.resultSet);
        if (row.alAlertCondition == 66) {
            row.alResourceType = violatorType;
            row.alResourceID = violatorID;
            row.alViolatorType = resourceType;
            row.alViolatorID = resourceID;
        } else {
            row.alResourceType = resourceType;
            row.alResourceID = resourceID;
            row.alViolatorType = violatorType;
            row.alViolatorID = violatorID;
        }
        row.alCreator = this.getString(this.resultSet);
        row.setAlName(this.getString(this.resultSet));
        row.alComputerID = this.getInt(this.resultSet);
        row.alScriptComputerID = this.getInt(this.resultSet);
        row.alScriptLogFile = this.getString(this.resultSet);
        row.alScriptName = this.getString(this.resultSet);
        row.alProductID = this.getShort(this.resultSet);
        row.alDbmsType = this.getByte(this.resultSet);
        row.alParentID = this.getInt(this.resultSet);
        row.alJobLogFile = this.getString(this.resultSet);
        row.alnExt = classIdAlertLogMap.get(condClass);
        classIdAlertLogMap.put(condClass, row);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"fetch");
        }
    }

    private Map<Short, ExtAlertLog> doSelect(String sqlText) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"doSelect", (String)"sqlText");
        }
        this.selectStmt = this.prepareStmt(sqlText);
        HashMap<Short, ExtAlertLog> result = new HashMap<Short, ExtAlertLog>();
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.fetch(result);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"doSelect", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"doSelect", result);
        }
        return result;
    }

    public Map<Short, ExtAlertLog> select(short productCode, byte subProduct) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"select", (String)"productCode, subProduct");
        }
        StringBuffer sqlBuffer = new StringBuffer(450);
        sqlBuffer.append(GUI_TABLE_SELECT);
        TAlertLog.appendSubProduct(sqlBuffer, productCode, subProduct);
        Map<Short, ExtAlertLog> traceResult = this.doSelect(sqlBuffer.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"select", traceResult);
        }
        return traceResult;
    }

    public Map<Short, ExtAlertLog> select(short productCode) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"select", (String)"productCode");
        }
        Map<Short, ExtAlertLog> traceResult = this.select(productCode, (byte)-1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"select", traceResult);
        }
        return traceResult;
    }

    private static void appendProduct(StringBuffer buf, short productCode) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"appendProduct", (String)"buf, productCode");
        }
        if (productCode >= 0) {
            buf.append(" AND l.product_id = ");
            buf.append(productCode);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"appendProduct");
        }
    }

    private static void appendSubProduct(StringBuffer buf, short productCode, byte subProduct) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"appendSubProduct", (String)"buf, productCode, subProduct");
        }
        TAlertLog.appendProduct(buf, productCode);
        if (AlertProductManager.getSubproductCount((short)productCode) > 0 && AlertProductManager.isValidSubproduct((byte)subProduct)) {
            buf.append(" AND l.dbms_type = '");
            buf.append(subProduct);
            buf.append("'");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"appendSubProduct");
        }
    }

    public Map<Short, ExtAlertLog> select(int alertID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"select", (String)"alertID");
        }
        StringBuffer buf = new StringBuffer(450);
        buf.append(GUI_TABLE_SELECT);
        buf.append(" AND l.alert_id = ");
        buf.append(Integer.toString(alertID));
        String sqlText = buf.toString();
        buf = null;
        Map<Short, ExtAlertLog> traceResult = this.doSelect(sqlText);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"select", traceResult);
        }
        return traceResult;
    }

    public Map<Short, ExtAlertLog> selectforcleanup() throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"selectforcleanup", (String)"");
        }
        TConfigSettings config = new TConfigSettings(this.dbc);
        ConfigSettings settings = config.getConfigSettings();
        long delta = settings.csDellogDays;
        long timestamp = 0L;
        try {
            timestamp = SQLUtil.getTimestamp(this.dbc).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"selectforcleanup", (Throwable)e);
            }
            return null;
        }
        this.selectStmt = this.prepareStmt(SELECT_FOR_CLEANUP);
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setTimestamp(this.selectStmt, timestamp -= (delta *= 86400000L));
        HashMap<Short, ExtAlertLog> result = new HashMap<Short, ExtAlertLog>();
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.fetch(result);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"selectforcleanup", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"selectforcleanup", result);
        }
        return result;
    }

    private static void appendInList(StringBuffer buf, short[] conditions) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"appendInList", (String)"buf, conditions");
        }
        if (conditions != null) {
            buf.append(" AND l.alert_condition IN (");
            boolean commaNeeded = false;
            int length = conditions.length;
            for (int i = 0; i < length; ++i) {
                if (commaNeeded) {
                    buf.append(", ");
                }
                commaNeeded = true;
                buf.append(Short.toString(conditions[i]));
            }
            buf.append(')');
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"appendInList");
        }
    }

    public Map<Short, ExtAlertLog> select(short objectType, int objectID, short productID, byte subProduct) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"select", (String)"objectType, objectID, productID, subProduct");
        }
        short[] conditionArray = null;
        boolean isQuota = false;
        switch (objectType) {
            case 1: 
            case 99: 
            case 100: 
            case 101: {
                conditionArray = computerConditions;
                break;
            }
            case 78: {
                conditionArray = diskArrayConditions;
                break;
            }
            case 10: {
                conditionArray = diskConditions;
                break;
            }
            case 3: {
                conditionArray = filesystemConditions;
                break;
            }
            case 121: {
                conditionArray = switchConditions;
                break;
            }
            case 114: {
                conditionArray = fabricConditions;
                break;
            }
            case 129: {
                conditionArray = endpointConditions;
                break;
            }
            case 134: {
                conditionArray = tapeConditions;
                break;
            }
            case 128: {
                conditionArray = externalConditions;
            }
        }
        StringBuffer buf = new StringBuffer(550);
        buf.append(GUI_TABLE_SELECT);
        TAlertLog.appendInList(buf, conditionArray);
        if (objectID > 0) {
            buf.append(" AND l.");
            if (isQuota) {
                buf.append("violator_id = ");
            } else if (objectType == 1) {
                buf.append("computer_id = ");
            } else {
                buf.append("resource_id = ");
            }
            buf.append(Integer.toString(objectID));
        } else if (isQuota) {
            buf.append(" AND l.violator_type = ");
            buf.append(Short.toString(objectType));
        }
        TAlertLog.appendSubProduct(buf, productID, subProduct);
        String sqlText = buf.toString();
        buf = null;
        Map<Short, ExtAlertLog> traceResult = this.doSelect(sqlText);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"select", traceResult);
        }
        return traceResult;
    }

    public Map<Short, ExtAlertLog> selectActive(short productCode, String userName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"selectActive", (String)"productCode, userName");
        }
        StringBuffer buf = new StringBuffer(450);
        buf.append(GUI_TABLE_SELECT);
        buf.append(" AND l.state = ");
        buf.append(ACTIVE);
        if (userName != null) {
            buf.append(" AND l.notify_user = '");
            buf.append(userName);
            buf.append('\'');
        }
        if (productCode >= 0) {
            TAlertLog.appendProduct(buf, productCode);
        }
        String sqlText = buf.toString();
        buf = null;
        Map<Short, ExtAlertLog> traceResult = this.doSelect(sqlText);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"selectActive", traceResult);
        }
        return traceResult;
    }

    public void updateJobLogFile(int alertLogID, String jobLogFile) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertLog.class.getName(), (String)"updateJobLogFile", (String)"alertLogID, jobLogFile");
        }
        StringBuffer buf = new StringBuffer(200);
        buf.append("update t_alert_log set job_log_file = '");
        buf.append(jobLogFile);
        buf.append("' where alert_log_id = ");
        buf.append(alertLogID);
        String sqlText = buf.toString();
        buf = null;
        this.setSQLText(sqlText);
        this.staticStmt = this.createStatement();
        try {
            this.staticStmt.executeUpdate(sqlText);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"updateJobLogFile", (Throwable)e);
            }
            this.stmtPhase = 3;
            this.sqlError(e);
        }
        this.commit();
        this.closeStaticStmt();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"updateJobLogFile");
        }
    }
}

