/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.BatchReport;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class TBatchReport
extends StorageRepositoryAccessor {
    private static final String INSERT = "insert into t_batch_report (report_id, file_mask, report_type, script_name, headers, totals, history_header, space_units, definition) values (?,?,?,?,?,?,?,?,?)";
    private static final String SELECT_BY_ID = "select file_mask, report_type, script_name, headers, totals, history_header, space_units, definition from t_batch_report where report_id = ?";
    private static final String DELETE = "delete from t_batch_report where report_id = ?";
    private static final String[] oldText = new String[]{"{Report creator}", "{Report name}", "{Report title}", "{Report run number}", "{Report run date}", "{Report run time}", "{Unique number}"};

    public TBatchReport(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TBatchReport.class.getName(), (String)"TBatchReport", (String)"dbc");
        }
        this.tableName = "t_batch_report";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TBatchReport.class.getName(), (String)"TBatchReport");
        }
    }

    public void insert(BatchReport batchReport) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TBatchReport.class.getName(), (String)"insert", (String)"batchReport");
        }
        ByteArrayOutputStream bs = null;
        ObjectOutputStream os = null;
        try {
            this.stmtType = 1;
            this.insertStmt = this.prepareStmt(INSERT);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.insertStmt, batchReport.reportID);
            this.setString(this.insertStmt, batchReport.fileMask);
            this.setByte(this.insertStmt, batchReport.reportType);
            this.setString(this.insertStmt, batchReport.scriptName);
            this.setBoolean(this.insertStmt, batchReport.includeHeaders);
            this.setBoolean(this.insertStmt, batchReport.includeTotals);
            this.setString(this.insertStmt, batchReport.historyHeader);
            this.setByte(this.insertStmt, batchReport.spaceUnits);
            try {
                bs = new ByteArrayOutputStream(1024);
                os = new ObjectOutputStream(bs);
                os.writeObject(batchReport.grr);
                os.flush();
                this.setBytes(this.insertStmt, bs.toByteArray());
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TBatchReport.class.getName(), (String)"insert", (Throwable)e);
                }
                this.cleanup();
                this.insertStmt = null;
                String msg = MessageLog.getMessageWithException((String)"STS0151E", (Exception)e);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TBatchReport.class.getName(), (String)"insert");
                }
                throw new GeneralException(msg);
            }
            finally {
                block25: {
                    block24: {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException ignored) {
                                if (!TraceLogger.enableTrace) break block24;
                                TraceLogger.exception((String)TBatchReport.class.getName(), (String)"insert", (Throwable)ignored);
                            }
                        }
                    }
                    if (bs != null) {
                        try {
                            bs.close();
                        }
                        catch (IOException ignored) {
                            if (!TraceLogger.enableTrace) break block25;
                            TraceLogger.exception((String)TBatchReport.class.getName(), (String)"insert", (Throwable)ignored);
                        }
                    }
                }
            }
            if (this.insertStmt != null) {
                this.executeUpdate(this.insertStmt);
                this.closeInsert();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TBatchReport.class.getName(), (String)"insert", (Throwable)e);
            }
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TBatchReport.class.getName(), (String)"insert");
        }
    }

    public BatchReport selectByID(int reportID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TBatchReport.class.getName(), (String)"selectByID", (String)"reportID");
        }
        ObjectInputStream oi = null;
        InputStream is = null;
        BatchReport batchReport = new BatchReport();
        batchReport.reportID = reportID;
        try {
            this.stmtType = 0;
            this.selectStmt = this.prepareStmt(SELECT_BY_ID);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, reportID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                batchReport.fileMask = this.getString(this.resultSet);
                batchReport.reportType = this.getByte(this.resultSet);
                batchReport.scriptName = this.getString(this.resultSet);
                batchReport.includeHeaders = this.getBoolean(this.resultSet);
                batchReport.includeTotals = this.getBoolean(this.resultSet);
                batchReport.historyHeader = this.getString(this.resultSet);
                batchReport.spaceUnits = this.getByte(this.resultSet);
                batchReport.fileMask = batchReport.maskToIDs(oldText);
                try {
                    is = this.resultSet.getBinaryStream(this.colIndex);
                    oi = new ObjectInputStream(is);
                    batchReport.grr = (GuiReportReq)oi.readObject();
                    if (batchReport.grr.productCode == 0) {
                        batchReport.grr.productCode = 1;
                    }
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)TBatchReport.class.getName(), (String)"selectByID", (Throwable)e);
                    }
                    this.cleanup();
                    String msg = MessageLog.getMessageWithException((String)"STS0151E", (Exception)e);
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)TBatchReport.class.getName(), (String)"selectByID");
                    }
                    throw new GeneralException(msg);
                }
                catch (ClassNotFoundException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)TBatchReport.class.getName(), (String)"selectByID", (Throwable)e);
                    }
                    this.cleanup();
                    String msg = MessageLog.getMessageWithException((String)"STS0151E", (Exception)e);
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)TBatchReport.class.getName(), (String)"selectByID");
                    }
                    throw new GeneralException(msg);
                }
                finally {
                    block29: {
                        block28: {
                            if (oi != null) {
                                try {
                                    oi.close();
                                }
                                catch (IOException ignored) {
                                    if (!TraceLogger.enableTrace) break block28;
                                    TraceLogger.exception((String)TBatchReport.class.getName(), (String)"selectByID", (Throwable)ignored);
                                }
                            }
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ignored) {
                                if (!TraceLogger.enableTrace) break block29;
                                TraceLogger.exception((String)TBatchReport.class.getName(), (String)"selectByID", (Throwable)ignored);
                            }
                        }
                    }
                }
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TBatchReport.class.getName(), (String)"selectByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        BatchReport traceResult = batchReport;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TBatchReport.class.getName(), (String)"selectByID", (Object)traceResult);
        }
        return traceResult;
    }

    public void delete(int reportID, boolean commit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TBatchReport.class.getName(), (String)"delete", (String)"reportID, commit");
        }
        try {
            this.stmtType = 3;
            this.deleteStmt = this.prepareStmt(DELETE);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, reportID);
            this.executeUpdate(this.deleteStmt);
            if (commit) {
                this.commit();
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TBatchReport.class.getName(), (String)"delete", (Throwable)e);
            }
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TBatchReport.class.getName(), (String)"delete");
        }
    }
}

