/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.ReportPrefs;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;

public class TReportPrefs
extends RepositoryAccessor {
    private static final String SELECT = "select report_type, profile_id, fs_max_rows, fs_grp_max_rows, dir_max_rows, dir_grp_max_rows, computer_max_rows, comp_grp_max_rows, user_max_rows, group_max_rows, domain_max_rows, network_max_rows, quota_max_rows, datafile_max_rows, ts_max_rows, ts_grp_max_rows, database_max_rows, instance_max_rows, tb_max_rows, tb_grp_max_rows from t_report_prefs where trellisoft_user = ?";
    private static final String DELETE = "delete from t_report_prefs where trellisoft_user = ?";
    private static final String INSERT = "insert into t_report_prefs (trellisoft_user, report_type, profile_id, fs_max_rows, fs_grp_max_rows, dir_max_rows, dir_grp_max_rows, computer_max_rows, comp_grp_max_rows, user_max_rows, group_max_rows, domain_max_rows, network_max_rows, quota_max_rows, datafile_max_rows, ts_max_rows, ts_grp_max_rows, database_max_rows, instance_max_rows, tb_max_rows, tb_grp_max_rows) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public TReportPrefs(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TReportPrefs.class.getName(), (String)"TReportPrefs", (String)"dbc");
        }
        this.tableName = "t_report_prefs";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TReportPrefs.class.getName(), (String)"TReportPrefs");
        }
    }

    public ReportPrefs getPrefs(String userName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TReportPrefs.class.getName(), (String)"getPrefs", (String)"userName");
        }
        ReportPrefs result = null;
        this.selectStmt = this.prepareStmt(SELECT);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setString(this.selectStmt, userName);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                ReportPrefs prefs = new ReportPrefs();
                this.colIndex = 1;
                prefs.rpType = this.getInt(this.resultSet);
                prefs.rpProfileID = this.getInt(this.resultSet);
                prefs.rpFSMaxRows = this.getInt(this.resultSet);
                prefs.rpFSGrpMaxRows = this.getInt(this.resultSet);
                prefs.rpDirMaxRows = this.getInt(this.resultSet);
                prefs.rpDirGrpMaxRows = this.getInt(this.resultSet);
                prefs.rpComputerMaxRows = this.getInt(this.resultSet);
                prefs.rpCompGrpMaxRows = this.getInt(this.resultSet);
                prefs.rpUserMaxRows = this.getInt(this.resultSet);
                prefs.rpGroupMaxRows = this.getInt(this.resultSet);
                prefs.rpDomMaxRows = this.getInt(this.resultSet);
                prefs.rpNetMaxRows = this.getInt(this.resultSet);
                prefs.rpQuotaMaxRows = this.getInt(this.resultSet);
                prefs.rpDFMaxRows = this.getInt(this.resultSet);
                prefs.rpTSMaxRows = this.getInt(this.resultSet);
                prefs.rpTSGrpMaxRows = this.getInt(this.resultSet);
                prefs.rpDBMaxRows = this.getInt(this.resultSet);
                prefs.rpINMaxRows = this.getInt(this.resultSet);
                prefs.rpTBMaxRows = this.getInt(this.resultSet);
                prefs.rpTBGrpMaxRows = this.getInt(this.resultSet);
                prefs.rpNext = result;
                result = prefs;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TReportPrefs.class.getName(), (String)"getPrefs", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        ReportPrefs traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TReportPrefs.class.getName(), (String)"getPrefs", traceResult);
        }
        return traceResult;
    }

    public void savePrefs(String userName, ReportPrefs toSave) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TReportPrefs.class.getName(), (String)"savePrefs", (String)"userName, toSave");
        }
        this.deleteStmt = this.prepareStmt(DELETE);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setString(this.deleteStmt, userName);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TReportPrefs.class.getName(), (String)"savePrefs", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        this.closeDelete();
        this.insertStmt = this.prepareStmt(INSERT);
        try {
            while (toSave != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setString(this.insertStmt, userName);
                this.setInt(this.insertStmt, toSave.rpType);
                this.setInt(this.insertStmt, toSave.rpProfileID);
                this.setInt(this.insertStmt, toSave.rpFSMaxRows);
                this.setInt(this.insertStmt, toSave.rpFSGrpMaxRows);
                this.setInt(this.insertStmt, toSave.rpDirMaxRows);
                this.setInt(this.insertStmt, toSave.rpDirGrpMaxRows);
                this.setInt(this.insertStmt, toSave.rpComputerMaxRows);
                this.setInt(this.insertStmt, toSave.rpCompGrpMaxRows);
                this.setInt(this.insertStmt, toSave.rpUserMaxRows);
                this.setInt(this.insertStmt, toSave.rpGroupMaxRows);
                this.setInt(this.insertStmt, toSave.rpDomMaxRows);
                this.setInt(this.insertStmt, toSave.rpNetMaxRows);
                this.setInt(this.insertStmt, toSave.rpQuotaMaxRows);
                this.setInt(this.insertStmt, toSave.rpDFMaxRows);
                this.setInt(this.insertStmt, toSave.rpTSMaxRows);
                this.setInt(this.insertStmt, toSave.rpTSGrpMaxRows);
                this.setInt(this.insertStmt, toSave.rpDBMaxRows);
                this.setInt(this.insertStmt, toSave.rpINMaxRows);
                this.setInt(this.insertStmt, toSave.rpTBMaxRows);
                this.setInt(this.insertStmt, toSave.rpTBGrpMaxRows);
                this.executeUpdate(this.insertStmt);
                toSave = toSave.rpNext;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TReportPrefs.class.getName(), (String)"savePrefs", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        this.closeInsert();
        this.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TReportPrefs.class.getName(), (String)"savePrefs");
        }
    }
}

