/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TResChunkCollection
extends StorageRepositoryAccessor {
    private static final String FETCH_BY_LOGICAL_DISK = "select collection_id, seqno, collection_type, striping_size from t_res_chunk_cllctn where logical_disk_id = ? order by seqno desc";
    private static final String FETCH_BY_FLEXIBLE_LOGICAL_DISK = "select collection_id, seqno, collection_type, striping_size from t_res_chunk_cllctn where collection_id = (select collection_id from t_res_aggregate  where logical_disk_id = ?)  order by seqno desc";
    private static final String INSERT = "insert into t_res_chunk_cllctn (collection_id, logical_disk_id, seqno, collection_type, striping_size) values (?,?,?,?,?)";
    private static final String DELETE_BY_LOGICAL_DISK = "delete from t_res_chunk_cllctn where logical_disk_id = ?";
    private static final String INSERT_AGGREGATE = "insert into t_res_aggregate values(?,?)";

    public TResChunkCollection(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunkCollection.class.getName(), (String)"TResChunkCollection", (String)"dbc");
        }
        this.tableName = "t_res_chunk_cllctn";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunkCollection.class.getName(), (String)"TResChunkCollection");
        }
    }

    public void prepSelectByLogicalDisk() throws GeneralException {
        this.selectStmt = this.prepareStmt(FETCH_BY_LOGICAL_DISK);
    }

    public void prepSelectByFlexibleLogicalDisk() throws GeneralException {
        this.selectStmt = this.prepareStmt(FETCH_BY_FLEXIBLE_LOGICAL_DISK);
    }

    public ChunkCollection getCollections(LogicalDisk lDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunkCollection.class.getName(), (String)"getCollections", (String)"lDisk");
        }
        ChunkCollection colList = null;
        try {
            ChunkCollection col;
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, lDisk.ldID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while ((col = this.fetchCollection()) != null) {
                col.ccLogicalDiskID = lDisk.ldID;
                col.ccNext = colList;
                colList = col;
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResChunkCollection.class.getName(), (String)"getCollections", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        ChunkCollection traceResult = colList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunkCollection.class.getName(), (String)"getCollections", traceResult);
        }
        return traceResult;
    }

    private ChunkCollection fetchCollection() throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunkCollection.class.getName(), (String)"fetchCollection", (String)"");
        }
        if (!this.nextResult()) {
            ChunkCollection traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResChunkCollection.class.getName(), (String)"fetchCollection", traceResult);
            }
            return traceResult;
        }
        ChunkCollection col = new ChunkCollection();
        this.colIndex = 1;
        col.ccID = this.getInt(this.resultSet);
        col.ccSeqno = this.getShort(this.resultSet);
        col.ccType = this.getByte(this.resultSet);
        col.ccStripingSize = this.getInt(this.resultSet);
        ChunkCollection traceResult = col;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunkCollection.class.getName(), (String)"fetchCollection", (Object)traceResult);
        }
        return traceResult;
    }

    public void prepInsert() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT);
    }

    public void insertCollections(ChunkCollection colList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunkCollection.class.getName(), (String)"insertCollections", (String)"colList");
        }
        try {
            ChunkCollection col = colList;
            while (col != null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage((int)3, (String)TResChunkCollection.class.getName(), (String)"insertCollections", (String)(" Inserting collection: " + col));
                }
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.insertStmt, col.ccID);
                this.setInt(this.insertStmt, col.ccLogicalDiskID);
                this.setShort(this.insertStmt, col.ccSeqno);
                this.setByte(this.insertStmt, col.ccType);
                this.setInt(this.insertStmt, col.ccStripingSize);
                this.executeUpdate(this.insertStmt);
                this.dbc.commit();
                col = col.ccNext;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResChunkCollection.class.getName(), (String)"insertCollections", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunkCollection.class.getName(), (String)"insertCollections");
        }
    }

    public void insertAggregates(int ldID, int ccID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunkCollection.class.getName(), (String)"insertAggregates", (String)"ldID, ccID");
        }
        try {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage((int)3, (String)TResChunkCollection.class.getName(), (String)"insertAggregates", (String)(" Inserting Aggregate: " + ldID + "," + ccID));
            }
            PreparedStatement stmt = this.prepareStmt(INSERT_AGGREGATE);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(stmt, ldID);
            this.setInt(stmt, ccID);
            this.executeUpdate(stmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResChunkCollection.class.getName(), (String)"insertAggregates", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunkCollection.class.getName(), (String)"insertAggregates");
        }
    }

    public void prepDeleteByLogicalDisk() throws GeneralException {
        this.deleteStmt = this.prepareStmt(DELETE_BY_LOGICAL_DISK);
    }
}

