/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDiskArray;

public class TResController
extends StorageRepositoryAccessor {
    public TResComputer cmpAccessor = null;
    private boolean isStorageSubsystem = false;
    private static final String FETCH_BY_COMPUTER = "select controller_id, computer_id, instance_number, bus_number, wwn, driver_name, driver_description, target, controller_type, loop, adapter_pair, array from t_res_controller where computer_id = ?";
    private static final String FETCH_BY_SS = "select disk_group_id, subsystem_id, disk_group_number, width, -1, tag, description, raid_level, loop, da_pair_id, array from t_res_disk_group where subsystem_id = ?";
    private static final String FETCH_CTRLR_NAME_BY_STOREXT = "select C.name from t_res_disk_group C  where C.disk_group_id in (select E.controller_id from t_res_ext_ctrlr E where E.storext_id = ?) order by C.name";
    private static final String ORDER_BY_CLAUSE = " order by driver_name desc, instance_number desc, bus_number desc";
    private static final String DG_ORDER_BY_CLAUSE = " order by name desc, width desc";
    private static final String INSERT = "insert into t_res_controller (computer_id, controller_id, instance_number, bus_number, wwn, wwn_str, driver_name, driver_description, target, controller_type, loop, adapter_pair, array) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_DG = "insert into t_res_disk_group (subsystem_id, disk_group_id, width, name, description raid_level, loop, device_adapter1, array) values (?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE = "update t_res_controller set driver_description = ?, target = ?, controller_type = ?, wwn = ?, wwn_str = ?, loop = ?, adapter_pair = ?, array = ? where computer_id = ? and controller_id = ?";
    private static final String UPDATE_DG = "update t_res_disk_group set description = ?, raid_level = ?, loop = ?, device_adapter1 = ?, array = ? where subsystem_id = ? and disk_group_id = ?";
    private static final String DELETE_BY_ID = "delete from t_res_controller where computer_id = ? and controller_id=?";
    private static final String DELETE_BY_DG_ID = "delete from t_res_disk_group where subsystem_id = ? and disk_group_id=?";
    private static final String DELETE_BY_COMPUTER = "delete from t_res_controller where and computer_id = ?";
    private static final String DELETE_DG_BY_COMPUTER = "delete from t_res_disk_group where and subsystem_id = ?";

    public TResController(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResController.class.getName(), (String)"TResController", (String)"dbc");
        }
        this.tableName = "t_res_controller";
        this.cmpAccessor = new TResComputer(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResController.class.getName(), (String)"TResController");
        }
    }

    public Controller getControllers(int computerID, short qualifier) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResController.class.getName(), (String)"getControllers", (String)"computerID, qualifier");
        }
        Controller ctlrList = null;
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(computerID);
        StringBuffer buf = new StringBuffer(400);
        if (!this.isStorageSubsystem) {
            buf.append(FETCH_BY_COMPUTER);
            if (qualifier != 0) {
                buf.append(" and controller_type ");
                if (qualifier > 0) {
                    buf.append("= ");
                } else {
                    buf.append("<> ");
                }
                buf.append(8);
            }
            buf.append(ORDER_BY_CLAUSE);
        } else {
            buf.append(FETCH_BY_SS);
            buf.append(DG_ORDER_BY_CLAUSE);
        }
        String sqlText = buf.toString();
        buf = null;
        try {
            this.selectStmt = this.prepareStmt(sqlText);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, computerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                Controller ctlr = new Controller();
                this.fetchController(ctlr);
                ctlr.ctlrNext = ctlrList;
                ctlrList = ctlr;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResController.class.getName(), (String)"getControllers", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Controller traceResult = ctlrList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResController.class.getName(), (String)"getControllers", traceResult);
        }
        return traceResult;
    }

    public Controller getControllers(int computerID) throws GeneralException {
        return this.getControllers(computerID, (short)0);
    }

    private void fetchController(Controller ctlr) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResController.class.getName(), (String)"fetchController", (String)"ctlr");
        }
        this.colIndex = 1;
        ctlr.ctlrID = this.getInt(this.resultSet);
        ctlr.ctlrComputerID = this.getInt(this.resultSet);
        ctlr.ctlrInstance = this.getShort(this.resultSet);
        if (this.isStorageSubsystem) {
            this.getShort(this.resultSet);
            TResDiskArray ssAccessor = new TResDiskArray(this.dbc);
            ctlr.ctlrBusNumber = (short)ssAccessor.getNumOfDiskGroupDisks(ctlr.ctlrID);
        } else {
            ctlr.ctlrBusNumber = this.getShort(this.resultSet);
        }
        ctlr.ctlrHBAPortWWN = this.getLong(this.resultSet);
        ctlr.ctlrDriverName = this.getString(this.resultSet);
        ctlr.ctlrDriverDescription = this.getString(this.resultSet);
        if (this.isStorageSubsystem) {
            ctlr.ctlrTarget = this.getDiskGroupRAIDLevel(this.getString(this.resultSet));
            ctlr.ctlrType = (short)7;
        } else {
            ctlr.ctlrTarget = this.getShort(this.resultSet);
            ctlr.ctlrType = this.getShort(this.resultSet);
        }
        ctlr.ctlrLoop = this.getString(this.resultSet);
        ctlr.ctlrAdapterPair = this.isStorageSubsystem ? new Integer(this.getInt(this.resultSet)).toString() : this.getString(this.resultSet);
        ctlr.ctlrArray = this.getString(this.resultSet);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResController.class.getName(), (String)"fetchController");
        }
    }

    public String getControllerNames(int rankID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResController.class.getName(), (String)"getControllerNames", (String)"rankID");
        }
        StringBuffer ret = new StringBuffer(20);
        StringBuffer buf = new StringBuffer(400);
        buf.append(FETCH_CTRLR_NAME_BY_STOREXT);
        String sqlText = buf.toString();
        buf = null;
        try {
            this.selectStmt = this.prepareStmt(sqlText);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, rankID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult()) {
                this.colIndex = 1;
                ret.append(this.getString(this.resultSet));
            }
            while (this.nextResult()) {
                this.colIndex = 1;
                ret.append(new String(", "));
                ret.append(this.getString(this.resultSet));
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResController.class.getName(), (String)"getControllerNames", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        String traceResult = ret.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResController.class.getName(), (String)"getControllerNames", (Object)traceResult);
        }
        return traceResult;
    }

    public void insertControllers(int computerID, Controller ctlrList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResController.class.getName(), (String)"insertControllers", (String)"ctlrList");
        }
        int identifierCount = 0;
        String wwn_str = "";
        try {
            Controller ctlr = ctlrList;
            while (ctlr != null) {
                ++identifierCount;
                ctlr = ctlr.ctlrNext;
            }
            int identifier = TResController.getIdentifier(1, identifierCount, this.dbc);
            this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(computerID);
            this.insertStmt = this.isStorageSubsystem ? this.prepareStmt(INSERT_DG) : this.prepareStmt(INSERT);
            ctlr = ctlrList;
            while (ctlr != null) {
                ctlr.ctlrID = identifier++;
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.insertStmt, ctlr.ctlrComputerID);
                this.setInt(this.insertStmt, ctlr.ctlrID);
                if (!this.isStorageSubsystem) {
                    this.setShort(this.insertStmt, ctlr.ctlrInstance);
                }
                this.setShort(this.insertStmt, ctlr.ctlrBusNumber);
                if (!this.isStorageSubsystem) {
                    if (ctlr.ctlrHBAPortWWN != 0L) {
                        wwn_str = Long.toHexString(ctlr.ctlrHBAPortWWN);
                        wwn_str = wwn_str.toUpperCase();
                    } else {
                        wwn_str = "0";
                    }
                    this.setLong(this.insertStmt, ctlr.ctlrHBAPortWWN);
                    this.setString(this.insertStmt, wwn_str);
                }
                this.setString(this.insertStmt, ctlr.ctlrDriverName);
                this.setString(this.insertStmt, ctlr.ctlrDriverDescription);
                this.setShort(this.insertStmt, ctlr.ctlrTarget);
                if (!this.isStorageSubsystem) {
                    this.setShort(this.insertStmt, ctlr.ctlrType);
                }
                this.setString(this.insertStmt, ctlr.ctlrLoop);
                this.setString(this.insertStmt, ctlr.ctlrAdapterPair);
                this.setString(this.insertStmt, ctlr.ctlrArray);
                this.executeUpdate(this.insertStmt);
                this.dbc.commit();
                ctlr = ctlr.ctlrNext;
            }
            this.closeInsert();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResController.class.getName(), (String)"insertControllers", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResController.class.getName(), (String)"insertControllers");
        }
    }

    private short getDiskGroupRAIDLevel(String raidLevel) {
        int result = 11;
        if ("raid5".equalsIgnoreCase(raidLevel)) {
            result = 0;
        } else if ("raid10".equalsIgnoreCase(raidLevel)) {
            result = 1;
        } else if ("jbod".equalsIgnoreCase(raidLevel)) {
            result = 2;
        } else if ("raid0".equalsIgnoreCase(raidLevel)) {
            result = 3;
        } else if ("raid1".equalsIgnoreCase(raidLevel)) {
            result = 4;
        } else if ("raid2".equalsIgnoreCase(raidLevel)) {
            result = 5;
        } else if ("raid3".equalsIgnoreCase(raidLevel)) {
            result = 6;
        } else if ("raid4".equalsIgnoreCase(raidLevel)) {
            result = 7;
        } else if ("raid6".equalsIgnoreCase(raidLevel)) {
            result = 8;
        } else if ("raid51".equalsIgnoreCase(raidLevel)) {
            result = 9;
        } else if ("raid15".equalsIgnoreCase(raidLevel)) {
            result = 9;
        }
        return (short)result;
    }

    public void updateControllers(int computerID, Controller ctlrList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResController.class.getName(), (String)"updateControllers", (String)"ctlrList");
        }
        String wwn_str = "";
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(computerID);
        this.updateStmt = this.isStorageSubsystem ? this.prepareStmt(UPDATE_DG) : this.prepareStmt(UPDATE);
        try {
            Controller ctlr = ctlrList;
            while (ctlr != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setString(this.updateStmt, ctlr.ctlrDriverDescription);
                this.setShort(this.updateStmt, ctlr.ctlrTarget);
                if (!this.isStorageSubsystem) {
                    if (ctlr.ctlrHBAPortWWN != 0L) {
                        wwn_str = Long.toHexString(ctlr.ctlrHBAPortWWN);
                        wwn_str = wwn_str.toUpperCase();
                    } else {
                        wwn_str = "0";
                    }
                    this.setShort(this.updateStmt, ctlr.ctlrType);
                    this.setLong(this.updateStmt, ctlr.ctlrHBAPortWWN);
                    this.setString(this.updateStmt, wwn_str);
                }
                this.setString(this.updateStmt, ctlr.ctlrLoop);
                this.setString(this.updateStmt, ctlr.ctlrAdapterPair);
                this.setString(this.updateStmt, ctlr.ctlrArray);
                this.setInt(this.updateStmt, ctlr.ctlrComputerID);
                this.setInt(this.updateStmt, ctlr.ctlrID);
                this.executeUpdate(this.updateStmt);
                this.dbc.commit();
                ctlr = ctlr.ctlrNext;
            }
            this.closeUpdate();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResController.class.getName(), (String)"updateControllers", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResController.class.getName(), (String)"updateControllers");
        }
    }

    public void deleteControllers(int computerID, Controller ctlrList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResController.class.getName(), (String)"deleteControllers", (String)"ctlrList");
        }
        try {
            this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(computerID);
            this.deleteStmt = this.isStorageSubsystem ? this.prepareStmt(DELETE_BY_DG_ID) : this.prepareStmt(DELETE_BY_ID);
            Controller ctlr = ctlrList;
            while (ctlr != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.deleteStmt, ctlr.ctlrComputerID);
                this.setInt(this.deleteStmt, ctlr.ctlrID);
                this.executeUpdate(this.deleteStmt);
                this.dbc.commit();
                ctlr = ctlr.ctlrNext;
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResController.class.getName(), (String)"deleteControllers", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResController.class.getName(), (String)"deleteControllers");
        }
    }
}

