/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TResLdapTree
extends RepositoryAccessor {
    public static final String TABLE_NAME = "t_res_ldap_tree";
    public static final String ID_COLUMN = "tree_id";
    private static final String SELECT_ID = "select tree_id from t_res_ldap_tree where name = ?";
    private static final String SELECT = "select t.tree_id, t.name, t.computer_id, p.user_name, p.pwd from t_res_ldap_tree t, t_res_pwd p where t.tree_id = p.resource_id";
    private static final String SELECT_NAME = "select name from t_res_ldap_tree where id = ?";
    private static final String WHERE_COMPUTER_EQUALS = " and t.computer_id = ";
    private static final String WHERE_NAME_EQUALS = " and t.name = ?";
    private static final String GUI_SELECT1 = "select t.tree_id, t.name, t.computer_id, p.user_name, p.pwd from t_res_ldap_tree t, t_res_pwd p where t.tree_id = p.resource_id union all ";
    private static final String GUI_SELECT2 = " select tt.tree_id, tt.name, tt.computer_id, ' ', ' '";
    private static final String GUI_SELECT_FROM = " from t_res_ldap_tree tt where not exists (select pp.resource_id from t_res_pwd pp where pp.resource_id = tt.tree_id)";
    private static final String INSERT = "insert into t_res_ldap_tree (tree_id, name, computer_id) values (?,?,?)";
    private static final String SELECT_NOVELL_PROBE_AGENT = "select t.computer_id from t_res_ldap_tree t, t_stat_computer c, t_res_domain d where c.computer_id = ? and c.domain_id = d.domain_id and d.tree_id = t.tree_id";
    private static final String UPDATE_COMPUTER_ID = "update t_res_ldap_tree set computer_id = ? where tree_id = ? and computer_id = ?";
    private static final String UPDATE_GUI_ID = "update t_res_ldap_tree set computer_id = ? where tree_id = ?";

    public TResLdapTree(Connection dbc) {
        super(dbc);
        this.tableName = TABLE_NAME;
    }

    public LdapTree getTrees(int computerID) throws GeneralException {
        String sqlText;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLdapTree.class.getName(), (String)"getTrees", (String)"computerID");
        }
        LdapTree treeList = null;
        if (computerID > 0) {
            sqlText = "select t.tree_id, t.name, t.computer_id, p.user_name, p.pwd from t_res_ldap_tree t, t_res_pwd p where t.tree_id = p.resource_id and t.computer_id = " + computerID;
        } else {
            sqlText = GUI_SELECT1;
            sqlText = sqlText + GUI_SELECT2;
            sqlText = sqlText + GUI_SELECT_FROM;
        }
        try {
            this.selectStmt = this.prepareStmt(sqlText);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.resultSet.next()) {
                LdapTree ldapTree = this.fetchTree();
                ldapTree.ltNext = treeList;
                treeList = ldapTree;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLdapTree.class.getName(), (String)"getTrees", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        LdapTree traceResult = treeList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"getTrees", traceResult);
        }
        return traceResult;
    }

    private LdapTree fetchTree() throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLdapTree.class.getName(), (String)"fetchTree", (String)"");
        }
        this.getPhase();
        LdapTree ldapTree = new LdapTree();
        ldapTree.ltTreeID = this.getInt(this.resultSet);
        ldapTree.setLtName(this.getString(this.resultSet));
        ldapTree.ltComputerID = this.getInt(this.resultSet);
        ldapTree.ltLdapUser = this.getString(this.resultSet);
        ldapTree.ltPassword = this.getString(this.resultSet);
        LdapTree traceResult = ldapTree;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"fetchTree", (Object)traceResult);
        }
        return traceResult;
    }

    public LdapTree[] getPackedTree() throws GeneralException {
        return LdapTree.pack((LdapTree)this.getTrees(-1));
    }

    public void prepGetByName() throws GeneralException {
        this.selectStmt = this.prepareStmt("select t.tree_id, t.name, t.computer_id, p.user_name, p.pwd from t_res_ldap_tree t, t_res_pwd p where t.tree_id = p.resource_id and t.name = ?");
    }

    public LdapTree getByName(String treeName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLdapTree.class.getName(), (String)"getByName", (String)"treeName");
        }
        try {
            this.setPhase();
            this.setString(this.selectStmt, treeName);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                LdapTree traceResult = this.fetchTree();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"getByName", (Object)traceResult);
                }
                return traceResult;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLdapTree.class.getName(), (String)"getByName", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        LdapTree traceResult = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"getByName", traceResult);
        }
        return traceResult;
    }

    public void prepGetTreeID() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_ID);
    }

    public int getTreeID(String treeName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLdapTree.class.getName(), (String)"getTreeID", (String)"treeName");
        }
        try {
            this.setPhase();
            this.setString(this.selectStmt, treeName);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.resultSet.next()) {
                this.getPhase();
                int traceResult = this.getInt(this.resultSet);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"getTreeID", (int)traceResult);
                }
                return traceResult;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLdapTree.class.getName(), (String)"getTreeID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        int traceResult = -1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"getTreeID", (int)traceResult);
        }
        return traceResult;
    }

    public void prepGetProbeAgent() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_NOVELL_PROBE_AGENT);
    }

    public int getProbeAgent(int filerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLdapTree.class.getName(), (String)"getProbeAgent", (String)"filerID");
        }
        try {
            this.setPhase();
            this.setInt(this.selectStmt, filerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                this.getPhase();
                int traceResult = this.getInt(this.resultSet);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"getProbeAgent", (int)traceResult);
                }
                return traceResult;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLdapTree.class.getName(), (String)"getProbeAgent", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        int traceResult = -1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"getProbeAgent", (int)traceResult);
        }
        return traceResult;
    }

    public void prepFetchByID() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_NAME);
    }

    public String fetchByID(int treeID, boolean failFriendly) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLdapTree.class.getName(), (String)"fetchByID", (String)"treeID, failFriendly");
        }
        String result = null;
        this.setPhase();
        try {
            this.setInt(this.selectStmt, treeID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.getPhase();
                result = this.getString(this.resultSet);
            } else if (failFriendly) {
                result = "? (" + treeID + ")";
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLdapTree.class.getName(), (String)"fetchByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"fetchByID", traceResult);
        }
        return traceResult;
    }

    public String fetchByID(int treeID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLdapTree.class.getName(), (String)"fetchByID", (String)"treeID");
        }
        String traceResult = this.fetchByID(treeID, true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"fetchByID", (Object)traceResult);
        }
        return traceResult;
    }

    public void save(LdapTree treeList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLdapTree.class.getName(), (String)"save", (String)"treeList");
        }
        if (treeList == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"save");
            }
            return;
        }
        int insertCount = 0;
        this.prepGetTreeID();
        LdapTree tree = treeList;
        while (tree != null) {
            tree.ltTreeID = this.getTreeID(tree.getTrueLtName());
            if (tree.ltTreeID == -1) {
                ++insertCount;
            }
            tree = tree.ltNext;
        }
        if (insertCount > 0) {
            int id = StorageRepositoryAccessor.getIdentifier(1, insertCount, this.dbc);
            this.insertStmt = this.prepareStmt(INSERT);
            LdapTree tree2 = treeList;
            while (tree2 != null) {
                if (tree2.ltTreeID == -1) {
                    tree2.ltTreeID = id++;
                    if (!this.insert(tree2)) {
                        tree2.ltTreeID = this.getTreeID(tree2.getTrueLtName());
                    }
                }
                tree2 = tree2.ltNext;
            }
            this.closeInsert();
        }
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"save");
        }
    }

    private boolean insert(LdapTree tree) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLdapTree.class.getName(), (String)"insert", (String)"tree");
        }
        try {
            this.setPhase();
            this.setInt(this.insertStmt, tree.ltTreeID);
            this.setString(this.insertStmt, tree.getTrueLtName());
            this.setInt(this.insertStmt, tree.ltComputerID);
            this.executeUpdate(this.insertStmt);
            this.dbc.commit();
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"insert", (boolean)traceResult);
            }
            return traceResult;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLdapTree.class.getName(), (String)"insert", (Throwable)e);
            }
            if (!SQLUtil.isDuplicateKeyViolation(e)) {
                this.stmtType = 1;
                this.sqlError(e);
            }
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"insert", (boolean)traceResult);
            }
            return traceResult;
        }
    }

    public void updateComputerID(int treeID, int computerID, int oldComputerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLdapTree.class.getName(), (String)"updateComputerID", (String)"treeID, computerID, oldComputerID");
        }
        this.updateStmt = this.prepareStmt(UPDATE_COMPUTER_ID);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.updateStmt, computerID);
            this.setInt(this.updateStmt, treeID);
            this.setInt(this.updateStmt, oldComputerID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLdapTree.class.getName(), (String)"updateComputerID", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.commit();
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"updateComputerID");
        }
    }

    public void updateGuiID(int treeID, int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLdapTree.class.getName(), (String)"updateGuiID", (String)"treeID, computerID");
        }
        this.updateStmt = this.prepareStmt(UPDATE_GUI_ID);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.updateStmt, computerID);
            this.setInt(this.updateStmt, treeID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLdapTree.class.getName(), (String)"updateGuiID", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLdapTree.class.getName(), (String)"updateGuiID");
        }
    }
}

