/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Attribute;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.sql.SqlAttributeLibraries;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeLibraryTable;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResLibraries
implements NameListQueryable {
    public static String LIBRARIES_NAMES = "SELECT CASE WHEN (TapeLibrary.DISPLAY_NAME <> '' AND TapeLibrary.DISPLAY_NAME is not null) THEN TapeLibrary.DISPLAY_NAME END AS LABEL, TAPE_LIBRARY_ID FROM T_RES_TAPE_LIBRARY TapeLibrary";
    public static String LIBRARIES_NAMES_BY_GROUPID = "SELECT CASE WHEN (TapeLibrary.DISPLAY_NAME <> '' AND TapeLibrary.DISPLAY_NAME is not null) THEN TapeLibrary.DISPLAY_NAME END AS LABEL, TAPE_LIBRARY_ID FROM T_RES_TAPE_LIBRARY TapeLibrary WHERE TapeLibrary.GROUP_ID =?";
    public static String LibrariesByScheduleID = "SELECT DISTINCT d.tape_library_id, a.exclude FROM t_res_tape_library d, t_res_attribute a WHERE a.attribute_id=? AND (d.tape_library_id = a.resource_id  OR d.group_id = a.resource_id OR resource_type = " + Short.toString((short)135) + ")";

    private DBConnection getConnection() throws GeneralException {
        DBConnection dbConn;
        block6: {
            dbConn = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)TResLibraries.class.getName(), (String)"getConnection", (String)"");
            }
            try {
                DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
                dbConn = (DBConnection)ds.getPooledConnection();
            }
            catch (SQLException sqlEx) {
                MessageLog.logException((String)"STS0920E", (Exception)sqlEx);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResLibraries.class.getName(), (String)"getConnection", (Object)sqlEx);
                }
                throw new GeneralException(sqlEx.getMessage());
            }
            catch (NullPointerException nullEx) {
                MessageLog.logException((String)"STS0920E", (Exception)nullEx);
                if (!TraceLogger.enableTrace) break block6;
                TraceLogger.exit((String)TResLibraries.class.getName(), (String)"getConnection", (Object)nullEx);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLibraries.class.getName(), (String)"getConnection");
        }
        return dbConn;
    }

    public NameList getLibrariesList(GuiListReq glr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLibraries.class.getName(), (String)"getLibrariesList", (String)"");
        }
        DBConnection connection = this.getConnection();
        DBResultSet rs = null;
        NameList list = null;
        try {
            if (glr.groupID > 0) {
                Hashtable<ColumnInfo, String> whereClause = new Hashtable<ColumnInfo, String>();
                whereClause.put(TapeLibrary.getColumnInfo((String)"GROUP_ID"), Integer.toString(glr.groupID));
                rs = ComplexQuery.sqlQuery((DBConnection)connection, (String)LIBRARIES_NAMES_BY_GROUPID, whereClause);
            } else {
                rs = ComplexQuery.sqlQuery((DBConnection)connection, (String)LIBRARIES_NAMES, null);
            }
            NameList item = new NameList();
            if (rs != null) {
                while (rs.next()) {
                    item = new NameList();
                    item.nlName = rs.getString(1);
                    item.nlID = rs.getInt(2);
                    item.nlInfo = (short)134;
                    item.nlNext = list;
                    list = item;
                }
            }
        }
        catch (SQLException eDB) {
            MessageLog.logException((String)"STS0929E", (Exception)eDB);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResLibraries.class.getName(), (String)"getLibrariesList", (Object)eDB);
            }
            throw new GeneralException(eDB.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.getStatement().close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sqlEx) {
                MessageLog.logException((String)"STS0921E", (Exception)sqlEx);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResLibraries.class.getName(), (String)"getLibrariesList", (Object)sqlEx);
                }
                throw new GeneralException(sqlEx.getMessage());
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLibraries.class.getName(), (String)"getLibrariesList", list);
        }
        return list;
    }

    public NameList getLibrariesTiedTo(int scheduleID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLibraries.class.getName(), (String)"getLibrariesTiedTo", (String)"");
        }
        DBConnection connection = null;
        DBResultSet rs = null;
        Object list = null;
        NameList head = null;
        try {
            connection = this.getConnection();
            Hashtable<ColumnInfo, String> whereClasue = new Hashtable<ColumnInfo, String>();
            whereClasue.put(Attribute.getColumnInfo((String)"ATTRIBUTE_ID"), Integer.toString(scheduleID));
            rs = ComplexQuery.sqlQuery((DBConnection)connection, (String)LibrariesByScheduleID, whereClasue);
            NameList item = null;
            while (rs.next()) {
                int librariesID = rs.getInt(1);
                boolean excluded = rs.getBoolean(2);
                if (excluded) continue;
                item = new NameList();
                item.nlID = librariesID;
                item.nlInfo = (short)134;
                item.nlID2 = 0;
                item.nlNext = head;
                head = item;
            }
        }
        catch (SQLException eDB) {
            MessageLog.logException((String)"STS0930E", (Exception)eDB);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResLibraries.class.getName(), (String)"getLibrariesTiedTo", (Object)eDB);
            }
            throw new GeneralException(eDB.toString());
        }
        finally {
            try {
                if (rs != null) {
                    rs.getStatement().close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new GeneralException(e.toString());
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLibraries.class.getName(), (String)"getLibrariesTiedTo", (Object)"");
        }
        return head;
    }

    public NameList selectNames(GuiListReq req) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLibraries.class.getName(), (String)"selectNames", (String)"req");
        }
        DBConnection connection = null;
        TapeLibrary.TapeLibraryCursor cursor = null;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        NameList list = null;
        try {
            TapeLibrary lib = null;
            NameList item = null;
            connection = this.getConnection();
            htWhereClause.put(TResTapeLibraryTable.getColumnInfo((String)"GROUP_ID"), Integer.toString(req.groupID));
            cursor = TapeLibrary.getCursor((DBConnection)connection, htWhereClause, null);
            while (cursor.next()) {
                lib = cursor.getAttributes();
                item = new NameList();
                item.nlName = lib.getName();
                item.nlID = lib.getTapeLibraryId();
                item.nlInfo = (short)134;
                item.nlName2 = lib.getElementName();
                item.nlNext = list;
                list = item;
            }
        }
        catch (SQLException eDB) {
            MessageLog.logException((String)"STS0931E", (Exception)eDB);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResLibraries.class.getName(), (String)"selectNames", (Object)eDB);
            }
            throw new GeneralException(eDB.getMessage());
        }
        finally {
            try {
                if (cursor != null) {
                    cursor.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sqlEx) {
                MessageLog.logException((String)"STS0921E", (Exception)sqlEx);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResLibraries.class.getName(), (String)"selectNames", (Object)sqlEx);
                }
                throw new GeneralException(sqlEx.getMessage());
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLibraries.class.getName(), (String)"selectNames", list);
        }
        return list;
    }

    public NameList queryDependents(int attributeID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLibraries.class.getName(), (String)"queryDependents", (String)"attributeID");
        }
        DBConnection connection = null;
        NameList list = null;
        DBResultSet dbr = null;
        NameList item = null;
        Hashtable<ColumnInfo, String> parms = new Hashtable<ColumnInfo, String>();
        parms.put(Attribute.getColumnInfo((String)"ATTRIBUTE_ID"), Integer.toString(attributeID));
        try {
            connection = this.getConnection();
            dbr = SqlAttributeLibraries.sqlQuery((DBConnection)connection, (int)SqlAttributeLibraries.allLibrariesDependentsQueryIndex, parms);
            while (dbr.next()) {
                item = new NameList();
                item.nlID = dbr.getInt(1);
                item.nlName = dbr.getString(2);
                item.nlInfo = (short)134;
                if (dbr.getBoolean(3)) {
                    item.nlState = 1;
                }
                item.nlNext = list;
                list = item;
            }
        }
        catch (SQLException eDB) {
            MessageLog.logException((String)"STS0932E", (Exception)eDB);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResLibraries.class.getName(), (String)"queryDependents");
            }
            throw new GeneralException(eDB.getMessage());
        }
        finally {
            try {
                if (dbr != null) {
                    dbr.getStatement().close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sqlEx) {
                MessageLog.logException((String)"STS0921E", (Exception)sqlEx);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResLibraries.class.getName(), (String)"queryDependants", (Object)sqlEx);
                }
                throw new GeneralException(sqlEx.getMessage());
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLibraries.class.getName(), (String)"queryDependents", list);
        }
        return list;
    }
}

