/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TStatDisk;

public class TResLogicalDisk
extends StorageRepositoryAccessor {
    PreparedStatement selectMirrorsStmt;
    private boolean useSetShort = false;
    private boolean isSV = false;
    public static final String CAPACITY_COLUMN = "capacity";
    public static final String ID_COLUMN = "logical_disk_id";
    public static final String SV_ID_COLUMN = "svid";
    public static final String COLUMNS = " logical_disk_id, parent_logdisk_id, logical_disk_type, capacity, use_count, mirror_count, is_swap, snap_source_id, is_vcmdb, replication_mode, not_exposed, overhead, volgroup_id, lun_identity, ssraidl, storage_type";
    public static final String SV_COLUMNS = " v.svid, v.pool_id, v.logical_disk_type, v.capacity,  v.use_count, v.mirror_count, v.is_swap, v.snap_source_id,  v.is_vcmdb, v.replication_mode, v.not_exposed, v.overhead,  v.pool_id, v.lun_identity, -1, v.format, v.display_name, v.name,  v.package_redundancy, v.data_redundancy, v.is_assigned,  cimv.device_id ";
    private static final String FETCH_ALL = "select logical_disk_id, parent_logdisk_id, logical_disk_type, capacity, use_count, mirror_count, is_swap, snap_source_id, is_vcmdb, replication_mode, not_exposed, overhead, volgroup_id, lun_identity, ssraidl, storage_type from t_res_logical_disk";
    private static final String FETCH_ALL_SV = "select  v.svid, v.pool_id, v.logical_disk_type, v.capacity,  v.use_count, v.mirror_count, v.is_swap, v.snap_source_id,  v.is_vcmdb, v.replication_mode, v.not_exposed, v.overhead,  v.pool_id, v.lun_identity, -1, v.format, v.display_name, v.name,  v.package_redundancy, v.data_redundancy, v.is_assigned,  cimv.device_id  from t_res_storage_volume v, t_res_cimkey_volume cimv ";
    private static final String BY_ID = " where logical_disk_id = ?";
    private static final String BY_SV_ID = " where svid = ?  and  v.svid = cimv.volume_id ";
    private static final String BY_PARENT = " where parent_logdisk_id = ? order by logical_disk_id";
    private static final String SELECT_BY_COMPUTERID1 = "select f.logical_disk_id, f.mount_point, f.filesystem_id, ''  from t_res_filesystem f where f.computer_id = ? ";
    private static final String SELECT_BY_COMPUTERID2 = "union all select l.logical_disk_id, s.path, -1, s.name  from t_res_share s, t_res_logical_disk l where s.computer_id = ?   and s.resource_type = 11   and s.resource_id = l.logical_disk_id   and l.parent_logdisk_id = -1   and l.logical_disk_id not in  (select logical_disk_id from t_res_filesystem ff  where ff.computer_id = ?) ";
    private static final String SELECT_BY_SS_COMPUTERID = " select distinct  l.svid, l.display_name, -1, l.name, cimv.device_id  from  t_res_storage_volume l, t_res_cimkey_volume cimv  where subsystem_id = ? and l.svid = cimv.volume_id ";
    private static final String BY_VOLGROUP_CLAUSE1 = " and   ( (f.logical_disk_id in           (select logical_disk_id from t_res_logical_disk z             where z.volgroup_id = ?))       or (f.logical_disk_id in           (select parent_logdisk_id from t_res_logical_disk z             where z.volgroup_id = ?)  )) ";
    private static final String BY_VOLGROUP_CLAUSE2 = " and l.volgroup_id = ? ";
    private static final String BY_SP_CLAUSE = " and l.pool_id = ? ";
    private static final String BY_COMPUTERID_ORDER = " order by 2, 3 desc";
    private static final String SELECT_BY_SVC_SS_DISKID = " select distinct vdisk.svid, vdisk.display_name, -1, vdisk.name, cimv.device_id\tfrom t_res_storage_volume vdisk,      t_res_storage_pool mdiskgrp,      t_res_storage_extent mdisk,      t_res_cimkey_volume cimv\twhere vdisk.pool_id = mdiskgrp.pool_id and   mdiskgrp.pool_id = mdisk.pool_id and   vdisk.svid = cimv.volume_id  and   mdisk.storage_extent_id = ?";
    private static final String SELECT_BY_SS_DISKID = " (select distinct sv.svid, sv.display_name, -1, sv.name, cimv.device_id from \tt_res_storage_volume sv,       t_res_volume2extent vte,       t_res_physicalvolume2extent pvte,       t_res_cimkey_volume cimv where sv.svid = vte.volume_id and   vte.storage_extent_id = pvte.storage_extent_id and   sv.svid = cimv.volume_id and   pvte.physical_volume_id = ?) UNION (select sv.svid, sv.display_name, -1, sv.name, sv.name  from t_res_chunk c, t_res_storage_volume sv  where c.disk_id = ?  and c.logical_disk_id = sv.svid and c.disk_id not in      (select physical_volume_id       from t_res_physicalvolume2extent      where physical_volume_id = ?)      ) order by 2 ";
    private static final String ORDER_BY_DISPLAY_NAME = " order by 2";
    private static final String SELECT_BY_DISKID = "select distinct f.logical_disk_id, f.mount_point, f.filesystem_id, ''  from t_res_chunk c, t_res_filesystem f where c.disk_id = ?   and c.logical_disk_id = f.logical_disk_id union all select distinct f.logical_disk_id, f.mount_point, f.filesystem_id, ''  from t_res_chunk c, t_res_filesystem f, t_res_logical_disk l where c.disk_id = ?   and c.logical_disk_id = l.logical_disk_id    and l.parent_logdisk_id > 0    and l.parent_logdisk_id = f.logical_disk_id union all select distinct c.logical_disk_id, s.path, -1, s.name  from t_res_chunk c, t_res_share s, t_res_logical_disk l where c.disk_id = ?   and c.logical_disk_id = s.resource_id   and c.logical_disk_id = l.logical_disk_id   and l.parent_logdisk_id = -1   and l.logical_disk_id not in  (select logical_disk_id from t_res_filesystem) union all select distinct l.parent_logdisk_id, s.path, -1, s.name  from t_res_chunk c, t_res_share s, t_res_logical_disk l where c.disk_id = ?   and c.logical_disk_id = l.logical_disk_id   and l.parent_logdisk_id = s.resource_id   and l.parent_logdisk_id <> -1   and l.parent_logdisk_id not in  (select logical_disk_id from t_res_filesystem) order by 3, 2 desc";
    private static final String SELECT_LUN_HOST_PATHS = "select distinct c.host_name, c.os_type, a.path  from  t_res_host c  , t_res_dev_access a  , t_res_physical_volume pv  , t_res_view_ssluncmp ssluncmp  where ssluncmp.svid = ?  and ssluncmp.computer_id = c.computer_id  and ssluncmp.physical_volume_id = a.device_id ";
    private static final String INSERT = "insert into t_res_logical_disk (logical_disk_id, parent_logdisk_id, logical_disk_type, capacity, use_count, mirror_count, is_swap, snap_source_id, is_vcmdb, replication_mode, not_exposed, overhead, volgroup_id, lun_identity, ssraidl, storage_type) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_SV = "insert into t_res_storage_volume (svid,  logical_disk_type, capacity, use_count, mirror_count, is_swap, snap_source_id, is_vcmdb, replication_mode, not_exposed, overhead, pool_id, lun_identity, ssraidl, storage_type) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String DELETE_BY_ID = "delete from t_res_logical_disk where logical_disk_id = ? or parent_logdisk_id = ?";
    private static final String DELETE_BY_SVID = "delete from t_res_storage_volume where svid = ?";
    private static final String UPDATE_USE_COUNT = "update t_res_logical_disk set use_count = ? where logical_disk_id = ?";
    private static final String UPDATE_SV_USE_COUNT = "update t_res_storage_volume set use_count = ? where svid = ?";
    private static final String UPDATE_ATTRIBUTES = "update t_res_logical_disk set use_count = ?, snap_source_id = ?, is_vcmdb = ?, replication_mode = ?, not_exposed = ?, volgroup_id = ?, ssraidl = ?, storage_type = ? where logical_disk_id = ?";
    private static final String UPDATE_SV_ATTRIBUTES = "update t_res_storage_volume set use_count = ?, snap_source_id = ?, is_vcmdb = ?, replication_mode = ?, not_exposed = ?, pool_id = ?, ssraidl = ?, storage_type = ? where svid = ?";
    private static final String SELECT_USE_COUNT = "select use_count from t_res_logical_disk where logical_disk_id = ?";
    private static final String SELECT_SV_CAPACITY = "select capacity from t_res_storage_volume where svid = ?";
    private static final String UPDATE_LUN_IDENTITY = "update t_res_storage_volume set lun_identity = ? where svid = ?";
    private static final String SELECT_SS_TYPE_FOR_LOGICAL_DISK = "select ss.os_type from t_res_storage_volume sv, t_res_storage_subsystem ss where sv.subsystem_id = ss.subsystem_id and svid = ?";
    private static final String SELECT_SS_LUNS = "select svid, vdisk_type, capacity from t_res_storage_volume where pool_id = ?";
    private static final String UPDATE_SVID_TYPE = "update t_res_storage_volume set logical_disk_type = ? where svid = ?";
    private static final String UPDATE_SS_SVID_TYPE = "update t_res_storage_volume set logical_disk_type = ? where subsystem_id = ?";
    private static final String GET_MDISKS_FOR_VDISK = " select storage_extent_id, total_num_extents from  t_res_storage_volume vol, t_res_volume2extent vte where vol.svid = vte.volume_id and vol.svid = ?";

    public TResLogicalDisk(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"TResLogicalDisk", (String)"dbc");
        }
        this.tableName = "t_res_logical_disk";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"TResLogicalDisk");
        }
    }

    public void prepSelectByID() throws GeneralException {
        this.selectStmt = this.prepareStmt("select logical_disk_id, parent_logdisk_id, logical_disk_type, capacity, use_count, mirror_count, is_swap, snap_source_id, is_vcmdb, replication_mode, not_exposed, overhead, volgroup_id, lun_identity, ssraidl, storage_type from t_res_logical_disk where logical_disk_id = ?");
    }

    public void prepSelectBySVID() throws GeneralException {
        this.selectStmt = this.prepareStmt("select  v.svid, v.pool_id, v.logical_disk_type, v.capacity,  v.use_count, v.mirror_count, v.is_swap, v.snap_source_id,  v.is_vcmdb, v.replication_mode, v.not_exposed, v.overhead,  v.pool_id, v.lun_identity, -1, v.format, v.display_name, v.name,  v.package_redundancy, v.data_redundancy, v.is_assigned,  cimv.device_id  from t_res_storage_volume v, t_res_cimkey_volume cimv  where svid = ?  and  v.svid = cimv.volume_id ");
    }

    public Share selectHostPaths(LogicalDisk ld) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"selectHostPaths", (String)"ld");
        }
        try {
            this.selectStmt = this.prepareStmt(SELECT_LUN_HOST_PATHS);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, ld.ldID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDisk.class.getName(), (String)"selectHostPaths", (Throwable)e);
            }
            this.stmtPhase = 3;
            this.sqlError(e);
        }
        Share head = null;
        this.stmtPhase = 1;
        while (this.nextResult()) {
            this.getPhase();
            try {
                Share sh = new Share();
                sh.shComputerName = this.getString(this.resultSet);
                sh.shResourceType = this.getShort(this.resultSet);
                sh.shPath = this.getString(this.resultSet);
                sh.shNext = head;
                head = sh;
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TStatDisk.class.getName(), (String)"selectHostPaths", (Throwable)e);
                }
                this.sqlError(e);
            }
        }
        this.closeSelect();
        this.closeResultSet();
        Share traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"selectHostPaths", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getSSTypeForLogicalDisk(int logical_disk_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResComputer.class.getName(), (String)"isStorageSubsystemLogicalDisk", (String)"id");
        }
        this.selectStmt = this.prepareStmt(SELECT_SS_TYPE_FOR_LOGICAL_DISK);
        short traceResult = -1;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, logical_disk_id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                traceResult = this.resultSet.getShort(1);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResComputer.class.getName(), (String)"isStorageSubsystemLogicalDisk", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResComputer.class.getName(), (String)"isStorageSubsystemLogicalDisk", (short)traceResult);
        }
        return traceResult;
    }

    public boolean getLogicalDisk(LogicalDisk ld, boolean isStorSys) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"getLogicalDisk", (String)"ld");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, ld.ldID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (!this.nextResult()) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"getLogicalDisk", (boolean)traceResult);
                }
                return traceResult;
            }
            this.stmtPhase = 1;
            this.fetchLogicalDisk(ld, this.resultSet, isStorSys);
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"getLogicalDisk", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"getLogicalDisk", (boolean)traceResult);
        }
        return traceResult;
    }

    public int fetchLogicalDisk(LogicalDisk ld, ResultSet rs, boolean isStorageSubsystem) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"fetchLogicalDisk", (String)"ld, rs");
        }
        this.colIndex = 1;
        ld.ldID = this.getInt(rs);
        ld.ldParentLogicalDiskID = this.getInt(rs);
        ld.ldType = this.getByte(rs);
        ld.ldCapacity = this.getLong(rs);
        ld.ldUseCount = this.getShort(rs);
        ld.ldMirrorCount = this.getByte(rs);
        ld.ldIsSwap = this.getBoolean(rs);
        ld.ldSnapSourceID = this.getInt(rs);
        boolean isVCMDB = this.getBoolean(rs);
        byte replicationMode = this.getByte(rs);
        boolean notExposed = this.getBoolean(rs);
        ld.setFlags((short)replicationMode, isVCMDB, notExposed);
        ld.ldOverhead = this.getLong(rs);
        ld.ldVolgroupID = this.getInt(rs);
        ld.lun_identity = this.getByte(rs);
        ld.ldRaid = this.getInt(rs);
        ld.ldStorageType = this.getShort(rs);
        if (isStorageSubsystem) {
            ld.ldStorageType = ld.ldStorageType == -1 ? (short)0 : ld.ldStorageType;
            ld.ldPath = this.getString(rs);
            ld.ldName = this.getString(rs);
            int raidLevel = 11;
            short pkgredundancy = this.getShort(rs);
            short dataredundancy = this.getShort(rs);
            if (dataredundancy == 1 && pkgredundancy == 0) {
                raidLevel = 3;
            } else if (dataredundancy == 1 && pkgredundancy == 1) {
                raidLevel = 0;
            } else if (dataredundancy > 1 && pkgredundancy == 1) {
                raidLevel = 1;
            } else if (dataredundancy > 1 && pkgredundancy > 1) {
                raidLevel = 9;
            } else if (dataredundancy == 1 && pkgredundancy > 1) {
                raidLevel = 8;
            }
            ld.ldRaid = raidLevel;
            short assigned = this.getShort(rs);
            boolean not_exposed = true;
            if (assigned > 0) {
                not_exposed = false;
            }
            ld.setFlags((short)replicationMode, isVCMDB, not_exposed);
            ld.ldDeviceId = this.getString(rs);
        }
        int traceResult = this.colIndex;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"fetchLogicalDisk", (int)traceResult);
        }
        return traceResult;
    }

    public NameList getLDlist(int computerID, int diskID, int volgroupID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"getLDlist", (String)"computerID, diskID, volgroupID");
        }
        NameList ldList = null;
        boolean unionQuery = false;
        TResComputer cmpAccessor = new TResComputer(this.dbc);
        short ssType = cmpAccessor.getStorageSubsystemType(computerID);
        boolean isStorageSubsystem = ssType >= 0;
        try {
            int id;
            StringBuffer buf = new StringBuffer(200);
            if (diskID < 1) {
                id = computerID;
                if (!isStorageSubsystem) {
                    buf.append(SELECT_BY_COMPUTERID1);
                    if (volgroupID > 0) {
                        buf.append(BY_VOLGROUP_CLAUSE1);
                    }
                    buf.append(SELECT_BY_COMPUTERID2);
                    if (volgroupID > 0) {
                        buf.append(BY_VOLGROUP_CLAUSE2);
                    }
                    buf.append(BY_COMPUTERID_ORDER);
                    this.selectStmt = this.prepareStmt(buf.toString());
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    this.setInt(this.selectStmt, id);
                    if (volgroupID > 0) {
                        this.setInt(this.selectStmt, volgroupID);
                        this.setInt(this.selectStmt, volgroupID);
                    }
                    this.setInt(this.selectStmt, id);
                    this.setInt(this.selectStmt, id);
                    if (volgroupID > 0) {
                        this.setInt(this.selectStmt, volgroupID);
                    }
                } else {
                    buf.append(SELECT_BY_SS_COMPUTERID);
                    if (volgroupID > 0) {
                        buf.append(BY_SP_CLAUSE);
                    }
                    buf.append(BY_COMPUTERID_ORDER);
                    this.selectStmt = this.prepareStmt(buf.toString());
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    this.setInt(this.selectStmt, id);
                    if (volgroupID > 0) {
                        this.setInt(this.selectStmt, volgroupID);
                    }
                }
            } else {
                id = diskID;
                if (!isStorageSubsystem) {
                    this.selectStmt = this.prepareStmt(SELECT_BY_DISKID);
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    this.setInt(this.selectStmt, id);
                    this.setInt(this.selectStmt, id);
                    this.setInt(this.selectStmt, id);
                    this.setInt(this.selectStmt, id);
                } else {
                    if (ssType == 21) {
                        buf.append(SELECT_BY_SVC_SS_DISKID);
                    } else {
                        buf.append(SELECT_BY_SS_DISKID);
                        unionQuery = true;
                    }
                    if (!unionQuery) {
                        buf.append(ORDER_BY_DISPLAY_NAME);
                    }
                    this.selectStmt = this.prepareStmt(buf.toString());
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    this.setInt(this.selectStmt, id);
                    if (unionQuery) {
                        this.setInt(this.selectStmt, id);
                        this.setInt(this.selectStmt, id);
                    }
                }
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                NameList ld = new NameList();
                this.colIndex = 1;
                ld.nlID = this.getInt(this.resultSet);
                ld.nlName = this.getString(this.resultSet);
                ld.nlID2 = this.getInt(this.resultSet);
                ld.nlName2 = this.getString(this.resultSet);
                if (isStorageSubsystem) {
                    String deviceId = this.getString(this.resultSet);
                    if (ssType == 25 || ssType == 27) {
                        ld.nlName2 = ld.nlName;
                        ld.nlName = deviceId;
                    }
                }
                ld.nlNext = ldList;
                ldList = ld;
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"getLDlist", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        NameList traceResult = ldList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"getLDlist", traceResult);
        }
        return traceResult;
    }

    public void getMirrors(LogicalDisk ld, boolean isStorageSystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"getMirrors", (String)"ld");
        }
        this.selectStmt = this.prepareStmt("select logical_disk_id, parent_logdisk_id, logical_disk_type, capacity, use_count, mirror_count, is_swap, snap_source_id, is_vcmdb, replication_mode, not_exposed, overhead, volgroup_id, lun_identity, ssraidl, storage_type from t_res_logical_disk where parent_logdisk_id = ? order by logical_disk_id");
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, ld.ldID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                ld.ldNextMirror = new LogicalDisk();
                this.fetchLogicalDisk(ld.ldNextMirror, this.resultSet, isStorageSystem);
                ld = ld.ldNextMirror;
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"getMirrors", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"getMirrors");
        }
    }

    public void prepInsert() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT);
        this.useSetShort = false;
        if (SQLUtil.isSybase()) {
            try {
                String sybSel = "select mirror_count from t_res_logical_disk";
                Statement sybStmt = this.dbc.createStatement();
                ResultSet sybRS = sybStmt.executeQuery(sybSel);
                ResultSetMetaData rsm = sybRS.getMetaData();
                int colType = rsm.getColumnType(1);
                if (colType == 5 || colType == 4) {
                    this.useSetShort = true;
                }
            }
            catch (SQLException e) {
                this.sqlError(e);
            }
        }
    }

    public void prepInsertSV() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT_SV);
        this.isSV = true;
    }

    public void insertLogicalDisks(LogicalDisk ldList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"insertLogicalDisks", (String)"ldList");
        }
        try {
            LogicalDisk ld = ldList;
            while (ld != null) {
                this.insert(ld);
                this.dbc.commit();
                ld = ld.ldNextMirror;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"insertLogicalDisks", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"insertLogicalDisks");
        }
    }

    private void insert(LogicalDisk ld) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"insert", (String)"ld");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.insertStmt, ld.ldID);
        if (!this.isSV) {
            this.setInt(this.insertStmt, ld.ldParentLogicalDiskID);
        }
        this.setByte(this.insertStmt, ld.ldType);
        this.setLong(this.insertStmt, ld.ldCapacity);
        this.setShort(this.insertStmt, ld.ldUseCount);
        if (this.useSetShort) {
            this.setShort(this.insertStmt, ld.ldMirrorCount);
        } else {
            this.setByte(this.insertStmt, ld.ldMirrorCount);
        }
        this.setBoolean(this.insertStmt, ld.ldIsSwap);
        this.setInt(this.insertStmt, ld.ldSnapSourceID);
        this.setBoolean(this.insertStmt, ld.isVCMDB());
        this.setByte(this.insertStmt, ld.getReplicationMode());
        this.setBoolean(this.insertStmt, ld.notExposed());
        this.setLong(this.insertStmt, ld.ldOverhead);
        this.setInt(this.insertStmt, ld.ldVolgroupID);
        this.setByte(this.insertStmt, ld.lun_identity);
        this.setInt(this.insertStmt, ld.ldRaid);
        this.setShort(this.insertStmt, ld.ldStorageType);
        this.executeUpdate(this.insertStmt);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"insert");
        }
    }

    public void prepUpdateUseCount() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_USE_COUNT);
    }

    public void prepUpdateSVUseCount() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_SV_USE_COUNT);
    }

    public void updateUseCount(LogicalDisk lDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"updateUseCount", (String)"lDisk");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setShort(this.updateStmt, lDisk.ldUseCount);
            this.setInt(this.updateStmt, lDisk.ldID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"updateUseCount", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"updateUseCount");
        }
    }

    public void prepUpdateAttributes() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_ATTRIBUTES);
    }

    public void prepUpdateSVAttributes() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_SV_ATTRIBUTES);
    }

    public void updateAttributes(LogicalDisk lDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"updateAttributes", (String)"lDisk");
        }
        this.setPhase();
        try {
            this.setShort(this.updateStmt, lDisk.ldUseCount);
            this.setInt(this.updateStmt, lDisk.ldSnapSourceID);
            this.setBoolean(this.updateStmt, lDisk.isVCMDB());
            this.setByte(this.updateStmt, lDisk.getReplicationMode());
            this.setBoolean(this.updateStmt, lDisk.notExposed());
            this.setInt(this.updateStmt, lDisk.ldVolgroupID);
            this.setInt(this.updateStmt, lDisk.ldRaid);
            this.setShort(this.updateStmt, lDisk.ldStorageType);
            this.setInt(this.updateStmt, lDisk.ldID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"updateAttributes", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"updateAttributes");
        }
    }

    public void prepUpdateLUNIdentity() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_LUN_IDENTITY);
    }

    public int updateLUNIdentity(int lvID, byte lunIdentity) throws GeneralException {
        int rowsUpdated = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"updateLUNIdentity", (String)"lvID, lunIdentity");
        }
        this.setPhase();
        try {
            this.setByte(this.updateStmt, lunIdentity);
            this.setInt(this.updateStmt, lvID);
            rowsUpdated = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            rowsUpdated = -1;
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"updateLUNIdentity", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"updateLUNIdentity");
        }
        return rowsUpdated;
    }

    public void prepDeleteLogicalDisk() throws GeneralException {
        this.deleteStmt = this.prepareStmt(DELETE_BY_ID);
    }

    public void prepDeleteSV() throws GeneralException {
        this.deleteStmt = this.prepareStmt(DELETE_BY_SVID);
    }

    public void deleteLogicalDisk(LogicalDisk lDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"deleteLogicalDisk", (String)"lDisk");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, lDisk.ldID);
            this.setInt(this.deleteStmt, lDisk.ldID);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"deleteLogicalDisk", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"deleteLogicalDisk");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUseCount(int logicalDiskID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"getUseCount", (String)"logicalDiskID");
        }
        int use_count = -1;
        try {
            this.selectStmt = this.prepareStmt(SELECT_USE_COUNT);
            this.setPhase();
            this.setInt(this.selectStmt, logicalDiskID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            if (this.nextResult()) {
                use_count = this.getInt(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"getUseCount", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        int traceResult = use_count;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"getUseCount", (int)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSVCapacity(int logicalDiskID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"getSVCapacity", (String)"logicalDiskID");
        }
        long capacity = 0L;
        try {
            this.selectStmt = this.prepareStmt(SELECT_SV_CAPACITY);
            this.setPhase();
            this.setInt(this.selectStmt, logicalDiskID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            if (this.nextResult()) {
                capacity = this.getLong(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"getSVCapacity", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        long traceResult = capacity;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"getSVCCapacity", (long)traceResult);
        }
        return traceResult;
    }

    public ResultSet getLUNs(int pool_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"getLUNs", (String)"pool_id");
        }
        ResultSet luns = null;
        try {
            PreparedStatement statement = this.dbc.prepareStatement(SELECT_SS_LUNS);
            statement.setInt(1, pool_id);
            luns = statement.executeQuery();
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"getLUNs", (Throwable)sqle);
            }
            this.sqlError(sqle);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"getLUNs", (Object)luns);
        }
        return luns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogicalDiskType(int svid, byte ld_type) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"setLogicalDiskType", (String)"svid, ld_type");
        }
        PreparedStatement updateStatement = null;
        ResultSet updateResultSet = null;
        try {
            updateStatement = this.dbc.prepareStatement(UPDATE_SVID_TYPE);
            updateStatement.setByte(1, ld_type);
            updateStatement.setInt(2, svid);
            updateStatement.executeUpdate();
            this.dbc.commit();
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"setLogicalDiskType", (Throwable)sqle);
            }
            this.sqlError(sqle);
        }
        finally {
            try {
                if (updateStatement != null) {
                    updateStatement.close();
                }
                if (updateResultSet != null) {
                    updateResultSet.close();
                }
            }
            catch (SQLException sqle) {}
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"setLogicalDiskType");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSSLogicalDiskType(int ssid, byte ld_type) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"setLogicalDiskType", (String)"ssid,ld_type");
        }
        PreparedStatement updateStatement = null;
        ResultSet updateResultSet = null;
        try {
            updateStatement = this.dbc.prepareStatement(UPDATE_SS_SVID_TYPE);
            updateStatement.setByte(1, ld_type);
            updateStatement.setInt(2, ssid);
            updateStatement.executeUpdate();
            this.dbc.commit();
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"setLogicalDiskType", (Throwable)sqle);
            }
            this.sqlError(sqle);
        }
        finally {
            try {
                if (updateStatement != null) {
                    updateStatement.close();
                }
                if (updateResultSet != null) {
                    updateResultSet.close();
                }
            }
            catch (SQLException sqle) {}
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"setLogicalDiskType");
        }
    }

    public byte getSVCLogicalDiskType(short vdisk_type) {
        int result = -1;
        result = vdisk_type == 0 ? 0 : (vdisk_type == 1 ? 1 : (vdisk_type == 2 ? 10 : (vdisk_type == 3 ? 9 : 7)));
        return (byte)result;
    }

    public ResultSet getSVCMDisksForVDisk(int volume_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"getSVCMDisksForVDisk", (String)"volume_id");
        }
        ResultSet mdisks = null;
        PreparedStatement mdisksStatement = null;
        try {
            mdisksStatement = this.dbc.prepareStatement(GET_MDISKS_FOR_VDISK);
            mdisksStatement.setInt(1, volume_id);
            mdisks = mdisksStatement.executeQuery();
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"getSVCMDisksForVDisk", (Throwable)sqle);
            }
            this.sqlError(sqle);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"getSVCMDisksForVDisk", (Object)mdisks);
        }
        return mdisks;
    }
}

