/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.RespManNas;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResShare
extends StorageRepositoryAccessor {
    private boolean excludeRemoved;
    public static final String TABLE_NAME = "t_res_share";
    public static final String COMPUTER_COLUMN = "computer_id";
    public static final String RESOURCE_COLUMN = "resource_id";
    private static final long MILLIS_PER_DAY = 86400000L;
    private Timestamp scanTS = new Timestamp(0L);
    private Timestamp removeTS = new Timestamp(0L);
    private Share updateList;
    private static final String SELECT = "select computer_id, resource_id, resource_type, scan_time, removed_time, path, name from t_res_share";
    private static final String REMOVED_RESOURCES = " where computer_id = ? and resource_type = ? and scan_time <> ?";
    private static final String OTHER_COMPUTERS = " where resource_id = ? and resource_type = ? and computer_id <> ? order by removed_time";
    private static final String UNIQUE = " where computer_id = ? and resource_id = ?";
    private static final String INSERT_SHARE = "insert into t_res_share (computer_id, resource_id, resource_type, scan_time, removed_time, path, name) values (?,?,?,?,?,?,?)";
    private static final String UPDATE_SHARE = "update t_res_share set scan_time = ?, removed_time = ?, path = ?, name = ? where computer_id = ? and resource_id = ?";
    private static final String DELETE_SHARE = "delete from t_res_share where computer_id = ? and resource_id = ?";
    private static final String DELETE_INCLUDING_TYPE = "delete from t_res_share where computer_id = ? and resource_id = ? and resource_type = ?";
    private static final String SELECT_SHARE_COUNT = "select count(*) from t_res_share where resource_id = ? and resource_type = ?";
    private static final String WHERE_NOT_REMOVED = " and removed_time <= ?";
    private static final String WHERE_REMOVED = " and removed_time > ?";
    private static final String SELECT_MAN_NAS = "select c.host_name, c.network_name, s.computer_id,  s.resource_id, c.os_type, d.name, ' '  from t_res_share s, t_res_host c, t_res_domain d  where s.resource_type = 103 and s.resource_id = c.computer_id  and s.computer_id = d.domain_id  union all select cc.host_name, cc.network_name, ss.computer_id,  ss.resource_id, cc.os_type, ' ', cc2.host_name  from t_res_share ss, t_res_host cc, t_res_host cc2  where ss.resource_type = 103 and ss.resource_id = cc.computer_id  and ss.computer_id = cc2.computer_id  union all select ccc.host_name, ccc.network_name, sss.computer_id,  sss.resource_id, ccc.os_type, lll.name, ' '  from t_res_share sss, t_res_host ccc, t_res_ldap_tree lll  where sss.resource_type = 103 and sss.resource_id = ccc.computer_id  and sss.computer_id = lll.tree_id ";
    private static final String SELECT_WINDOWS_MAN_NAS_COUNT = "select count(*)  from t_res_share s, t_res_host c, t_res_domain d  where s.resource_type = 103 and s.resource_id = c.computer_id  and s.computer_id = d.domain_id  and s.resource_id = ?";
    private static final String SELECT_WINDOWS_MAN_NET_COUNT = "select count(*)  from t_res_share s, t_res_host c, t_res_ldap_tree l  where s.resource_type = 103 and s.resource_id = c.computer_id  and s.computer_id = l.tree_id  and s.resource_id = ?";
    private static final String SELECT_TREE_AGENTS = "select s.resource_id, s.computer_id, s.resource_type, l.name from t_res_share s, t_res_ldap_tree l where s.resource_type = 66 and s.resource_id = l.tree_id union all select ss.resource_id, ss.computer_id, ss.resource_type,";
    private static final String SELECT_TREE_AGENTS2 = " ' '";
    private static final String SELECT_TREE_AGENTS3 = " from t_res_share ss, t_res_host cc where ss.resource_type = 68 and ss.computer_id = cc.computer_id order by 1";
    private static final String SELECT_SHARING_COMPUTERS = "select computer_id from t_res_share where resource_type = ? and resource_id = ?";
    private static final String SELECT_ARRAY_SHARES = "select resource_id, computer_id from t_res_share  where resource_type = 78 order by resource_id desc, computer_id desc";
    private static final String SELECT_VS_SHARES = "select resource_id from t_res_share  where resource_type = 99";
    private static final String SHARE_EXISTS = "select count(*) from t_res_share  where computer_id = ? and resource_id = ? and resource_type = ?";

    public TResShare(Connection dbc) {
        super(dbc);
        this.tableName = TABLE_NAME;
    }

    public void prepGetAnotherComputer() throws GeneralException {
        this.selectStmt = this.prepareStmt("select computer_id, resource_id, resource_type, scan_time, removed_time, path, name from t_res_share where resource_id = ? and resource_type = ? and computer_id <> ? order by removed_time");
    }

    public Share getAnotherComputer(int resourceID, short resourceType, int computerID) throws GeneralException {
        Share share = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, resourceID);
            this.setShort(this.selectStmt, resourceType);
            this.setInt(this.selectStmt, computerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult()) {
                share = new Share();
                this.getAttributes(share);
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        return share;
    }

    public void prepGetShareCount() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_SHARE_COUNT);
    }

    public int getShareCount(int resourceID, short resourceType) throws GeneralException {
        int shareCount = 0;
        try {
            this.setPhase();
            this.setInt(this.selectStmt, resourceID);
            this.setShort(this.selectStmt, resourceType);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                this.getPhase();
                shareCount = this.getInt(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        return shareCount;
    }

    public void prepGetWindowsManShareCount(boolean bNAS) throws GeneralException {
        this.selectStmt = bNAS ? this.prepareStmt(SELECT_WINDOWS_MAN_NAS_COUNT) : this.prepareStmt(SELECT_WINDOWS_MAN_NET_COUNT);
    }

    public int getWindowsManShareCount(int resourceID) throws GeneralException {
        int shareCount = 0;
        try {
            this.setPhase();
            this.setInt(this.selectStmt, resourceID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                this.getPhase();
                shareCount = this.getInt(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        return shareCount;
    }

    public boolean getShareExists(int compID, int resID, short type) throws GeneralException {
        int count = 0;
        try {
            this.selectStmt = this.prepareStmt(SHARE_EXISTS);
            this.setPhase();
            this.setInt(this.selectStmt, compID);
            this.setInt(this.selectStmt, resID);
            this.setShort(this.selectStmt, type);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                this.getPhase();
                count = this.getInt(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        return count > 0;
    }

    public Share getRemovedResources(int computerID, short resourceType, long scanTime) throws GeneralException {
        return this.getRemovedResources(computerID, resourceType, scanTime, null);
    }

    public Share getRemovedResources(int computerID, short resourceType, long scanTime, Share shareList) throws GeneralException {
        this.selectStmt = this.prepareStmt("select computer_id, resource_id, resource_type, scan_time, removed_time, path, name from t_res_share where computer_id = ? and resource_type = ? and scan_time <> ?");
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, computerID);
            this.setShort(this.selectStmt, resourceType);
            this.setTimestamp(this.selectStmt, scanTime);
            shareList = this.getAllShares(shareList);
            this.closeSelect();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        return shareList;
    }

    public Share setRemovedTime(Share missingResources, long runTime, long retainDuration) throws GeneralException {
        Share sh;
        long removeTime = runTime - retainDuration * 86400000L;
        Share removeList = null;
        this.updateList = null;
        while (missingResources != null) {
            sh = missingResources;
            missingResources = sh.shNext;
            if (sh.shRemovedTime <= 86400000L) {
                sh.shRemovedTime = runTime;
            }
            if (sh.shRemovedTime < removeTime) {
                sh.shNext = removeList;
                removeList = sh;
                continue;
            }
            if (sh.shRemovedTime != runTime) continue;
            sh.shNext = this.updateList;
            this.updateList = sh;
        }
        if (this.updateList != null) {
            this.prepUpdate();
            sh = this.updateList;
            while (sh != null) {
                this.updateShare(sh);
                sh = sh.shNext;
            }
            this.closeUpdate();
        }
        return removeList;
    }

    public Share getUpdateList() {
        return this.updateList;
    }

    public void prepGetUniqueShare() throws GeneralException {
        this.selectStmt = this.prepareStmt("select computer_id, resource_id, resource_type, scan_time, removed_time, path, name from t_res_share where computer_id = ? and resource_id = ?");
    }

    public void getUniqueShare(Share share) throws GeneralException {
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, share.shComputerID);
            this.setInt(this.selectStmt, share.shResourceID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.getAttributes(share);
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
    }

    private Share getAllShares(Share shareList) throws SQLException, GeneralException {
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        this.stmtPhase = 1;
        while (this.nextResult()) {
            Share share = new Share();
            this.getAttributes(share);
            share.shNext = shareList;
            shareList = share;
        }
        return shareList;
    }

    private void getAttributes(Share share) throws SQLException {
        this.colIndex = 1;
        share.shComputerID = this.getInt(this.resultSet);
        share.shResourceID = this.getInt(this.resultSet);
        share.shResourceType = this.getShort(this.resultSet);
        share.shScanTime = this.getTimestamp(this.resultSet);
        share.shRemovedTime = this.getTimestamp(this.resultSet);
        share.shPath = this.getString(this.resultSet);
        share.shName = this.getString(this.resultSet);
    }

    public void prepSave() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT_SHARE);
        this.updateStmt = this.prepareStmt(UPDATE_SHARE);
    }

    public void closeSave() throws GeneralException {
        this.closeInsert();
        this.closeUpdate();
    }

    public boolean saveShare(Share share, boolean newResource) throws GeneralException {
        try {
            if (newResource && this.insert(share, true)) {
                return true;
            }
            if (this.update(share) == 0) {
                this.insert(share, false);
                return true;
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        return false;
    }

    private boolean insert(Share share, boolean catchDuplicateKeyExceptions) throws SQLException {
        try {
            this.stmtType = 1;
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setIDs(this.insertStmt, share);
            this.setShort(this.insertStmt, share.shResourceType);
            this.setAttributes(this.insertStmt, share);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException e) {
            if (catchDuplicateKeyExceptions && SQLUtil.isDuplicateKeyViolation(e)) {
                Object[] args = new Object[]{new Integer(share.shComputerID), new Integer(share.shResourceType), new Integer(share.shResourceID)};
                MessageLog.logException((String)"STS0171E", (Exception)e, (Object[])args);
                e.printStackTrace(MessageLog.getThreadLog());
                return false;
            }
            throw e;
        }
        return true;
    }

    private void setIDs(PreparedStatement stmt, Share share) throws SQLException {
        this.setInt(stmt, share.shComputerID);
        this.setInt(stmt, share.shResourceID);
    }

    private void setAttributes(PreparedStatement stmt, Share share) throws SQLException {
        this.setTimestamp(stmt, share.shScanTime, this.scanTS);
        this.setTimestamp(stmt, share.shRemovedTime, this.removeTS);
        this.setString(stmt, share.shPath);
        this.setString(stmt, share.shName);
    }

    private int update(Share share) throws SQLException {
        this.stmtType = 2;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setAttributes(this.updateStmt, share);
        this.setIDs(this.updateStmt, share);
        return this.executeUpdate(this.updateStmt);
    }

    public void prepUpdate() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_SHARE);
    }

    public void updateShare(Share share) throws GeneralException {
        try {
            this.update(share);
            this.dbc.commit();
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
    }

    public void updateVSProbeTime(Share share) throws GeneralException {
        block2: {
            try {
                this.update(share);
                this.dbc.commit();
            }
            catch (SQLException e) {
                if (SQLUtil.isRowNotFound(e)) break block2;
                this.sqlError(e);
            }
        }
    }

    public void prepDelete() throws GeneralException {
        this.deleteStmt = this.prepareStmt(DELETE_SHARE);
    }

    public void deleteShare(Share share) throws GeneralException {
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setIDs(this.deleteStmt, share);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            this.stmtType = 3;
            this.sqlError(e);
        }
    }

    public void prepDeleteIncludingType() throws GeneralException {
        this.deleteStmt = this.prepareStmt(DELETE_INCLUDING_TYPE);
    }

    public void deleteIncludingType(Share share) throws GeneralException {
        this.setPhase();
        try {
            this.setIDs(this.deleteStmt, share);
            this.setShort(this.deleteStmt, share.shResourceType);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException e) {
            this.stmtType = 3;
            this.sqlError(e);
        }
        this.commit();
    }

    public void deleteByCompAndResType(int computerID, int[] resourceTypes) throws GeneralException {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(" where computer_id = ");
        buffer.append(computerID);
        buffer.append(" and resource_type in (");
        for (int i = 0; i < resourceTypes.length; ++i) {
            buffer.append(resourceTypes[i]);
            buffer.append(',');
        }
        buffer.setLength(buffer.length() - 1);
        buffer.append(')');
        this.delete(TABLE_NAME, buffer.toString(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Share getByCompAndResType(int computerID, int[] resourceTypes) throws GeneralException {
        Share shareList = null;
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(" where computer_id = ");
        buffer.append(computerID);
        buffer.append(" and resource_type in (");
        for (int i = 0; i < resourceTypes.length; ++i) {
            buffer.append(resourceTypes[i]);
            buffer.append(',');
        }
        buffer.setLength(buffer.length() - 1);
        buffer.append(')');
        this.selectStmt = this.prepareStmt(SELECT + buffer.toString());
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            while (this.nextResult()) {
                Share share = new Share();
                this.getAttributes(share);
                if (shareList == null) {
                    shareList = share;
                    continue;
                }
                share.shNext = shareList;
                shareList = share;
            }
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeSelect();
        }
        return shareList;
    }

    public NameList[] getTreeAgents() throws GeneralException {
        NameList head = null;
        NameList prev = null;
        try {
            this.staticStmt = this.createStatement();
            String strSelect = SELECT_TREE_AGENTS;
            strSelect = strSelect + SELECT_TREE_AGENTS2;
            strSelect = strSelect + SELECT_TREE_AGENTS3;
            this.resultSet = this.staticStmt.executeQuery(strSelect);
            this.stmtPhase = 1;
            while (this.nextResult()) {
                NameList node = new NameList();
                this.colIndex = 1;
                node.nlID = this.getInt(this.resultSet);
                node.nlID2 = this.getInt(this.resultSet);
                node.nlID3 = this.getInt(this.resultSet);
                node.nlName = this.getString(this.resultSet);
                if (prev != null) {
                    prev.nlNext = node;
                } else {
                    head = node;
                }
                prev = node;
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        return NameList.packList(head);
    }

    public RespManNas[] getManualNasEntries() throws GeneralException {
        RespManNas head = null;
        RespManNas prev = null;
        try {
            this.staticStmt = this.createStatement();
            String strSelect = SELECT_MAN_NAS;
            this.resultSet = this.staticStmt.executeQuery(strSelect);
            this.getPhase();
            while (this.nextResult()) {
                RespManNas node = new RespManNas();
                this.colIndex = 1;
                node.mnFiler = this.getString(this.resultSet);
                node.mnNetName = this.getString(this.resultSet);
                node.mnComputerID = this.getInt(this.resultSet);
                node.mnResourceID = this.getInt(this.resultSet);
                node.mnOsType = this.getShort(this.resultSet);
                node.mnDomain = this.getString(this.resultSet);
                node.mnUnixComp = this.getString(this.resultSet);
                if (prev != null) {
                    prev.mnNext = node;
                } else {
                    head = node;
                }
                prev = node;
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        return (RespManNas[])Packer.pack(head);
    }

    public void prepSelectSharingComputers() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_SHARING_COMPUTERS);
    }

    public LinkedInteger fetchSharingComputers(short resourceType, int resourceID) throws GeneralException {
        LinkedInteger head = null;
        this.setPhase();
        try {
            this.setShort(this.selectStmt, resourceType);
            this.setInt(this.selectStmt, resourceID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                LinkedInteger li = new LinkedInteger();
                li.value = this.getInt(this.resultSet);
                li.next = head;
                head = li;
            }
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        return head;
    }

    public int[][] selectDiskArrayShares() throws GeneralException {
        int[][] result = null;
        int arrayCount = 0;
        DiskArray daHead = null;
        DiskArray daCurr = null;
        DiskShare dsCurr = null;
        this.selectStmt = this.prepareStmt(SELECT_ARRAY_SHARES);
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                int diskID = this.getInt(this.resultSet);
                int compID = this.getInt(this.resultSet);
                if (daHead == null || daHead.daDiskID != diskID) {
                    daCurr = new DiskArray();
                    ++arrayCount;
                    daCurr.daNext = daHead;
                    daHead = daCurr;
                    daCurr.daDiskID = diskID;
                }
                dsCurr = new DiskShare();
                dsCurr.dsNext = daCurr.daShare;
                daCurr.daShare = dsCurr;
                dsCurr.dsCompID = compID;
                ++daCurr.daShareCount;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.stmtPhase = 1;
            this.sqlError(e);
        }
        if (arrayCount > 0) {
            result = new int[arrayCount][1];
            int i = 0;
            DiskArray daWork = daHead;
            while (daWork != null) {
                result[i] = new int[daWork.daShareCount + 1];
                result[i][0] = daWork.daDiskID;
                int j = 1;
                DiskShare dsWork = daWork.daShare;
                while (dsWork != null) {
                    result[i][j] = dsWork.dsCompID;
                    ++j;
                    dsWork = dsWork.dsNext;
                }
                ++i;
                daWork = daWork.daNext;
            }
        }
        return result;
    }

    public LinkedInteger getExpiredVSs() throws GeneralException {
        LinkedInteger result = null;
        this.selectStmt = this.prepareStmt("select resource_id from t_res_share  where resource_type = 99 and removed_time > ?");
        try {
            this.setPhase();
            this.setTimestamp(this.selectStmt, 86400000L);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            int i = 0;
            while (this.nextResult()) {
                this.getPhase();
                if (result == null) {
                    result = new LinkedInteger(this.getInt(this.resultSet));
                } else {
                    LinkedInteger temp = result;
                    result = new LinkedInteger(this.getInt(this.resultSet));
                    result.next = temp;
                }
                ++i;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.stmtPhase = 1;
            this.sqlError(e);
        }
        return result;
    }

    private class DiskArray {
        DiskArray daNext;
        int daDiskID;
        int daShareCount;
        DiskShare daShare;

        private DiskArray() {
        }
    }

    private class DiskShare {
        DiskShare dsNext;
        int dsCompID;

        private DiskShare() {
        }
    }
}

