/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResCimom;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.repository.table.TResVolGroup;

public class TResStorExtent
extends StorageRepositoryAccessor {
    private static final String SELECT_STORAGE_EXTENT = "select se.other_name, se.name, se.storage_extent_id, se.operational_status, se.extent_type, se.total_capacity, se.vol_group_id, se.array_ids, se.subsystem_id, se.redundancy from T_RES_DISK_GROUP dg, T_RES_STORAGE_SUBSYSTEM ss, T_RES_STORAGE_EXTENT se where ss.subsystem_id = dg.subsystem_id and dg.storage_extent_id = se.storage_extent_id and se.subsystem_id = dg.subsystem_id and ";
    private static final String COLLECT_RANK_GROUP = "select sp.rank_group from T_RES_STORAGE_EXTENT se, T_RES_STORAGE_POOL sp where se.pool_id = sp.pool_id and se.storage_extent_id = ? ";
    private static final String COLLECT_ARRAY_SITES = "select distinct dg.disk_group_number from T_RES_DISK_GROUP dg, T_RES_STORAGE_SUBSYSTEM ss, T_RES_STORAGE_EXTENT se where ss.subsystem_id = dg.subsystem_id and dg.storage_extent_id = se.storage_extent_id and se.subsystem_id = dg.subsystem_id and se.storage_extent_id = ? order by 1";
    private static final String GET_LUN_NUM_RANKS = "select count(*) from  t_res_storage_volume v, t_res_storage_extent se, t_res_volume2extent v2e  where v.svid = v2e.volume_id and v2e.storage_extent_id = se.storage_extent_id  and v.svid = ?";
    private static final String GET_LUN_RANK_INFO = "select distinct dg.width, se.redundancy, se.storage_extent_id from t_res_disk_group dg,  t_res_storage_extent se, t_res_storage_volume v, t_res_storage_pool sp where v.pool_id = sp.pool_id and sp.pool_id = se.pool_id  and se.storage_extent_id = dg.storage_extent_id and v.svid = ?";
    private static final String GET_STORAGE_POOL_IN_RANK = " select p.pool_id from t_res_storage_extent se, t_res_storage_pool p where  se.pool_id = p.pool_id and se.storage_extent_id = ?";
    private static final String GET_NUM_ARRAY_SITES = "select count(*) from T_RES_DISK_GROUP dg, T_RES_STORAGE_EXTENT se where dg.storage_extent_id = se.storage_extent_id and  se.storage_extent_id = ? ";
    private static final String GET_NUM_DISKS = "select count(*) from T_RES_DISK_GROUP dg, T_RES_STORAGE_EXTENT se, T_RES_PHYSICAL_VOLUME pv where dg.storage_extent_id = se.storage_extent_id and dg.disk_group_id = pv.disk_group_id and se.storage_extent_id = ? ";
    private static final String BY_DISK_GROUP_ID = " dg.disk_group_id = ?";
    private static final String BY_SUBSYSTEM_ID = " se.subsystem_id = ?";
    private static final String BY_STORAGE_EXTENT_ID = " se.storage_extent_id = ?";
    private static final String INSERT = "insert into t_res_stor_extent (other_name, name, size_extent, storext_id, status, config, type, volgroup_id, arrays, group_id, computer_id) values (?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE = "update t_res_stor_extent set other_name = ?, name = ?, size_extent = ?, status = ?, config = ?, type = ?, volgroup_id = ?,  arrays = ?, group_id = ?, computer_id = ? where storext_id = ?";
    private static final String DELETE_BY_ID = "delete from t_res_storage_extent where storage_extent_id = ?";
    private static final String DELETE_BY_COMPID = "delete from t_res_storage_extent where subsystem_id = ?";
    private static final String ORDER = " order by 2";

    public TResStorExtent(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResStorExtent.class.getName(), (String)"TResStorExtent", (String)"dbc");
        }
        this.tableName = "t_res_storage_extent";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"TResStorExtent");
        }
    }

    public Rank getStorExtentByComputer(int compID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCimom.class.getName(), (String)"getStorExtentByComputer", (String)"compID");
        }
        Rank rankList = null;
        String selectSql = "select se.other_name, se.name, se.storage_extent_id, se.operational_status, se.extent_type, se.total_capacity, se.vol_group_id, se.array_ids, se.subsystem_id, se.redundancy from T_RES_DISK_GROUP dg, T_RES_STORAGE_SUBSYSTEM ss, T_RES_STORAGE_EXTENT se where ss.subsystem_id = dg.subsystem_id and dg.storage_extent_id = se.storage_extent_id and se.subsystem_id = dg.subsystem_id and  se.subsystem_id = ?";
        this.selectStmt = this.prepareStmt(selectSql);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, compID);
            rankList = this.getStorageExtents();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResStorExtent.class.getName(), (String)"getStorExtentByComputer", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Rank traceResult = rankList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"getStorExtentByComputer", (Object)traceResult);
        }
        return traceResult;
    }

    public Rank getStorExtentByID(int rankID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResStorExtent.class.getName(), (String)"getStorExtentByID", (String)"rankID");
        }
        Rank rankList = null;
        String selectSql = "select se.other_name, se.name, se.storage_extent_id, se.operational_status, se.extent_type, se.total_capacity, se.vol_group_id, se.array_ids, se.subsystem_id, se.redundancy from T_RES_DISK_GROUP dg, T_RES_STORAGE_SUBSYSTEM ss, T_RES_STORAGE_EXTENT se where ss.subsystem_id = dg.subsystem_id and dg.storage_extent_id = se.storage_extent_id and se.subsystem_id = dg.subsystem_id and  se.storage_extent_id = ?";
        this.selectStmt = this.prepareStmt(selectSql);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, rankID);
            rankList = this.getStorageExtents();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResStorExtent.class.getName(), (String)"getStorExtentByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Rank traceResult = rankList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"getStorExtentByID", (Object)traceResult);
        }
        return traceResult;
    }

    public Rank getStorExtentByController(int ctrlrID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCimom.class.getName(), (String)"getStorExtentByController", (String)"ctrlrID");
        }
        Rank rankList = null;
        String selectSql = "select se.other_name, se.name, se.storage_extent_id, se.operational_status, se.extent_type, se.total_capacity, se.vol_group_id, se.array_ids, se.subsystem_id, se.redundancy from T_RES_DISK_GROUP dg, T_RES_STORAGE_SUBSYSTEM ss, T_RES_STORAGE_EXTENT se where ss.subsystem_id = dg.subsystem_id and dg.storage_extent_id = se.storage_extent_id and se.subsystem_id = dg.subsystem_id and  dg.disk_group_id = ? order by 2";
        this.selectStmt = this.prepareStmt(selectSql);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, ctrlrID);
            rankList = this.getStorageExtents();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResStorExtent.class.getName(), (String)"getStorExtentByComputer", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Rank traceResult = rankList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"getStorExtentByComputer", (Object)traceResult);
        }
        return traceResult;
    }

    private Rank getStorageExtents() throws SQLException, GeneralException {
        Rank rank;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResStorExtent.class.getName(), (String)"getStorageExtents", (String)"");
        }
        Rank result = null;
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        while ((rank = this.getStorageExtent()) != null) {
            rank.rankNext = result;
            result = rank;
        }
        this.closeSelect();
        Rank traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"getStorageExtents", (Object)traceResult);
        }
        return traceResult;
    }

    public Rank getStorageExtent() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResStorExtent.class.getName(), (String)"getStorageExtent", (String)"");
        }
        Rank rank = null;
        try {
            if (!this.nextResult()) {
                Rank traceResult = null;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"getStorageExtent", traceResult);
                }
                return traceResult;
            }
            this.stmtPhase = 1;
            this.colIndex = 1;
            rank = new Rank();
            rank.rankOtherName = this.getString(this.resultSet);
            rank.rankName = this.getString(this.resultSet);
            rank.rankID = this.getInt(this.resultSet);
            rank.rankStatus = this.getInt(this.resultSet);
            rank.rankType = this.getInt(this.resultSet);
            rank.rankSize = this.getLong(this.resultSet);
            rank.rankVolGroupID = this.getInt(this.resultSet);
            rank.rankArrays = this.getArrayIDs(this.getString(this.resultSet));
            rank.rankComputerID = this.getInt(this.resultSet);
            rank.rankConfig = this.getConfig(Integer.toString(this.getInt(this.resultSet)));
            TResComputer cmpAccessor = new TResComputer(this.dbc);
            short type = cmpAccessor.getStorageSubsystemType(rank.rankComputerID);
            if (type == 27 || type == 25) {
                rank.rankGroup = this.getRankGroup(rank.rankID);
                rank.rankArraySiteNames = this.getArraySites(rank.rankID);
                rank.rankVolGroupID = this.getStoragePoolInRank(rank.rankID);
            } else {
                rank.rankGroup = (short)-1;
                rank.rankArraySiteNames = null;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResStorExtent.class.getName(), (String)"getStorageExtent", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Rank traceResult = rank;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"getStorageExtent", (Object)traceResult);
        }
        return traceResult;
    }

    public void saveStorExtents(Rank rankList, int identifierCount) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResStorExtent.class.getName(), (String)"saveStorExtents", (String)"vgList, identifierCount");
        }
        if (rankList == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"saveStorExtents");
            }
            return;
        }
        Rank rank = null;
        int identifier = 0;
        try {
            this.updateStmt = this.prepareStmt(UPDATE);
            if (identifierCount > 0) {
                identifier = TResStorExtent.getIdentifier(1, identifierCount, this.dbc);
                this.insertStmt = this.prepareStmt(INSERT);
            }
            rank = rankList;
            while (rank != null) {
                if (rank.rankID == -1) {
                    rank.rankID = identifier++;
                    this.insertStorExtent(rank);
                } else {
                    this.updateStorExtent(rank);
                }
                this.dbc.commit();
                rank = rank.rankNext;
            }
            this.closeSelect();
            this.closeInsert();
            this.closeUpdate();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResStorExtent.class.getName(), (String)"saveStorExtents", (Throwable)e);
            }
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"saveStorExtents");
        }
    }

    private void insertStorExtent(Rank rank) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"insertStorExtent", (String)"rank");
        }
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setString(this.insertStmt, rank.rankOtherName);
        this.setString(this.insertStmt, rank.rankName);
        this.setLong(this.insertStmt, rank.rankSize);
        this.setInt(this.insertStmt, rank.rankID);
        this.setInt(this.insertStmt, rank.rankStatus);
        this.setShort(this.insertStmt, rank.rankConfig);
        this.setInt(this.insertStmt, rank.rankType);
        this.setInt(this.insertStmt, rank.rankVolGroupID);
        this.setString(this.insertStmt, rank.rankArrays);
        this.setShort(this.insertStmt, rank.rankGroup);
        this.setInt(this.insertStmt, rank.rankComputerID);
        this.executeUpdate(this.insertStmt);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"insertStorExtent");
        }
    }

    public void deleteStorExtents(Rank rankList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResStorExtent.class.getName(), (String)"deleteStorExtents", (String)"rankList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_ID);
            Rank rank = rankList;
            while (rank != null) {
                this.deleteStorExtent(rank);
                rank = rank.rankNext;
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResStorExtent.class.getName(), (String)"deleteStorExtents", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"deleteStorExtents");
        }
    }

    public void deleteStorExtents(int cmpID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResStorExtent.class.getName(), (String)"deleteStorExtents", (String)"cmpID");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_COMPID);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, cmpID);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResStorExtent.class.getName(), (String)"deleteStorExtents", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"deleteStorExtents");
        }
    }

    private void deleteStorExtent(Rank rank) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResStorExtent.class.getName(), (String)"deleteStorExtent", (String)"rank");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.deleteStmt, rank.rankID);
        this.executeUpdate(this.deleteStmt);
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"deleteStorExtent");
        }
    }

    public void updateStorExtent(Rank rank) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResStorExtent.class.getName(), (String)"updateStorExtent", (String)"rank");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setString(this.updateStmt, rank.rankOtherName);
            this.setString(this.updateStmt, rank.rankName);
            this.setLong(this.updateStmt, rank.rankSize);
            this.setInt(this.updateStmt, rank.rankStatus);
            this.setShort(this.updateStmt, rank.rankConfig);
            this.setInt(this.updateStmt, rank.rankType);
            this.setInt(this.updateStmt, rank.rankVolGroupID);
            this.setString(this.updateStmt, rank.rankArrays);
            this.setShort(this.updateStmt, rank.rankGroup);
            this.setInt(this.updateStmt, rank.rankComputerID);
            this.setInt(this.updateStmt, rank.rankID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResStorExtent.class.getName(), (String)"updateStorExtent", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"updateStorExtent");
        }
    }

    private short getConfig(String redundancy) {
        int traceResult = 11;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResStorExtent.class.getName(), (String)"getConfig", (String)"redundancy");
        }
        if (redundancy != null) {
            for (int i = 0; i < Rank.REDUNDANCY.length; i = (int)((short)(i + 1))) {
                if (redundancy.compareToIgnoreCase(Rank.REDUNDANCY[i]) != 0) continue;
                traceResult = i;
                break;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"getAccessParms", (short)traceResult);
        }
        return (short)traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStoragePoolInRank(int rank_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResStorExtent.class.getName(), (String)"getStoragePoolInRank", (String)"rank_id");
        }
        PreparedStatement rankStatement = null;
        ResultSet rankResultSet = null;
        int result = -1;
        try {
            rankStatement = this.dbc.prepareStatement(GET_STORAGE_POOL_IN_RANK);
            rankStatement.setInt(1, rank_id);
            rankResultSet = rankStatement.executeQuery();
            if (rankResultSet.next()) {
                result = rankResultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResStorExtent.class.getName(), (String)"deleteStorExtents", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            try {
                if (rankStatement != null) {
                    rankStatement.close();
                }
                if (rankResultSet != null) {
                    rankResultSet.close();
                }
            }
            catch (SQLException sqle) {}
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResStorExtent.class.getName(), (String)"getStoragePoolInRank", (int)result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getArraySites(int rank_id) throws GeneralException {
        PreparedStatement arraySitesStatement = null;
        ResultSet arraySitesResultSet = null;
        boolean getArraySites = false;
        String arraySites = new String();
        try {
            arraySitesStatement = this.dbc.prepareStatement(COLLECT_ARRAY_SITES);
            arraySitesStatement.setInt(1, rank_id);
            arraySitesResultSet = arraySitesStatement.executeQuery();
            this.dbc.commit();
            while (arraySitesResultSet.next()) {
                this.getPhase();
                String dgName = Short.toString(this.getShort(arraySitesResultSet));
                arraySites = arraySites.concat(dgName);
                arraySites = arraySites.concat(", ");
                getArraySites = true;
            }
            arraySites = getArraySites ? arraySites.substring(0, arraySites.length() - 2) : " ";
        }
        catch (SQLException sqle) {
            this.sqlError(sqle);
        }
        finally {
            try {
                if (arraySitesStatement != null) {
                    arraySitesStatement.close();
                }
                if (arraySitesResultSet != null) {
                    arraySitesResultSet.close();
                }
            }
            catch (SQLException sqle) {}
        }
        return arraySites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getRankGroup(int rank_id) throws GeneralException {
        PreparedStatement rankGroupStatement = null;
        ResultSet rankGroupResultSet = null;
        short rankGroup = -1;
        try {
            rankGroupStatement = this.dbc.prepareStatement(COLLECT_RANK_GROUP);
            rankGroupStatement.setInt(1, rank_id);
            rankGroupResultSet = rankGroupStatement.executeQuery();
            this.dbc.commit();
            if (rankGroupResultSet.next()) {
                this.getPhase();
                rankGroup = this.getShort(rankGroupResultSet);
            }
        }
        catch (SQLException sqle) {
            this.sqlError(sqle);
        }
        finally {
            try {
                if (rankGroupStatement != null) {
                    rankGroupStatement.close();
                }
                if (rankGroupResultSet != null) {
                    rankGroupResultSet.close();
                }
            }
            catch (SQLException sqle) {}
        }
        return rankGroup;
    }

    private String getArrayIDs(String array_IDs) {
        String newArrayIDs = null;
        if (array_IDs != null) {
            StringTokenizer st = new StringTokenizer(array_IDs, " []");
            newArrayIDs = st.nextToken();
            newArrayIDs = newArrayIDs.concat(", ");
            while (st.hasMoreTokens()) {
                newArrayIDs = newArrayIDs.concat(st.nextToken());
                newArrayIDs = newArrayIDs.concat(", ");
            }
            newArrayIDs = newArrayIDs.substring(0, newArrayIDs.length() - 2);
        }
        return newArrayIDs;
    }

    public short getNumOfDisks(int rank_id) throws GeneralException {
        return this.getNum(GET_NUM_DISKS, rank_id);
    }

    public short getNumOfArraySites(int rank_id) throws GeneralException {
        return this.getNum(GET_NUM_ARRAY_SITES, rank_id);
    }

    public short getNumOfLUNRanks(int svid) throws GeneralException {
        return this.getNum(GET_LUN_NUM_RANKS, svid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getNum(String sqlText, int id) throws GeneralException {
        short result = -1;
        PreparedStatement getNumStmt = null;
        ResultSet getNumResultSet = null;
        try {
            getNumStmt = this.dbc.prepareStatement(sqlText);
            getNumStmt.setInt(1, id);
            getNumResultSet = getNumStmt.executeQuery();
            if (getNumResultSet.next()) {
                result = getNumResultSet.getShort(1);
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        finally {
            try {
                if (getNumStmt != null) {
                    getNumStmt.close();
                }
                if (getNumResultSet != null) {
                    getNumResultSet.close();
                }
            }
            catch (SQLException sqle) {}
        }
        return result;
    }

    public ResultSet getLUNRankInfo(int logical_disk_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"getPoolRanks", (String)"pool_id");
        }
        ResultSet ranks = null;
        try {
            PreparedStatement statement = this.dbc.prepareStatement(GET_LUN_RANK_INFO);
            statement.setInt(1, logical_disk_id);
            ranks = statement.executeQuery();
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"getPoolRanks", (Throwable)sqle);
            }
            this.sqlError(sqle);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"getPoolRanks", (Object)ranks);
        }
        return ranks;
    }

    public void closeInsert() throws GeneralException {
        super.closeInsert();
    }

    public void closeDelete() throws GeneralException {
        super.closeDelete();
    }

    public void closeSelect() throws GeneralException {
        super.closeSelect();
    }
}

