/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Script;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class TScript
extends RepositoryAccessor {
    static final String SELECT = "select script_name from t_script where script_id = ";
    static final String INSERT = "insert into t_script (script_id, script_name) values (";
    static final String UPDATE = "update t_script set script_name = '";
    static final String UPDATE_WHERE = "' where script_id = ";
    static final String DELETE = "delete from t_script where script_id = ";

    public TScript(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TScript.class.getName(), (String)"TScript", (String)"dbc");
        }
        this.tableName = "t_script";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TScript.class.getName(), (String)"TScript");
        }
    }

    public String select(int ID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TScript.class.getName(), (String)"select", (String)"ID");
        }
        String name = null;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT + ID);
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                name = this.getString(this.resultSet);
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TScript.class.getName(), (String)"select", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        String traceResult = name;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TScript.class.getName(), (String)"select", traceResult);
        }
        return traceResult;
    }

    public void insert(Script script) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TScript.class.getName(), (String)"insert", (String)"script");
        }
        String insert = INSERT + script.ID + ", '" + script.scrName + "')";
        try {
            this.staticStmt = this.createStatement();
            this.staticStmt.executeUpdate(insert);
            this.dbc.commit();
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TScript.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TScript.class.getName(), (String)"insert");
        }
    }

    public void update(Script script) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TScript.class.getName(), (String)"update", (String)"script");
        }
        String update = UPDATE + script.scrName + UPDATE_WHERE + script.ID;
        try {
            this.staticStmt = this.createStatement();
            if (this.staticStmt.executeUpdate(update) == 0) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TScript.class.getName(), (String)"update");
                }
                throw new GeneralException(MessageLog.getMessage((String)"NAG0005E"));
            }
            this.dbc.commit();
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TScript.class.getName(), (String)"update", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TScript.class.getName(), (String)"update");
        }
    }

    public void delete(int ID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TScript.class.getName(), (String)"delete", (String)"ID");
        }
        String delete = DELETE + ID;
        try {
            this.staticStmt = this.createStatement();
            this.staticStmt.executeUpdate(delete);
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TScript.class.getName(), (String)"delete", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TScript.class.getName(), (String)"delete");
        }
    }
}

