/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.NasFilerAdmin;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.HasID;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.EnclosureAccessor;
import org.eclipse.aperi.repository.Group2ResSqlUtil;
import org.eclipse.aperi.repository.MissingAlertAccessible;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.QueryBySchedule;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.xmsg.MessageLog;

public class TStatComputer
extends StorageRepositoryAccessor
implements NameListQueryable,
MissingAlertAccessible,
EnclosureAccessor {
    public static final String ID_COLUMN_NAME = "computer_id";
    public static final byte NETWARE = 1;
    public static final byte NO_NETWARE = 2;
    private QueryBySchedule queryBySchedule;
    private boolean diskArrayLicensed;
    private Timestamp tsProbe;
    private static final String SELECT = "select s.computer_id, s.group_id, s.domain_id, s.manufacturer, s.model, s.serial_number, s.os_type, s.cpu_architecture, s.os_version, s.processor_type, s.processor_speed, s.processor_count, s.ram, s.swap_space, s.disk_capacity, s.disk_free_space, s.fs_free_space, s.last_boot_time, s.last_probe_time, s.probe_status, s.owned_disk_cap, s.owned_disk_free_sp, s.cluster_id, s.node_hosted_id";
    private static final String UNIQUE = " from t_stat_computer s where s.computer_id = ?";
    private static final String GUI = " , r.discovered_time from t_stat_computer s, t_res_host r where s.computer_id = r.computer_id";
    public static String EXCLUDE_UNMANAGED_OSTYPES;
    private static final String GUI_UNIQUE = " and s.computer_id = ?";
    private static final String INSERT = "insert into t_stat_computer (computer_id, group_id, domain_id, manufacturer, model, serial_number, os_type, cpu_architecture, os_version, processor_type, processor_count, processor_speed, ram, swap_space, disk_capacity, disk_free_space, fs_free_space, last_boot_time, last_probe_time, probe_status, owned_disk_cap, owned_disk_free_sp, cluster_id, node_hosted_id) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE = "update t_stat_computer set domain_id = ?, manufacturer = ?, model = ?, serial_number = ?, os_type = ?, cpu_architecture = ?, os_version = ?, processor_type = ?, processor_count = ?, processor_speed = ?, ram = ?, swap_space = ?, disk_capacity = ?, disk_free_space = ?, fs_free_space = ?, last_boot_time = ?, last_probe_time = ?, probe_status = ?, owned_disk_cap = ?, owned_disk_free_sp = ?, cluster_id = ?, node_hosted_id = ? where computer_id = ?";
    private static final String UPDATE_CLUSTER_MEMBERSHIP = "update t_stat_computer set cluster_id = ?, node_hosted_id = ? where computer_id = ?";
    private static final String UPDATE_DOMAIN = "update t_stat_computer set domain_id = ? where computer_id = ?";
    private static final String SELECT_NAMES = "select os_type, computer_id from t_stat_computer ";
    private static final String SELECT_VIRTUAL_SERVER = "select computer_id from t_stat_computer where computer_id = ? and os_type = ?";
    private static final String SELECT_CLUSTER_ID = "select cluster_id from t_stat_computer where computer_id = ?";
    private static final String SELECT_PING_CMP_GROUP = "select computer_id from t_stat_computer c where group_id = ? and not exists (select 1 from t_res_attribute where attribute_type = 17 and resource_type = 1 and resource_id = c.computer_id)";
    private static final String SELECT_BY_ATTR_TYPE_PT_I = "select distinct a.attribute_id, c.computer_id, a.exclude from t_stat_computer c, t_res_attribute a where a.attribute_type = ? and c.computer_id";
    private static final String SELECT_BY_ATTR_TYPE_PT_II;
    private static final String SELECT_DISCOVERY_COMPUTERS = "select distinct c.computer_id, c.domain_id, '1' from t_stat_computer c, t_res_ldap_tree t, t_res_pwd p where c.computer_id = t.computer_id and t.tree_id = p.resource_id and p.user_name <> ' ' union all select computer_id, domain_id, '2' from t_stat_computer c where c.os_type";
    private static final String SELECT_DOMAIN_DISCOVERY_COMPUTERS = "select distinct c.computer_id, c.domain_id, '2' from t_stat_computer c where c.os_type";
    private static final String SELECT_NETWARE_DISCOVERY_COMPUTERS = "select distinct c.computer_id, c.domain_id, '1' from t_stat_computer c, t_res_ldap_tree t, t_res_pwd p where c.computer_id = t.computer_id and t.tree_id = p.resource_id and p.user_name <> ' ' ";
    private static final String WHERE_WINDOWS = " in (4,5)";
    private static final String NETWARE_COUNT = "select count(*) from t_stat_computer c, t_res_ldap_tree t, t_res_pwd p where c.computer_id = t.computer_id and t.tree_id = p.resource_id and p.user_name <> ' ' ";
    public static String WHERE_DISCOVERY_OS_TYPE;
    public static String WHERE_NAS;
    private static final String ORDER_DISCOVERY_COMPUTERS = " order by 2, 1, 3";
    private static final String SELECT_GROUP_MEMBERS = "select computer_id from t_stat_computer where group_id = ?";
    private static final String SELECT_DOMAIN_SIZE = "select computer_id from t_stat_computer where domain_id = ? and computer_id <> ?";
    private static final String JOIN_1 = "select s.os_type, s.computer_id, r.host_name, s.cluster_id from t_stat_computer s, t_res_host r where r.computer_id = s.computer_id";
    private static final String JOIN_2;
    private static final String JOIN_3 = "select s.computer_id, r.host_name, a.exclude, s.cluster_id from t_stat_computer s, t_res_host r, t_res_attribute a where a.attribute_id = ? and s.computer_id = a.resource_id and r.computer_id = s.computer_id and r.computer_id = a.resource_id order by 2, 3 desc";
    private static final String SELECT_WINDOWS_FILERS = "select distinct r.os_type, r.computer_id, d.domain_id, r.network_name, d.name from t_res_host r, t_res_domain d, t_res_share s where r.computer_id = s.resource_id and s.resource_type in (1,103) and s.computer_id = d.domain_id";
    private static final String SELECT_AGENTS = "select os_type, computer_id, domain_id from t_stat_computer where domain_id > 0";
    private static final String SELECT_AGENTS_IN_CLUSTER = "select r.host_name, s.computer_id, s.os_type, s.cluster_id, s.domain_id from t_stat_computer s, t_res_host r where r.computer_id = s.computer_id and s.cluster_id = ? and s.os_type <> ? order by host_name desc";
    private static final String SELECT_VS_IN_CLUSTER = "select r.host_name, s.computer_id, s.os_type, s.cluster_id, s.domain_id from t_stat_computer s, t_res_host r where r.computer_id = s.computer_id and s.cluster_id = ? and s.os_type = ? order by host_name desc";
    private static final String SELECT_CLUSTER_MEMBERS = "select r.host_name, s.computer_id, s.os_type, cluster_id from t_stat_computer s, t_res_host r where r.computer_id = s.computer_id and cluster_id = ? order by host_name desc";
    private static final String SELECT_FILERS_AND_DOMAINS = "select s.resource_id, d.domain_id, d.name from t_res_share s, t_res_domain d where s.computer_id = d.domain_id and s.resource_type in (1,103)";
    private static final String SELECT_DOMAIN_ID = "select domain_id from t_stat_computer where computer_id = ?";

    public TStatComputer(Connection dbc) {
        super(dbc);
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(" s.os_type not in (");
        for (short i = 0; i < 28; i = (short)(i + 1)) {
            if (!Constants.isUnmanagedOS((short)i)) continue;
            buffer.append(i);
            buffer.append(',');
        }
        buffer.setCharAt(buffer.length() - 1, ')');
        EXCLUDE_UNMANAGED_OSTYPES = buffer.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"TStatComputer", (String)"dbc");
        }
        this.tableName = "t_stat_computer";
        this.queryBySchedule = null;
        this.diskArrayLicensed = false;
        this.tsProbe = new Timestamp(0L);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"TStatComputer");
        }
    }

    public void setDiskArrayLicensed(boolean pDiskArrayLicensed) {
        this.diskArrayLicensed = pDiskArrayLicensed;
    }

    public static void appendNasAndVSOSTypes(StringBuffer buf, boolean includeNas, boolean includeVS, int exclude) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"appendNasAndVSOSTypes", (String)"buf, includeNas, includeVS, exclude");
        }
        boolean first = true;
        for (short i = 0; i < 28; i = (short)(i + 1)) {
            if (i == exclude || (!includeNas || !Constants.isNasBox((short)i)) && (!includeVS || !Constants.isVirtualServer((int)i))) continue;
            if (!first) {
                buf.append(',');
            }
            first = false;
            buf.append(i);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"appendNasAndVSOSTypes");
        }
    }

    public boolean getComputerStats(Computer c, MutableBoolean beenProbed) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"getComputerStats", (String)"c, beenProbed");
        }
        boolean status = false;
        try {
            this.selectStmt = this.prepareStmt("select s.computer_id, s.group_id, s.domain_id, s.manufacturer, s.model, s.serial_number, s.os_type, s.cpu_architecture, s.os_version, s.processor_type, s.processor_speed, s.processor_count, s.ram, s.swap_space, s.disk_capacity, s.disk_free_space, s.fs_free_space, s.last_boot_time, s.last_probe_time, s.probe_status, s.owned_disk_cap, s.owned_disk_free_sp, s.cluster_id, s.node_hosted_id from t_stat_computer s where s.computer_id = ?");
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, c.cmpID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            status = this.fetchRow(c);
            this.selectStmt.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"getComputerStats", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        beenProbed.value = status;
        boolean traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"getComputerStats", (boolean)traceResult);
        }
        return traceResult;
    }

    public boolean getGuiComputerStats(Computer c) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"getGuiComputerStats", (String)"c");
        }
        boolean status = false;
        boolean all = c.cmpID == -2;
        try {
            if (all) {
                this.selectStmt = this.prepareStmt("select s.computer_id, s.group_id, s.domain_id, s.manufacturer, s.model, s.serial_number, s.os_type, s.cpu_architecture, s.os_version, s.processor_type, s.processor_speed, s.processor_count, s.ram, s.swap_space, s.disk_capacity, s.disk_free_space, s.fs_free_space, s.last_boot_time, s.last_probe_time, s.probe_status, s.owned_disk_cap, s.owned_disk_free_sp, s.cluster_id, s.node_hosted_id , r.discovered_time from t_stat_computer s, t_res_host r where s.computer_id = r.computer_id and " + EXCLUDE_UNMANAGED_OSTYPES);
            } else {
                this.selectStmt = this.prepareStmt("select s.computer_id, s.group_id, s.domain_id, s.manufacturer, s.model, s.serial_number, s.os_type, s.cpu_architecture, s.os_version, s.processor_type, s.processor_speed, s.processor_count, s.ram, s.swap_space, s.disk_capacity, s.disk_free_space, s.fs_free_space, s.last_boot_time, s.last_probe_time, s.probe_status, s.owned_disk_cap, s.owned_disk_free_sp, s.cluster_id, s.node_hosted_id , r.discovered_time from t_stat_computer s, t_res_host r where s.computer_id = r.computer_id and s.computer_id = ?");
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, c.cmpID);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            status = this.fetchRow(c);
            if (status) {
                c.cmpDiscoveredTime = this.getTimestamp(this.resultSet);
                if (all) {
                    c.cmpNext = new Computer();
                    while (this.fetchRow(c.cmpNext)) {
                        c = c.cmpNext;
                        c.cmpDiscoveredTime = this.getTimestamp(this.resultSet);
                        c.cmpNext = new Computer();
                    }
                    c.cmpNext = null;
                }
            }
            this.selectStmt.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"getGuiComputerStats", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        boolean traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"getGuiComputerStats", (boolean)traceResult);
        }
        return traceResult;
    }

    public void insert(Computer c) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"insert", (String)"c");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.executeInsert(c);
        try {
            TGroup2Res grp2ResAccessor = new TGroup2Res(this.dbc);
            try {
                TComputer cmpInfo = TComputer.getComputer(null, null, c.cmpID, null, this.dbc);
                TComputer.updateOSVersion(c.cmpID, c.cmpOSVersion, this.dbc);
                grp2ResAccessor.insertNewResources(c.cmpID, c.cmpGroupID, cmpInfo.tsName, false);
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TStatComputer.class.getName(), (String)"insert", (Throwable)e);
                }
                grp2ResAccessor.insertNewResources(c.cmpID, c.cmpGroupID, null, false);
            }
            this.dbc.commit();
            this.insertStmt.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"insert");
        }
    }

    public boolean executeInsert(Computer c) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"executeInsert", (String)"c");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.insertStmt, c.cmpID);
            this.setInt(this.insertStmt, c.cmpGroupID);
            this.setStatistics(this.insertStmt, c);
            this.executeUpdate(this.insertStmt);
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TStatComputer.class.getName(), (String)"executeInsert", (boolean)traceResult);
            }
            return traceResult;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"executeInsert", (Throwable)e);
            }
            if (!SQLUtil.isDuplicateKeyViolation(e)) {
                this.stmtType = 1;
                this.sqlError(e);
            }
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TStatComputer.class.getName(), (String)"executeInsert", (boolean)traceResult);
            }
            return traceResult;
        }
    }

    public void prepSaveFiler() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"prepSaveFiler", (String)"");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.prepUpdateDomain();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"prepSaveFiler");
        }
    }

    public boolean saveFiler(Computer c) throws GeneralException {
        boolean rowInserted;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"saveFiler", (String)"c");
        }
        if (!(rowInserted = this.executeInsert(c)) && c.cmpDomainID > 0) {
            this.updateDomain(c);
        }
        if (rowInserted) {
            try {
                TGroup2Res grp2ResAccessor = new TGroup2Res(this.dbc);
                try {
                    TComputer cmpInfo = TComputer.getComputer(null, null, c.cmpID, null, this.dbc);
                    grp2ResAccessor.insertNewResources(c.cmpID, c.cmpGroupID, cmpInfo.tsName, false);
                }
                catch (SQLException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)TStatComputer.class.getName(), (String)"saveFiler", (Throwable)e);
                    }
                    grp2ResAccessor.insertNewResources(c.cmpID, c.cmpGroupID, null, false);
                }
                this.dbc.commit();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TStatComputer.class.getName(), (String)"saveFiler", (Throwable)e);
                }
                this.stmtType = 1;
                this.sqlError(e);
            }
        }
        boolean traceResult = rowInserted;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"saveFiler", (boolean)traceResult);
        }
        return traceResult;
    }

    public void prepUpdateDomain() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_DOMAIN);
    }

    public void updateDomain(Computer c) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"updateDomain", (String)"c");
        }
        try {
            this.setPhase();
            this.setInt(this.updateStmt, c.cmpDomainID);
            this.setInt(this.updateStmt, c.cmpID);
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"updateDomain", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"updateDomain");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateClusterMembership(Computer c) throws GeneralException {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"updateClusterMembership", (String)"c");
        }
        int updateCount = 0;
        try {
            this.updateStmt = this.prepareStmt(UPDATE_CLUSTER_MEMBERSHIP);
            this.setPhase();
            this.setInt(this.updateStmt, c.cmpClusterID);
            this.setInt(this.updateStmt, c.cmpNodeHostedID);
            this.setInt(this.updateStmt, c.cmpID);
            updateCount = this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"updateClusterMembership", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        finally {
            this.closeUpdate();
        }
        boolean bl = traceResult = updateCount > 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"updateClusterMembership", (boolean)traceResult);
        }
        return traceResult;
    }

    public boolean update(Computer c) throws GeneralException {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"update", (String)"c");
        }
        int updateCount = 0;
        this.updateStmt = this.prepareStmt(UPDATE);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setStatistics(this.updateStmt, c);
            this.setInt(this.updateStmt, c.cmpID);
            updateCount = this.executeUpdate(this.updateStmt);
            this.dbc.commit();
            this.updateStmt.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"update", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        boolean bl = traceResult = updateCount > 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"update", (boolean)traceResult);
        }
        return traceResult;
    }

    private boolean fetchRow(Computer c) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"fetchRow", (String)"c");
        }
        if (!this.nextResult()) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TStatComputer.class.getName(), (String)"fetchRow", (boolean)traceResult);
            }
            return traceResult;
        }
        this.stmtPhase = 1;
        this.colIndex = 1;
        c.cmpID = this.getInt(this.resultSet);
        c.cmpGroupID = this.getInt(this.resultSet);
        c.cmpDomainID = this.getInt(this.resultSet);
        c.cmpManufacturer = this.getString(this.resultSet);
        c.cmpModel = this.getString(this.resultSet);
        c.cmpSerialNumber = this.getString(this.resultSet);
        c.cmpOSType = this.getShort(this.resultSet);
        c.cmpCPUArchitecture = this.getShort(this.resultSet);
        c.cmpOSVersion = this.getString(this.resultSet);
        c.cmpProcessorType = this.getString(this.resultSet);
        c.cmpProcessorSpeed = this.getShort(this.resultSet);
        c.cmpProcessorCount = this.getShort(this.resultSet);
        c.cmpRAM = this.getInt(this.resultSet);
        c.cmpSwapSpace = this.getInt(this.resultSet);
        c.cmpDiskCapacity = this.getLong(this.resultSet);
        c.cmpDiskFreeSpace = this.getLong(this.resultSet);
        c.cmpFilesystemFreeSpace = this.getLong(this.resultSet);
        c.cmpLastBootTime = this.getTimestamp(this.resultSet);
        c.cmpLastProbeTime = this.getTimestamp(this.resultSet);
        c.cmpProbeStatus = this.getByte(this.resultSet);
        c.cmpOwnedDiskCap = this.getLong(this.resultSet);
        c.cmpOwnedDiskFreeSp = this.getLong(this.resultSet);
        c.cmpClusterID = this.getInt(this.resultSet);
        c.cmpNodeHostedID = this.getInt(this.resultSet);
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"fetchRow", (boolean)traceResult);
        }
        return traceResult;
    }

    private void setStatistics(PreparedStatement stmt, Computer c) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"setStatistics", (String)"stmt, c");
        }
        c.cmpDomainID = c.cmpDomain == null ? -1 : c.cmpDomain.domID;
        this.setInt(stmt, c.cmpDomainID);
        this.setString(stmt, c.cmpManufacturer);
        this.setString(stmt, c.cmpModel);
        this.setString(stmt, c.cmpSerialNumber);
        this.setShort(stmt, c.cmpOSType);
        this.setShort(stmt, c.cmpCPUArchitecture);
        this.setString(stmt, c.cmpOSVersion);
        this.setString(stmt, c.cmpProcessorType);
        this.setShort(stmt, c.cmpProcessorCount);
        this.setShort(stmt, c.cmpProcessorSpeed);
        this.setInt(stmt, c.cmpRAM);
        this.setInt(stmt, c.cmpSwapSpace);
        this.setLong(stmt, c.cmpDiskCapacity);
        this.setLong(stmt, c.cmpDiskFreeSpace);
        this.setLong(stmt, c.cmpFilesystemFreeSpace);
        this.setTimestamp(stmt, c.cmpLastBootTime);
        this.setTimestamp(stmt, c.cmpLastProbeTime, this.tsProbe);
        this.setByte(stmt, c.cmpProbeStatus);
        this.setLong(stmt, c.cmpOwnedDiskCap);
        this.setLong(stmt, c.cmpOwnedDiskFreeSp);
        this.setInt(stmt, c.cmpClusterID);
        this.setInt(stmt, c.cmpNodeHostedID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"setStatistics");
        }
    }

    public NameList getComputerNames(boolean excludeNAS) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"getComputerNames", (String)"excludeNAS");
        }
        NameList list = null;
        this.selectStmt = this.prepareStmt(SELECT_NAMES);
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                short osType = this.getShort(this.resultSet);
                if (Constants.isUnmanagedOS((short)osType) || excludeNAS && Constants.isNasBox((short)osType)) continue;
                int computerID = this.getInt(this.resultSet);
                NameList newname = new NameList();
                newname.nlNext = list;
                list = newname;
                newname.nlID = computerID;
            }
            this.selectStmt.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"getComputerNames", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        NameList traceResult = list;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"getComputerNames", traceResult);
        }
        return traceResult;
    }

    public NameList fetchNames() throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"fetchNames", (String)"");
        }
        NameList list = null;
        this.stmtPhase = 1;
        while (this.nextResult()) {
            NameList newname = new NameList();
            newname.nlNext = list;
            list = newname;
            this.colIndex = 1;
            newname.nlID = this.getInt(this.resultSet);
        }
        NameList traceResult = list;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"fetchNames", (Object)traceResult);
        }
        return traceResult;
    }

    public void prepPingSelect() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_PING_CMP_GROUP);
    }

    public NameList getComputerGroup(int groupID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"getComputerGroup", (String)"groupID");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, groupID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            NameList traceResult = this.fetchNames();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TStatComputer.class.getName(), (String)"getComputerGroup", (Object)traceResult);
            }
            return traceResult;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"getComputerGroup", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
            NameList traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TStatComputer.class.getName(), (String)"getComputerGroup", traceResult);
            }
            return traceResult;
        }
    }

    public void prepGroupSelect() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_GROUP_MEMBERS);
    }

    public NameList selectNames(GuiListReq req) throws GeneralException {
        boolean includeUnmanaged;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"selectNames", (String)"req");
        }
        NameList head = null;
        NameList prev = null;
        boolean excludeVS = req.excludeVS;
        boolean bl = includeUnmanaged = req.includeUnmanaged || req.listRequested == 1 && req.groupID > 0;
        short desiredOSType = req.excludeNAS ? (short)-1 : (req.qualifierID == 0 && req.qualifier > 0 ? (short)req.qualifier : (short)0);
        StringBuffer buf = new StringBuffer();
        if (req.listRequested == 0) {
            buf.append("select s.os_type, s.computer_id, r.host_name, s.cluster_id from t_stat_computer s, t_res_host r, t_view_group2res gr ");
            int[] groupIDList = new int[]{req.groupID};
            buf.append(" where r.computer_id = s.computer_id ");
            Group2ResSqlUtil.appendG2RWhere(buf, groupIDList, true, true, 13, "gr");
            buf.append(" AND s.computer_id in (gr.resource_id)");
        } else {
            buf.append(JOIN_1);
        }
        if (req.groupID > 0) {
            if (req.listRequested != 0) {
                buf.append(" AND s.group_id = ");
                buf.append(Integer.toString(req.groupID));
            }
        } else if (req.qualifierID != 0) {
            buf.append(" AND s.domain_id = ");
            buf.append(Integer.toString(req.qualifierID));
        }
        buf.append(" ORDER BY 3");
        this.selectStmt = this.prepareStmt(buf.toString());
        this.stmtPhase = 3;
        try {
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 0;
            while (this.nextResult()) {
                this.colIndex = 1;
                short osType = this.getShort(this.resultSet);
                if (!includeUnmanaged && Constants.isUnmanagedOS((short)osType) || !this.isDesiredOSType(osType, desiredOSType) || excludeVS && Constants.isVirtualServer((int)osType)) continue;
                int computerID = this.getInt(this.resultSet);
                NameList element = new NameList();
                element.nlInfo = 1;
                element.nlID = computerID;
                element.nlID2 = osType;
                element.nlName = this.getString(this.resultSet);
                element.nlClusterID = this.getInt(this.resultSet);
                if (element.nlClusterID > 0) {
                    TResCluster trescluster = new TResCluster(this.dbc);
                    trescluster.fillInClusterDetails(element);
                }
                if (prev != null) {
                    prev.nlNext = element;
                } else {
                    head = element;
                }
                prev = element;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"selectNames", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        if (req.getVersions) {
            this.getVersions(head);
        }
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"selectNames", traceResult);
        }
        return traceResult;
    }

    private boolean isDesiredOSType(short osType, short desiredOSType) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"isDesiredOSType", (String)"osType, desiredOSType");
        }
        boolean result = desiredOSType == 0 ? true : (desiredOSType < 0 ? !Constants.isNasBox((short)osType) : osType == desiredOSType);
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"isDesiredOSType", (boolean)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVirtualServer(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"isVirtualServer", (String)"computerID");
        }
        boolean result = false;
        this.selectStmt = this.prepareStmt(SELECT_VIRTUAL_SERVER);
        try {
            this.setPhase();
            this.setInt(this.selectStmt, computerID);
            this.setInt(this.selectStmt, 20);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            result = this.nextResult();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"isVirtualServer", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"isVirtualServer", (boolean)traceResult);
        }
        return traceResult;
    }

    public void getVersions(NameList list) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"getVersions", (String)"list");
        }
        this.selectStmt = this.prepareStmt("select computer_id, product_versions from t_res_agent");
        this.stmtPhase = 3;
        try {
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                int computerID = this.getInt(this.resultSet);
                byte[] productVersions = this.getBytes(this.resultSet);
                NameList element = list;
                while (element != null) {
                    if (element.nlID == computerID) {
                        String version = " - (" + productVersions[0] + "." + productVersions[1] + "." + productVersions[2] + ")";
                        element.nlName = element.nlName + version;
                    }
                    element = element.nlNext;
                }
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"getVersions", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"getVersions");
        }
    }

    public void prepFetchByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"prepFetchByID", (String)"");
        }
        StringBuffer buf = new StringBuffer(180);
        buf.append(JOIN_1);
        buf.append(GUI_UNIQUE);
        this.selectStmt = this.prepareStmt(buf.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"prepFetchByID");
        }
    }

    public boolean fetchByID(Share share) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"fetchByID", (String)"share");
        }
        boolean result = false;
        this.setPhase();
        try {
            this.setInt(this.selectStmt, share.shResourceID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                result = true;
                this.getPhase();
                this.getShort(this.resultSet);
                share.shResourceID = this.getInt(this.resultSet);
                share.shPath = this.getString(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"fetchByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"fetchByID", (boolean)traceResult);
        }
        return traceResult;
    }

    public void initQueryByAttrType(short attributeType, HasID list) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"initQueryByAttrType", (String)"attributeType, list");
        }
        StringBuffer buf = new StringBuffer(400);
        buf.append(SELECT_BY_ATTR_TYPE_PT_I);
        SQLUtil.appendInClause(buf, list);
        buf.append(SELECT_BY_ATTR_TYPE_PT_II);
        this.selectStmt = this.prepareStmt(buf.toString());
        this.setPhase();
        try {
            this.setShort(this.selectStmt, attributeType);
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"initQueryByAttrType", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.queryBySchedule = new QueryBySchedule(this, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"initQueryByAttrType");
        }
    }

    public NameList computersTiedTo(int objectID, boolean excludeNonOS) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"computersTiedTo", (String)"objectID, excludeNonOS");
        }
        this.selectStmt = this.prepareStmt(JOIN_2);
        this.stmtType = 0;
        this.colIndex = 1;
        this.stmtPhase = 0;
        try {
            this.setInt(this.selectStmt, objectID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"computersTiedTo", (Throwable)e);
            }
            this.sqlError(e);
        }
        int computerID = -1;
        boolean excluded = false;
        short osType = 0;
        int lastComputerID = -3;
        NameList head = null;
        this.stmtPhase = 1;
        while (this.nextResult()) {
            this.colIndex = 1;
            try {
                osType = this.getShort(this.resultSet);
                if (Constants.isUnmanagedOS((short)osType) || excludeNonOS && Constants.isNasBox((short)osType)) continue;
                computerID = this.getInt(this.resultSet);
                excluded = this.getBoolean(this.resultSet);
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TStatComputer.class.getName(), (String)"computersTiedTo", (Throwable)e);
                }
                this.sqlError(e);
            }
            if (computerID == lastComputerID) continue;
            lastComputerID = computerID;
            if (excluded) continue;
            NameList item = new NameList();
            item.nlID = computerID;
            item.nlInfo = osType;
            item.nlNext = head;
            head = item;
        }
        this.closeSelect();
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"computersTiedTo", traceResult);
        }
        return traceResult;
    }

    public NameList queryDependents(int attributeID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"queryDependents", (String)"attributeID");
        }
        this.selectStmt = this.prepareStmt(JOIN_3);
        this.stmtType = 0;
        this.colIndex = 1;
        this.stmtPhase = 0;
        try {
            this.setInt(this.selectStmt, attributeID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"queryDependents", (Throwable)e);
            }
            this.sqlError(e);
        }
        NameList head = null;
        NameList prev = null;
        this.stmtPhase = 1;
        while (this.nextResult()) {
            NameList element = new NameList();
            element.nlInfo = 1;
            this.colIndex = 1;
            try {
                element.nlID = this.getInt(this.resultSet);
                element.nlName = this.getString(this.resultSet);
                if (this.getBoolean(this.resultSet)) {
                    element.nlState = 1;
                }
                element.nlClusterID = this.getInt(this.resultSet);
                if (element.nlClusterID > 0) {
                    TResCluster trescluster = new TResCluster(this.dbc);
                    trescluster.fillInClusterDetails(element);
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TStatComputer.class.getName(), (String)"queryDependents", (Throwable)e);
                }
                this.sqlError(e);
            }
            if (prev == null) {
                head = element;
            } else {
                prev.nlNext = element;
            }
            prev = element;
        }
        this.closeSelect();
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"queryDependents", traceResult);
        }
        return traceResult;
    }

    public int getNetwareCount() throws GeneralException {
        int result = 0;
        this.selectStmt = this.prepareStmt(NETWARE_COUNT);
        try {
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                result = this.getInt(this.resultSet);
            }
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.stmtPhase = 3;
            this.sqlError(e);
        }
        return result;
    }

    public void initQueryBySchedule(int scheduleID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"initQueryBySchedule", (String)"scheduleID");
        }
        throw new GeneralException(MessageLog.getMessage((String)"STA0254I", null));
    }

    public void initQueryBySchedule(int scheduleID, short jobType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"initQueryBySchedule", (String)"scheduleID, jobType");
        }
        this.prepareDiscovery(jobType);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"initQueryBySchedule");
        }
    }

    private void prepareDiscovery(short jobType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"prepareDiscoveryNoES", (String)"");
        }
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(SELECT_DOMAIN_DISCOVERY_COMPUTERS);
        buffer.append(WHERE_DISCOVERY_OS_TYPE);
        buffer.append(ORDER_DISCOVERY_COMPUTERS);
        this.selectStmt = this.prepareStmt(buffer.toString());
        try {
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"prepareDiscoveryNoES", (Throwable)e);
            }
            this.stmtType = 0;
            this.stmtPhase = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"prepareDiscoveryNoES");
        }
    }

    public boolean fetchQueryBySchedule(NameList element) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"fetchQueryBySchedule", (String)"element");
        }
        if (this.queryBySchedule != null) {
            boolean traceResult = this.queryBySchedule.fetch(element);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TStatComputer.class.getName(), (String)"fetchQueryBySchedule", (boolean)traceResult);
            }
            return traceResult;
        }
        boolean gotRow = false;
        try {
            gotRow = this.nextResult();
            if (!gotRow) {
                this.closeSelect();
            } else {
                this.getPhase();
                element.nlID2 = this.getInt(this.resultSet);
                element.nlID = this.getInt(this.resultSet);
                element.nlState = this.getByte(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"fetchQueryBySchedule", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        boolean traceResult = gotRow;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"fetchQueryBySchedule", (boolean)traceResult);
        }
        return traceResult;
    }

    public NasFilerAdmin selectWindowsFilers() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"selectWindowsFilers", (String)"");
        }
        NasFilerAdmin head = null;
        NasFilerAdmin prev = null;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT_WINDOWS_FILERS);
            while (this.nextResult()) {
                boolean isNasBox;
                this.getPhase();
                short osType = this.getShort(this.resultSet);
                if (osType == 8 || !(isNasBox = Constants.isNasBox((short)osType))) continue;
                NasFilerAdmin filer = new NasFilerAdmin();
                filer.nfaFilerID = this.getInt(this.resultSet);
                filer.nfaDomainID = this.getInt(this.resultSet);
                filer.nfaNetworkName = this.getString(this.resultSet);
                filer.nfaDomainName = this.getString(this.resultSet);
                if (prev != null) {
                    prev.nfaNext = filer;
                } else {
                    head = filer;
                }
                prev = filer;
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"selectWindowsFilers", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        NasFilerAdmin traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"selectWindowsFilers", traceResult);
        }
        return traceResult;
    }

    public NameList selectAgents() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"selectAgents", (String)"");
        }
        NameList head = null;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT_AGENTS);
            while (this.nextResult()) {
                this.getPhase();
                boolean isWindows = Constants.isWindows((short)this.getShort(this.resultSet));
                if (!isWindows) continue;
                int compID = this.getInt(this.resultSet);
                NameList node = new NameList();
                node.nlID2 = compID;
                node.nlID = this.getInt(this.resultSet);
                node.nlNext = head;
                head = node;
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"selectAgents", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"selectAgents", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameList selectAgentsInCluster(int cluster_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"selectAgentsInCluster", (String)"cluster_id");
        }
        NameList head = null;
        try {
            this.selectStmt = this.prepareStmt(SELECT_AGENTS_IN_CLUSTER);
            this.setPhase();
            this.setInt(this.selectStmt, cluster_id);
            this.setInt(this.selectStmt, 20);
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                String name = this.getString(this.resultSet);
                int compID = this.getInt(this.resultSet);
                NameList node = new NameList();
                node.nlName = name;
                node.nlID = compID;
                node.nlID2 = this.getShort(this.resultSet);
                node.nlInfo = 1;
                node.nlClusterID = this.getInt(this.resultSet);
                node.nlID3 = this.getInt(this.resultSet);
                if (node.nlClusterID > 0) {
                    TResCluster trescluster = new TResCluster(this.dbc);
                    Cluster c = trescluster.getClusterByID(node.nlClusterID);
                    node.nlClusterName = c.clusterName;
                    node.nlClusterDomain = c.domain_name;
                }
                node.nlNext = head;
                head = node;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"selectAgentsInCluster", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"selectAgentsInCluster", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameList selectVirtualServersInCluster(int cluster_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"selectVirtualServersInCluster", (String)"cluster_id");
        }
        boolean index = true;
        NameList head = null;
        try {
            this.selectStmt = this.prepareStmt(SELECT_VS_IN_CLUSTER);
            this.setPhase();
            this.setInt(this.selectStmt, cluster_id);
            this.setInt(this.selectStmt, 20);
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                NameList node = new NameList();
                node.nlName = this.getString(this.resultSet);
                node.nlID = this.getInt(this.resultSet);
                node.nlID2 = this.getShort(this.resultSet);
                node.nlInfo = 1;
                node.nlClusterID = this.getInt(this.resultSet);
                node.nlID3 = this.getInt(this.resultSet);
                if (node.nlClusterID > 0) {
                    TResCluster trescluster = new TResCluster(this.dbc);
                    Cluster c = trescluster.getClusterByID(node.nlClusterID);
                    node.nlClusterName = c.clusterName;
                    node.nlClusterDomain = c.domain_name;
                }
                node.nlNext = head;
                head = node;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"selectVirtualServersInCluster", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"selectVirtualServersInCluster", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameList selectComputersAndDomains() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"selectComputersAndDomains", (String)"");
        }
        NameList head = null;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT_FILERS_AND_DOMAINS);
            while (this.nextResult()) {
                this.getPhase();
                NameList node = new NameList();
                node.nlID = this.getInt(this.resultSet);
                node.nlID2 = this.getInt(this.resultSet);
                node.nlName = this.getString(this.resultSet);
                node.nlNext = head;
                head = node;
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"selectComputersAndDomains", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
        }
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"selectComputersAndDomains", traceResult);
        }
        return traceResult;
    }

    public boolean domainHasOtherOSAgents(int domainID, int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"domainHasOtherOSAgents", (String)"domainID, computerID");
        }
        boolean foundOSAgent = false;
        this.selectStmt = this.prepareStmt(SELECT_DOMAIN_SIZE);
        try {
            this.setPhase();
            this.setInt(this.selectStmt, domainID);
            this.setInt(this.selectStmt, computerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult(this.resultSet)) {
                this.getPhase();
                int fetchedID = this.getInt(this.resultSet);
                foundOSAgent = true;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"domainHasOtherOSAgents", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        boolean traceResult = foundOSAgent;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"domainHasOtherOSAgents", (boolean)traceResult);
        }
        return traceResult;
    }

    public void prepSelectDomainID() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_DOMAIN_ID);
    }

    public int fetchDomainID(int computerID, MutableBoolean pRowPresent) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"fetchDomainID", (String)"computerID, pRowPresent");
        }
        int result = -1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, computerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            boolean rowPresent = this.resultSet.next();
            if (pRowPresent != null) {
                pRowPresent.value = rowPresent;
            }
            if (rowPresent) {
                this.getPhase();
                result = this.getInt(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"fetchDomainID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"fetchDomainID", (int)traceResult);
        }
        return traceResult;
    }

    public int fetchDomainID(int computerID) throws GeneralException {
        return this.fetchDomainID(computerID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameList getClusterMembers(int clusterID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"getClusterMembers", (String)"clusterID");
        }
        NameList head = null;
        try {
            this.selectStmt = this.prepareStmt(SELECT_CLUSTER_MEMBERS);
            this.setPhase();
            this.setInt(this.selectStmt, clusterID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                NameList node = new NameList();
                node.nlName = this.getString(this.resultSet);
                node.nlID = this.getInt(this.resultSet);
                node.nlID2 = this.getInt(this.resultSet);
                node.nlClusterID = this.getInt(this.resultSet);
                if (node.nlClusterID > 0) {
                    TResCluster trescluster = new TResCluster(this.dbc);
                    trescluster.fillInClusterDetails(node);
                }
                node.nlNext = head;
                head = node;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"getClusterMembers", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"getClusterMembers", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusterID(Computer c) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatComputer.class.getName(), (String)"getClusterID", (String)"c");
        }
        int cluster_id = -1;
        try {
            this.selectStmt = this.prepareStmt(SELECT_CLUSTER_ID);
            this.setPhase();
            this.setInt(this.selectStmt, c.cmpID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            if (this.nextResult()) {
                cluster_id = this.getInt(this.resultSet);
                if (this.resultSet.wasNull()) {
                    cluster_id = -1;
                }
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatComputer.class.getName(), (String)"getClusterID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeResultSet();
            this.closeSelect();
        }
        int traceResult = cluster_id;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatComputer.class.getName(), (String)"getClusterID", (int)traceResult);
        }
        return traceResult;
    }

    static {
        SELECT_BY_ATTR_TYPE_PT_II = " and (a.resource_id = c.computer_id or a.resource_id = c.group_id or a.resource_type = " + Short.toString((short)13) + " or a.resource_type = " + Short.toString((short)99) + ") order by 1, 2, 3 desc";
        JOIN_2 = "select distinct c.os_type, c.computer_id, a.exclude from t_stat_computer c, t_res_attribute a  where a.attribute_id = ? and (c.computer_id = a.resource_id or c.group_id = a.resource_id or   a.resource_id = c.cluster_id or a.resource_type = " + Short.toString((short)13) + ") order by 2, 3 desc";
        StringBuffer buf = new StringBuffer(50);
        buf.append(" not in (");
        TStatComputer.appendNasAndVSOSTypes(buf, true, true, 29);
        buf.append(')');
        WHERE_DISCOVERY_OS_TYPE = buf.toString();
        buf = new StringBuffer(50);
        buf.append(" in (");
        TStatComputer.appendNasAndVSOSTypes(buf, true, false, 8);
        buf.append(')');
        WHERE_NAS = buf.toString();
    }
}

