/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TStatDisk
extends StorageRepositoryAccessor {
    private static final String GET_DISK_BY_ID = "select heads, cylinders, rpm, sector_size, sectors_avg_track, sectors_outr_track, sectors_innr_track, logical_block_size, minutes_powered_on, write_protected, write_cache_enable, read_cache_disable, auto_write_realloc, auto_read_realloc, no_error_recovery, failure_predicted, capacity, spare_blocks, volgroup_id, desired_awre, desired_arre, desired_noerrrcvry from t_stat_disk where disk_id = ?";
    private static final String SELECT_HOST_LUNS_PREAMBLE = "select v.serial_number, s.disk_id, s.logical_disk_id from t_stat_disk s, t_res_physical_volume v where s.disk_id = v.physical_volume_id and ";
    private static final String SELECT_PATHS_FOR_HOST_DISK = "select c.host_name, c.host_url, c.os_type, a.path from t_res_host c, t_res_dev_access a, t_res_controller n, t_stat_disk d where c.computer_id = n.computer_id and n.controller_id = a.controller_id and a.device_id = d.disk_id and d.disk_id = ?";
    private static final String SELECT_PATHS_FOR_SUBSYSTEM_DISK = "select ss.name, ss.name, ss.os_type, pv.device_id from t_res_storage_subsystem ss, t_res_physical_volume pv where ss.subsystem_id = pv.subsystem_id and pv.physical_volume_id = ?";
    private static final String SELECT_PATHS_FOR_SVC_MDISK = "select ss.name, ss.name, ss.os_type, se.element_name from t_res_storage_subsystem ss, t_res_storage_extent se where ss.subsystem_id = se.subsystem_id and se.storage_extent_id = ?";
    private static final String SELECT_LUN_DEFINITION_GIVEN_DISK = "select svid from t_res_view_ssluncmp where physical_volume_id = ?";
    private static final String INSERT_DISK = "insert into t_stat_disk (disk_id, heads, cylinders, rpm, sector_size, sectors_avg_track, sectors_outr_track, sectors_innr_track, logical_block_size, minutes_powered_on, write_protected, write_cache_enable, read_cache_disable, auto_write_realloc, auto_read_realloc, no_error_recovery, failure_predicted, capacity, spare_blocks, volgroup_id, desired_awre, desired_arre, desired_noerrrcvry, logical_disk_id, disk_identity) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,-1,?)";
    private static final String UPDATE_DISK = "update t_stat_disk set sector_size = ?, sectors_avg_track = ?, sectors_outr_track = ?, sectors_innr_track = ?, logical_block_size=?, minutes_powered_on = ?, write_protected = ?, write_cache_enable = ?, read_cache_disable = ?, auto_write_realloc = ?, auto_read_realloc=?, no_error_recovery = ?, failure_predicted = ?, capacity = ?, spare_blocks = ?, volgroup_id = ?, desired_awre = ?, desired_arre = ?, desired_noerrrcvry = ?, disk_identity = ? where disk_id = ?";
    private static final String UPDATE_DISK_DESIRED_SETTINGS = "update t_stat_disk set desired_awre = ?, desired_arre = ?, desired_noerrrcvry = ? where disk_id = ?";
    private static final String GET_LOGICAL_DISK_ID = "select logical_disk_id from t_stat_disk where disk_id = ?";
    private static final String UPDATE_LOGICAL_DISK_ID = "update t_stat_disk set logical_disk_id = ? where disk_id = ?";
    private static final String UPDATE_VOLGROUP_ID = "update t_stat_disk set volgroup_id = ? where disk_id = ?";
    private static final String UPDATE_SVC_DISK_IDENTITY = "update t_stat_disk set disk_identity = ? where disk_id in (select device_id from t_res_dev_access where controller_id = ?)";
    private static final String DELETE_DISK = "delete from t_stat_disk where disk_id = ?";
    private static final String INSERT_SS_DISK_DATA = "insert into t_stat_disk (DISK_ID, HEADS, CYLINDERS, RPM, SECTOR_SIZE, SECTORS_AVG_TRACK, SECTORS_OUTR_TRACK, SECTORS_INNR_TRACK, LOGICAL_BLOCK_SIZE, MINUTES_POWERED_ON, WRITE_PROTECTED, WRITE_CACHE_ENABLE, READ_CACHE_DISABLE, AUTO_WRITE_REALLOC, AUTO_READ_REALLOC, NO_ERROR_RECOVERY, FAILURE_PREDICTED, CAPACITY, SPARE_BLOCKS, VOLGROUP_ID, DESIRED_AWRE, DESIRED_ARRE, DESIRED_NOERRRCVRY, LOGICAL_DISK_ID, DISK_IDENTITY) select pv.PHYSICAL_VOLUME_ID, -1, -1, -1, 512, -1, -1, -1, 512, -1, '0', '0', '0', '0', '0', '0', '0', CASE WHEN pv.capacity  IS NULL  THEN 0  ELSE pv.capacity  END, -1, 0, '0', '0', '0', -1, '0' from t_res_physical_volume pv where pv.physical_volume_id NOT IN (select disk_id from t_stat_disk) and ";
    private static final String INSERT_SVC_MDISK_DATA = "insert into t_stat_disk (DISK_ID, HEADS, CYLINDERS, RPM, SECTOR_SIZE, SECTORS_AVG_TRACK, SECTORS_OUTR_TRACK, SECTORS_INNR_TRACK, LOGICAL_BLOCK_SIZE, MINUTES_POWERED_ON, WRITE_PROTECTED, WRITE_CACHE_ENABLE, READ_CACHE_DISABLE, AUTO_WRITE_REALLOC, AUTO_READ_REALLOC, NO_ERROR_RECOVERY, FAILURE_PREDICTED, CAPACITY, SPARE_BLOCKS, VOLGROUP_ID, DESIRED_AWRE, DESIRED_ARRE, DESIRED_NOERRRCVRY, LOGICAL_DISK_ID, DISK_IDENTITY) select se.STORAGE_EXTENT_ID, -1, -1, -1, 512, -1, -1, -1, 512, -1, '0', '0', '0', '0', '0', '0', '0', CASE WHEN se.total_capacity  IS NULL  THEN 0  ELSE se.total_capacity  END, -1, 0, '0', '0', '0', -1, '0'  from t_res_storage_extent se where  se.storage_extent_id NOT IN (select disk_id from t_stat_disk) and ";
    private static final String SELECT_SS_DISKS = "select disk_id from t_stat_disk stat, t_res_physical_volume pv where stat.disk_id = pv.physical_volume_id and ";
    private static final String SELECT_SVC_DISKS = "select disk_id from t_stat_disk stat, t_res_storage_extent se where stat.disk_id = se.storage_extent_id and ";
    private static final String UPDATE_SS_DISK_DATA = "update t_stat_disk set SECTOR_SIZE = 512, SECTORS_AVG_TRACK = -1, SECTORS_OUTR_TRACK = -1, SECTORS_INNR_TRACK = -1, LOGICAL_BLOCK_SIZE = 512, MINUTES_POWERED_ON = -1, WRITE_PROTECTED = cast (0 as char), WRITE_CACHE_ENABLE = cast (0 as char), READ_CACHE_DISABLE = cast (0 as char), AUTO_WRITE_REALLOC = cast (0 as char), AUTO_READ_REALLOC = cast (0 as char), NO_ERROR_RECOVERY = cast (0 as char), FAILURE_PREDICTED = cast (0 as char), CAPACITY = (select (CASE WHEN pv.capacity  IS NULL  THEN 0  ELSE pv.capacity  END) from t_res_physical_volume pv, t_stat_disk sdisk where pv.physical_volume_id = sdisk.disk_id and pv.physical_volume_id = ?), SPARE_BLOCKS = -1, VOLGROUP_ID = 0, DESIRED_AWRE = cast (0 as char), DESIRED_ARRE = cast (0 as char), DESIRED_NOERRRCVRY = cast (0 as char), DISK_IDENTITY = cast (0 as char) where disk_id = ?";
    private static final String UPDATE_SVC_MDISK_DATA = "update t_stat_disk set   SECTOR_SIZE = 512,     SECTORS_AVG_TRACK = -1,    SECTORS_OUTR_TRACK = -1,     SECTORS_INNR_TRACK = -1,      LOGICAL_BLOCK_SIZE = 512,      MINUTES_POWERED_ON = -1,     WRITE_PROTECTED = '0',       WRITE_CACHE_ENABLE = '0',     READ_CACHE_DISABLE = '0',      AUTO_WRITE_REALLOC = '0',    AUTO_READ_REALLOC = '0',      NO_ERROR_RECOVERY = '0',      FAILURE_PREDICTED = '0',      CAPACITY = (SELECT CASE WHEN se.total_capacity  IS NULL  THEN 0  ELSE se.total_capacity  END    from t_res_storage_extent se,    t_stat_disk sdisk    \t where se.storage_extent_id = sdisk.disk_id and  \t se.storage_extent_id = ?),      SPARE_BLOCKS = -1,      VOLGROUP_ID = 0,    \tDESIRED_AWRE = '0',    \tDESIRED_ARRE = '0',    \tDESIRED_NOERRRCVRY = '0',  \tDISK_IDENTITY = '0' where disk_id = ?";

    public TStatDisk(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"TStatDisk", (String)"dbc");
        }
        this.tableName = "t_stat_disk";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"TStatDisk");
        }
    }

    public int updateSSandSVCDisks(int[] svcIDs, int[] ssIDs) throws GeneralException {
        int updatedRows = 0;
        if (svcIDs.length > 0) {
            StringBuffer selectSVCMDisks = new StringBuffer();
            selectSVCMDisks.append(SELECT_SVC_DISKS);
            SQLUtil.appendInClause(selectSVCMDisks, "se.subsystem_id", svcIDs);
            StringBuffer updateTStatDiskMDisk = new StringBuffer();
            updateTStatDiskMDisk.append(UPDATE_SVC_MDISK_DATA);
            updatedRows += this.executeUpdateDisks(selectSVCMDisks.toString(), updateTStatDiskMDisk.toString(), svcIDs);
        }
        if (ssIDs.length > 0) {
            StringBuffer selectSSDisks = new StringBuffer();
            selectSSDisks.append(SELECT_SS_DISKS);
            SQLUtil.appendInClause(selectSSDisks, "pv.subsystem_id", ssIDs);
            StringBuffer updateTStatDiskSS = new StringBuffer();
            updateTStatDiskSS.append(UPDATE_SS_DISK_DATA);
            updatedRows += this.executeUpdateDisks(selectSSDisks.toString(), updateTStatDiskSS.toString(), ssIDs);
        }
        return updatedRows;
    }

    private int executeUpdateDisks(String selectSql, String updateSql, int[] ids) throws GeneralException {
        int updatedRows = 0;
        try {
            Statement selectStmt = this.dbc.createStatement();
            ResultSet selectDisksRS = selectStmt.executeQuery(selectSql);
            PreparedStatement updateDisksStmt = this.dbc.prepareStatement(updateSql);
            int idindex = 0;
            int disk_id = -1;
            while (selectDisksRS.next()) {
                disk_id = selectDisksRS.getInt(1);
                updateDisksStmt.setInt(1, disk_id);
                updateDisksStmt.setInt(2, disk_id);
                ++idindex;
                updatedRows += updateDisksStmt.executeUpdate();
            }
            updateDisksStmt.close();
            this.dbc.commit();
        }
        catch (SQLException sqle) {
            this.sqlError(sqle);
        }
        return updatedRows;
    }

    public int insertSSandSVCDisks(int[] svcIDs, int[] ssIDs) throws GeneralException {
        int insertedRows = 0;
        if (svcIDs.length > 0) {
            StringBuffer insertTStatDiskMDisk = new StringBuffer();
            insertTStatDiskMDisk.append(INSERT_SVC_MDISK_DATA);
            SQLUtil.appendInClause(insertTStatDiskMDisk, "se.subsystem_id", svcIDs);
            insertedRows += this.executeInsertDisks(insertTStatDiskMDisk.toString());
        }
        if (ssIDs.length > 0) {
            StringBuffer insertTStatDiskSS = new StringBuffer();
            insertTStatDiskSS.append(INSERT_SS_DISK_DATA);
            SQLUtil.appendInClause(insertTStatDiskSS, "pv.subsystem_id", ssIDs);
            insertedRows += this.executeInsertDisks(insertTStatDiskSS.toString());
        }
        return insertedRows;
    }

    private int executeInsertDisks(String sqlText) throws GeneralException {
        int insertedRows = 0;
        try {
            Statement insertStatement = this.dbc.createStatement();
            insertedRows = insertStatement.executeUpdate(sqlText);
            insertStatement.close();
            this.dbc.commit();
        }
        catch (SQLException sqle) {
            this.sqlError(sqle);
        }
        return insertedRows;
    }

    public Device getDiskByID(Device devListIn) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"getDiskByID", (String)"devListIn");
        }
        Device devListOut = null;
        try {
            Device dev;
            this.selectStmt = this.prepareStmt(GET_DISK_BY_ID);
            while ((dev = devListIn) != null) {
                devListIn = dev.devNext;
                if (dev.isFixedDisk()) {
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    this.setInt(this.selectStmt, dev.devID);
                    this.stmtPhase = 3;
                    this.resultSet = this.selectStmt.executeQuery();
                    if (!this.getDisk((Disk)dev)) continue;
                }
                dev.devNext = devListOut;
                devListOut = dev;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDisk.class.getName(), (String)"getDiskByID", (Throwable)e);
            }
            this.sqlError(e);
        }
        Device traceResult = devListOut;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"getDiskByID", traceResult);
        }
        return traceResult;
    }

    private boolean getDisk(Disk disk) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"getDisk", (String)"disk");
        }
        this.stmtPhase = 0;
        if (!this.nextResult()) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TStatDisk.class.getName(), (String)"getDisk", (boolean)traceResult);
            }
            return traceResult;
        }
        this.colIndex = 1;
        disk.dskHeads = this.getInt(this.resultSet);
        disk.dskCylinders = this.getInt(this.resultSet);
        disk.dskRPM = this.getInt(this.resultSet);
        disk.dskSectorSize = this.getInt(this.resultSet);
        disk.dskSectorsPerAvgTrack = this.getInt(this.resultSet);
        disk.dskSectorsPerOuterTrack = this.getInt(this.resultSet);
        disk.dskSectorsPerInnerTrack = this.getInt(this.resultSet);
        disk.dskLogicalBlockSize = this.getInt(this.resultSet);
        disk.dskMinutesPoweredOn = this.getInt(this.resultSet);
        disk.dskWriteProtected = this.getBoolean(this.resultSet);
        disk.dskWriteCacheEnabled = this.getBoolean(this.resultSet);
        disk.dskReadCacheDisabled = this.getBoolean(this.resultSet);
        disk.dskAutoWriteRealloc = this.getBoolean(this.resultSet);
        disk.dskAutoReadRealloc = this.getBoolean(this.resultSet);
        disk.dskNoErrorRecovery = this.getBoolean(this.resultSet);
        disk.dskFailurePredicted = this.getBoolean(this.resultSet);
        disk.dskCapacity = this.getLong(this.resultSet);
        disk.dskSpareBlocks = this.getInt(this.resultSet);
        disk.dskVolgroupID = this.getInt(this.resultSet);
        disk.dskDesiredAWRE = this.getByte(this.resultSet);
        disk.dskDesiredARRE = this.getByte(this.resultSet);
        disk.dskDesiredNoErrRcvry = this.getByte(this.resultSet);
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"getDisk", (boolean)traceResult);
        }
        return traceResult;
    }

    public NameList selectHostLUNs(Computer computer) throws GeneralException {
        String sqlText;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"selectHostLUNs", (String)"computer");
        }
        int daLength = 0;
        NameList head = null;
        StringBuffer buf = new StringBuffer(300);
        buf.append(SELECT_HOST_LUNS_PREAMBLE);
        buf.append("v.storage_system_type = " + computer.cmpOSType);
        if (computer.cmpOSType == 18) {
            buf.append(" and v.serial_number = ?");
            sqlText = buf.toString();
            buf = null;
            this.setSQLText(sqlText);
            try {
                this.selectStmt = this.prepareStmt(sqlText);
                LogicalDisk ld = computer.cmpLogicalDisk;
                while (ld != null) {
                    String wrkLun;
                    this.setPhase();
                    if (computer.cmpOSType == 14) {
                        wrkLun = ld.ldPath.substring(9, 16);
                        wrkLun = wrkLun + "/";
                        wrkLun = wrkLun + ld.ldPath.substring(16);
                    } else {
                        wrkLun = ld.ldPath;
                    }
                    this.setString(this.selectStmt, wrkLun);
                    this.stmtPhase = 3;
                    this.resultSet = this.selectStmt.executeQuery();
                    if (this.nextResult()) {
                        NameList element = new NameList();
                        this.getPhase();
                        element.nlName = this.getString(this.resultSet);
                        if (computer.cmpOSType == 14) {
                            element.nlName = element.nlName.substring(8);
                        }
                        element.nlID = this.getInt(this.resultSet);
                        element.nlID2 = this.getInt(this.resultSet);
                        element.nlNext = head;
                        head = element;
                    }
                    ld = ld.ldNext;
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TStatDisk.class.getName(), (String)"selectHostLUNs", (Throwable)e);
                }
                this.sqlError(e);
            }
            this.closeSelect();
        } else {
            buf.append(" and v.serial_number like '");
            if (computer.cmpOSType == 12 || computer.cmpOSType == 25 || computer.cmpOSType == 27) {
                int i = computer.cmpNasFiler.nfName.indexOf(".");
                if (i > 0) {
                    buf.append(computer.cmpNasFiler.nfName.substring(i + 1));
                    daLength = computer.cmpNasFiler.nfName.length() - i;
                } else {
                    buf.append("-1");
                }
            } else if (computer.cmpOSType == 21) {
                if (computer.cmpNasFiler.nfNetworkName != null) {
                    buf.append(computer.cmpNasFiler.nfNetworkName);
                    daLength = computer.cmpNasFiler.nfNetworkName.length() + 1;
                }
            } else if (computer.cmpOSType == 14) {
                if (computer.cmpNasFiler.nfManufacturer != null && computer.cmpNasFiler.nfManufacturer.length() > 1) {
                    if (computer.cmpNasFiler.nfManufacturer.toUpperCase().startsWith("HEWLETT")) {
                        buf.append(computer.cmpNasFiler.nfName);
                        daLength = computer.cmpNasFiler.nfName.length() + 1;
                    }
                } else {
                    int i = computer.cmpNasFiler.nfName.indexOf(".");
                    if (i > 0) {
                        String serialDec = computer.cmpNasFiler.nfName.substring(i + 1);
                        if (serialDec.length() > 5) {
                            buf.append(serialDec.substring(4));
                        } else {
                            buf.append(Util.charToHex((String)serialDec, (int)4));
                        }
                        daLength = 5;
                    } else {
                        buf.append("-1");
                    }
                }
            } else {
                buf.append(computer.cmpNasFiler.nfName);
                daLength = computer.cmpNasFiler.nfName.length() + 1;
            }
            buf.append("/%'");
            sqlText = buf.toString();
            buf = null;
            this.setSQLText(sqlText);
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            try {
                this.resultSet = this.staticStmt.executeQuery(sqlText);
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TStatDisk.class.getName(), (String)"selectHostLUNs", (Throwable)e);
                }
                this.sqlError(e);
            }
            while (this.nextResult()) {
                this.getPhase();
                NameList element = new NameList();
                try {
                    element.nlName = this.getString(this.resultSet);
                    element.nlID = this.getInt(this.resultSet);
                    element.nlID2 = this.getInt(this.resultSet);
                }
                catch (SQLException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)TStatDisk.class.getName(), (String)"selectHostLUNs", (Throwable)e);
                    }
                    this.sqlError(e);
                }
                element.nlName = element.nlName.substring(daLength);
                element.nlNext = head;
                head = element;
            }
        }
        this.closeStaticStmt();
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"selectHostLUNs", traceResult);
        }
        return traceResult;
    }

    public void getLogicalDiskID(Disk disk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"getLogicalDiskID", (String)"disk");
        }
        disk.dskLogicalDiskID = -1;
        this.selectStmt = this.prepareStmt(SELECT_LUN_DEFINITION_GIVEN_DISK);
        this.execQueryByID(disk.devID);
        try {
            if (this.nextResult()) {
                this.getPhase();
                disk.dskLogicalDiskID = this.getInt(this.resultSet);
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDisk.class.getName(), (String)"getLogicalDiskID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"getLogicalDiskID");
        }
    }

    public Share selectHostPaths(int logicalDiskID, boolean isStorageSubsystemDisk, boolean isMDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"selectHostPaths", (String)"logicalDiskID");
        }
        this.selectStmt = isStorageSubsystemDisk ? this.prepareStmt(SELECT_PATHS_FOR_SUBSYSTEM_DISK) : (isMDisk ? this.prepareStmt(SELECT_PATHS_FOR_SVC_MDISK) : this.prepareStmt(SELECT_PATHS_FOR_HOST_DISK));
        try {
            this.setPhase();
            this.setInt(this.selectStmt, logicalDiskID);
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDisk.class.getName(), (String)"selectHostPaths", (Throwable)e);
            }
            this.stmtPhase = 3;
            this.sqlError(e);
        }
        Share head = null;
        while (this.nextResult()) {
            this.getPhase();
            try {
                String canonicalName = this.getString(this.resultSet);
                String localName = this.getString(this.resultSet);
                Share sh = new Share();
                sh.shResourceType = this.getShort(this.resultSet);
                sh.shComputerName = Constants.isDiskArray((short)sh.shResourceType) ? localName : canonicalName;
                sh.shPath = this.getString(this.resultSet);
                sh.shNext = head;
                head = sh;
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TStatDisk.class.getName(), (String)"selectHostPaths", (Throwable)e);
                }
                this.sqlError(e);
            }
        }
        this.closeResultSet();
        this.closeSelect();
        Share traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"selectHostPaths", traceResult);
        }
        return traceResult;
    }

    public void prepSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"prepSave", (String)"");
        }
        this.insertStmt = this.prepareStmt(INSERT_DISK);
        this.updateStmt = this.prepareStmt(UPDATE_DISK);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"prepSave");
        }
    }

    public void closeSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"closeSave", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"closeSave");
        }
    }

    public void saveDisk(Disk disk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"saveDisk", (String)"disk");
        }
        try {
            if ((disk.devFlags & 4) == 0) {
                this.updateDisk(disk);
            } else {
                this.insertDisk(disk);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDisk.class.getName(), (String)"saveDisk", (Throwable)e);
            }
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"saveDisk");
        }
    }

    private void insertDisk(Disk disk) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"insertDisk", (String)"disk");
        }
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.insertStmt, disk.devID);
        this.setInt(this.insertStmt, disk.dskHeads);
        this.setInt(this.insertStmt, disk.dskCylinders);
        this.setInt(this.insertStmt, disk.dskRPM);
        this.setDiskAttrs(this.insertStmt, disk);
        this.setByte(this.insertStmt, disk.dskIdentity);
        this.executeUpdate(this.insertStmt);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"insertDisk");
        }
    }

    private void setDiskAttrs(PreparedStatement stmt, Disk disk) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"setDiskAttrs", (String)"stmt, disk");
        }
        this.setInt(stmt, disk.dskSectorSize);
        this.setInt(stmt, disk.dskSectorsPerAvgTrack);
        this.setInt(stmt, disk.dskSectorsPerOuterTrack);
        this.setInt(stmt, disk.dskSectorsPerInnerTrack);
        this.setInt(stmt, disk.dskLogicalBlockSize);
        this.setInt(stmt, disk.dskMinutesPoweredOn);
        this.setBoolean(stmt, disk.dskWriteProtected);
        this.setBoolean(stmt, disk.dskWriteCacheEnabled);
        this.setBoolean(stmt, disk.dskReadCacheDisabled);
        this.setBoolean(stmt, disk.dskAutoWriteRealloc);
        this.setBoolean(stmt, disk.dskAutoReadRealloc);
        this.setBoolean(stmt, disk.dskNoErrorRecovery);
        this.setBoolean(stmt, disk.dskFailurePredicted);
        this.setLong(stmt, disk.dskCapacity);
        this.setInt(stmt, disk.dskSpareBlocks);
        this.setInt(stmt, disk.dskVolgroupID);
        this.setDiskDesired(stmt, disk);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"setDiskAttrs");
        }
    }

    private void setDiskDesired(PreparedStatement stmt, Disk disk) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"setDiskDesired", (String)"stmt, disk");
        }
        this.setByte(stmt, disk.dskDesiredAWRE);
        this.setByte(stmt, disk.dskDesiredARRE);
        this.setByte(stmt, disk.dskDesiredNoErrRcvry);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"setDiskDesired");
        }
    }

    private void updateDisk(Disk disk) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"updateDisk", (String)"disk");
        }
        this.stmtType = 2;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setDiskAttrs(this.updateStmt, disk);
        this.setByte(this.updateStmt, disk.dskIdentity);
        this.setInt(this.updateStmt, disk.devID);
        this.executeUpdate(this.updateStmt);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"updateDisk");
        }
    }

    public void updateDiskDesiredSettings(Disk disk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"updateDiskDesiredSettings", (String)"disk");
        }
        try {
            this.updateStmt = this.prepareStmt(UPDATE_DISK_DESIRED_SETTINGS);
            this.stmtType = 2;
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setDiskDesired(this.updateStmt, disk);
            this.setInt(this.updateStmt, disk.devID);
            this.executeUpdate(this.updateStmt);
            this.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDisk.class.getName(), (String)"updateDiskDesiredSettings", (Throwable)e);
            }
            this.sqlError(e);
        }
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"updateDiskDesiredSettings");
        }
    }

    public void prepUpdateLogicalDiskID() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_LOGICAL_DISK_ID);
    }

    public int updateLogicalDiskID(int diskID, int logicalDiskID, boolean doCommit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"updateLogicalDiskID", (String)"diskID, logicalDiskID, doCommit");
        }
        int rowsUpdated = -1;
        this.setPhase();
        try {
            this.setInt(this.updateStmt, logicalDiskID);
            this.setInt(this.updateStmt, diskID);
            rowsUpdated = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDisk.class.getName(), (String)"updateLogicalDiskID", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (doCommit) {
            this.commit();
        }
        int traceResult = rowsUpdated;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"updateLogicalDiskID", (int)traceResult);
        }
        return traceResult;
    }

    public void prepUpdateVolGroupID() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_VOLGROUP_ID);
    }

    public int updateVolGroupID(int diskID, int VolGroupID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"updateVolGroupID", (String)"diskID, VolGroupID");
        }
        int rowsUpdated = -1;
        this.setPhase();
        try {
            this.setInt(this.updateStmt, VolGroupID);
            this.setInt(this.updateStmt, diskID);
            rowsUpdated = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDisk.class.getName(), (String)"updateVolGroupID", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.commit();
        int traceResult = rowsUpdated;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"updateVolGroupID", (int)traceResult);
        }
        return traceResult;
    }

    public int updateSVCDiskIdentity(int entityID, byte diskIdentity) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"updateSVCDiskIdentity", (String)"entityID, diskIdentity");
        }
        int rowsUpdated = -1;
        this.updateStmt = this.prepareStmt(UPDATE_SVC_DISK_IDENTITY);
        this.setPhase();
        try {
            this.setByte(this.updateStmt, diskIdentity);
            this.setInt(this.updateStmt, entityID);
            rowsUpdated = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDisk.class.getName(), (String)"updateSVCDiskIdentity", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.commit();
        int traceResult = rowsUpdated;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"updateDiskIdentity", (int)traceResult);
        }
        return traceResult;
    }

    public void prepDelete() throws GeneralException {
        this.deleteStmt = this.prepareStmt(DELETE_DISK);
    }

    public void deleteDisk(Device device) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatDisk.class.getName(), (String)"deleteDisk", (String)"device");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, device.devID);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatDisk.class.getName(), (String)"deleteDisk", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatDisk.class.getName(), (String)"deleteDisk");
        }
    }
}

