/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.History;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public abstract class TStatHist
extends StorageRepositoryAccessor {
    private boolean ageOffHistoryOnSave = true;

    public TStatHist(Connection dbc) {
        super(dbc);
    }

    protected void setAgeOffHistoryOnSave(boolean state) {
        this.ageOffHistoryOnSave = state;
    }

    public abstract void insertHist(History var1) throws GeneralException;

    private void updateHist(History hist) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatHist.class.getName(), (String)"updateHist", (String)"hist");
        }
        this.stmtType = 2;
        this.setPhase();
        int updateCount = this.updateAccumulator(hist);
        if (updateCount != 1) {
            hist.hsAccumCount = 1;
            this.insertHist(hist);
        }
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatHist.class.getName(), (String)"updateHist");
        }
    }

    protected abstract int updateAccumulator(History var1) throws SQLException, GeneralException;

    private void ageOff(Calendar calendar, Date scanTime, History hist, int retention, int calendarUnit) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatHist.class.getName(), (String)"ageOff", (String)"calendar, scanTime, hist, retention, calendarUnit");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        calendar.setTime(scanTime);
        calendar.add(calendarUnit, -retention);
        this.setTimestamp(this.deleteStmt, calendar.getTime().getTime());
        this.setIDs(this.deleteStmt, hist);
        this.executeUpdate(this.deleteStmt);
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatHist.class.getName(), (String)"ageOff");
        }
    }

    protected abstract void setIDs(PreparedStatement var1, History var2) throws SQLException;

    public void execFetchAccumulator(History hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatHist.class.getName(), (String)"execFetchAccumulator", (String)"hist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setByte(this.selectStmt, hist.hsStatisticType);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatHist.class.getName(), (String)"execFetchAccumulator", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatHist.class.getName(), (String)"execFetchAccumulator");
        }
    }

    public void resetAccumulator(History hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatHist.class.getName(), (String)"resetAccumulator", (String)"hist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.updateStmt, hist.hsStatisticTime);
            this.setIDs(this.updateStmt, hist);
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatHist.class.getName(), (String)"resetAccumulator", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatHist.class.getName(), (String)"resetAccumulator");
        }
    }

    public void closeHistSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatHist.class.getName(), (String)"closeHistSave", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatHist.class.getName(), (String)"closeHistSave");
        }
    }

    public void closeAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatHist.class.getName(), (String)"closeAverages", (String)"");
        }
        this.closeSelect();
        this.closeInsert();
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatHist.class.getName(), (String)"closeAverages");
        }
    }
}

