/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class TStormSettings
extends StorageRepositoryAccessor {
    private static final String UPDATE_REMOVED = "update t_storm_settings set keep_removed_comp = ?, keep_removed_fs = ?, keep_removed_dev = ?, keep_removed_filers = ?, keep_removed_subsystems = ?, keep_removed_fabric = ?, keep_removed_tape = ?";
    private static final String UPDATE_EMAIL_RULES = "update t_storm_settings set email_addr_rules = ?";
    private static final String UPDATE_DISCOVERY = "update t_storm_settings set no_wksta_discovery = ?";
    public static final int OS_HISTORY = 0;
    private static final String[] updateRemoved = new String[]{"update t_storm_settings set keep_removed_comp = ?, keep_removed_fs = ?, keep_removed_dev = ?, keep_removed_filers = ?, keep_removed_subsystems = ?, keep_removed_fabric = ?, keep_removed_tape = ?"};
    private static final String FETCH = "select keep_removed_comp, keep_removed_fs, keep_removed_dev, disk_daily_hist, disk_weekly_hist, disk_monthly_hist, ping_daily_hist, ping_weekly_hist, ping_monthly_hist, comp_daily_hist, comp_weekly_hist, comp_monthly_hist, fs_daily_hist, fs_weekly_hist, fs_monthly_hist, disk_awre, disk_arre, disk_noerrrcvry, email_addr_rules, no_wksta_discovery, keep_removed_filers, keep_removed_subsystems, keep_removed_fabric, keep_removed_tape from t_storm_settings";
    private static final String UPDATE_HIST = "update t_storm_settings set disk_daily_hist = ?, disk_weekly_hist = ?, disk_monthly_hist = ?, ping_daily_hist = ?, ping_weekly_hist = ?, ping_monthly_hist = ?, comp_daily_hist = ?, comp_weekly_hist = ?, comp_monthly_hist = ?, fs_daily_hist = ?, fs_weekly_hist = ?, fs_monthly_hist = ?";
    private static final String[] updateHist = new String[]{"update t_storm_settings set disk_daily_hist = ?, disk_weekly_hist = ?, disk_monthly_hist = ?, ping_daily_hist = ?, ping_weekly_hist = ?, ping_monthly_hist = ?, comp_daily_hist = ?, comp_weekly_hist = ?, comp_monthly_hist = ?, fs_daily_hist = ?, fs_weekly_hist = ?, fs_monthly_hist = ?"};
    private static final String INSERT = "insert into t_storm_settings ( keep_removed_comp, keep_removed_fs, keep_removed_filers,  keep_removed_subsystems, keep_removed_fabric, keep_removed_tape, disk_daily_hist, disk_weekly_hist, disk_monthly_hist, ping_daily_hist, ping_weekly_hist, ping_monthly_hist, comp_daily_hist, comp_weekly_hist, comp_monthly_hist, fs_daily_hist, fs_weekly_hist, fs_monthly_hist,  disk_awre, disk_arre, disk_noerrrcvry, email_addr_rules, no_wksta_discovery,  ) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public TStormSettings(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStormSettings.class.getName(), (String)"TStormSettings", (String)"dbc");
        }
        this.tableName = "t_storm_settings";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStormSettings.class.getName(), (String)"TStormSettings");
        }
    }

    public Settings getSettings(boolean throwException) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStormSettings.class.getName(), (String)"getSettings", (String)"throwException");
        }
        Settings settings = null;
        try {
            this.selectStmt = this.prepareStmt(FETCH);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult()) {
                settings = new Settings();
                this.colIndex = 1;
                settings.seKeepRemovedComp = this.getShort(this.resultSet);
                settings.seKeepRemovedFS = this.getShort(this.resultSet);
                settings.seKeepRemovedDev = this.getShort(this.resultSet);
                settings.seDiskDailyHist = this.getShort(this.resultSet);
                settings.seDiskWeeklyHist = this.getShort(this.resultSet);
                settings.seDiskMonthlyHist = this.getShort(this.resultSet);
                settings.sePingDailyHist = this.getShort(this.resultSet);
                settings.sePingWeeklyHist = this.getShort(this.resultSet);
                settings.sePingMonthlyHist = this.getShort(this.resultSet);
                settings.seCompDailyHist = this.getShort(this.resultSet);
                settings.seCompWeeklyHist = this.getShort(this.resultSet);
                settings.seCompMonthlyHist = this.getShort(this.resultSet);
                settings.seFSDailyHist = this.getShort(this.resultSet);
                settings.seFSWeeklyHist = this.getShort(this.resultSet);
                settings.seFSMonthlyHist = this.getShort(this.resultSet);
                settings.seDiskDesiredAWRE = this.getByte(this.resultSet);
                settings.seDiskDesiredARRE = this.getByte(this.resultSet);
                settings.seDiskDesiredNoErrRcvry = this.getByte(this.resultSet);
                settings.seEmailAddrRules = this.getString(this.resultSet);
                settings.seNoWkstaDiscovery = this.getBoolean(this.resultSet);
                settings.seKeepRemovedFilers = this.getShort(this.resultSet);
                settings.seKeepRemovedSubsystems = this.getShort(this.resultSet);
                settings.seKeepRemovedFabric = this.getShort(this.resultSet);
                settings.seKeepRemovedTape = this.getShort(this.resultSet);
            }
            this.closeSelect();
            if (settings == null && throwException) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TStormSettings.class.getName(), (String)"getSettings");
                }
                throw new GeneralException(MessageLog.getMessage((String)"STS0029E", null));
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStormSettings.class.getName(), (String)"getSettings", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Settings traceResult = settings;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStormSettings.class.getName(), (String)"getSettings", traceResult);
        }
        return traceResult;
    }

    public Settings getSettings() throws GeneralException {
        return this.getSettings(true);
    }

    private void setHist(Settings settings, PreparedStatement stmt) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStormSettings.class.getName(), (String)"setHist", (String)"settings, stmt");
        }
        this.setShort(stmt, settings.seDiskDailyHist);
        this.setShort(stmt, settings.seDiskWeeklyHist);
        this.setShort(stmt, settings.seDiskMonthlyHist);
        this.setShort(stmt, settings.sePingDailyHist);
        this.setShort(stmt, settings.sePingWeeklyHist);
        this.setShort(stmt, settings.sePingMonthlyHist);
        this.setShort(stmt, settings.seCompDailyHist);
        this.setShort(stmt, settings.seCompWeeklyHist);
        this.setShort(stmt, settings.seCompMonthlyHist);
        this.setShort(stmt, settings.seFSDailyHist);
        this.setShort(stmt, settings.seFSWeeklyHist);
        this.setShort(stmt, settings.seFSMonthlyHist);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStormSettings.class.getName(), (String)"setHist");
        }
    }

    private void setRemoved(Settings settings, PreparedStatement stmt) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStormSettings.class.getName(), (String)"setRemoved", (String)"settings, stmt");
        }
        this.setShort(stmt, settings.seKeepRemovedComp);
        this.setShort(stmt, settings.seKeepRemovedFS);
        this.setShort(stmt, settings.seKeepRemovedDev);
        this.setShort(stmt, settings.seKeepRemovedFilers);
        this.setShort(stmt, settings.seKeepRemovedSubsystems);
        this.setShort(stmt, settings.seKeepRemovedFabric);
        this.setShort(stmt, settings.seKeepRemovedTape);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStormSettings.class.getName(), (String)"setRemoved");
        }
    }

    private void setDiskBits(Settings settings, PreparedStatement stmt) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStormSettings.class.getName(), (String)"setDiskBits", (String)"settings, stmt");
        }
        this.setByte(stmt, settings.seDiskDesiredAWRE);
        this.setByte(stmt, settings.seDiskDesiredARRE);
        this.setByte(stmt, settings.seDiskDesiredNoErrRcvry);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStormSettings.class.getName(), (String)"setDiskBits");
        }
    }

    private void setEmailAddressRules(Settings settings, PreparedStatement stmt) throws SQLException {
        this.setString(stmt, settings.seEmailAddrRules);
    }

    private void setDiscovery(Settings settings, PreparedStatement stmt) throws SQLException {
        this.setBoolean(stmt, settings.seNoWkstaDiscovery);
    }

    public void insert(Settings settings) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStormSettings.class.getName(), (String)"insert", (String)"settings");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setRemoved(settings, this.insertStmt);
            this.setHist(settings, this.insertStmt);
            this.setDiskBits(settings, this.insertStmt);
            this.setEmailAddressRules(settings, this.insertStmt);
            this.setDiscovery(settings, this.insertStmt);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStormSettings.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        this.closeInsert();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStormSettings.class.getName(), (String)"insert");
        }
    }

    public int updateHist(Settings settings, int type) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStormSettings.class.getName(), (String)"updateHist", (String)"settings, type");
        }
        int result = 0;
        this.updateStmt = this.prepareStmt(updateHist[type]);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setHist(settings, this.updateStmt);
            result = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStormSettings.class.getName(), (String)"updateHist", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.closeUpdate();
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStormSettings.class.getName(), (String)"updateHist", (int)traceResult);
        }
        return traceResult;
    }

    public int updateRemoved(Settings settings, int type) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStormSettings.class.getName(), (String)"updateRemoved", (String)"settings, type");
        }
        int result = 0;
        this.updateStmt = this.prepareStmt(updateRemoved[type]);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setRemoved(settings, this.updateStmt);
            result = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStormSettings.class.getName(), (String)"updateRemoved", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.closeUpdate();
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStormSettings.class.getName(), (String)"updateRemoved", (int)traceResult);
        }
        return traceResult;
    }

    public int updateEmailRules(Settings settings) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStormSettings.class.getName(), (String)"updateEmailRules", (String)"settings");
        }
        int result = 0;
        this.updateStmt = this.prepareStmt(UPDATE_EMAIL_RULES);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setEmailAddressRules(settings, this.updateStmt);
            result = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStormSettings.class.getName(), (String)"updateEmailRules", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.closeUpdate();
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStormSettings.class.getName(), (String)"updateEmailRules", (int)traceResult);
        }
        return traceResult;
    }

    public int updateDiscovery(Settings settings) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStormSettings.class.getName(), (String)"updateDiscovery", (String)"settings");
        }
        int result = 0;
        this.updateStmt = this.prepareStmt(UPDATE_DISCOVERY);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setDiscovery(settings, this.updateStmt);
            result = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStormSettings.class.getName(), (String)"updateDiscovery", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.closeUpdate();
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStormSettings.class.getName(), (String)"updateDiscovery", (int)traceResult);
        }
        return traceResult;
    }
}

