/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.io.Serializable;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.scheduler.SchRunNode;

public class SchScheduleNode {
    SchScheduleNode prev;
    SchScheduleNode next;
    SchRunNode runHdr;
    LinkedInteger pingList;
    int SID;
    String creator;
    private String name;
    String arguments;
    Serializable jobData;
    short jobType;
    int alertID;
    int alertLogID;
    String scriptName;
    int runNumber;
    long submitMillis;
    int numberRuns;
    int completedRuns;
    int successfulRuns;
    boolean anyWarnings;
    boolean completed;
    int state;
    Request request;

    public void clear() {
        this.prev = null;
        this.next = null;
        this.runHdr = null;
        this.creator = null;
        this.name = null;
        this.arguments = null;
        this.request = null;
        this.numberRuns = 0;
        this.completedRuns = 0;
        this.successfulRuns = 0;
        this.anyWarnings = false;
        this.completed = false;
        this.state = 2;
        this.jobData = null;
        this.alertLogID = -1;
    }

    public synchronized void processComplete(SchRunNode runPtr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchScheduleNode.class.getName(), (String)"processComplete", (String)"runPtr");
        }
        if (runPtr.returnCode <= 4) {
            ++this.successfulRuns;
            if (runPtr.returnCode != 0) {
                this.anyWarnings = true;
            }
        }
        ++this.completedRuns;
        if (this.completedRuns >= this.numberRuns) {
            this.state = this.numberRuns > this.successfulRuns ? 0 : (this.anyWarnings ? 3 : 1);
            this.completed = true;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SchScheduleNode.class.getName(), (String)"processComplete");
        }
    }

    public boolean failed() {
        return this.state == 0;
    }

    public String getName() {
        return Util.getTranslatedName((String)this.name);
    }

    public String getTrueName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

