/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchRunNode;
import org.eclipse.aperi.scheduler.SchScheduleNode;
import org.eclipse.aperi.scheduler.ScheduleAlerter;
import org.eclipse.aperi.scheduler.ScheduleBuild;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.svp.SchedulerSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleComplete {
    private static final String NO_LOG_FILE = " " + MessageLog.getMessageNoID((String)"JSS0044L", null);

    public void processCancel(SchRunNode runPtr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleComplete.class.getName(), (String)"processCancel", (String)"runPtr");
        }
        this.process(runPtr, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleComplete.class.getName(), (String)"processCancel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(SchRunNode runPtr, StartedJob startedJob) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleComplete.class.getName(), (String)"process", (String)"runPtr, startedJob");
        }
        Connection connection = null;
        Statement updateStmt = null;
        try {
            connection = Server.getConnection();
            if (connection == null) {
                MessageLog.logMessage((String)"JSS0006E", (Object)"ScheduleComplete.process");
                SchCommon.stopped = true;
                return;
            }
            updateStmt = null;
            try {
                updateStmt = connection.prepareStatement("update t_run_jobs set    submit_status = 0, return_code = ?, process_id = ?,        start_time = ?, finish_time = ?, log_file_name = ? where  job_run_number = ?");
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ScheduleComplete.class.getName(), (String)"ScheduleComplete", (Throwable)e);
                }
                MessageLog.getThreadLog().println(SQLUtil.getSQLExceptionMsg("JSS0007E", e, new Object[]{"update", "t_run_jobs", "ScheduleComplete.process"}));
                SchCommon.stopped = true;
                if (updateStmt != null) {
                    try {
                        updateStmt.close();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    Server.returnConnection(connection);
                }
                return;
            }
            AgentManager agentRoutine = Server.getAgentManager();
            ScheduleBuild buildRoutine = SchCommon.buildTask;
            SchScheduleNode schedulePtr = runPtr.back;
            if (runPtr.rowInserted) {
                String logFilename;
                long finishedMillis;
                long startedMillis;
                int pid;
                if (runPtr.returnCode < 0) {
                    runPtr.returnCode = 12;
                }
                if (startedJob == null) {
                    pid = 0;
                    try {
                        startedMillis = SQLUtil.getTimestamp(connection).getTime();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)ScheduleComplete.class.getName(), (String)"process", (Throwable)e);
                        }
                        if (updateStmt != null) {
                            try {
                                updateStmt.close();
                            }
                            catch (Exception ignore) {
                                // empty catch block
                            }
                        }
                        if (connection != null) {
                            Server.returnConnection(connection);
                        }
                        return;
                    }
                    finishedMillis = startedMillis;
                    logFilename = runPtr.logFileName == null ? NO_LOG_FILE : runPtr.logFileName;
                } else {
                    runPtr.returnCode = startedJob.getExitCode();
                    pid = startedJob.getPid();
                    startedMillis = startedJob.getStarted();
                    finishedMillis = startedJob.getFinished();
                    logFilename = startedJob.getLogFileName();
                }
                try {
                    updateStmt.setInt(1, runPtr.returnCode);
                    updateStmt.setInt(2, pid);
                    updateStmt.setLong(3, startedMillis);
                    updateStmt.setLong(4, finishedMillis);
                    updateStmt.setString(5, logFilename);
                    updateStmt.setInt(6, runPtr.runNumber);
                    updateStmt.executeUpdate();
                    connection.commit();
                }
                catch (SQLException e) {
                    String name;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ScheduleComplete.class.getName(), (String)"process", (Throwable)e);
                    }
                    if (SchedulerSvp.connectBad(connection)) {
                        SchCommon.stopped = true;
                        SchCommon.bounceNeeded = true;
                    }
                    MessageLog.getThreadLog().println(SQLUtil.getSQLExceptionMsg("JSS0009E", e, new Object[]{"update", "t_run_jobs"}));
                    if (runPtr.CID < 1) {
                        name = MessageLog.getMessageNoID((String)"SRV0121E");
                    } else {
                        name = agentRoutine.getAgentHostAddress(runPtr.CID);
                        if (name == null) {
                            name = Integer.toString(runPtr.CID);
                        }
                    }
                    Object[] args = new Object[]{Integer.toString(runPtr.runNumber), name, Integer.toString(schedulePtr.runNumber), ResourceTypeManager.getJobName((short)schedulePtr.jobType), schedulePtr.creator + "." + schedulePtr.getName(), Integer.toString(runPtr.returnCode)};
                    MessageLog.logMessage((String)"JSS0018E", (Object[])args);
                }
            }
            schedulePtr.processComplete(runPtr);
            if (schedulePtr.completed) {
                if (schedulePtr.failed()) {
                    ScheduleAlerter alerter = null;
                    try {
                        alerter = new ScheduleAlerter(connection);
                        alerter.alert(schedulePtr);
                    }
                    catch (GeneralException ge) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)ScheduleComplete.class.getName(), (String)"process", (Throwable)ge);
                        }
                        MessageLog.logException((String)"JSS0066E", (Exception)((Object)ge), (Object[])new Object[]{ResourceTypeManager.getJobName((short)schedulePtr.jobType), schedulePtr.creator + "." + schedulePtr.getName()});
                    }
                    finally {
                        if (alerter != null) {
                            try {
                                alerter.close();
                            }
                            catch (Exception ignore) {}
                        }
                    }
                }
                buildRoutine.deleteSchedule(schedulePtr);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ScheduleComplete.class.getName(), (String)"process");
            }
        }
        finally {
            if (updateStmt != null) {
                try {
                    updateStmt.close();
                }
                catch (Exception ignore) {}
            }
            if (connection != null) {
                Server.returnConnection(connection);
            }
        }
    }
}

