/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.Script;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.scheduler.InternalIntervalNode;
import org.eclipse.aperi.scheduler.SchChangeNode;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchIntervalNode;
import org.eclipse.aperi.scheduler.ScheduleInterval;

public class ScheduleQueue {
    public static ScheduleQueue routine = new ScheduleQueue();
    public static SchChangeNode head;
    SchChangeNode change;
    SchChangeNode tail;
    public static boolean initialized;

    public synchronized void addCreate(ScheduleHeader header) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"addCreate", (String)"header");
        }
        this.change = new SchChangeNode(1);
        this.change.interval = this.makeInterval(header);
        this.addChange();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"addCreate");
        }
    }

    public synchronized void addEdit(ScheduleHeader header) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"addEdit", (String)"header");
        }
        this.change = new SchChangeNode(2);
        this.change.interval = this.makeInterval(header);
        this.addChange();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"addEdit");
        }
    }

    public synchronized void addRename(int sid, String newName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"addRename", (String)"sid, newName");
        }
        this.change = new SchChangeNode(3);
        this.change.SID = sid;
        this.change.setName(newName);
        this.addChange();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"addRename");
        }
    }

    public synchronized void addDelete(int sid) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"addDelete", (String)"sid");
        }
        this.change = new SchChangeNode(4);
        this.change.SID = sid;
        this.addChange();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"addDelete");
        }
    }

    public synchronized void run(int sid, int computerID, Serializable jobData, int alertLogID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"run", (String)"sid, computerID, jobData, alertLogID");
        }
        this.change = new SchChangeNode(5);
        this.change.SID = sid;
        this.change.computerID = computerID;
        this.change.jobData = jobData;
        this.change.alertLogID = alertLogID;
        this.addChange();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"run");
        }
    }

    public void run(int sid) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"run", (String)"sid");
        }
        this.run(sid, -1, null, -1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"run");
        }
    }

    public synchronized void setAsFirst(SchChangeNode change) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"setAsFirst", (String)"change");
        }
        if (head == null) {
            head = change;
            this.tail = change;
        } else {
            change.next = head;
            head = change;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"setAsFirst");
        }
    }

    public synchronized void getHighRunNumber(ScheduleHeader header) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"getHighRunNumber", (String)"header");
        }
        int SID = header.ID;
        SchIntervalNode interval = ScheduleInterval.runNumberHdr;
        int runNumber = -1;
        while (interval != null) {
            if (interval.SID == SID) {
                runNumber = interval.highRunNumber;
                break;
            }
            interval = interval.allNext;
        }
        if (runNumber > header.highRunNumber) {
            header.highRunNumber = runNumber;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"getHighRunNumber");
        }
    }

    public synchronized void rebuild() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"rebuild", (String)"");
        }
        this.change = new SchChangeNode(6);
        this.addChange();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"rebuild");
        }
    }

    public synchronized void clear() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"clear", (String)"");
        }
        while (head != null) {
            this.getNext();
        }
        InternalIDAllocator.clearIDs();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"clear");
        }
    }

    public synchronized SchChangeNode getNext() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"getNext", (String)"");
        }
        SchChangeNode most = head;
        if (head != null) {
            head = ScheduleQueue.head.next;
            if (head == null) {
                this.tail = null;
            } else if (most.type == 6) {
                while (head != null && ScheduleQueue.head.type == 6) {
                    head = ScheduleQueue.head.next;
                }
                if (head == null) {
                    this.tail = null;
                } else {
                    SchChangeNode prev = head;
                    SchChangeNode rest = ScheduleQueue.head.next;
                    while (rest != null) {
                        if (rest.type == 6) {
                            prev.next = rest.next;
                            rest.next = null;
                        } else {
                            prev = rest;
                        }
                        rest = prev.next;
                    }
                    this.tail = prev;
                }
            }
        }
        SchChangeNode traceResult = most;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"getNext", (Object)traceResult);
        }
        return traceResult;
    }

    public static boolean isInternal(int SID) {
        return InternalIDAllocator.isInternal(SID);
    }

    public synchronized void addInternalJob(int delayInMinutes, Request request) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"addInternalJob", (String)"delayInMinutes, request");
        }
        InternalIntervalNode interval = new InternalIntervalNode();
        interval.scheduleType = (byte)2;
        interval.jobType = (short)73;
        interval.SID = InternalIDAllocator.allocID();
        interval.creator = request.serviceName;
        interval.setName(request.subType);
        interval.enabled = true;
        interval.timezoneType = (byte)2;
        interval.globalType = 1;
        interval.alertID = -1;
        interval.highRunNumber = 1;
        interval.request = request;
        long ts = 0L;
        try {
            ts = CurrentTime.getTimestamp().getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleQueue.class.getName(), (String)"addInternalJob", (Throwable)e);
            }
            return;
        }
        ts += SchCommon.millisAdvanced;
        long delta = delayInMinutes + 1;
        Date hence = new Date(ts += (delta *= 60000L));
        Calendar cal = Calendar.getInstance();
        cal.setTime(hence);
        interval.startYear = cal.get(1) - 2000;
        interval.startMonth = cal.get(2);
        interval.startDay = cal.get(5) - 1;
        interval.startHour = cal.get(10);
        interval.startMinute = cal.get(12);
        this.change = new SchChangeNode(1);
        this.change.interval = interval;
        this.addChange();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"addInternalJob");
        }
    }

    private SchIntervalNode makeInterval(ScheduleHeader header) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"makeInterval", (String)"header");
        }
        SchIntervalNode interval = new SchIntervalNode();
        interval.SID = header.ID;
        interval.creator = header.creator;
        interval.setName(header.getTrueName());
        interval.enabled = header.enabled;
        interval.scheduleType = header.scheduleType;
        interval.startYear = header.startYear - 2000;
        interval.startMonth = header.startMonth - 1;
        interval.startDay = header.startDay - 1;
        interval.startHour = header.startHour;
        interval.startMinute = header.startMinute;
        interval.intervalType = header.intervalType;
        interval.intervalNumber = header.intervalNumber;
        if (header.repeatType == 2) {
            interval.daysArray = new boolean[7];
            if (header.runSunday == 2) {
                interval.daysArray[1] = true;
            }
            if (header.runMonday == 2) {
                interval.daysArray[2] = true;
            }
            if (header.runTuesday == 2) {
                interval.daysArray[3] = true;
            }
            if (header.runWednesday == 2) {
                interval.daysArray[4] = true;
            }
            if (header.runThursday == 2) {
                interval.daysArray[5] = true;
            }
            if (header.runFriday == 2) {
                interval.daysArray[6] = true;
            }
            if (header.runSaturday == 2) {
                interval.daysArray[0] = true;
            }
        }
        interval.timezoneType = header.timezoneType;
        interval.globalType = header.globalType;
        interval.timezone = header.timezone;
        interval.arguments = header.arguments;
        interval.alertID = header.alertID;
        interval.jobType = header.jobType;
        interval.highRunNumber = header.highRunNumber;
        interval.computerID = header.computerID;
        if (header instanceof Script) {
            Script script = (Script)header;
            interval.scriptName = script.scrName;
        }
        if (interval.jobType != 16 && interval.jobType != 36 && interval.jobType != 67 && interval.jobType != 65) {
            interval.timezoneType = (byte)2;
        }
        SchIntervalNode traceResult = interval;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"makeInterval", (Object)traceResult);
        }
        return traceResult;
    }

    private void addChange() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleQueue.class.getName(), (String)"addChange", (String)"");
        }
        if (this.tail == null) {
            head = this.change;
            this.tail = this.change;
        } else {
            this.tail.next = this.change;
            this.tail = this.change;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleQueue.class.getName(), (String)"addChange");
        }
    }

    private static class InternalIDAllocator {
        private static final int HIGHEST_INTERNAL_ID = -2;
        private static long[] usedIDs = new long[1];
        private static long currentBit;
        private static int currentBitNumber;

        private InternalIDAllocator() {
        }

        public static int allocID() {
            int index;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)InternalIDAllocator.class.getName(), (String)"allocID", (String)"");
            }
            for (index = 0; index < usedIDs.length && usedIDs[index] == -1L; ++index) {
            }
            if (index >= usedIDs.length) {
                long[] newArray = new long[usedIDs.length << 1];
                System.arraycopy(newArray, 0, usedIDs, 0, usedIDs.length);
                usedIDs = newArray;
            }
            long mask = usedIDs[index];
            do {
                if (currentBit > 0L) {
                    currentBit <<= 1;
                    ++currentBitNumber;
                    continue;
                }
                currentBit = 1L;
                currentBitNumber = 0;
            } while ((mask & currentBit) != 0L);
            InternalIDAllocator.usedIDs[index] = mask | currentBit;
            int negated = index << 6 | currentBitNumber;
            System.out.println(negated);
            int traceResult = -2 - negated;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)InternalIDAllocator.class.getName(), (String)"allocID", (int)traceResult);
            }
            return traceResult;
        }

        public static void returnID(int returnedID) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)InternalIDAllocator.class.getName(), (String)"returnID", (String)"returnedID");
            }
            int negated = -2 - returnedID;
            int index = negated >> 6;
            int bitNumber = negated & 0x3F;
            long bit = 1L;
            int n = index;
            usedIDs[n] = usedIDs[n] & ((bit <<= bitNumber) ^ 0xFFFFFFFFFFFFFFFFL);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)InternalIDAllocator.class.getName(), (String)"returnID");
            }
        }

        public static boolean isInternal(int ID) {
            int negated;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)InternalIDAllocator.class.getName(), (String)"isInternal", (String)"ID");
            }
            boolean result = ID > -2 ? false : (negated = -2 - ID) >> 6 < usedIDs.length;
            boolean traceResult = result;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)InternalIDAllocator.class.getName(), (String)"isInternal", (boolean)traceResult);
            }
            return traceResult;
        }

        public static void clearIDs() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)InternalIDAllocator.class.getName(), (String)"clearIDs", (String)"");
            }
            Arrays.fill(usedIDs, 0L);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)InternalIDAllocator.class.getName(), (String)"clearIDs");
            }
        }

        static {
            currentBitNumber = 63;
            currentBit = 1L;
            currentBit <<= currentBitNumber;
        }
    }
}

