/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.sql.Connection;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchRunNode;

public class ScheduleSubmitted {
    SchRunNode submittedRunHead;
    SchRunNode submittedRunTail;
    SchRunNode runPtr;

    public synchronized void addRunNodes(SchRunNode newRunPtr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleSubmitted.class.getName(), (String)"addRunNodes", (String)"newRunPtr");
        }
        if (this.submittedRunHead == null) {
            this.submittedRunHead = newRunPtr;
        } else {
            this.submittedRunTail.submitNext = newRunPtr;
            newRunPtr.submitPrev = this.submittedRunTail;
        }
        while (newRunPtr.submitNext != null) {
            newRunPtr = newRunPtr.submitNext;
        }
        this.submittedRunTail = newRunPtr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleSubmitted.class.getName(), (String)"addRunNodes");
        }
    }

    public synchronized SchRunNode getNext(Connection connection) {
        long runMillis = 0L;
        try {
            runMillis = SQLUtil.getTimestamp(connection).getTime() + SchCommon.millisAdvanced;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleSubmitted.class.getName(), (String)"getNext", (Throwable)e);
            }
            return null;
        }
        SchRunNode runPtr = this.submittedRunHead;
        while (runPtr != null && runPtr.submitMillis > runMillis) {
            runPtr = runPtr.submitNext;
        }
        if (runPtr != null) {
            SchRunNode prevRunPtr = runPtr.submitPrev;
            SchRunNode nextRunPtr = runPtr.submitNext;
            if (prevRunPtr == null) {
                this.submittedRunHead = nextRunPtr;
            } else {
                prevRunPtr.submitNext = nextRunPtr;
                runPtr.submitPrev = null;
            }
            if (nextRunPtr == null) {
                this.submittedRunTail = prevRunPtr;
            } else {
                nextRunPtr.submitPrev = prevRunPtr;
                runPtr.submitNext = null;
            }
        }
        return runPtr;
    }
}

