/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import com.tivoli.tec.event_delivery.TECEvent;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertProductManager;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.scheduler.ScheduleAlerter;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.alert.StormAlerter;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.server.guireq.AlertEmail;
import org.eclipse.aperi.server.guireq.AlertLog;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.server.util.smtp.Email;
import org.eclipse.aperi.server.util.snmp.SnmpUtil;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.TimeTicks;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.aperi.xmsg.NestableException;

public class AlertUtil {
    private static final String CLASSNAME = AlertUtil.class.getName();
    public static final String ADAPTER_HOST = "adapter_host";
    public static final String MSG = "msg";
    public static final String MSG_ID = "messageID";
    public static final String ALERT_NAME = "alertName";
    public static final String ORIGIN = "origin";
    public static final String HOSTNAME = "hostname";

    public static AlertLog getAlertLog(Alert alert) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getAlertLog", (String)"alert");
        }
        AlertLog alertLog = new AlertLog();
        AlertDefinition alertDef = alert.getAlertDefinition();
        alertLog.alAlertID = alertDef.aldAlertID;
        alertLog.alNotifyUser = alertDef.aldNotifyOnLogin;
        alertLog.alProductID = alertDef.aldProductID;
        alertLog.alAlertCondition = alertDef.aldCondition;
        alertLog.alThresholdType = alertDef.aldThresholdType;
        alertLog.alThresholdValue = alertDef.aldThresholdValue;
        alertLog.alDbmsType = alert.getDbmsType();
        alertLog.alComputerID = alert.getComputerID();
        alertLog.alResourceID = alert.getResourceID();
        alertLog.alParentID = alert.getParentID();
        alertLog.alResourceType = alert.getResourceType();
        alertLog.alViolatingValue = alert.getViolatingValue();
        alertLog.alPreviousValue = alert.getPreviousValue();
        alertLog.alViolatorID = alert.getViolatorID();
        alertLog.alViolatorType = alert.getViolatorType();
        alertLog.alLastAlertTime = alert.getAlertTime();
        alertLog.alMessage = AlertUtil.getLogMsg(alert, false);
        AlertLog traceResult = alertLog;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getAlertLog", (Object)traceResult);
        }
        return traceResult;
    }

    public static String getLogMsg(Alert alert) {
        return AlertUtil.getLogMsg(alert, true);
    }

    public static String getLogMsg(Alert alert, boolean includeAffectedResources) {
        String traceResult;
        String msgID;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getLogMsg", (String)"alert, includeAffectedResources");
        }
        if (alert instanceof FabricAlert) {
            msgID = alert.getMessageID();
        } else {
            AlertDefinition alertDef = alert.getAlertDefinition();
            msgID = alertDef.getLogMsgID();
        }
        String[] parms = alert.getParameters();
        if (msgID != null && msgID.equals("ALR0021W")) {
            parms[0] = Util.getTranslatedName((String)parms[0]);
        }
        if (msgID.length() > 0) {
            traceResult = MessageLog.getMessageNoTS((String)msgID, (Object[])parms);
        } else {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < parms.length; ++i) {
                buf.append(parms[i]);
                buf.append(MessageLog.lineSeparator);
            }
            traceResult = buf.toString();
        }
        if (alert instanceof FabricAlert && includeAffectedResources && alert.hasAffectedResources()) {
            traceResult = traceResult + "\n" + alert.getAffectedHosts();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getLogMsg", (Object)traceResult);
        }
        return traceResult;
    }

    public static TECEvent getTecEvent(Alert alert) throws LocalizableException {
        TECEvent tecEvent;
        block13: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CLASSNAME, (String)"getTecEvent", (String)"alert");
            }
            String server = HardwareID.getLocalHostName();
            tecEvent = new TECEvent();
            try {
                if (alert instanceof FabricAlert) {
                    tecEvent.setClassName(alert.getTecClass());
                    Hashtable tecAttributes = alert.getTecAttributes();
                    Enumeration keys = tecAttributes.keys();
                    while (keys.hasMoreElements()) {
                        String attr = (String)keys.nextElement();
                        String attrValue = (String)tecAttributes.get(attr);
                        tecEvent.setSlot(attr, "\"" + attrValue + "\"");
                    }
                } else {
                    String tecClass = AlertUtil.getTecClass(alert);
                    if (tecClass == null) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)CLASSNAME, (String)"getTecEvent");
                        }
                        throw new LocalizableException("SRV0207E", null);
                    }
                    tecEvent.setClassName(tecClass);
                    String[] tecSlotNames = alert.getTecSlotNames();
                    String[] parms = alert.getParameters();
                    for (int i = 0; i < tecSlotNames.length && i < parms.length; ++i) {
                        if (tecSlotNames[i] == null || parms[i] == null) continue;
                        tecEvent.setSlot(tecSlotNames[i], "'" + parms[i] + "'");
                    }
                    AgentManager agentMgr = Server.getAgentManager();
                    String hostAddress = agentMgr.getHostAddress(alert.getComputerID());
                    String ipAddress = InetAddress.getByName(hostAddress).getHostAddress();
                    tecEvent.setSlot(HOSTNAME, hostAddress);
                    tecEvent.setSlot(ORIGIN, ipAddress);
                }
                tecEvent.setSlot(ADAPTER_HOST, server);
                String msg = AlertUtil.getTecEventMsg(alert);
                tecEvent.setSlot(MSG, "'" + msg + "'");
                String msgID = AlertUtil.getTecEventMsgID(alert);
                tecEvent.setSlot(MSG_ID, msgID);
                AlertDefinition alertDef = alert.getAlertDefinition();
                String alertName = alertDef.aldCreator + '.' + alertDef.getAldName();
                tecEvent.setSlot(ALERT_NAME, "'" + alertName + "'");
            }
            catch (UnknownHostException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)CLASSNAME, (String)"getTecEvent", (Throwable)e);
                }
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)CLASSNAME, (String)"getTecEvent");
                }
                throw new NestableException("GEN0106E", null, (Exception)e);
            }
            catch (Exception e) {
                if (!TraceLogger.enableTrace) break block13;
                TraceLogger.exception((String)CLASSNAME, (String)"getTecEvent", (Throwable)e);
            }
        }
        TECEvent traceResult = tecEvent;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getTecEvent", (Object)traceResult);
        }
        return traceResult;
    }

    private static String getTecClass(Alert alert) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getTecClass", (String)"alert");
        }
        String tecClass = null;
        int trapType = alert.getTrapType();
        AlertDefinition alertDef = alert.getAlertDefinition();
        if (trapType == 20) {
            tecClass = "JobFailure";
        } else if (alertDef.aldProductID == 0 || alertDef.aldProductID == 3) {
            tecClass = StormAlerter.tecClassNames[trapType];
        }
        String traceResult = tecClass;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getTecClass", (Object)traceResult);
        }
        return traceResult;
    }

    private static String getTecEventMsg(Alert alert) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getTecEventMsg", (String)"alert");
        }
        String tecMsg = null;
        if (alert instanceof FabricAlert) {
            tecMsg = MessageLog.getMessageNoID((String)alert.getMessageID(), (Object[])alert.getMessageParameters());
        } else {
            int trapType = alert.getTrapType();
            AlertDefinition alertDef = alert.getAlertDefinition();
            if (trapType == 20) {
                tecMsg = ScheduleAlerter.FAILED_JOB_EVENT_MSG;
            } else if (alertDef.aldProductID == 0 || alertDef.aldProductID == 3) {
                tecMsg = StormAlerter.tecEventMsgs[trapType];
            }
        }
        if (tecMsg == null) {
            tecMsg = "";
        }
        String traceResult = tecMsg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getTecEventMsg", (Object)traceResult);
        }
        return traceResult;
    }

    private static String getTecEventMsgID(Alert alert) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getTecEventMsgID", (String)"alert");
        }
        String tecMsgID = null;
        if (alert instanceof FabricAlert) {
            tecMsgID = alert.getMessageID();
        } else {
            int trapType = alert.getTrapType();
            AlertDefinition alertDef = alert.getAlertDefinition();
            if (trapType == 20) {
                tecMsgID = "ALR1339W";
            } else if (alertDef.aldProductID == 0 || alertDef.aldProductID == 3) {
                tecMsgID = StormAlerter.tecEventMsgIDs[trapType];
            }
        }
        if (tecMsgID == null) {
            tecMsgID = "";
        }
        String traceResult = tecMsgID;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getTecEventMsgID", (Object)traceResult);
        }
        return traceResult;
    }

    public static SnmpTrap getTrapPdu(Alert alert) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getTrapPdu", (String)"alert");
        }
        SnmpTrap trap = new SnmpTrap();
        try {
            String address = InetAddress.getLocalHost().getHostAddress();
            trap.agentAddr = new IPAddress(address);
        }
        catch (UnknownHostException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)CLASSNAME, (String)"getTrapPdu", (Throwable)e);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CLASSNAME, (String)"getTrapPdu");
            }
            throw new NestableException("GEN0106E", null, (Exception)e);
        }
        trap.genericTrap = 6;
        trap.specificTrap = alert.getTrapType();
        long timeTicks = alert.getAlertTime() - Server.startTime.getTime();
        trap.timeStamp = new TimeTicks(timeTicks / 10L);
        AlertDefinition alertDef = alert.getAlertDefinition();
        if (alert instanceof FabricAlert) {
            boolean isSSAlert = false;
            if (alertDef.aldProductID == 3) {
                isSSAlert = true;
            }
            trap.enterprise = isSSAlert ? SnmpUtil.tivoliSRMOID(AlertProductManager.getSnmpOid((short)0)) : SnmpUtil.tpcFabricOID(alert.getEnterprise());
            Hashtable varBinds = alert.getVarBinds();
            if (varBinds != null && !varBinds.isEmpty()) {
                Enumeration keys = varBinds.keys();
                while (keys.hasMoreElements()) {
                    int[] oid = (int[])keys.nextElement();
                    String binding = (String)varBinds.get(oid);
                    if (isSSAlert) {
                        trap.addVarBind(SnmpUtil.tivoliSRMOID(oid), (Serializable)new OctetString(binding, true));
                        continue;
                    }
                    trap.addVarBind(SnmpUtil.tpcFabricOID(oid), (Serializable)new OctetString(binding, true));
                }
                int[] msgOID = new int[]{1, 1};
                int[] msgID_OID = new int[]{1, 9};
                int[] ALERT_NAME_OID = new int[]{1, 1, 2};
                String msgID = alert.getMessageID();
                Object[] msgParms = alert.getMessageParameters();
                String msg = MessageLog.getMessageNoID((String)msgID, (Object[])msgParms);
                if (isSSAlert) {
                    String s = alertDef.aldCreator + '.' + alertDef.getAldName();
                    trap.addVarBind(SnmpUtil.tivoliSRMOID(ALERT_NAME_OID), (Serializable)new OctetString(s, true));
                } else {
                    trap.addVarBind(SnmpUtil.tpcFabricOID(msgOID), (Serializable)new OctetString(msg, true));
                    trap.addVarBind(SnmpUtil.tpcFabricOID(msgID_OID), (Serializable)new OctetString(msgID, true));
                }
            }
        } else {
            trap.enterprise = alertDef.aldProductID == 3 ? SnmpUtil.tivoliSRMOID(AlertProductManager.getSnmpOid((short)0)) : SnmpUtil.tivoliSRMOID(AlertProductManager.getSnmpOid((short)alertDef.aldProductID));
            int[][] varBindOID = alert.getVarBindOID();
            String[] parms = alert.getParameters();
            for (int i = 0; i < varBindOID.length && i < parms.length; ++i) {
                if (varBindOID[i] == null || varBindOID[i].length == 0 || parms[i] == null) continue;
                trap.addVarBind(SnmpUtil.tivoliSRMOID(varBindOID[i]), (Serializable)new OctetString(parms[i], true));
            }
        }
        SnmpTrap traceResult = trap;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getTrapPdu", (Object)traceResult);
        }
        return traceResult;
    }

    public static Email getEmail(Alert alert) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getEmail", (String)"alert");
        }
        Email email = null;
        Object[] parms = alert.getParameters();
        AlertDefinition alertDef = alert.getAlertDefinition();
        AlertEmail emailDef = alertDef.aldEmailDef;
        if (emailDef != null) {
            String text;
            String subject;
            ConfigSettings settings = Server.getSettings();
            if (SQLUtil.isNullString(emailDef.aleSubject)) {
                String msgID = alertDef.getEmailSubjectID();
                subject = MessageLog.getMessageNoID((String)msgID);
            } else {
                subject = emailDef.aleSubject;
            }
            StringBuffer textbuf = new StringBuffer(2048);
            if (SQLUtil.isNullString(emailDef.aleText)) {
                String msgID = alert instanceof FabricAlert ? alert.getMessageID() : alertDef.getEmailMsgID();
                text = MessageLog.getMessageNoID((String)msgID, (Object[])parms);
                if (alert instanceof FabricAlert && alert.hasAffectedResources()) {
                    text = text + "\n" + alert.getAffectedHosts();
                }
            } else {
                Util.formatLine((String)emailDef.aleText, (StringBuffer)textbuf, (Object[])parms);
                text = textbuf.toString();
            }
            String from = MessageLog.getMessageNoID((String)"ALR1200L", (Object)AlertProductManager.getName((short)alertDef.aldProductID), (Object)Server.getServerHostName());
            email = new Email(subject, text, from, settings.csSmtp.ssReplyTo, settings.csSmtp.ssReturn, settings.csSmtp.ssDfltDomain);
            AlertUtil.addRecipients(email, emailDef);
        }
        Email traceResult = email;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getEmail", traceResult);
        }
        return traceResult;
    }

    private static void addRecipients(Email email, AlertEmail emailDef) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"addRecipients", (String)"email, emailDef");
        }
        ArrayList recipientList = emailDef.parseRecipients();
        for (int i = 0; i < recipientList.size(); ++i) {
            email.addRecipient((String)recipientList.get(i));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"addRecipients");
        }
    }
}

