/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.aperi.logging.TraceLogger;

public class ComputerHashTable {
    private int hashTableSize;
    private HashAnchor[] hashTable;
    private static final int DEFAULT_HASH_TABLE_SIZE = 53;

    public ComputerHashTable() {
        this(53);
    }

    public ComputerHashTable(int hashTableSize) {
        this.hashTableSize = hashTableSize;
        this.hashTable = new HashAnchor[hashTableSize];
        for (int i = hashTableSize - 1; i >= 0; --i) {
            this.hashTable[i] = new HashAnchor();
        }
    }

    public HashedComputer get(int computerID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ComputerHashTable.class.getName(), (String)"get", (String)"computerID");
        }
        HashedComputer result = null;
        if (computerID >= 0) {
            HashAnchor hashAnchor = this.getHashAnchor(computerID);
            HashedComputer computer = hashAnchor.head;
            for (int i = hashAnchor.count; i > 0; --i) {
                if (computer.computerID == computerID) {
                    result = computer;
                    break;
                }
                computer = computer.nextElement;
            }
        }
        HashedComputer traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ComputerHashTable.class.getName(), (String)"get", traceResult);
        }
        return traceResult;
    }

    public synchronized void add(HashedComputer computer) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ComputerHashTable.class.getName(), (String)"add", (String)"computer");
        }
        HashAnchor hashAnchor = this.getHashAnchor(computer.computerID);
        computer.nextElement = null;
        if (hashAnchor.tail == null) {
            hashAnchor.head = computer;
        } else {
            hashAnchor.tail.nextElement = computer;
        }
        hashAnchor.tail = computer;
        ++hashAnchor.count;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ComputerHashTable.class.getName(), (String)"add");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int computerID) {
        HashedComputer computer;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ComputerHashTable.class.getName(), (String)"delete", (String)"computerID");
        }
        if ((computer = this.get(computerID)) != null) {
            HashedComputer hashedComputer = computer;
            synchronized (hashedComputer) {
                computer.computerID = Integer.MIN_VALUE;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ComputerHashTable.class.getName(), (String)"delete");
        }
    }

    private HashAnchor getHashAnchor(int computerID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ComputerHashTable.class.getName(), (String)"getHashAnchor", (String)"computerID");
        }
        int index = computerID % this.hashTableSize;
        HashAnchor traceResult = this.hashTable[index];
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ComputerHashTable.class.getName(), (String)"getHashAnchor", (Object)traceResult);
        }
        return traceResult;
    }

    public Iterator getIterator() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ComputerHashTable.class.getName(), (String)"getIterator", (String)"");
        }
        ComputerIterator traceResult = new ComputerIterator();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ComputerHashTable.class.getName(), (String)"getIterator", (Object)traceResult);
        }
        return traceResult;
    }

    private class ComputerIterator
    implements Iterator {
        int hashIndex = -1;
        int computerCount = 0;
        HashedComputer nextComputer = null;

        private ComputerIterator() {
        }

        public boolean hasNext() {
            if (this.computerCount > 0) {
                return true;
            }
            while (++this.hashIndex < ComputerHashTable.this.hashTableSize && ((ComputerHashTable)ComputerHashTable.this).hashTable[this.hashIndex].count == 0) {
            }
            if (this.hashIndex < ComputerHashTable.this.hashTableSize) {
                this.computerCount = ((ComputerHashTable)ComputerHashTable.this).hashTable[this.hashIndex].count;
                this.nextComputer = ((ComputerHashTable)ComputerHashTable.this).hashTable[this.hashIndex].head;
                return true;
            }
            return false;
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.computerCount;
            HashedComputer computer = this.nextComputer;
            this.nextComputer = computer.nextElement;
            return computer;
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }

    private static class HashAnchor {
        public int count;
        public HashedComputer head;
        public HashedComputer tail;

        private HashAnchor() {
        }
    }

    public static class HashedComputer {
        public HashedComputer nextElement;
        public int computerID;
    }
}

