/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.Service;
import org.eclipse.aperi.server.ServiceProvider;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.server.ServiceRequest;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.VMTransceiver;
import org.eclipse.aperi.server.handler.scheduler.JobHndlr;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.aperi.xmsg.MessageLog;

public class ServiceManager
implements IDisposable {
    private static final String CLASSNAME = ServiceManager.class.getName();
    private ServiceExtensionManager extensionManager;
    private Map<String, Service> serviceCache;
    private ReadWriteLock cacheLock;
    private boolean isInitialized;

    public ServiceManager() {
        String methodName = "ServiceManager";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"ServiceManager", (String)"");
        }
        this.extensionManager = new ServiceExtensionManager();
        this.serviceCache = new HashMap<String, Service>();
        this.cacheLock = new ReentrantReadWriteLock(true);
        this.isInitialized = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"ServiceManager");
        }
    }

    public synchronized boolean initialize() {
        String[] providerExtensionIds;
        String methodName = "initialize";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"initialize", (String)"");
        }
        if ((providerExtensionIds = this.extensionManager.getAllExtensionIds()) != null) {
            for (int i = 0; i < providerExtensionIds.length; ++i) {
                try {
                    this.addService(providerExtensionIds[i]);
                    continue;
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception((String)CLASSNAME, (String)"initialize", (Throwable)e);
                }
            }
        }
        this.isInitialized = true;
        this.notifyAll();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"initialize", (boolean)this.isInitialized);
        }
        return this.isInitialized;
    }

    public synchronized void awaitInitialization() {
        while (!this.isInitialized) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    public void dispose() {
        String methodName = "dispose";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"dispose", (String)"");
        }
        this.terminate((byte)1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"dispose");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(byte stopOption) {
        Service[] services;
        String methodName = "terminate";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"terminate", (String)"stopOption");
        }
        this.extensionManager.dispose();
        this.cacheLock.writeLock().lock();
        try {
            services = this.serviceCache.values().toArray(new Service[0]);
            this.serviceCache.clear();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        for (int i = 0; i < services.length; ++i) {
            this.stopService(services[i], stopOption);
        }
        this.isInitialized = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"terminate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addService(String requestType) throws Exception {
        String methodName = "addService";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"addService", (String)"serviceProvider");
        }
        Service s = null;
        ServiceProvider provider = null;
        this.cacheLock.writeLock().lock();
        try {
            if (this.serviceCache.containsKey(requestType)) {
                throw new GeneralException("Failed to register service. Service ID " + requestType + " is not available.");
            }
            provider = (ServiceProvider)this.extensionManager.getExtensionImpl(requestType);
            if (provider != null) {
                String serviceName = RequestTypeManager.getInternalName((String)requestType);
                s = new Service(requestType, serviceName, provider.getClass());
                this.serviceCache.put(requestType, s);
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        if (s != null && !this.startService(s, provider) && TraceLogger.enableTrace) {
            TraceLogger.traceMessage((int)1, (String)CLASSNAME, (String)"addService", (String)("Failed to start service (" + s.serviceClass.getName() + ")."));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"addService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeService(String requestType) throws Exception {
        String methodName = "removeService";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"removeService", (String)"serviceProvider");
        }
        Service s = null;
        this.cacheLock.writeLock().lock();
        try {
            s = this.serviceCache.remove(requestType);
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        if (s != null) {
            this.stopService(s, (byte)1);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"removeService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startService(String typeCode) {
        Service s;
        String methodName = "startService";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"startService", (String)"typeCode");
        }
        boolean success = false;
        this.cacheLock.readLock().lock();
        try {
            s = this.serviceCache.get(typeCode);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        if (s != null) {
            success = this.startService(s, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"startService", (boolean)success);
        }
        return success;
    }

    public boolean startService(Service s) {
        return this.startService(s, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startService(Service s, ServiceProvider providerInstance) {
        String methodName = "startService";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"startService", (String)"s");
        }
        boolean success = true;
        Service service = s;
        synchronized (service) {
            PrintWriter myLogWriter = MessageLog.getThreadLog();
            String myServiceID = TSThread.getServiceID();
            try {
                if (s.instance == null) {
                    MessageLog.logMessage((String)"SRV0020I", (Object)s.serviceName);
                    s.instance = providerInstance != null ? providerInstance : (ServiceProvider)s.serviceClass.newInstance();
                    TSThread.setServiceID((String)s.instance.getTypeCode());
                    s.queue.setActive(true);
                    s.instance.startup(s.queue);
                    s.logWriter = MessageLog.getThreadLog();
                }
            }
            catch (Exception e) {
                success = false;
                e.printStackTrace();
                MessageLog.logException((String)"SRV0018E", (Exception)e, (Object)s.serviceClass.getName());
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)CLASSNAME, (String)"startService", (Throwable)e);
                }
                s.instance = null;
                s.queue.setActive(false);
                this.drainQueue(s.queue);
            }
            finally {
                MessageLog.setThreadLog((PrintWriter)myLogWriter);
                TSThread.setServiceID((String)myServiceID);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"startService", (boolean)success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopService(String typeCode, byte stopOption) {
        Service s;
        String methodName = "stopService";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"stopService", (String)"typeCode, stopOption");
        }
        boolean success = false;
        this.cacheLock.readLock().lock();
        try {
            s = this.serviceCache.get(typeCode);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        if (s != null) {
            success = this.stopService(s, stopOption);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"stopService", (boolean)success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopService(Service s, byte stopOption) {
        String methodName = "stopService";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"stopService", (String)"s, stopOption");
        }
        boolean success = true;
        PrintWriter myLogWriter = MessageLog.getThreadLog();
        try {
            Service service = s;
            synchronized (service) {
                if (s.instance != null) {
                    MessageLog.logMessage((String)"SRV0021I", (Object)s.serviceName);
                    ServiceProvider provider = s.instance;
                    s.instance = null;
                    s.queue.setActive(false);
                    this.drainQueue(s.queue);
                    MessageLog.setThreadLog((PrintWriter)s.logWriter);
                    provider.shutdown(stopOption);
                }
            }
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace();
            MessageLog.logException((String)"SRV0019E", (Exception)e, (Object)s.serviceClass.getName());
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)CLASSNAME, (String)"stopService", (Throwable)e);
            }
        }
        finally {
            MessageLog.setThreadLog((PrintWriter)myLogWriter);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"stopService", (boolean)success);
        }
        return success;
    }

    private void drainQueue(ServiceQueue queue) {
        String methodName = "drainQueue";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"drainQueue", (String)"queue");
        }
        ServiceRequest sr = (ServiceRequest)queue.getHead();
        while (sr != null) {
            try {
                VMTransceiver transceiver = (VMTransceiver)sr.comm;
                VMJobResults jobResults = transceiver.getJobData(sr.request);
                if (jobResults != null) {
                    JobRun job = jobResults.getJobRun();
                    JobHndlr.removeFromJobTable(job);
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            sr.comm.close();
            sr.returnServiceRequest();
            sr = (ServiceRequest)sr.nextElement;
        }
        queue.empty();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"drainQueue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getService(String typeCode) {
        Service s;
        String methodName = "getService";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getService", (String)"typeCode");
        }
        this.cacheLock.readLock().lock();
        try {
            s = this.serviceCache.get(typeCode);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getService", (Object)s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service[] listServices() {
        Service[] services;
        String methodName = "listServices";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"listServices", (String)"");
        }
        this.cacheLock.readLock().lock();
        try {
            services = this.serviceCache.values().toArray(new Service[0]);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"listServices", Arrays.asList(services));
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean routeRequest(Request request, Transceiver comm) {
        Service s;
        String methodName = "routeRequest";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"routeRequest", (String)"request, comm");
        }
        boolean success = false;
        this.cacheLock.readLock().lock();
        try {
            s = this.serviceCache.get(request.typeCode);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        if (s != null) {
            success = s.queue.add(ServiceRequest.getServiceRequest(request, comm), (request.flags & 1) != 0);
            if (!success) {
                ServiceManager.routingError(request, comm, "SRV0024E", (short)24);
            }
        } else {
            ServiceManager.routingError(request, comm, "SRV0023E");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"routeRequest", (boolean)success);
        }
        return success;
    }

    public static void routingError(Request request, Transceiver comm, String msgID) {
        String methodName = "routingError";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"routingError", (String)"request, comm, msgID");
        }
        ServiceManager.routingError(request, comm, msgID, (short)12);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"routingError");
        }
    }

    public static void routingError(Request request, Transceiver comm, String msgID, short status) {
        String methodName = "routingError";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"routingError", (String)"request, comm, msgID, status");
        }
        Response response = Response.getResponse((short)status, null);
        response.errorMessage = MessageLog.getMessage((String)msgID, null);
        comm.transmitResponse(request, response);
        comm.close();
        comm.returnTransceiver();
        response.returnResponse();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"routingError");
        }
    }

    private class ServiceExtensionManager
    extends AbstractExtensionMgr {
        private ServiceExtensionManager() {
        }

        public String getExtensionPointId() {
            return "org.eclipse.aperi.server.data.serviceProvider";
        }

        public Object getExtensionImpl(String extensionId) throws ExtensionException {
            return super.getExtensionImpl(extensionId, false);
        }

        public Object getExtensionImpl(String extensionId, boolean useCache) throws ExtensionException {
            throw new UnsupportedOperationException();
        }

        protected void extensionAdded(String extensionId) {
            block2: {
                try {
                    ServiceManager.this.addService(extensionId);
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block2;
                    TraceLogger.exception((String)ServiceExtensionManager.class.getName(), (String)"extensionAdded", (Throwable)e);
                }
            }
        }

        protected void extensionRemoved(String extensionId) {
            block2: {
                try {
                    ServiceManager.this.removeService(extensionId);
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block2;
                    TraceLogger.exception((String)ServiceExtensionManager.class.getName(), (String)"extensionRemoved", (Throwable)e);
                }
            }
        }
    }
}

