/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import org.eclipse.aperi.common.ListElement;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.RequestManager;

public class ServiceQueue {
    private byte state = 0;
    private int pending;
    private int processed;
    private int waiting;
    private ListElement head = null;
    private ListElement tail = null;
    private RequestManager threadManager = null;

    public int getPending() {
        return this.pending;
    }

    public int getProcessed() {
        return this.processed;
    }

    public int getWaiting() {
        return this.waiting;
    }

    public ListElement getHead() {
        return this.head;
    }

    public void setThreadManager(RequestManager threadManager) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ServiceQueue.class.getName(), (String)"setThreadManager", (String)"threadManager");
        }
        this.threadManager = threadManager;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ServiceQueue.class.getName(), (String)"setThreadManager");
        }
    }

    public synchronized void setState(byte pState) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ServiceQueue.class.getName(), (String)"setState", (String)"pState");
        }
        this.state = pState;
        if (this.state != 0) {
            this.notifyAll();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ServiceQueue.class.getName(), (String)"setState");
        }
    }

    public void setActive(boolean isActive) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ServiceQueue.class.getName(), (String)"setActive", (String)"isActive");
        }
        byte newState = isActive ? (byte)0 : 2;
        this.setState(newState);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ServiceQueue.class.getName(), (String)"setActive");
        }
    }

    public synchronized boolean add(ListElement element, boolean highPriority) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ServiceQueue.class.getName(), (String)"add", (String)"element, highPriority");
        }
        if (this.state != 0) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ServiceQueue.class.getName(), (String)"add", (boolean)traceResult);
            }
            return traceResult;
        }
        if (highPriority) {
            element.nextElement = this.head;
            this.head = element;
            if (this.tail == null) {
                this.tail = this.head;
            }
        } else {
            if (this.tail == null) {
                this.head = element;
            } else {
                this.tail.nextElement = element;
            }
            element.nextElement = null;
            this.tail = element;
        }
        ++this.pending;
        if (this.threadManager != null) {
            this.threadManager.growThreadPool();
        }
        this.notify();
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ServiceQueue.class.getName(), (String)"add", (boolean)traceResult);
        }
        return traceResult;
    }

    public synchronized ListElement get() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ServiceQueue.class.getName(), (String)"get", (String)"");
        }
        if (this.state >= 2) {
            ListElement traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ServiceQueue.class.getName(), (String)"get", traceResult);
            }
            return traceResult;
        }
        try {
            while (this.head == null) {
                if (this.state != 0 || this.threadManager != null && !this.threadManager.shouldThreadWait()) {
                    ListElement traceResult = null;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ServiceQueue.class.getName(), (String)"get", traceResult);
                    }
                    return traceResult;
                }
                ++this.waiting;
                this.wait();
                --this.waiting;
            }
        }
        catch (InterruptedException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ServiceQueue.class.getName(), (String)"get", (Throwable)e);
            }
            --this.waiting;
            ListElement traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ServiceQueue.class.getName(), (String)"get", traceResult);
            }
            return traceResult;
        }
        --this.pending;
        ++this.processed;
        ListElement element = this.head;
        this.head = this.head.nextElement;
        if (this.head == null) {
            this.tail = null;
        }
        element.nextElement = null;
        ListElement traceResult = element;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ServiceQueue.class.getName(), (String)"get", (Object)traceResult);
        }
        return traceResult;
    }

    public void empty() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ServiceQueue.class.getName(), (String)"empty", (String)"");
        }
        this.tail = null;
        this.head = null;
        this.pending = 0;
        this.processed = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ServiceQueue.class.getName(), (String)"empty");
        }
    }
}

