/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.alert;

import java.sql.Connection;
import java.util.TreeMap;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.HasID;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.MissingAlertAccessible;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.alert.StormAlerter;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiscoveryAlerter
extends StormAlerter {
    private static final int[][] varBindOIDs = new int[][]{null, FILER_NAME_OID, RESOURCE_TYPE_OID, RESOURCE_NAME_OID, Alerter.ALERT_TYPE_OID};
    private static final String[] tecSlotNames = new String[]{null, "filerName", "resourceType", "resourceName", "alertType"};
    private short alertType;
    private MissingAlertAccessible accessor;
    private short ownerType;
    private int ownerID;
    private String ownerName;
    private String ownerTypeName;

    public DiscoveryAlerter(Connection pDBC, MissingAlertAccessible pAccessor, short pAlertType, short pOwnerType, int pOwnerID, String pOwnerName) {
        super(pDBC, -1);
        this.alertType = pAlertType;
        this.accessor = pAccessor;
        this.ownerType = pOwnerType;
        this.ownerID = pOwnerID;
        this.ownerName = pOwnerName;
        this.ownerTypeName = ResourceTypeManager.getName((short)this.ownerType);
    }

    private void processMissingFilerAlert(Share share) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DiscoveryAlerter.class.getName(), (String)"processMissingFilerAlert", (String)"share");
        }
        String[] parms = new String[varBindOIDs.length];
        parms[0] = ResourceTypeManager.getName((short)share.shResourceType);
        parms[1] = share.shPath;
        parms[2] = this.ownerTypeName;
        parms[3] = this.ownerName;
        parms[4] = MessageLog.getMessageNoID((String)this.alertDef.getEmailSubjectID());
        Alert alert = new Alert(share.shResourceID, share.shResourceID, share.shResourceType, this.alertDef, parms, 21, varBindOIDs, tecSlotNames, -1, -1, this.ownerID, this.ownerType, 0, -1);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DiscoveryAlerter.class.getName(), (String)"processMissingFilerAlert");
        }
    }

    private void processDiskArrayAlert(Share share) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DiscoveryAlerter.class.getName(), (String)"processDiskArrayAlert", (String)"share");
        }
        this.initParms();
        this.alertParms[0] = this.ownerName;
        this.alertParms[1] = share.shPath;
        this.alertParms[11] = ResourceTypeManager.getName((short)share.shResourceType);
        this.alertParms[10] = MessageLog.getMessageNoID((String)this.alertDef.getEmailSubjectID());
        Alert alert = new Alert(this.ownerID, share.shResourceID, share.shResourceType, this.alertDef, this.alertParms, 22, this.snmpOIDs, DiscoveryAlerter.getTecSlotNames(), -1, -1, -1, -1, 1, -1);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DiscoveryAlerter.class.getName(), (String)"processDiskArrayAlert");
        }
    }

    protected void processAlert(HasID resource) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DiscoveryAlerter.class.getName(), (String)"processAlert", (String)"resource");
        }
        Share share = (Share)resource;
        if (this.alertDef.aldCondition == 66) {
            this.processMissingFilerAlert(share);
        } else {
            this.processDiskArrayAlert(share);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DiscoveryAlerter.class.getName(), (String)"processAlert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alert(Share resources) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DiscoveryAlerter.class.getName(), (String)"alert", (String)"resources");
        }
        TreeMap<Integer, Share> sorter = new TreeMap<Integer, Share>();
        while (resources != null) {
            sorter.put(new Integer(-resources.shResourceID), resources);
            resources = resources.shNext;
        }
        for (Share share : sorter.values()) {
            share.shNext = resources;
            resources = share;
        }
        sorter = null;
        this.initAlertAccessor();
        try {
            this.accessor.initQueryByAttrType(this.alertType, (HasID)resources);
            this.processOncePrepared(this.accessor, (HasID)resources);
        }
        finally {
            this.close();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DiscoveryAlerter.class.getName(), (String)"alert");
        }
    }
}

