/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.alert;

import java.sql.Connection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.server.alert.StormAlerter;
import org.eclipse.aperi.server.guireq.AlertDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeAlerter
extends StormAlerter {
    private Computer oldComputer;
    private Computer computer;
    private Share missingDevList;
    private Share missingFSList;
    private Share missingVSList;
    private boolean isDiskArray;
    private short attributeType;
    private short computerType;
    private short groupType;
    private short clusterGroupType;
    private byte subProduct;

    public ProbeAlerter(Connection dbc, Computer oldComputer, Computer computer, Share missingDevList, Share missingFSList) {
        super(dbc, computer.cmpID);
        this.oldComputer = oldComputer;
        this.computer = computer;
        this.missingDevList = missingDevList;
        this.missingFSList = missingFSList;
        this.isDiskArray = Constants.isDiskArray((short)computer.cmpOSType);
        if (this.isDiskArray) {
            this.attributeType = (short)81;
            this.computerType = (short)78;
            this.groupType = (short)77;
            this.subProduct = 1;
            this.computerID = computer.cmpID;
            this.hostName = computer.cmpNasFiler.nfAlias;
        } else {
            this.attributeType = (short)26;
            this.computerType = 1;
            this.groupType = 0;
            this.clusterGroupType = (short)-1;
            this.subProduct = 0;
        }
    }

    public ProbeAlerter(Connection dbc, int cmpID) {
        super(dbc, cmpID);
        this.attributeType = (short)26;
        this.computerType = 1;
        this.groupType = 0;
        this.subProduct = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alertVSRemoved(int clusterID, Share missingVSList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"alertVSRemoved", (String)"clusterID, missingVSList");
        }
        this.clusterGroupType = (short)99;
        int clusterGroupID = clusterID;
        this.missingVSList = missingVSList;
        try {
            this.initAlertAccessor();
            AlertDefinition[] alerts = this.alertAccessor.getByResource(this.computerType, -1, this.groupType, -1, this.clusterGroupType, clusterGroupID, this.attributeType);
            if (alerts == null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"alertVSRemoved");
                }
                return;
            }
            for (int i = 0; i < alerts.length; ++i) {
                this.alertDef = alerts[i];
                if (this.alertDef.aldCondition != 74) continue;
                this.checkVS_removed(clusterID);
            }
        }
        finally {
            this.close();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"alertVSRemoved");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alert() throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"alert", (String)"");
        }
        try {
            AlertDefinition[] alerts;
            if (this.isDiskArray) {
                this.initAlertAccessor();
            } else {
                this.dealWithFilesystems();
            }
            int groupID = this.oldComputer != null ? this.oldComputer.cmpGroupID : (this.isDiskArray ? 8 : 4);
            int clusterGroupID = -1;
            if (this.computer.cmpCluster != null) {
                this.clusterGroupType = (short)99;
                clusterGroupID = this.computer.cmpCluster.clusterID;
            }
            if ((alerts = this.alertAccessor.getByResource(this.computerType, this.computerID, this.groupType, groupID, this.clusterGroupType, clusterGroupID, this.attributeType)) == null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"alert");
                }
                return;
            }
            block15: for (int i = 0; i < alerts.length; ++i) {
                this.alertDef = alerts[i];
                switch (this.alertDef.aldCondition) {
                    case 1: 
                    case 2: 
                    case 67: 
                    case 68: {
                        this.checkRAM();
                        continue block15;
                    }
                    case 3: 
                    case 4: {
                        this.checkMemory();
                        continue block15;
                    }
                    case 5: {
                        this.checkNewDisk();
                        continue block15;
                    }
                    case 6: {
                        this.checkMissingDisk();
                        continue block15;
                    }
                    case 7: 
                    case 24: {
                        this.checkDiskDefect();
                        continue block15;
                    }
                    case 8: {
                        this.checkDiskFailure();
                        continue block15;
                    }
                    case 9: {
                        this.checkNewFS();
                        continue block15;
                    }
                    case 73: {
                        this.checkVS_added();
                        continue block15;
                    }
                    case 75: {
                        this.checkVS_moved();
                    }
                }
            }
        }
        finally {
            this.close();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"alert");
        }
    }

    @Override
    protected boolean processFilesystemAlert(Filesystem fs) {
        boolean result;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"processFilesystemAlert", (String)"fs");
        }
        if (!(result = super.processFilesystemAlert(fs)) && this.alertDef.aldCondition == 10) {
            this.checkFSConfig(fs);
            result = true;
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"processFilesystemAlert", (boolean)traceResult);
        }
        return traceResult;
    }

    private static Filesystem extractFromSorter(Map<MutableInteger, Filesystem> sorter) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"extractFromSorter", (String)"sorter");
        }
        Filesystem result = null;
        for (Filesystem fs : sorter.values()) {
            fs.fsNext = result;
            result = fs;
        }
        Filesystem traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"extractFromSorter", (Object)traceResult);
        }
        return traceResult;
    }

    private void dealWithFilesystems() throws StorageException {
        MutableInteger key;
        Filesystem fs;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"dealWithFilesystems", (String)"");
        }
        TreeMap<MutableInteger, Filesystem> sorter = new TreeMap<MutableInteger, Filesystem>();
        LogicalDisk ld = this.computer.cmpLogicalDisk;
        while (ld != null) {
            fs = ld.ldFilesystem;
            if (fs != null) {
                key = new MutableInteger(-fs.fsID);
                sorter.put(key, fs);
            }
            ld = ld.ldNext;
        }
        Filesystem present = ProbeAlerter.extractFromSorter(sorter);
        sorter.clear();
        Share share = this.missingFSList;
        Share share2 = this.missingFSList;
        while (share != null) {
            fs = (Filesystem)share.shResource;
            if (fs != null) {
                key = new MutableInteger(-fs.fsID);
                sorter.put(key, fs);
            }
            share = share.shNext;
        }
        fs = ProbeAlerter.extractFromSorter(sorter);
        sorter = null;
        if (share2 != null && fs != null && share2.shComputerID != fs.fsComputerID) {
            TStatComputer tstat = new TStatComputer(this.dbc);
            if (tstat.isVirtualServer(share2.shComputerID)) {
                fs.fsComputerID = share2.shComputerID;
            }
            share2 = null;
        }
        this.initAlertAccessor();
        this.processFilesystemAlerts(present, fs);
        if (this.alertAccessor != null) {
            this.alertAccessor.closeSelect();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"dealWithFilesystems");
        }
    }

    private void checkRAM() {
        boolean isIncrease;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"checkRAM", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkRAM");
            }
            return;
        }
        boolean bl = isIncrease = this.alertDef.aldCondition == 1 || this.alertDef.aldCondition == 67;
        if (this.computer.cmpRAM < this.oldComputer.cmpRAM && !isIncrease || this.computer.cmpRAM > this.oldComputer.cmpRAM && isIncrease) {
            this.initParms();
            this.setHostName();
            this.alertParms[1] = this.hostName;
            this.setNumParm(3, this.computer.cmpRAM, "MB");
            this.setNumParm(4, this.oldComputer.cmpRAM, "MB");
            this.setParmFromMsg(11, "STS0054I");
            this.setParmFromMsg(10, "ALR1055W");
            this.genAlert(this.computerID, this.computerType, 1, this.computer.cmpRAM, this.oldComputer.cmpRAM, this.subProduct, -1);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkRAM");
        }
    }

    private void checkMemory() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"checkMemory", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkMemory");
            }
            return;
        }
        int memory = this.computer.cmpRAM + this.computer.cmpSwapSpace;
        int oldMemory = this.oldComputer.cmpRAM + this.oldComputer.cmpSwapSpace;
        if (memory < oldMemory && this.alertDef.aldCondition == 4 || memory > oldMemory && this.alertDef.aldCondition == 3) {
            this.initParms();
            this.setHostName();
            this.alertParms[1] = this.hostName;
            this.setNumParm(3, memory, "MB");
            this.setNumParm(4, oldMemory, "MB");
            this.setParmFromMsg(11, "STS0054I");
            this.setParmFromMsg(10, "ALR1056W");
            this.genAlert(this.computerID, (short)1, 2, memory, oldMemory);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkMemory");
        }
    }

    private void checkNewDisk() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"checkNewDisk", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkNewDisk");
            }
            return;
        }
        Device dev = this.computer.cmpDevice;
        while (dev != null) {
            if (dev.devType == 0 && (dev.devFlags & 4) != 0) {
                this.initParms();
                this.setHostName();
                if (this.isDiskArray && this.computer.cmpNasFiler.nfAlias != null) {
                    this.alertParms[20] = this.hostName;
                }
                this.alertParms[1] = this.getDiskName(dev);
                this.setParmFromMsg(11, "STS0066I");
                this.setParmFromMsg(10, "ALR1057W");
                this.genAlert(dev.devID, (short)10, 3, -1, -1, this.subProduct, -1);
            }
            dev = dev.devNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkNewDisk");
        }
    }

    private void checkMissingDisk() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"checkMissingDisk", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkMissingDisk");
            }
            return;
        }
        Share sh = this.missingDevList;
        while (sh != null) {
            if (sh.shResource != null) {
                Device dev = (Device)sh.shResource;
                this.initParms();
                this.setHostName();
                if (this.isDiskArray && this.computer.cmpNasFiler.nfAlias != null) {
                    this.alertParms[20] = this.hostName;
                }
                this.alertParms[1] = this.getDiskName(dev);
                this.setParmFromMsg(11, "STS0066I");
                this.setParmFromMsg(10, "ALR1058W");
                this.genAlert(dev.devID, (short)10, 4, -1, -1, this.subProduct, -1);
            }
            sh = sh.shNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkMissingDisk");
        }
    }

    private void checkDiskDefect() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"checkDiskDefect", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkDiskDefect");
            }
            return;
        }
        Device dev = this.computer.cmpDevice;
        while (dev != null) {
            if (dev.devType == 0) {
                Disk disk = (Disk)dev;
                DiskHistory hist = disk.dskHistory;
                if (hist != null && hist.dkhGrownDefects > hist.dkhOldGrownDefects && (this.alertDef.aldCondition != 24 || hist.dkhGrownDefects > this.alertDef.aldThresholdValue)) {
                    this.initParms();
                    this.setHostName();
                    if (this.alertDef.aldCondition == 24) {
                        this.setNumParm(2, this.alertDef.aldThresholdValue, (String)null);
                    }
                    this.setNumParm(3, hist.dkhGrownDefects, (String)null);
                    this.setNumParm(4, hist.dkhOldGrownDefects, (String)null);
                    this.alertParms[1] = this.getDiskName(dev);
                    this.setParmFromMsg(11, "STS0066I");
                    this.setParmFromMsg(10, "ALR1059W");
                    this.genAlert(dev.devID, (short)10, 5, hist.dkhGrownDefects, hist.dkhOldGrownDefects);
                }
            }
            dev = dev.devNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkDiskDefect");
        }
    }

    private void checkDiskFailure() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"checkDiskFailure", (String)"");
        }
        Device dev = this.computer.cmpDevice;
        while (dev != null) {
            if (dev.devType == 0) {
                Disk disk = (Disk)dev;
                if (disk.dskFailurePredicted) {
                    this.initParms();
                    this.setHostName();
                    this.alertParms[1] = this.getDiskName(dev);
                    this.setParmFromMsg(11, "STS0066I");
                    this.setParmFromMsg(10, "ALR1060W");
                    this.genAlert(dev.devID, (short)10, 6, -1, -1);
                }
            }
            dev = dev.devNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkDiskFailure");
        }
    }

    private void checkNewFS() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"checkNewFS", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkNewFS");
            }
            return;
        }
        LogicalDisk lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldFilesystem != null && lDisk.ldFilesystem.fsNewFilesystem) {
                Filesystem fs = lDisk.ldFilesystem;
                this.initParms();
                this.setHostName();
                this.alertParms[1] = fs.fsMountPoint;
                this.alertParms[11] = "filesystem";
                this.setParmFromMsg(10, "ALR1061W");
                this.genAlert(fs.fsID, (short)3, 7, -1, -1);
            }
            lDisk = lDisk.ldNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkNewFS");
        }
    }

    private void checkFSConfig(Filesystem fs) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"checkFSConfig", (String)"fs");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkFSConfig");
            }
            return;
        }
        if (!fs.fsLogicalDisk.ldNewLogicalDisk || fs.fsNewFilesystem) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkFSConfig");
            }
            return;
        }
        this.initParms();
        this.setHostName();
        this.alertParms[1] = fs.fsMountPoint;
        this.alertParms[11] = "filesystem";
        this.setParmFromMsg(10, "ALR1063W");
        this.genAlert(fs.fsID, (short)3, 9, -1, -1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkFSConfig");
        }
    }

    private void checkVS_added() throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"checkVS_added", (String)"");
        }
        if (Constants.isVirtualServer((int)this.computer.cmpOSType) && this.computer.cmpNewVS) {
            this.processVirtualServerAlerts(this.computer, this.oldComputer);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkVS_added");
        }
    }

    private void checkVS_moved() throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"checkVS_moved", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkVS_moved");
            }
            return;
        }
        if (Constants.isVirtualServer((int)this.computer.cmpOSType) && this.computer.cmpClusterID == this.oldComputer.cmpClusterID && this.computer.cmpNodeHostedID != this.oldComputer.cmpNodeHostedID) {
            this.processVirtualServerAlerts(this.computer, this.oldComputer);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkVS_moved");
        }
    }

    private void checkVS_removed(int clusterID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeAlerter.class.getName(), (String)"checkVS_removed", (String)"clusterID");
        }
        this.processVirtualServerRemovedAlert(this.missingVSList.shResourceID, clusterID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeAlerter.class.getName(), (String)"checkVS_removed");
        }
    }

    private String getDiskName(Device dev) {
        return dev.devManufacturer + '/' + dev.devSerialNumber;
    }
}

