/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.alert;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.HasID;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.ScheduleQueryable;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.alert.BaseAlerter;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class StormAlerter
extends BaseAlerter {
    private TResFS fsAccessor;
    private TResComputer cmpAccessor;
    public static final int RESOURCE_NAME = 1;
    public static final int THRESHOLD = 2;
    public static final int NEW_VALUE = 3;
    public static final int OLD_VALUE = 4;
    public static final int PERCENTAGE = 5;
    public static final int VIOLATOR_NAME = 6;
    public static final int VIOLATOR_TYPE = 7;
    public static final int FILE_COUNT = 8;
    public static final int RESOURCE_GROUP = 9;
    public static final int ALERT_TYPE = 10;
    public static final int RESOURCE_TYPE = 11;
    public static final int USER = 12;
    public static final int USER_COUNT = 13;
    public static final int USER_SIZE = 14;
    public static final int LIST_OF_FILES = 15;
    public static final int VIRTUAL_SERVER_NAME = 16;
    public static final int CLUSTER_NAME = 17;
    public static final int CURRENT_NODE_NAME = 18;
    public static final int OLD_NODE_NAME = 19;
    public static final int STORAGE_SUBSYSTEM_NAME = 20;
    public static final int DEVICE_NAME = 21;
    public static final int THRESHOLD_BOUNDARY = 22;
    public static final int THRESHOLD_TIME = 23;
    public static final int THRESHOLD_NAME = 24;
    public static final int THRESH_DESCRIPTION = 25;
    public static final int START_TIME = 26;
    public static final int STOP_TIME = 27;
    public static final int ERROR = 28;
    public static final int RECORDS_CNT = 29;
    public static final int KEY_COUNT = 30;
    public static final int RAM_TRAP = 1;
    public static final int MEMORY_TRAP = 2;
    public static final int NEW_DISK_TRAP = 3;
    public static final int MISSING_DISK_TRAP = 4;
    public static final int DISK_DEFECT_TRAP = 5;
    public static final int DISK_FAILURE_TRAP = 6;
    public static final int NEW_FS_TRAP = 7;
    public static final int MISSING_FS_TRAP = 8;
    public static final int FS_RECONFIGURED_TRAP = 9;
    public static final int FS_FREESPACE_TRAP = 10;
    public static final int FS_FREE_INODE_TRAP = 11;
    public static final int NEW_DIR_TRAP = 12;
    public static final int MISSING_DIR_TRAP = 13;
    public static final int QUOTA_VIOLATION_TRAP = 14;
    public static final int CONSTRAINT_VIOLATION_TRAP = 15;
    public static final int PING_FAILURE_TRAP = 16;
    public static final int COMPUTER_DISCOVERED_TRAP = 17;
    public static final int NEW_NAS_COMPUTER_TRAP = 18;
    public static final int MISSING_FILER_TRAP = 21;
    public static final int MISSING_DISK_ARRAY_TRAP = 22;
    public static final int NEW_DISK_ARRAY_TRAP = 23;
    public static final int AUTO_FS_EXTEND_TRAP = 24;
    public static final int STOPPED_AUTO_FS_EXTEND_TRAP = 25;
    public static final int ADDED_VIRTUAL_SERVER_TRAP = 26;
    public static final int REMOVED_VIRTUAL_SERVER_TRAP = 27;
    public static final int MOVED_VIRTUAL_SERVER_TRAP = 28;
    public static final int PERF_THRESHOLD_TRAP = 29;
    public static final int PERF_MONITOR_FAIL_TRAP = 30;
    public static final int TRAP_COUNT = 31;
    public static final String RAM_EVENT_CLASS = "Ram_Changed";
    public static final String MEMORY_EVENT_CLASS = "VirtualMemory_Changed";
    public static final String NEW_DISK_EVENT_CLASS = "Disk_New";
    public static final String MISSING_DISK_EVENT_CLASS = "Disk_Missing";
    public static final String DISK_DEFECT_EVENT_CLASS = "Disk_Defect";
    public static final String DISK_FAILURE_EVENT_CLASS = "Disk_Failure";
    public static final String NEW_FS_EVENT_CLASS = "Filesystem_New";
    public static final String MISSING_FS_EVENT_CLASS = "Filesystem_Missing";
    public static final String FS_RECONFIGURED_EVENT_CLASS = "Filesystem_Reconfigured";
    public static final String FS_FREESPACE_EVENT_CLASS = "Filesystem_Freespace_Low";
    public static final String FS_FREE_INODE_EVENT_CLASS = "Filesystem_Inode_Low";
    public static final String MISSING_DIR_EVENT_CLASS = "Directory_Missing";
    public static final String CONSTRAINT_VIOLATION_EVENT_CLASS = "Filesystem_Constraint_Violated";
    public static final String PING_FAILURE_EVENT_CLASS = "Computer_Offline";
    public static final String COMPUTER_DISCOVERED_EVENT_CLASS = "Computer_Discovered";
    public static final String NEW_NAS_COMPUTER_EVENT_CLASS = "NasComputer_Discovered";
    public static final String MISSING_FILER_EVENT_CLASS = "Filer_Missing";
    public static final String MISSING_DISK_ARRAY_EVENT_CLASS = "DiskArray_Missing";
    public static final String NEW_DISK_ARRAY_EVENT_CLASS = "DiskArray_New";
    public static final String AUTO_FS_EXTEND_EVENT_CLASS = "Filesystem_Auto_Extend";
    public static final String STOPPED_AUTO_FS_EXTEND_EVENT_CLASS = "Filesystem_Stopped_Auto_Extend";
    public static final String ADDED_VIRTUAL_SERVER_EVENT_CLASS = "VirtualServer_Added";
    public static final String REMOVED_VIRTUAL_SERVER_EVENT_CLASS = "VirtualServer_Removed";
    public static final String MOVED_VIRTUAL_SERVER_EVENT_CLASS = "VirtualServer_Moved";
    public static final String PERF_THRESHOLD_EVENT_CLASS = "Perf_Threshold";
    public static final String PERF_MONITOR_FAIL_EVENT_CLASS = "PerfMonitor_Fail";
    public static String[] tecClassNames = StormAlerter.getTecClassNames();
    public static String[] tecEventMsgs = StormAlerter.getTecEventMsgs();
    public static String[] tecEventMsgIDs = StormAlerter.getTecEventMsgIDs();

    protected StormAlerter(Connection dbc, int computerID) {
        super(dbc, computerID);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"StormAlerter", (String)"dbc, computerID");
        }
        this.snmpOIDs = StormAlerter.getSnmpOIDTable();
        this.tecSlotNames = StormAlerter.getTecSlotNames();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"StormAlerter");
        }
    }

    public static int[][] getSnmpOIDTable() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"getSnmpOIDTable", (String)"");
        }
        int[][] snmpOIDs = new int[30][];
        snmpOIDs[0] = COMPUTER_OID;
        snmpOIDs[11] = RESOURCE_TYPE_OID;
        snmpOIDs[1] = RESOURCE_NAME_OID;
        snmpOIDs[10] = Alerter.ALERT_TYPE_OID;
        snmpOIDs[2] = THRESHOLD_OID;
        snmpOIDs[3] = NEW_VALUE_OID;
        snmpOIDs[4] = OLD_VALUE_OID;
        snmpOIDs[7] = VIOLATOR_TYPE_OID;
        snmpOIDs[6] = VIOLATOR_NAME_OID;
        snmpOIDs[16] = VIRTUAL_SERVER_NAME_OID;
        snmpOIDs[17] = CLUSTER_NAME_OID;
        snmpOIDs[18] = CURRENT_NODE_NAME_OID;
        snmpOIDs[19] = OLD_NODE_NAME_OID;
        snmpOIDs[20] = STORAGE_SUBSYSTEM_OID;
        snmpOIDs[21] = DEVICE_NAME_OID;
        snmpOIDs[22] = THRESHOLD_BOUNDARY_OID;
        snmpOIDs[24] = THRESHOLD_NAME_OID;
        snmpOIDs[23] = THRESHOLD_TIME_OID;
        snmpOIDs[25] = THRESH_DESCRIPTION_OID;
        snmpOIDs[26] = START_TIME_OID;
        snmpOIDs[27] = STOP_TIME_OID;
        snmpOIDs[28] = ERROR_OID;
        snmpOIDs[29] = RECORDS_CNT_OID;
        int[][] traceResult = snmpOIDs;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"getSnmpOIDTable", (Object)traceResult);
        }
        return traceResult;
    }

    public static String[] getTecSlotNames() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"getTecSlotNames", (String)"");
        }
        String[] tecSlotNames = new String[30];
        tecSlotNames[0] = "hostname";
        tecSlotNames[11] = "resourceType";
        tecSlotNames[1] = "resourceName";
        tecSlotNames[10] = "alertType";
        tecSlotNames[2] = "threshold";
        tecSlotNames[3] = "currentValue";
        tecSlotNames[4] = "previousValue";
        tecSlotNames[7] = "violatorType";
        tecSlotNames[6] = "violatorName";
        tecSlotNames[16] = "vsName";
        tecSlotNames[17] = "clusterName";
        tecSlotNames[18] = "currentNodeName";
        tecSlotNames[19] = "previousNodeName";
        tecSlotNames[20] = "storageSubsystemName";
        tecSlotNames[21] = "deviceName";
        tecSlotNames[22] = "thresholdBoundary";
        tecSlotNames[23] = "thresholdTime";
        tecSlotNames[24] = "thresholdName";
        tecSlotNames[26] = "startTime";
        tecSlotNames[27] = "stopTime";
        tecSlotNames[28] = "error";
        tecSlotNames[29] = "recordCnt";
        String[] traceResult = tecSlotNames;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"getTecSlotNames", (Object)traceResult);
        }
        return traceResult;
    }

    protected static String[] getTecClassNames() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"getTecClassNames", (String)"");
        }
        String[] tecClassNames = new String[31];
        tecClassNames[1] = RAM_EVENT_CLASS;
        tecClassNames[2] = MEMORY_EVENT_CLASS;
        tecClassNames[3] = NEW_DISK_EVENT_CLASS;
        tecClassNames[4] = MISSING_DISK_EVENT_CLASS;
        tecClassNames[5] = DISK_DEFECT_EVENT_CLASS;
        tecClassNames[6] = DISK_FAILURE_EVENT_CLASS;
        tecClassNames[7] = NEW_FS_EVENT_CLASS;
        tecClassNames[8] = MISSING_FS_EVENT_CLASS;
        tecClassNames[9] = FS_RECONFIGURED_EVENT_CLASS;
        tecClassNames[10] = FS_FREESPACE_EVENT_CLASS;
        tecClassNames[11] = FS_FREE_INODE_EVENT_CLASS;
        tecClassNames[13] = MISSING_DIR_EVENT_CLASS;
        tecClassNames[15] = CONSTRAINT_VIOLATION_EVENT_CLASS;
        tecClassNames[16] = PING_FAILURE_EVENT_CLASS;
        tecClassNames[17] = COMPUTER_DISCOVERED_EVENT_CLASS;
        tecClassNames[18] = NEW_NAS_COMPUTER_EVENT_CLASS;
        tecClassNames[21] = MISSING_FILER_EVENT_CLASS;
        tecClassNames[22] = MISSING_DISK_ARRAY_EVENT_CLASS;
        tecClassNames[23] = NEW_DISK_ARRAY_EVENT_CLASS;
        tecClassNames[24] = AUTO_FS_EXTEND_EVENT_CLASS;
        tecClassNames[25] = STOPPED_AUTO_FS_EXTEND_EVENT_CLASS;
        tecClassNames[26] = ADDED_VIRTUAL_SERVER_EVENT_CLASS;
        tecClassNames[27] = REMOVED_VIRTUAL_SERVER_EVENT_CLASS;
        tecClassNames[28] = MOVED_VIRTUAL_SERVER_EVENT_CLASS;
        tecClassNames[29] = PERF_THRESHOLD_EVENT_CLASS;
        tecClassNames[30] = PERF_MONITOR_FAIL_EVENT_CLASS;
        String[] traceResult = tecClassNames;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"getTecClassNames", (Object)traceResult);
        }
        return traceResult;
    }

    protected static String[] getTecEventMsgs() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"getTecEventMsgs", (String)"");
        }
        String[] tecEventMsgs = new String[31];
        tecEventMsgs[1] = MessageLog.getMessageNoID((String)"ALR1300W", null);
        tecEventMsgs[2] = MessageLog.getMessageNoID((String)"ALR1301W", null);
        tecEventMsgs[3] = MessageLog.getMessageNoID((String)"ALR1302W", null);
        tecEventMsgs[4] = MessageLog.getMessageNoID((String)"ALR1303W", null);
        tecEventMsgs[5] = MessageLog.getMessageNoID((String)"ALR1304W", null);
        tecEventMsgs[6] = MessageLog.getMessageNoID((String)"ALR1305W", null);
        tecEventMsgs[7] = MessageLog.getMessageNoID((String)"ALR1306W", null);
        tecEventMsgs[8] = MessageLog.getMessageNoID((String)"ALR1307W", null);
        tecEventMsgs[9] = MessageLog.getMessageNoID((String)"ALR1308W", null);
        tecEventMsgs[10] = MessageLog.getMessageNoID((String)"ALR1309W", null);
        tecEventMsgs[11] = MessageLog.getMessageNoID((String)"ALR1312W", null);
        tecEventMsgs[13] = MessageLog.getMessageNoID((String)"ALR1310W", null);
        tecEventMsgs[15] = MessageLog.getMessageNoID((String)"ALR1311W", null);
        tecEventMsgs[16] = MessageLog.getMessageNoID((String)"ALR1315W", null);
        tecEventMsgs[18] = MessageLog.getMessageNoID((String)"ALR1316W", null);
        tecEventMsgs[17] = MessageLog.getMessageNoID((String)"ALR1314W", null);
        tecEventMsgs[21] = MessageLog.getMessageNoID((String)"ALR1317W", null);
        tecEventMsgs[22] = MessageLog.getMessageNoID((String)"ALR1319W", null);
        tecEventMsgs[23] = MessageLog.getMessageNoID((String)"ALR1318W", null);
        tecEventMsgs[24] = MessageLog.getMessageNoID((String)"ALR1340W", null);
        tecEventMsgs[25] = MessageLog.getMessageNoID((String)"ALR1341W", null);
        tecEventMsgs[26] = MessageLog.getMessageNoID((String)"ALR1342W", null);
        tecEventMsgs[27] = MessageLog.getMessageNoID((String)"ALR1343W", null);
        tecEventMsgs[28] = MessageLog.getMessageNoID((String)"ALR1344W", null);
        tecEventMsgs[29] = MessageLog.getMessageNoID((String)"ALR1345W", null);
        tecEventMsgs[30] = MessageLog.getMessageNoID((String)"ALR1346W", null);
        String[] traceResult = tecEventMsgs;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"getTecEventMsgs", (Object)traceResult);
        }
        return traceResult;
    }

    protected static String[] getTecEventMsgIDs() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"getTecEventMsgIDs", (String)"");
        }
        String[] tecEventMsgIDs = new String[31];
        tecEventMsgIDs[1] = "ALR1300W";
        tecEventMsgIDs[2] = "ALR1301W";
        tecEventMsgIDs[3] = "ALR1302W";
        tecEventMsgIDs[4] = "ALR1303W";
        tecEventMsgIDs[5] = "ALR1304W";
        tecEventMsgIDs[6] = "ALR1305W";
        tecEventMsgIDs[7] = "ALR1306W";
        tecEventMsgIDs[8] = "ALR1307W";
        tecEventMsgIDs[9] = "ALR1308W";
        tecEventMsgIDs[10] = "ALR1309W";
        tecEventMsgIDs[11] = "ALR1312W";
        tecEventMsgIDs[13] = "ALR1310W";
        tecEventMsgIDs[15] = "ALR1311W";
        tecEventMsgIDs[16] = "ALR1315W";
        tecEventMsgIDs[17] = "ALR1314W";
        tecEventMsgIDs[18] = "ALR1316W";
        tecEventMsgIDs[21] = "ALR1317W";
        tecEventMsgIDs[22] = "ALR1319W";
        tecEventMsgIDs[23] = "ALR1318W";
        tecEventMsgIDs[24] = "ALR1340W";
        tecEventMsgIDs[25] = "ALR1341W";
        tecEventMsgIDs[26] = "ALR1342W";
        tecEventMsgIDs[27] = "ALR1343W";
        tecEventMsgIDs[28] = "ALR1344W";
        tecEventMsgIDs[29] = "ALR1345W";
        tecEventMsgIDs[30] = "ALR1346W";
        String[] traceResult = tecEventMsgIDs;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"getTecEventMsgIDs", (Object)traceResult);
        }
        return traceResult;
    }

    private void missingFSAlert(Filesystem fs) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"missingFSAlert", (String)"fs");
        }
        this.initParms();
        this.setHostName();
        this.alertParms[1] = fs.fsMountPoint;
        this.alertParms[11] = "filesystem";
        this.setParmFromMsg(10, "ALR1062W");
        this.genAlert(fs.fsID, (short)3, 8, -1, -1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"missingFSAlert");
        }
    }

    private void checkFreeSpace(Filesystem fs) {
        long threshold;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"checkFreeSpace", (String)"fs");
        }
        if (fs.fsFreeSpace < (threshold = this.alertDef.aldThresholdType == 2 ? fs.fsCapacity * (long)this.alertDef.aldThresholdValue / 100L : (long)(this.alertDef.aldThresholdValue * 2))) {
            this.initParms();
            this.setHostName();
            if (this.alertDef.aldThresholdType == 2) {
                this.setNumParm(2, this.alertDef.aldThresholdValue, "%");
            } else {
                this.setByteSizeParm(2, threshold);
            }
            this.setByteSizeParm(3, fs.fsFreeSpace);
            double freeSpacePct = fs.fsFreeSpace * 100L;
            this.setNumParm(5, freeSpacePct /= (double)fs.fsCapacity, "%");
            this.alertParms[1] = fs.fsMountPoint;
            this.alertParms[11] = "filesystem";
            this.setParmFromMsg(10, "ALR1064W");
            this.genAlert(fs.fsID, (short)3, 10, (int)fs.fsFreeSpace, -1);
        } else {
            this.clearAlert(fs.fsID, (short)3);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"checkFreeSpace");
        }
    }

    private void checkFreeInodes(Filesystem fs) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"checkFreeInodes", (String)"fs");
        }
        if (fs.fsFreeInodes == -1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StormAlerter.class.getName(), (String)"checkFreeInodes");
            }
            return;
        }
        long threshold = this.alertDef.aldThresholdType == 2 ? (long)(fs.fsMaxFiles * this.alertDef.aldThresholdValue / 100) : (long)this.alertDef.aldThresholdValue;
        if ((long)fs.fsFreeInodes < threshold) {
            this.initParms();
            this.setHostName();
            if (this.alertDef.aldThresholdType == 2) {
                this.setNumParm(2, this.alertDef.aldThresholdValue, "%");
            } else {
                this.setNumParm(2, this.alertDef.aldThresholdValue, (String)null);
            }
            this.setNumParm(3, fs.fsFreeInodes, (String)null);
            double freeInodePct = fs.fsFreeInodes * 100;
            this.setNumParm(5, freeInodePct /= (double)fs.fsMaxFiles, "%");
            this.alertParms[1] = fs.fsMountPoint;
            this.alertParms[11] = "filesystem";
            this.setParmFromMsg(10, "ALR1065W");
            this.genAlert(fs.fsID, (short)3, 11, fs.fsFreeInodes, -1);
        } else {
            this.clearAlert(fs.fsID, (short)3);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"checkFreeInodes");
        }
    }

    protected void initParms() {
        this.alertParms = new String[30];
    }

    protected boolean processFilesystemAlert(Filesystem fs) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"processFilesystemAlert", (String)"fs");
        }
        if (fs.fsComputerID != this.computerID) {
            this.setComputer(fs.fsComputerID);
        }
        boolean result = true;
        switch (this.alertDef.aldCondition) {
            case 13: {
                this.checkFreeSpace(fs);
                break;
            }
            case 14: {
                this.checkFreeInodes(fs);
                break;
            }
            case 12: {
                this.missingFSAlert(fs);
                break;
            }
            default: {
                result = false;
            }
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"processFilesystemAlert", (boolean)traceResult);
        }
        return traceResult;
    }

    protected void processAlert(HasID resource) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"processAlert", (String)"resource");
        }
        this.processFilesystemAlert((Filesystem)resource);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"processAlert");
        }
    }

    protected void processOncePrepared(ScheduleQueryable accessor, HasID head) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"processOncePrepared", (String)"accessor, head");
        }
        NameList row = new NameList();
        this.alertDef = null;
        int alertID = -1;
        int lastResourceID = -1;
        HasID resource = head;
        while (accessor.fetchQueryBySchedule(row)) {
            if (row.nlID2 != alertID) {
                alertID = row.nlID2;
                lastResourceID = -1;
                resource = head;
            }
            if (row.nlID == lastResourceID) continue;
            lastResourceID = row.nlID;
            if (row.nlState != 0) continue;
            while (resource != null && resource.getID() != row.nlID) {
                resource = (HasID)resource.getNext();
            }
            if (resource == null) {
                Object[] args = new Object[]{new Integer(row.nlID), new Integer(alertID)};
                String msg = MessageLog.getMessage((String)"STS0116E", (Object[])args);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)StormAlerter.class.getName(), (String)"processOncePrepared");
                }
                throw new GeneralException(msg);
            }
            if (this.alertDef == null || this.alertDef.aldAlertID != alertID) {
                this.alertDef = this.alertAccessor.getByID(alertID);
            }
            if (this.alertDef == null) continue;
            this.processAlert(resource);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"processOncePrepared");
        }
    }

    private void processFilesystemAlerts(Filesystem head, short attributeType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"processFilesystemAlerts", (String)"head, attributeType");
        }
        this.fsAccessor = new TResFS(this.dbc);
        this.fsAccessor.initQueryByAttrType(attributeType, head, null);
        this.processOncePrepared(this.fsAccessor, (HasID)head);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"processFilesystemAlerts");
        }
    }

    protected void processFilesystemAlerts(Filesystem present, Filesystem missing) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"processFilesystemAlerts", (String)"present, missing");
        }
        if (present == null && missing == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StormAlerter.class.getName(), (String)"processFilesystemAlerts");
            }
            return;
        }
        try {
            if (present != null) {
                this.processFilesystemAlerts(present, (short)27);
            }
            if (missing != null) {
                this.processFilesystemAlerts(missing, (short)29);
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)StormAlerter.class.getName(), (String)"processFilesystemAlerts", (Throwable)e);
            }
            this.fsAccessor.closeSelect();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StormAlerter.class.getName(), (String)"processFilesystemAlerts");
            }
            throw e;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"processFilesystemAlerts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processVirtualServerAlerts(Computer computer, Computer oldComputer) throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"processVirtualServerAlerts", (String)"computer, oldComputer");
        }
        try {
            if (this.cmpAccessor == null) {
                this.cmpAccessor = new TResComputer(this.dbc);
            }
            this.cmpAccessor.prepSelectName();
            this.initParms();
            this.setHostName();
            this.alertParms[16] = this.hostName;
            this.alertParms[18] = this.cmpAccessor.fetchName(computer.cmpNodeHostedID);
            this.alertParms[17] = computer.cmpCluster.clusterName;
            this.setParmFromMsg(11, "STS0054I");
            if (this.alertDef.aldCondition == 73) {
                this.setParmFromMsg(10, "ALR1119W");
                this.genAlert(this.computerID, (short)1, 26, -1, -1, (byte)0, -1);
            } else if (this.alertDef.aldCondition == 75) {
                String oldNodeHosted;
                this.alertParms[19] = oldNodeHosted = this.cmpAccessor.fetchName(oldComputer.cmpNodeHostedID);
                this.setParmFromMsg(10, "ALR1121W");
                this.genAlert(this.computerID, (short)1, 28, -1, -1, (byte)0, -1);
            }
        }
        finally {
            this.cleanupSelect(this.cmpAccessor);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"processVirtualServerAlerts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processVirtualServerRemovedAlert(int cmpID, int clusterID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StormAlerter.class.getName(), (String)"processVirtualServerRemovedAlert", (String)"cmpID, clusterID");
        }
        try {
            if (this.cmpAccessor == null) {
                this.cmpAccessor = new TResComputer(this.dbc);
            }
            this.cmpAccessor.prepSelectName();
            TResCluster clusterAccessor = new TResCluster(this.dbc);
            String clusterName = null;
            Cluster cluster = clusterAccessor.getClusterByID(clusterID);
            if (cluster != null) {
                clusterName = cluster.clusterName;
            }
            this.initParms();
            this.alertParms[16] = this.cmpAccessor.fetchName(cmpID);
            this.alertParms[18] = this.cmpAccessor.getVSNodeName(cmpID);
            this.alertParms[17] = clusterName;
            this.setParmFromMsg(11, "STS0054I");
            this.setParmFromMsg(10, "ALR1120W");
            this.setComputer(cmpID);
            this.genAlert(cmpID, (short)1, 27, -1, -1, (byte)0, -1);
        }
        finally {
            this.cleanupSelect(this.cmpAccessor);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"processVirtualServerRemovedAlert");
        }
    }

    private void cleanupSelect(RepositoryAccessor accessor) {
        block4: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)StormAlerter.class.getName(), (String)"cleanupSelect", (String)"accessor");
            }
            try {
                accessor.closeSelect();
            }
            catch (GeneralException ignored) {
                if (!TraceLogger.enableTrace) break block4;
                TraceLogger.exception((String)StormAlerter.class.getName(), (String)"cleanupSelect", (Throwable)ignored);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StormAlerter.class.getName(), (String)"cleanupSelect");
        }
    }
}

