/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler;

import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.sanmgmt.middleware.data.MiddlewareCrypto;
import org.eclipse.aperi.sanmgmt.middleware.data.SecurityContext;
import org.eclipse.aperi.sanmgmt.middleware.data.SystemSecurityContext;
import org.eclipse.aperi.server.DeviceServerManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.util.SRMCrypto;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class DeviceRequestHndlr
implements RequestHandler {
    public static void initDeviceServerComm(DeviceRequest request) {
        DeviceServerManager dsm;
        org.eclipse.aperi.infrastructure.database.objects.Server deviceServer;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceRequestHndlr.class.getName(), (String)"initDeviceServerComm", (String)"request");
        }
        if ((deviceServer = (dsm = Server.getDeviceServerManager()).getDeviceServer()) != null) {
            String pWord = deviceServer.getPassword();
            try {
                pWord = SRMCrypto.decrypt((String)pWord);
            }
            catch (Exception e) {
                e.printStackTrace(MessageLog.getThreadLog());
            }
            try {
                if (SecurityContext.getDefaultContext() == null) {
                    SecurityContext.setDefaultContext((SecurityContext)new SystemSecurityContext());
                }
                MiddlewareCrypto.initialize((char[])pWord.toCharArray());
                request.deviceServerID = deviceServer.getServerId();
                request.deviceServerHost = deviceServer.getServerName();
                request.deviceServerPort = deviceServer.getPortNumber();
            }
            catch (Throwable t) {
                t.printStackTrace(MessageLog.getThreadLog());
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceRequestHndlr.class.getName(), (String)"initDeviceServerComm");
        }
    }

    public abstract int deviceAPI(DeviceRequest var1, Response var2);

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceRequestHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        DeviceRequest dr = (DeviceRequest)request;
        Response response = new Response(0, null);
        DeviceRequestHndlr.initDeviceServerComm(dr);
        try {
            this.deviceAPI(dr, response);
        }
        catch (RuntimeException e) {
            response.errorMessage = e.getLocalizedMessage();
            response.status = (short)12;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceRequestHndlr.class.getName(), (String)"handle", (Object)response);
        }
        return response;
    }
}

