/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.agent;

import java.io.File;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.BatchReport;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.backend.WindowsScript;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.table.TBatchReport;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.ScriptSubmitter;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.PartitionedReport;
import org.eclipse.aperi.server.handler.PartitionedDataProvider;
import org.eclipse.aperi.server.handler.StormReportHndlr;

public class BatchReportHndlr
implements RequestHandler,
StormReportHndlr,
ThrowAway {
    Request request;
    Response response;
    Transceiver transceiver;
    BatchReport batchReport;

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BatchReportHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.request = request;
        this.transceiver = transceiver;
        this.response = Response.getResponse((short)0, null);
        if (RequestChecker.isDesiredType(MutableLong.class, (Request)request, (Response)this.response)) {
            long value = ((MutableLong)request.requestData).value;
            int scheduleID = (int)value;
            value >>= 32;
            Connection dbc = Server.getConnection();
            if (dbc == null) {
                Server.setResponseError(this.response, "GEN0050E");
            } else {
                TBatchReport brAccessor = new TBatchReport(dbc);
                try {
                    this.batchReport = brAccessor.selectByID(scheduleID);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)BatchReportHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(this.response, (Exception)((Object)e));
                }
                if (this.batchReport != null) {
                    if (this.batchReport.scriptName != null) {
                        this.maybeLoadScript(value != 0L);
                    }
                    this.response.responseData = this.batchReport;
                    GuiReportReq grr = this.batchReport.grr;
                    grr.isBatchReport = true;
                    int grrID1 = this.batchReport.grr.grrID1;
                    byte histType = this.batchReport.grr.histType;
                    byte histSubtype = this.batchReport.grr.histSubtype;
                    this.batchReport.grr.grrID1 = 0;
                    this.batchReport.grr.histType = 0;
                    this.batchReport.grr.histSubtype = 0;
                    GuiDataProvider dataProvider = null;
                    PartitionedDataProvider pDataProvider = null;
                    boolean gotReporter = false;
                    String className = GuiReportReq.guiClasses[grr.reportType][1];
                    try {
                        Class<?> rClass = Class.forName(className);
                        Class[] argdef = new Class[]{Connection.class};
                        Constructor<?> constr = rClass.getConstructor(argdef);
                        Object[] args = new Object[]{dbc};
                        if (PartitionedDataProvider.class.isAssignableFrom(rClass)) {
                            gotReporter = true;
                            pDataProvider = (PartitionedDataProvider)constr.newInstance(args);
                        } else {
                            gotReporter = true;
                            dataProvider = (GuiDataProvider)constr.newInstance(args);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)BatchReportHndlr.class.getName(), (String)"handle", (Throwable)e);
                        }
                        Object[] args = new Object[]{new Integer(grr.reportType), new Integer(grr.reportSubtype)};
                        Server.setResponseError(this.response, "GEN0125E", args);
                    }
                    catch (Exception e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)BatchReportHndlr.class.getName(), (String)"handle", (Throwable)e);
                        }
                        System.err.println(e);
                        e.printStackTrace();
                        Server.setResponseError(this.response, e);
                    }
                    if (gotReporter) {
                        try {
                            if (dataProvider != null) {
                                this.batchReport.data = dataProvider.getReportData(grr);
                            } else {
                                pDataProvider.getReportData(grr, this);
                            }
                        }
                        catch (GeneralException e) {
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception((String)BatchReportHndlr.class.getName(), (String)"handle", (Throwable)e);
                            }
                            Server.setResponseError(this.response, (Exception)((Object)e));
                        }
                    }
                    this.batchReport.grr.grrID1 = grrID1;
                    this.batchReport.grr.histType = histType;
                    this.batchReport.grr.histSubtype = histSubtype;
                }
                Server.returnConnection(dbc);
            }
        }
        Response traceResult = this.response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BatchReportHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    public static Object packComps(Computer computer) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BatchReportHndlr.class.getName(), (String)"packComps", (String)"computer");
        }
        Computer[] computers = null;
        int count = 0;
        Computer node = computer;
        while (node != null) {
            ++count;
            node = node.cmpNext;
        }
        computers = new Computer[count];
        for (int i = 0; i < count; ++i) {
            node = computer.cmpNext;
            computer.cmpNext = null;
            computers[i] = computer;
            computer = node;
        }
        Computer[] traceResult = computers;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BatchReportHndlr.class.getName(), (String)"packComps", (Object)traceResult);
        }
        return traceResult;
    }

    private void maybeLoadScript(boolean isWindows) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BatchReportHndlr.class.getName(), (String)"maybeLoadScript", (String)"isWindows");
        }
        String fileName = null;
        StringBuffer buf = new StringBuffer(120);
        if (isWindows) {
            WindowsScript ws = JobUtil.resolveWindowsScript((String)this.batchReport.scriptName, (StringBuffer)buf);
            if (ws != null) {
                if (buf.length() > 0) {
                    this.batchReport.scriptExtension = buf.toString();
                }
                buf.setLength(0);
                buf.append(JobUtil.scriptsDir);
                buf.append(File.separatorChar);
                buf.append(ws.wsResolvedName);
                fileName = buf.toString();
            }
        } else {
            buf.append(JobUtil.scriptsDir);
            buf.append(File.separatorChar);
            if (JobUtil.resolveUnixScript((String)this.batchReport.scriptName, (StringBuffer)buf) != null) {
                fileName = buf.toString();
            }
        }
        if (fileName != null) {
            MutableBoolean ok = new MutableBoolean(true);
            byte[] scriptBody = ScriptSubmitter.loadFile(fileName, ok);
            if (ok.value) {
                this.batchReport.scriptBody = scriptBody;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BatchReportHndlr.class.getName(), (String)"maybeLoadScript");
        }
    }

    public void transmitReportData(PartitionedReport partition) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BatchReportHndlr.class.getName(), (String)"transmitReportData", (String)"partition");
        }
        this.batchReport.data = partition;
        this.transceiver.transmitResponse(this.request, this.response);
        this.response.returnResponse();
        this.response = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BatchReportHndlr.class.getName(), (String)"transmitReportData");
        }
    }
}

